<?php
/*
Plugin Name: Landmark Theme Plugins
Plugin URI: http://www.themeforest.net/user/bliccaThemes
Description: This Plugin will install themes shortcodes and CPT
Author: Blicca Themes
Version: 1.0
Author URI: http://www.themeforest.net/user/bliccaThemes
*/

/************************************************************/
/******************** Custom Post Types  ********************/
/************************************************************/

    add_action('init', 'landmark_construction_theme_create_portfolio', 1);
    function landmark_construction_theme_create_portfolio() {
        $args = array(
            'label' => 'Portfolio',
            'singular_label' => 'Portfolio',
            'menu_icon' => 'dashicons-calendar-alt',
            'public' => true,
            'show_ui' => true,
            'capability_type' => 'post',
            'hierarchical' => false,
            'rewrite' => array('slug' => 'portfolios', 'url' => 'portfolio'),
            'taxonomies' => array('post_tag'),
            'supports' => array('title', 'editor', 'thumbnail', 'excerpt')
        );
        register_post_type('portfolio',$args);
    }
    add_action( 'init', 'landmark_construction_theme_portfolio_tax', 1 );
    function landmark_construction_theme_portfolio_tax() {
    register_taxonomy("portfolio-category", array("portfolio"), array("hierarchical" => true, "label" => "Portfolio Category", "singular_label" => "Portfolio Category", "rewrite" => true));
    }
    function landmark_construction_theme_portfolio_thumbnail_url($pid){  
    $image_id = get_post_thumbnail_id($pid);    
    $image_url = wp_get_attachment_image_src($image_id,'screen-shot');    
    return  $image_url[0];    
    }    
    add_filter('pre_get_posts', 'query_post_type'); function query_post_type($query) { if(is_category() || is_tag()) { $post_type = get_query_var('post_type'); if($post_type) $post_type = $post_type;         else $post_type = array('post','nav_menu_item', 'portfolio'); $query->set('post_type',$post_type); return $query; } }

/*****************************/
/* Creating Footer CPT  landmark */
/*****************************/
    add_action('init', 'landmark_construction_theme_create_footers');
    function landmark_construction_theme_create_footers() {
        $args = array(
            'label' => 'Footers',
            'singular_label' => 'footer',
            'menu_icon' => 'dashicons-calendar-alt',
            'public' => true,
            'show_ui' => true,
            'capability_type' => 'post',
            'hierarchical' => false,
            'rewrite' => array('slug' => 'footers', 'url' => 'footer'),
            'supports' => array('title', 'editor', 'thumbnail'),
            'exclude_from_search' => true,
            'publicly_queryable'  => false
        );
        register_post_type('footers',$args);
    }
/*****************************/
/* Creating Sidebar CPT  landmark */
/*****************************/
    add_action('init', 'landmark_construction_theme_create_sidebars_cpt');
    function landmark_construction_theme_create_sidebars_cpt() {
        $args = array(
            'label' => 'Sidebars',
            'singular_label' => 'sidebar',
            'menu_icon' => 'dashicons-calendar-alt',
            'public' => true,
            'show_ui' => true,
            'capability_type' => 'post',
            'hierarchical' => false,
            'rewrite' => array('slug' => 'sidebars', 'url' => 'sidebar'),
            'supports' => array('title', 'editor', 'thumbnail'),
            'exclude_from_search' => true,
            'publicly_queryable'  => false
        );
        register_post_type('sidebars',$args);
    }
/**************************************************************/

/******************** Visual Composer Func ********************/

/**************************************************************/

/*********************************/
/*         Random String         */
/*********************************/ 
function landmark_construction_theme_random_string($length) {
    
    $key = null;

    $keys = array_merge(range(0,9), range('a', 'z'));

    for($i=0; $i < $length; $i++) {

        $key .= $keys[array_rand($keys)];

    }

    return $key;

}

// Check the plugin
if ( in_array( 'js_composer/js_composer.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {

/************************/
/* Twitter Widget 2     */
/************************/

function landmark_construction_theme_time_since($time) {

        $since = time() - strtotime($time);

        $string     = '';

        $chunks = array(
            array(60 * 60 * 24 * 365 , 'year'),
            array(60 * 60 * 24 * 30 , 'month'),
            array(60 * 60 * 24 * 7, 'week'),
            array(60 * 60 * 24 , 'day'),
            array(60 * 60 , 'hour'),
            array(60 , 'minute'),
            array(1 , 'second')
        );

        for ($i = 0, $j = count($chunks); $i < $j; $i++) {
            $seconds = $chunks[$i][0];
            $name = $chunks[$i][1];
            if (($count = floor($since / $seconds)) != 0) {
                break;
            }
        }

        $string = ($count == 1) ? '1 ' . $name . ' ago' : $count . ' ' . $name . 's ago';

        return $string;

} 
function landmark_construction_twitter2($tweetcount,$widget_type) {
global $landmark_construction_theme_options; 
$widget_content = $access_token = $access_token_secret = $consumer_key = $consumer_secret = $twitter_user_name = "";
if ( isset($landmark_construction_theme_options['access_token'])) {
$access_token = $landmark_construction_theme_options['access_token'];
}
if ( isset($landmark_construction_theme_options['access_token_secret'])) {
$access_token_secret = $landmark_construction_theme_options['access_token_secret'];
}
if ( isset($landmark_construction_theme_options['consumer_key'])) {
$consumer_key = $landmark_construction_theme_options['consumer_key'];
}
if ( isset($landmark_construction_theme_options['consumer_secret'])) {
$consumer_secret = $landmark_construction_theme_options['consumer_secret'];
}
if ( isset($landmark_construction_theme_options['twitter_user_name'])) {
$twitter_user_name = $landmark_construction_theme_options['twitter_user_name'];
}
$twitter_check = "true";
if ( $access_token == "" ||  $twitter_user_name == "" ||  $consumer_key == "" ||  $access_token_secret == "" ||  $consumer_secret == "" ) {
  $twitter_check = "false";
}
  if ( $twitter_check == "true") {
  if ( in_array( 'twitter-feeds-plugin/twitter-feeds-plugin.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
// Setting our Authentication Variables that we got after creating an application
$settings = array(
    'oauth_access_token' => $access_token,
    'oauth_access_token_secret' => $access_token_secret,
    'consumer_key' => $consumer_key,
    'consumer_secret' => $consumer_secret
);

// We are using GET Method to Fetch the latest tweets.
$url = 'https://api.twitter.com/1.1/statuses/user_timeline.json';

// Set your screen_name to your twitter screen name. Also set the count to the number of tweets you want to be fetched. Here we are fetching 5 latest tweets.

$getfield = '?screen_name='.$twitter_user_name.'&count='.$tweetcount;
$requestMethod = 'GET';

// Making an object to access our library class
$twitter = new TwitterAPIExchange($settings);
$store = $twitter->setGetfield($getfield)
             ->buildOauth($url, $requestMethod)
             ->performRequest();
// Since the returned result is in json format, we need to decode it             
  $result = json_decode($store);
  
// After decoding, we have an standard object array, so we can print each tweet into a list item.
  $multi_array = objectToArray($result);
  
  if( !empty($multi_array)) {
    if ( $widget_type == "slider_on" || $widget_type == "slider_two" ) {
      $slider_clas = "twitter_slide_container";
      $extra_text = '<p class="tweet_user"><a href="http://www.twitter.com/'.$twitter_user_name.'" target="_blank">@'.$twitter_user_name.'</a></p>';
      if ( $widget_type == "slider_two" ) {
      $extra_text = "";
      $slider_clas = "twitter_slide_container twitter_slide2";  
      }
      $widget_content .= '<div class="'.$slider_clas.'"><div class="twitter-ico"><i class="fa fa-twitter"></i></div><div class="twitter_slider">';
    }
    else {
      $widget_content .= '<div class="twitter_grid_container"><div class="twitter_grids">';
      $extra_text = "";
    }
    foreach($multi_array as $key => $value ){
   
    // The Text you want to filter for urls

  
    $tweet = $value["text"];
            
    //Convert urls to <a> links
    $tweet = preg_replace("/([\w]+\:\/\/[\w-?&;#~=\.\/\@]+[\w\/])/", "<a target=\"_blank\" href=\"$1\">$1</a>", $tweet);
    
    //Convert hashtags to twitter searches in <a> links
    $tweet = preg_replace("/#([A-Za-z0-9\/\.]*)/", "<a target=\"_new\" href=\"http://twitter.com/search?q=$1\">#$1</a>", $tweet);
    
    //Convert attags to twitter profiles in &lt;a&gt; links
    $tweet = preg_replace("/@([A-Za-z0-9\/\.]*)/", "<a href=\"http://www.twitter.com/$1\">@$1</a>", $tweet);
    if ( $widget_type != "slider_two" ) {
    // make the urls hyper links
    $widget_content .= '<div><p>'. $tweet . '</p>'.$extra_text.'<p class="tweet_date">'.landmark_construction_theme_time_since($value["created_at"]).'</p></div>';
    }
    else {
    $widget_content .= '<div><p>'. $tweet . '</p></div>';  
    }
 
   } 
   $widget_content .= '</div></div>';
   }
}
}
  else {
     $widget_content .= '<h1>Please install and activate twitter widget plugin and write your access_token, access_token_secret, twitter_username, consumer_key, consumer_secret in themeoptions social page</h1>';
  }
  return $widget_content;
}
/************************/
/*  Twitter Post Widget */
/************************/
function landmark_construction_twitter_sliders($atts) {
   extract(shortcode_atts ( array(
    'tweet_count' => '3',
    'widget_type' => 'slider_on'
    ), 
   $atts));
  
  if ( !is_numeric($tweet_count) ) {
    $tweet_count = 3;
  }
  $content = landmark_construction_twitter2($tweet_count, $widget_type);  
  return $content; 
}
add_shortcode('landmark_construction_twitter_slider', 'landmark_construction_twitter_sliders');
add_action( 'init', 'landmark_construction_twitter_slider_integrateWithVC' );
function landmark_construction_twitter_slider_integrateWithVC() {
vc_map( array(
   "name" => __("Twitter Widget", 'landmark-construction-theme'),
   "base" => "landmark_construction_twitter_slider",
   "class" => "",
   "icon" => "icon-wpb-vc_extend",
   "category" => 'Content',
   "params" => array(

    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Number of Tweets", 'landmark-construction-theme'),
        "param_name" => "tweet_count",
        "description" => __("Before using this widget please go to themeoptions > socials and fill all twitter API keys, after writing your keys you can add this widget.", 'landmark-construction-theme')
    ),
   array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Widget Type", 'landmark-construction-theme'),
        "param_name" => "widget_type",
        "value" => array( 
        __( 'Slider', 'landmark-construction-theme' ) => 'slider_on',
        __( 'Grid', 'landmark-construction-theme' ) => 'grid_on',
        __( 'Slider Style 2', 'landmark-construction-theme' ) => 'slider_two',
        ),
        "description" => __("Choose your twitter widget type, slider or grid", 'landmark-construction-theme')
    )     
   )
  
) );
}  
/********************/
/*    Accordion     */
/********************/
function landmark_construction_accordion($atts, $content = null) {
wp_enqueue_script( 'jquery-ui-accordion' );
$output = $title = $interval = $el_class = $collapsible = $disable_keyboard = $active_tab = '';
//
extract( shortcode_atts( array(
  'accordion_style' => '',
  'title' => '',
  'interval' => 0,
  'el_class' => '',
  'collapsible' => 'no',
  'disable_keyboard' => 'no',
  'active_tab' => '1'
), $atts ) );


$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'wpb_accordion wpb_content_element ' . $accordion_style . ' ' . $el_class . ' not-column-inherit', $atts );

$output .= "\n\t" . '<div class="' . $css_class . '" data-collapsible="' . $collapsible . '" data-vc-disable-keydown="' . ( esc_attr( ( 'yes' == $disable_keyboard ? 'true' : 'false' ) ) ) . '" data-active-tab="' . $active_tab . '">'; //data-interval="'.$interval.'"
$output .= "\n\t\t" . '<div class="wpb_wrapper wpb_accordion_wrapper ui-accordion">';
$output .= wpb_widget_title( array( 'title' => $title, 'extraclass' => 'wpb_accordion_heading' ) );

$output .= "\n\t\t\t" . wpb_js_remove_wpautop( $content );
$output .= "\n\t\t" . '</div> ';
$output .= "\n\t" . '</div> ';

return $output;
}

add_shortcode('vc_accordion', 'landmark_construction_accordion');

function landmark_construction_accordion_tab($atts, $content = null) {
$output = $title = $el_id = $icon_fontawesome = $icon_openiconic = $icon_typicons = $icon_entypoicons = $icon_linecons = '';

extract( shortcode_atts( array(
  'title' => __( "Section", "landmark-construction-theme" ),
  'icon_style' => 'fontawesome',
  'icon_fontawesome' => 'fa fa-adjust',
  'icon_openiconic' => '',
  'icon_typicons' => '',
  'icon_entypoicons' => '',
  'icon_linecons' => '',
  'icon_entypo' => '',  
  'el_id' => '',
), $atts ) );

vc_icon_element_fonts_enqueue( $icon_style );
$iconClass = isset( ${"icon_" . $icon_style} ) ? esc_attr( ${"icon_" . $icon_style} ) : 'fa fa-adjust';


$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'wpb_accordion_section group', $atts );
$output .= "\n\t\t\t" . '<div ' . ( isset( $el_id ) && ! empty( $el_id ) ? "id='" . esc_attr( $el_id ) . "'" : "" ) . 'class="' . $css_class . '">';
$output .= "\n\t\t\t\t" . '<h3 class="wpb_accordion_header ui-accordion-header"><a href="#' . sanitize_title( $title ) . '">' . $title . '</a>
<div
  class="vc_icon_element vc_icon_element-outer vc_icon_element-align-center">
  <div
    class="vc_icon_element-inner vc_icon_element-size-xs vc_icon_element-style-"><span
      class="vc_icon_element-icon '. $iconClass . '"></span></div>
</div></h3>';
$output .= "\n\t\t\t\t" . '<div class="wpb_accordion_content ui-accordion-content vc_clearfix">';
$output .= ( $content == '' || $content == ' ' ) ? __( "Empty section. Edit page to add content here.", "landmark-construction-theme" ) : "\n\t\t\t\t" . wpb_js_remove_wpautop( $content );
$output .= "\n\t\t\t\t" . '</div>';
$output .= "\n\t\t\t" . '</div> ';

return $output;
}

add_shortcode('vc_accordion_tab', 'landmark_construction_accordion_tab');
/* Accordion block
---------------------------------------------------------- */
add_action( 'vc_before_init', 'landmark_construction_accordion_integrateWithVC' );
function landmark_construction_accordion_integrateWithVC() { 
vc_map( array(
  'name' => __( 'landmark Accordion', "landmark-construction-theme" ),
  'base' => 'vc_accordion',
  'show_settings_on_create' => false,
  'is_container' => true,
  'icon' => 'icon-wpb-ui-accordion',
  'category' => __( 'Content', "landmark-construction-theme" ),
  'description' => __( 'Collapsible content panels', "landmark-construction-theme" ),
  'params' => array(
    array(
        'type' => 'dropdown',
        'heading' =>  __('Accordion Style', 'landmark-construction-theme'),
        'param_name' => 'accordion_style',
        'value' => array( "no-style", "accordion-style-1", "accordion-style-2", "accordion-style-3", "accordion-style-4", "accordion-style-5", "accordion-style-6", "accordion-style-7", "accordion-style-8", "accordion-style-9", "accordion-style-10", "accordion-style-11", "accordion-style-12", "accordion-style-13", "accordion-style-14", "accordion-style-15", "accordion-style-16", "accordion-style-17", "accordion-style-18", "accordion-style-19", "accordion-style-20" ),
        'description' => __( "Select Accordion Style", "landmark-construction-theme" )  
    ),  
    array(
      'type' => 'textfield',
      'heading' => __( 'Widget title', "landmark-construction-theme" ),
      'param_name' => 'title',
      'description' => __( 'Enter text used as widget title (Note: located above content element).', "landmark-construction-theme" )
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Active section', "landmark-construction-theme" ),
      'param_name' => 'active_tab',
      'value' => 1,
      'description' => __( 'Enter section number to be active on load or enter "false" to collapse all sections.', "landmark-construction-theme" )
    ),
    array(
      'type' => 'checkbox',
      'heading' => __( 'Allow collapse all sections?', "landmark-construction-theme" ),
      'param_name' => 'collapsible',
      'description' => __( 'If checked, it is allowed to collapse all sections.', "landmark-construction-theme" ),
      'value' => array( __( 'Yes', "landmark-construction-theme" ) => 'yes' )
    ),
    array(
      'type' => 'checkbox',
      'heading' => __( 'Disable keyboard interactions?', "landmark-construction-theme" ),
      'param_name' => 'disable_keyboard',
      'description' => __( 'If checked, disables keyboard arrow interactions (Keys: Left, Up, Right, Down, Space).', "landmark-construction-theme" ),
      'value' => array( __( 'Yes', "landmark-construction-theme" ) => 'yes' )
    ),
    array(
      'type' => 'textfield',
      'heading' => __( 'Extra class name', "landmark-construction-theme" ),
      'param_name' => 'el_class',
      'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', "landmark-construction-theme" )
    )
  ),
  'custom_markup' => '
<div class="wpb_accordion_holder wpb_holder clearfix vc_container_for_children">
%content%
</div>
<div class="tab_controls">
    <a class="add_tab" title="' . __( 'Add section', "landmark-construction-theme" ) . '"><span class="vc_icon"></span> <span class="tab-label">' . __( 'Add section', "landmark-construction-theme" ) . '</span></a>
</div>
',
  'default_content' => '
    [vc_accordion_tab title="' . __( 'Section 1', "landmark-construction-theme" ) . '"][/vc_accordion_tab]
    [vc_accordion_tab title="' . __( 'Section 2', "landmark-construction-theme" ) . '"][/vc_accordion_tab]
',
  'js_view' => 'VcAccordionView'
) );
}
add_action( 'vc_before_init', 'landmark_construction_accordion_tab_integrateWithVC' );
function landmark_construction_accordion_tab_integrateWithVC() { 
vc_map( array(
  'name' => __( 'landmark Acc Section', "landmark-construction-theme" ),
  'base' => 'vc_accordion_tab',
  'allowed_container_element' => 'vc_row',
  'is_container' => true,
  'content_element' => false,
  'params' => array(
    array(
      'type' => 'textfield',
      'heading' => __( 'Title', "landmark-construction-theme" ),
      'param_name' => 'title',
      'value' => __( 'Section', "landmark-construction-theme" ),
      'description' => __( 'Enter accordion section title.', "landmark-construction-theme" )
    ),
    array(
      'type' => 'el_id',
      'heading' => __( 'Section ID', "landmark-construction-theme" ),
      'param_name' => 'el_id',
      'description' => sprintf( __( 'Enter optional row ID. Make sure it is unique, and it is valid as w3c specification: %s (Must not have spaces)', "landmark-construction-theme" ), '<a target="_blank" href="http://www.w3schools.com/tags/att_global_id.asp">' . __( 'link', "landmark-construction-theme" ) . '</a>' ),
    ),
    array(
          "type" => "dropdown",
          "holder" => "div",
          "class" => "",
          "heading" => __("Icon or Image", 'landmark-construction-theme'),
          "param_name" => "icon_style",
          "value" => array( 
          __( 'Font Awesome', "landmark-construction-theme" ) => 'fontawesome',
          __( 'Open Iconic', "landmark-construction-theme" ) => 'openiconic',
          __( 'Typicons', "landmark-construction-theme" ) => 'typicons',
          __( 'Entypo', "landmark-construction-theme" ) => 'entypo',
          __( 'Linecons', "landmark-construction-theme" ) => 'linecons',
          ),
          "description" => __("You can add image or icon to your services, if you use image please use square image and not bigger then 180x180 px", 'landmark-construction-theme')
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_fontawesome',
        'value' => 'fa fa-adjust', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
        ),
        'dependency' => Array( 'element' => 'icon_style', 'value' => 'fontawesome' ),

        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_openiconic',
        'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'type' => 'openiconic',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => Array(
          'element' => 'icon_style',
          'value' => 'openiconic',
        ),
        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_typicons',
        'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'type' => 'typicons',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => Array(
          'element' => 'icon_style',
          'value' => 'typicons',
        ),
        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_entypo',
        'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'type' => 'entypo',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => Array(
          'element' => 'icon_style',
          'value' => 'entypo',
        ),
      ),
      array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_linecons',
        'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'type' => 'linecons',
          'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => Array( 'element' => 'icon_style','value' => 'linecons',
        ),
        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
      )      
    ),

    'js_view' => 'VcAccordionTabView'
) );
}
/********************/
/* Recent Portfolio */
/********************/
function landmark_construction_portfolio_widget($atts){
   extract(shortcode_atts ( array(
      'style' => 'portfolio-style1',
      'r' => '',
      'item_count' => '',
      'taxonomies' => '',
      'order' => 'DESC',
      'title_color' => '',
      'meta_color' => '',
      'icon_bg' => '',
      'icon_color' => '',
      'icon_border' => '',
      'excerpt_color' => '',
      'content_color' => '',
      'overlay_color' => '',
      'title_color_hover' => '',
      'meta_color_hover' => '',
      'excerpt_color_hover' => '',
      'icon_bg_hover' => '',
      'icon_color_hover' => '',
      'icon_border_hover' => '',
      'content_color_hover' => ''    
    ), 
   $atts));
        $portfolio_user_style = "";
        $portfoliorandom = landmark_construction_theme_random_string(20); 
        $ordery = $order;
        if ( empty($item_count) )
        {
          $item_count = 10;
        }
  
      if ( $style == "portfolio-style13" ) {
      $item_count = 8;
      }
      
    if ( !empty($title_color)) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' h3 a {color:'.$title_color.'}';
    }
    if ( !empty($title_color_hover)) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item:hover h3 a {color:'.$title_color_hover.'}';
    }
    if ( !empty($icon_bg)) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item-over a {background:'.$icon_bg.'}';
    }
    if ( !empty($icon_bg_hover)) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item-over a:hover {background:'.$icon_bg_hover.'}';
    }
    if ( !empty($icon_color)) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item-over a {color:'.$icon_color.'}';
    }
    if ( !empty($icon_color_hover)) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item-over a:hover {color:'.$icon_color_hover.'}';
    }
    if ( !empty($icon_border)) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item-over a {border-color:'.$icon_border.'}';
    }
    if ( !empty($icon_border_hover)) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item-over a:hover {border-color:'.$icon_border_hover.'}';
    }
    if ( !empty($excerpt_color)) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-excerpt {color:'.$excerpt_color.'}';
    }
    if ( !empty($excerpt_color_hover)) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item:hover .portfolio-excerpt {color:'.$excerpt_color_hover.'}';
    }
    if ( !empty($content_color)) {
      if ( $style == "portfolio-style1" || $style == "portfolio-style2" || $style == "portfolio-style4" || $style == "portfolio-style5" || $style == "portfolio-style6" || $style == "portfolio-style7" || $style == "portfolio-style12" || $style == "portfolio-style14" || $style == "portfolio-style17" ) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-meta {background:'.$content_color.'}';
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-meta {background:'.$content_color.'}';
      $portfolio_user_style .= '#portfolio-style4 .portfolio-meta:before {color:'.$content_color.'}';
      $portfolio_user_style .= '#portfolio-style1.portfolio-items .portfolio-item .portfolio-meta:before {color:'.$content_color.'}';
      }
      if ( $style == "portfolio-style18") {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item-title {background:'.$content_color.'}';        
      }

      if ( $style == "portfolio-style17" || $style == "portfolio-style5") {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item-over {background:'.$content_color.'}';
      }
    }
    if ( !empty($content_color_hover)) {
      if ( $style == "portfolio-style1" || $style == "portfolio-style2" || $style == "portfolio-style4" || $style == "portfolio-style5" || $style == "portfolio-style6" || $style == "portfolio-style7" || $style == "portfolio-style12" || $style == "portfolio-style14" || $style == "portfolio-style17" ) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item:hover .portfolio-meta {background:'.$content_color_hover.'}';
      $portfolio_user_style .= '#portfolio-style4 .portfolio-item:hover .portfolio-meta:before {color:'.$content_color_hover.'}';
      $portfolio_user_style .= '#portfolio-style1.portfolio-items .portfolio-item:hover .portfolio-meta:before {color:'.$content_color_hover.'}';     
      }
      if ( $style == "portfolio-style18") {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item:hover .portfolio-item-title {background:'.$content_color_hover.'}';        
      }
      if ( $style == "portfolio-style17" || $style == "portfolio-style5") {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item:hover .portfolio-item-over {background:'.$content_color.'}';
      }     
    }

    if ( !empty($overlay_color)) {
      if ( $style == "portfolio-style8" || $style == "portfolio-style9" || $style == "portfolio-style10" || $style == "portfolio-style11" || $style == "portfolio-style15" || $style == "portfolio-style16" || $style == "portfolio-style19" ) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-meta {background:'.$overlay_color.'}';
      }
      if ( $style == "portfolio-style3" || $style == "portfolio-style4" || $style == "portfolio-style7" || $style == "portfolio-style12") {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item-over {background:'.$overlay_color.'}';       
      }     
    }

    if ( !empty($meta_color)) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-cat {color:'.$meta_color.'}';
    }

    if ( !empty($meta_color_hover)) {
      $portfolio_user_style .= '#'.$style.'.portfolio-items.pcustom_'.$portfoliorandom.' .portfolio-item:hover .portfolio-cat {color:'.$meta_color_hover.'}';
    }                                       
        global $post;
        global $wp_query;
        if ( !empty($taxonomies)) {
        
        $taxo = explode(",", $taxonomies);
        $r = new WP_Query( array( 
          'posts_per_page' => $item_count, 
          'post_type' => 'portfolio',
          'order' => $ordery, 
          'tax_query' => array(
                            'relation' => 'AND',
                            array(
                              'taxonomy' => 'post_tag',
                              'field'    => 'id',
                              'terms'    => $taxo,
                              
                            ),  
                        ),
          ) );
        
        }
        else {        
        $r = new WP_Query( array( 'posts_per_page' => $item_count, 'post_type' => 'portfolio', 'order' => $ordery) );
        }
        if ($r->have_posts()) :
            ?>
        <?php ob_start();
        ?>
    <div class="portfolio-container">
    <?php if ( !empty($portfolio_user_style) ) { ?>          
           <style scoped>
           <?php echo ' '.$portfolio_user_style; ?>
           </style>
    <?php } ?>
           <div id="<?php echo esc_attr($style); ?>" class="portfolio-items pcustom_<?php echo esc_attr($portfoliorandom);?>">

            <?php switch ($style) {
              case 'portfolio-style1':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo esc_attr($category->slug).' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-portfolio_size1');
                      }
                  ?>
                    </div>
                    <div class="portfolio-meta">                                  
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                        foreach($categories as $category){
                        echo '<span class="portfolio-cat">'.$category->name.'</span>'; 
                        } ?></p>
                    </div>               
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style2':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-portfolio_size2');
                      }
                  ?>
                    <div class="portfolio-item-over">                
                        <a href="<?php the_permalink(); ?>" id="<?php the_ID(); ?>" class="portfoliolink"><i class="fa fa-link"></i></a>  
                        <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-search"></i></a>                               
                      </div> 
                    </div>
                    <div class="portfolio-meta">                                  
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    </div>                                    
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style3':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-portfolio_size2');
                      }
                  ?>
                      <div class="portfolio-meta">
                          <div class="portfolio-hover-container">
                          <div class="portfolio-hover-center">
                          <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                      <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                          
                          echo '<span class="portfolio-cat">'.$categories[0]->name.'</span>'; 
                           ?></p>
                          </div>
                          </div>
                      </div>
                    </div>               
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style4':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                      <?php  if ( has_post_thumbnail() ) {  
                         the_post_thumbnail('landmark_construction_theme-portfolio_size4');
                      }
                      ?>
                      <div class="portfolio-item-over">  
                        <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-search"></i></a>                               
                      </div>   
                    </div>
                    <div class="portfolio-meta">                                  
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                          
                          echo '<span class="portfolio-cat">'.$categories[0]->name.'</span>'; 
                           ?></p>
                    </div>               
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style5':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail();
                      }
                  ?>
                    </div>
                    <div class="portfolio-meta">                                  
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                        echo '<span class="portfolio-cat"> - '.$categories[0]->name.'</span>'; ?>
                        <div class="portfolio-item-over">                
                        <a href="<?php the_permalink(); ?>" id="<?php the_ID(); ?>" class="portfoliolink"><i class="fa fa-link"></i></a>  
                        <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-search"></i></a>                               
                      </div>
                    </div>                                    
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style6':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail();
                      }
                  ?>
                    </div>
                    <div class="portfolio-meta">                                  
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                        echo '<span class="portfolio-cat">'.$categories[0]->name.'</span>'; ?>
                        <?php if( function_exists('zilla_likes') ) { ?><div class="portfolio-icon-box"><?php zilla_likes(); ?></div><?php } ?>                                                
                    </div>
                   <div class="portfolio-item-over">                
                      <a href="<?php the_permalink(); ?>" id="<?php the_ID(); ?>" class="portfoliolink"><i class="fa fa-link"></i></a>  
                      <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-search"></i></a>                               
                  </div>                                                        
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style7':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                      <?php  if ( has_post_thumbnail() ) {  
                         the_post_thumbnail('landmark_construction_theme-blog_widget3');
                      }
                      ?>
                      <div class="portfolio-item-over">  
                        <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-plus"></i></a>                               
                  </div>   
                    </div>
                    <div class="portfolio-meta">                                  
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                          
                          echo '<span class="portfolio-cat">'.$categories[0]->name.'</span>'; 
                           ?></p>
                    </div>               
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style8':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                      <?php  if ( has_post_thumbnail() ) {  
                         the_post_thumbnail('landmark_construction_theme-portfolio_size8');
                      }
                      ?>  
                    </div>
                    <div class="portfolio-meta">                                  
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                        foreach($categories as $category){
                        echo '<span class="portfolio-cat">'.$category->name.'</span>'; 
                        } ?></p>
                        <div class="portfolio-item-over">  
                      <a href="<?php the_permalink(); ?>" id="<?php the_ID(); ?>" class="portfoliolink"><i class="fa fa-long-arrow-right"></i></a>  
                    </div> 
                    </div>               
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style9':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-portfolio_size8');
                      }
                  ?>
                      <div class="portfolio-meta">
                          <div class="portfolio-hover-container">
                          <div class="portfolio-hover-center">
                          <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                      <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                          
                          echo '<span class="portfolio-cat">'.$categories[0]->name.'</span>'; 
                           ?></p>
                          </div>
                          </div>
                      </div>
                    </div>               
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style10':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-portfolio_size8');
                      }
                  ?>
                      <div class="portfolio-meta">
                          <div class="portfolio-hover-container">
                          <div class="portfolio-hover-center">
                          <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                          <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                             foreach($categories as $category){
                             echo '<span class="portfolio-cat">'.$category->name.'</span>'; 
                          } ?></p>
                          </div>
                          </div>
                        <div class="portfolio-item-over">  
                        <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-plus"></i></a>                               
                        </div>  
                      </div>
                    </div>               
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style11':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-portfolio_size1');
                      }
                  ?>
                      <div class="portfolio-meta">
                          <div class="portfolio-hover-container">
                          <div class="portfolio-hover-center">
                          <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                          <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                          
                          echo '<span class="portfolio-cat">'.$categories[0]->name.'</span>'; 
                           ?></p>
                          <div class="portfolio-item-over">  
                             <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-chevron-right"></i></a>                               
                          </div>    
                          </div>
                          </div>
                      </div>
                    </div>               
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style12':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-portfolio_size8');
                      }
                  ?>  
                        <div class="portfolio-item-over">
                            <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"></a> 
                        </div>
                    </div>
                    <div class="portfolio-meta">                                  
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                        echo '<span class="portfolio-cat">'.$categories[0]->name.'</span>'; ?>
                        <?php if( function_exists('zilla_likes') ) { ?><div class="portfolio-icon-box"><?php zilla_likes(); ?></div><?php } ?>                                                
                    </div>
                                                      
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style13':
                wp_enqueue_script( 'isotope' );
                $item_check = 1;
                ?>
                <div class="portfolio-sizer"></div>
                <div class="portfolio13-gutter"></div>
                <?php
                while ( $r->have_posts() ) : $r->the_post();
                $thumb_check = "masonry2";
                if ( $item_check == 1 ) { $thumb_check = "masonry1"; }
                if ( $item_check == 4 ) { $thumb_check = "masonry3"; }
                $item_check = $item_check + 1;
                ?>
                <div class="portfolio-item bt-<?php echo esc_attr($thumb_check); ?> <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail($thumb_check);
                      }
                  ?>
                    <div class="portfolio-meta">
                            <div class="portfolio-hover-container">
                            <div class="portfolio-hover-center">
                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                            <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                               foreach($categories as $category){
                               echo '<span class="portfolio-cat">'.$category->name.'</span>'; 
                            } ?></p>
                            <div class="portfolio-item-over">  
                               <a href="<?php the_permalink(); ?>" id="<?php the_ID(); ?>" class="portfoliolink"><i class="fa fa-link"></i></a>  
                               <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-search"></i></a>                              
                            </div>   
                            </div>
                            </div> 
                    </div>
                    </div>               
                </div>
               <?php endwhile; 
              break;          
              case 'portfolio-style14':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-portfolio_size8');
                      }
                  ?>
                    </div>
                    <div class="portfolio-meta">                                  
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                        foreach($categories as $category){
                        echo '<span class="portfolio-cat">'.$category->name.'</span>'; 
                        } ?></p>
                    </div>                                                        
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style15':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-portfolio_size2');
                      }
                  ?>
                    <div class="portfolio-meta">
                            <div class="portfolio-hover-container">
                            <div class="portfolio-hover-center">
                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                            <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                               foreach($categories as $category){
                               echo '<span class="portfolio-cat">'.$category->name.'</span>'; 
                            } ?></p>
                            </div>
                            </div>
                            <div class="portfolio-item-over">  
                        <a href="<?php the_permalink(); ?>" id="<?php the_ID(); ?>" class="portfoliolink"><i class="fa fa-link"></i></a>  
                        <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-search"></i></a>                               
                      </div>  
                    </div>
                    </div>               
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style16':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-portfolio_size16');
                      }
                  ?>
                    <div class="portfolio-meta">
                            <div class="portfolio-hover-container">
                            <div class="portfolio-hover-center">
                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                            <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                               foreach($categories as $category){
                               echo '<span class="portfolio-cat">'.$category->name.'</span>'; 
                            } ?></p>
                            <div class="portfolio-item-over">  
                               <a href="<?php the_permalink(); ?>" id="<?php the_ID(); ?>" class="portfoliolink"><i class="fa fa-link"></i></a>  
                               <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-search"></i></a>                              
                            </div>   
                            </div>
                            </div> 
                    </div>
                    </div>               
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style17':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-portfolio_size16');
                      }
                  ?>
                    </div>
                    <div class="portfolio-meta">                                  
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                        echo '<span class="portfolio-cat"> - '.$categories[0]->name.'</span>'; ?>
                        <div class="portfolio-item-over">                
                        <a href="<?php the_permalink(); ?>" id="<?php the_ID(); ?>" class="portfoliolink"><i class="fa fa-link"></i></a>  
                        <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-search"></i></a>                               
                      </div>
                    </div>                                    
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style18':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-masonry3');
                      }
                  ?>
                    </div>
                    <div class="portfolio-meta">
                        <div class="portfolio-item-title">                                  
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                        echo '<span class="portfolio-cat">'.$categories[0]->name.'</span>'; ?>
                        </div>
                        <div class="portfolio-item-over">
                        <?php if( function_exists('zilla_likes') ) { ?><?php zilla_likes(); ?><?php } ?>  
                        <a href="<?php the_permalink(); ?>" id="<?php the_ID(); ?>" class="portfoliolink"><i class="fa fa-link"></i></a>  
                        <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-search"></i></a>                               
                      </div>
                    </div>                                    
                </div>
               <?php endwhile; 
              break;            
              case 'portfolio-style19':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-portfolio_size16');
                      }
                  ?>
                    <div class="portfolio-meta">
                            <div class="portfolio-hover-container">
                            <div class="portfolio-hover-center">
                            <div class="portfolio-item-over">  
                               <a href="<?php the_permalink(); ?>" id="<?php the_ID(); ?>" class="portfoliolink"><i class="fa fa-link"></i></a>  
                               <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-search"></i></a>                              
                            </div>                               
                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                            <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                               foreach($categories as $category){
                               echo '<span class="portfolio-cat">'.$category->name.'</span>'; 
                            } ?></p>
  
                            </div>
                            </div> 
                    </div>
                    </div>               
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style20':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
              $thumb = get_post_thumbnail_id($post->ID); 
              $image = vt_resize( $thumb, '', 480, 558, true );
                      $alt = get_post_meta($thumb, '_wp_attachment_image_alt', true);
                    ?>  
                      <img src="<?php echo esc_url($image['url']); ?>" width="<?php echo esc_attr($image['width']); ?>" height="<?php echo esc_attr($image['height']); ?>"/ alt="<?php echo esc_attr($alt); ?>">
                    <?php
                    }  
                  ?>
                    <div class="portfolio-item-over">
                      <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-search"></i></a>                               
                    </div>
                    <div class="clearfix"></div>
                    </div>
                    <div class="portfolio-meta">                                                          
                        <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                        echo '<span class="portfolio-cat">'.$categories[0]->name.'</span>'; ?>
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <?php the_excerpt(); ?>
                    </div>
                    <div class="clearfix"></div>  
                </div>
               <?php endwhile;              
              break;
              case 'portfolio-style21':
                wp_enqueue_script( 'isotope' );
                $item_check = 1;
                ?>
                <div class="portfolio21-sizer"></div>
                <div class="portfolio21-gutter"></div>
                <?php
                while ( $r->have_posts() ) : $r->the_post();
                
                if ( $item_check == 1 ) { $fimage_width = 761; $fimage_height = 558; $thumb_check = "masonry1"; }
                if ( $item_check == 2 || $item_check == 3 ) { $fimage_width = 480; $fimage_height = 352; $thumb_check = "masonry2"; }
                if ( $item_check == 4 || $item_check == 7 || $item_check == 8 || $item_check == 9 || $item_check == 10 ) { $thumb_check = "masonry3"; $fimage_width = 480; $fimage_height = 352; }
                if ( $item_check == 5 ) { $fimage_width = 761; $fimage_height = 279; $thumb_check = "masonry4"; } 
                if ( $item_check == 6 ) { $fimage_width = 480; $fimage_height = 704; $thumb_check = "masonry5"; }
                $item_check = $item_check + 1;
                ?>
                <div class="portfolio-item bt-<?php echo esc_attr($thumb_check); ?> <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
              $thumb = get_post_thumbnail_id(); 
              $image = vt_resize( $thumb, '', $fimage_width, $fimage_height, true );
                      $alt = get_post_meta($thumb, '_wp_attachment_image_alt', true);
                    ?>  
                      <img src="<?php echo esc_url($image['url']); ?>" width="<?php echo esc_attr($image['width']); ?>" height="<?php echo esc_attr($image['height']); ?>"/ alt="<?php echo esc_attr($alt); ?>">
                    <?php
                    }  
                  ?>
                    <div class="portfolio-meta">
                            <div class="portfolio-hover-container">
                            <div class="portfolio-hover-center">
                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                            <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                               foreach($categories as $category){
                               echo '<span class="portfolio-cat">'.$category->name.'</span>'; 
                            } ?></p>
                            <div class="portfolio-item-over">  
                               <a href="<?php the_permalink(); ?>" id="<?php the_ID(); ?>" class="portfoliolink"><i class="fa fa-link"></i></a>  
                               <a href="<?php echo landmark_construction_theme_portfolio_thumbnail_url( $post->ID ); ?>" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-search"></i></a>                              
                            </div>   
                            </div>
                            </div> 
                    </div>
                    </div>               
                </div>
               <?php endwhile; 
              break;
              case 'portfolio-style22':
                while ( $r->have_posts() ) : $r->the_post();?>
                <div class="portfolio-item <?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                  foreach($categories as $category){
                    echo $category->slug.' '; }?>">
                    <div class="portfolio-thumb">
                  <?php  if ( has_post_thumbnail() ) {  
                    the_post_thumbnail('landmark_construction_theme-portfolio_size8');
                      }
                  ?>
                    </div>
                    <div class="portfolio-meta">                                  
                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                        <p><?php $categories = wp_get_object_terms($post->ID, 'portfolio-category');
                        foreach($categories as $category){
                        echo '<span class="portfolio-cat">'.$category->name.'</span>'; 
                        } ?></p>
                    </div>                                                        
                </div>
               <?php endwhile; 
              break;          
              default:
                break;
            }
            if ( $style != "portfolio-style13" ) {
            ?><div class="clearfix"></div>
            <?php } ?>
           </div>
           </div>           
    
<?php 
endif;
    wp_reset_postdata(); 
    $content = ob_get_contents();
    ob_end_clean();
    return $content;
}
add_shortcode('landmark_construction_portfolio', 'landmark_construction_portfolio_widget');
add_action( 'vc_before_init', 'landmark_construction_portfolio_integrateWithVC' );
function landmark_construction_portfolio_integrateWithVC() {
$vc_taxonomies_types = get_taxonomies( array( 'public' => true ), 'objects' );
$vc_taxonomies = get_terms( array_keys( $vc_taxonomies_types ), array( 'hide_empty' => false ) );
$taxonomies_list = array();
if ( is_array( $vc_taxonomies ) && ! empty( $vc_taxonomies ) ) {
  foreach ( $vc_taxonomies as $t ) {
    if ( is_object( $t ) ) {
      $taxonomies_list[] = array(
        'label' => $t->name,
        'value' => $t->term_id,
        'group_id' => $t->taxonomy,
        'group' =>
          isset( $vc_taxonomies_types[ $t->taxonomy ], $vc_taxonomies_types[ $t->taxonomy ]->labels, $vc_taxonomies_types[ $t->taxonomy ]->labels->name )
            ? $vc_taxonomies_types[ $t->taxonomy ]->labels->name
            : __( 'Taxonomies', "landmark-construction-theme" )
      );
    }
  }
}
$taxonomies_for_filter = array();
if ( is_array( $vc_taxonomies_types ) && ! empty( $vc_taxonomies_types ) ) {
  foreach ( $vc_taxonomies_types as $t => $data ) {
    if ( $t !== 'post_format' && is_object( $data ) ) {
      $taxonomies_for_filter[ $data->labels->name ] = $t;
    }
  }
}   
   vc_map( array(
      "name" => __( "Recent Portfolio Posts", "landmark-construction-theme" ),
      "base" => "landmark_construction_portfolio",
      "class" => "",
      "category" => 'Content',
      "params" => array(
        array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "",
              "heading" => __("Choose your style", 'landmark-construction-theme'),
              "param_name" => "style",
              "value" => array(__('Style 1', "landmark-construction-theme") => "portfolio-style1",  __('Style 2', "landmark-construction-theme") => "portfolio-style2", __('Style 3', "landmark-construction-theme") => "portfolio-style3", __('Style 4', "landmark-construction-theme") => "portfolio-style4", __('Style 5', "landmark-construction-theme") => "portfolio-style5" , __('Style 6', "landmark-construction-theme") => "portfolio-style6", __('Style 7', "landmark-construction-theme") => "portfolio-style7", __('Style 8', "landmark-construction-theme") => "portfolio-style8", __('Style 9', "landmark-construction-theme") => "portfolio-style9", __('Style 10', "landmark-construction-theme") => "portfolio-style10", __('Style 11', "landmark-construction-theme") => "portfolio-style11", __('Style 12', "landmark-construction-theme") => "portfolio-style12", __('Style 13', "landmark-construction-theme") => "portfolio-style13", __('Style 14', "landmark-construction-theme") => "portfolio-style14", __('Style 15', "landmark-construction-theme") => "portfolio-style15", __('Style 16', "landmark-construction-theme") => "portfolio-style16", __('Style 17', "landmark-construction-theme") => "portfolio-style17", __('Style 18', "landmark-construction-theme") => "portfolio-style18", __('Style 19', "landmark-construction-theme") => "portfolio-style19", __('Style 20', "landmark-construction-theme") => "portfolio-style20", __('Style 21', "landmark-construction-theme") => "portfolio-style21", __('Style 22', "landmark-construction-theme") => "portfolio-style22" ),
              "description" => __("Choose your style, content and options change depending on your style", 'landmark-construction-theme')
        ),
    array(
        'type' => 'autocomplete',
        'heading' => __( 'Narrow data source', "landmark-construction-theme" ),
        'param_name' => 'taxonomies',
        'settings' => array(
          'multiple' => true,
          // is multiple values allowed? default false
          // 'sortable' => true, // is values are sortable? default false
          'min_length' => 1,
          // min length to start search -> default 2
          // 'no_hide' => true, // In UI after select doesn't hide an select list, default false
          'groups' => true,
          // In UI show results grouped by groups, default false
          'unique_values' => true,
          // In UI show results except selected. NB! You should manually check values in backend, default false
          'display_inline' => true,
          // In UI show results inline view, default false (each value in own line)
          'delay' => 500,
          // delay for search. default 500
          'auto_focus' => true,
          // auto focus input, default true
          'values' => $taxonomies_list,
        ),
        'param_holder_class' => 'vc_not-for-custom',
        'description' => __( 'Enter menu categories', "landmark-construction-theme" ),
        'dependency' => array(
          'element' => 'post_type',
          'value_not_equal_to' => array( 'ids', 'custom' ),
        ),
      ), 
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Portfolio Order", 'landmark-construction-theme'),
            "param_name" => "order",
            "value" => array(__('Descending ', "landmark-construction-theme") => "DESC ", __('Ascending ', "landmark-construction-theme") => "ASC" ),
            "description" => __("Choose your order.", 'landmark-construction-theme')
        ),  

        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Items", 'landmark-construction-theme'),
            "param_name" => "item_count",
            "description" => __("How many items do you want to show? Please write a number, like 3 or 6 etc..", 'landmark-construction-theme')
        ),

    array(
      "type" => "colorpicker",
      "heading" => __("Color Settings<br><p>these color options depend on your portfolio style. it may be useless to change color for some portfolio style.</p>Title Color", "landmark-construction-theme"),
      "param_name" => "title_color",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Color Style', 'landmark-construction-theme' )   
    ),
    array(
      "type" => "colorpicker",
      "heading" => __("Tags/Category Color", "landmark-construction-theme"),
      "param_name" => "meta_color",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Color Style', 'landmark-construction-theme' )   
    ),
    array(
      "type" => "colorpicker",
      "heading" => __("Excerpt Color", "landmark-construction-theme"),
      "param_name" => "excerpt_color",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Color Style', 'landmark-construction-theme' )   
    ),        
    array(
      "type" => "colorpicker",
      "heading" => __("Icon Background", "landmark-construction-theme"),
      "param_name" => "icon_bg",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Color Style', 'landmark-construction-theme' )   
    ),
    array(
      "type" => "colorpicker",
      "heading" => __("Icon Color", "landmark-construction-theme"),
      "param_name" => "icon_color",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Color Style', 'landmark-construction-theme' )   
    ),
    array(
      "type" => "colorpicker",
      "heading" => __("Icon Border", "landmark-construction-theme"),
      "param_name" => "icon_border",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Color Style', 'landmark-construction-theme' )   
    ),    
    array(
      "type" => "colorpicker",
      "heading" => __("Content Body Background", "landmark-construction-theme"),
      "param_name" => "content_color",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Color Style', 'landmark-construction-theme' )   
    ),
    array(
      "type" => "colorpicker",
      "heading" => __("Overlay Color(on hover picture)", "landmark-construction-theme"),
      "param_name" => "overlay_color",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Color Style', 'landmark-construction-theme' )   
    ),
    array(
      "type" => "colorpicker",
      "heading" => __("Color Settings<br><p>these color options depend on your portfolio style. it may be useless to change color for some portfolio style.</p>Title Color", "landmark-construction-theme"),
      "param_name" => "title_color_hover",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Hover Style', 'landmark-construction-theme' )   
    ),
    array(
      "type" => "colorpicker",
      "heading" => __("Tags/Category Color", "landmark-construction-theme"),
      "param_name" => "meta_color_hover",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Hover Style', 'landmark-construction-theme' )   
    ),
    array(
      "type" => "colorpicker",
      "heading" => __("Excerpt Color", "landmark-construction-theme"),
      "param_name" => "excerpt_color_hover",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Hover Style', 'landmark-construction-theme' )   
    ),        
    array(
      "type" => "colorpicker",
      "heading" => __("Icon Background", "landmark-construction-theme"),
      "param_name" => "icon_bg_hover",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Hover Style', 'landmark-construction-theme' )   
    ),
    array(
      "type" => "colorpicker",
      "heading" => __("Icon Color", "landmark-construction-theme"),
      "param_name" => "icon_color_hover",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Hover Style', 'landmark-construction-theme' )   
    ),
    array(
      "type" => "colorpicker",
      "heading" => __("Icon Border", "landmark-construction-theme"),
      "param_name" => "icon_border_hover",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Hover Style', 'landmark-construction-theme' )   
    ),    
    array(
      "type" => "colorpicker",
      "heading" => __("Content Body Background", "landmark-construction-theme"),
      "param_name" => "content_color_hover",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
      'group' => __( 'Hover Style', 'landmark-construction-theme' )   
    )                                                                         
      )
   ) );
}
/*********************/
/* Recent Blog Posts */
/*********************/
function landmark_construction_blog_widget($atts){
   extract(shortcode_atts ( array(
      'style' => 'bt_blog-style1',
      'r' => '',
      'item_count' => '',
      'order' => '',
      'readmore' => '',
      'share' => '',
      'single_comment' => '',
      'plural_comment' => '',
      'by_translate'=> '',
      'taxonomies' => '',
      'title_color' => '',
      'main_background' => '',
      'blog_footer_color' => '',
      'excerpt_color' => '',
      'meta_color' => '',
      'read_bg' => '',
      'read_color' => '',
      'title_hover_color' => '',
      'read_bg_hover' => '',
      'read_color_hover' => ''
    ), 
   $atts));
    $ordery = $order;
    if ( empty($item_count) ) { $item_count = 10; }
    if ( empty($readmore) ) { $readmore = "Read More"; }
    if ( empty($share) ) { $share = "Share"; }
    if ( empty($single_comment) ) { $single_comment = "Comment"; }
    if ( empty($plural_comment) ) { $plural_comment = "Comments"; }   
    if ( empty($by_translate) ) { $by_translate = "By"; }   
    global $post;
    global $wp_query;

        if ( !empty($taxonomies)) {
        
        $taxo = explode(",", $taxonomies);
        $r = new WP_Query( array( 
          'posts_per_page' => $item_count, 
          'post_type' => 'post',
          'order' => $ordery, 
          'tax_query' => array(
                            'relation' => 'AND',
                            array(
                              'taxonomy' => 'category',
                              'field'    => 'id',
                              'terms'    => $taxo,
                              
                            ),  
                        ),
          ) );
        
        }
        else {        
        $r = new WP_Query( array( 'posts_per_page' => $item_count, 'post_type' => 'post', 'order' => $ordery) );
        }

  if ($r->have_posts()) :
    ob_start();
    ?>
    <div class="bt-recent-blog-container">
    <?php
    $blog_user_style = "";
    if ( !empty($main_background) ) {
      $blog_user_style .=  '.bt-recent-blog-widget .bt_content, .bt-recent-blog-widget > div, .bt-recent-blog-widget .bt_recent_blog-style5 .bt-blog-date-inner, .bt-recent-blog-widget .bt_recent_blog-style10 { background:'.$main_background.' ;}';
    }

    if ( !empty($blog_footer_color)) {
      $blog_user_style .= '.bt-recent-blog-widget .bt_recent_blog-style1 .bt_blog_widget_footer, .bt-recent-blog-widget .bt_recent_blog-style3 .bt_blog_widget_footer, bt_blog_widget_footer, .bt-recent-blog-widget .bt_recent_blog-style7 .blog-subtitle { background: '.$main_background.';}';
    }

    if ( !empty($excerpt_color)) {
      $blog_user_style .= '.bt-recent-blog-widget .blog-content p { color: '.$excerpt_color.'; }';
    }

    if ( !empty($meta_color)) {
      $blog_user_style .= '.bt-recent-blog-widget .blog-subtitle, .bt-recent-blog-widget .blog-subtitle a, .bt-recent-blog-widget .bt_recent_blog-style7 .blog-subtitle i, .bt-recent-blog-widget .bt_recent_blog-style4 .blog-icon-box, .bt-recent-blog-widget .bt_recent_blog-style3 .blog-icon-box, .bt-recent-blog-widget .bt_recent_blog-style1 .bt_blog_widget_footer {color: '.$meta_color.';}';
    }

    if ( !empty($title_color)) {
      $blog_user_style .= '.bt-recent-blog-widget h3.blog-title a { color: '.$title_color.';}';
    }
    if ( !empty($title_hover_color)) {
      $blog_user_style .= '.bt-recent-blog-widget h3.blog-title a:hover { color: '.$title_hover_color.';}';
    }
    if ( !empty($read_bg)) {
      $blog_user_style .= '.bt-recent-blog-widget a.bt_blog_widget-more { background: '.$read_bg.'!important;}';
    }

    if ( !empty($read_color)) {
      $blog_user_style .= '.bt-recent-blog-widget a.bt_blog_widget-more { color: '.$read_color.'!important;}';
    }

    if ( !empty($read_bg_hover)) {
      $blog_user_style .= '.bt-recent-blog-widget a.bt_blog_widget-more:hover { background: '.$read_bg_hover.'!important;}';
    }

    if ( !empty($read_color_hover)) {
      $blog_user_style .= '.bt-recent-blog-widget a.bt_blog_widget-more:hover { color: '.$read_color_hover.'!important;}';
    }
    ?>
    <?php if ( !empty($blog_user_style) ) { ?>          
           <style scoped>
           <?php echo ' '.$blog_user_style; ?>
           </style>
    <?php } ?>    
    <ul class="bt-recent-blog-widget">
    <?php
    
    switch ($style) {
      case 'bt_blog-style1':
        while ( $r->have_posts() ) : $r->the_post();
        
        ?>
          <li <?php post_class('bt_recent_blog-style1'); ?>>
            <div class="bt_thumbnail">
          <?php             
              $format = get_post_format();
              switch ($format) {
                case 'audio':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget1'); }
                  ?>
                  <div class="bt_audio"><?php landmark_construction_theme_audio();?></div>
                  <?php
                  break;
                case 'video':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget1'); }
                  ?>
                <div id="prettyVideo-<?php the_ID();?>" class="bt_video hide"><?php landmark_construction_theme_video(); ?></div>
                <div class="bt-video-icon"><a class="prettyPhoto" data-rel="prettyPhoto" href="#prettyVideo-<?php the_ID();?>"><i class="fa fa-play"></i></a></div>                 
                  <?php
                  break;
                case 'gallery':
                  landmark_construction_theme_gallery('landmark_construction_theme-blog_widget1');
                  break;
                default:
                  if (has_post_thumbnail()) { 
                  ?><a class="prettyPhoto" data-rel="prettyPhoto" href="<?php echo wp_get_attachment_url(get_post_thumbnail_id(get_the_ID())); ?>">
                  <?php
                    the_post_thumbnail('landmark_construction_theme-blog_widget1');
                  ?></a><?php  
                  }
                  ?>
                  <?php
                  break;
              }
            ?>
            </div>
            <div class="bt_content">
              <h3 class="blog-title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>                     
              <div class="blog-subtitle">
                <?php echo esc_html($by_translate); echo ' '; echo the_author_posts_link(); ?>
                <span class="bt_blog_title_sep"> | </span>
                <?php the_time('j F Y'); ?>
              </div>
              <div class="blog-content">
                <?php echo '<p>' . wp_trim_words( get_the_content(), 36 ) . '</p>'; ?>
              </div>
            </div>
            <div class="bt_blog_widget_footer">
              <i class="fa fa-comment-o"></i> <?php comments_number( '0 '.$single_comment, '1 '.$plural_comment, '% '.$plural_comment ); ?>
              <a class="bt_blog_widget-more" href="<?php the_permalink(); ?>"><?php echo esc_html($readmore); ?> <i class="fa fa-angle-double-right"></i></a>
              <div class="clearfix"></div>
            </div>
          </li>
        <?php
        endwhile;
        break;
      case 'bt_blog-style2':  
      while ( $r->have_posts() ) : $r->the_post();
        ?>
          <li <?php post_class('bt_recent_blog-style2'); ?>>
            <div class="bt_thumbnail">
          <?php             
              $format = get_post_format();
              switch ($format) {
                case 'audio':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget1'); }
                  ?>
                  <div class="bt_audio"><?php landmark_construction_theme_audio();?></div>
                  <?php
                  break;
                case 'video':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget1'); }
                  ?>
                <div id="prettyVideo-<?php the_ID();?>" class="bt_video hide"><?php landmark_construction_theme_video(); ?></div>
                <div class="bt-video-icon"><a class="prettyPhoto" data-rel="prettyPhoto" href="#prettyVideo-<?php the_ID();?>"><i class="fa fa-play"></i></a></div>             
                  <?php
                  break;
                case 'gallery':
                  landmark_construction_theme_gallery('landmark_construction_theme-blog_widget1');
                  break;
                default:
                  if (has_post_thumbnail()) { 
                  ?><a class="prettyPhoto" data-rel="prettyPhoto" href="<?php echo wp_get_attachment_url(get_post_thumbnail_id(get_the_ID())); ?>">
                  <?php
                    the_post_thumbnail('landmark_construction_theme-blog_widget1');
                  ?></a><?php  
                  }
                  ?>                  
                  <?php
                  break;
              }
            ?>
            </div>
            <div class="bt_content">
              <h3 class="blog-title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>                     
              <div class="blog-subtitle">
                <?php echo esc_html($by_translate); echo ' '; echo the_author_posts_link(); ?>
                <span class="bt_blog_title_sep"> | </span>
                <?php comments_number( '0 '.$single_comment, '1 '.$plural_comment, '% '.$plural_comment ); ?>
              </div>
              <div class="blog-content">
                <?php echo '<p>' . wp_trim_words( get_the_content(), 23 ) . '</p>'; ?>
              </div>
            </div>
            <a class="bt_blog_widget-more" href="<?php the_permalink(); ?>"><?php echo esc_html($readmore); ?> <i class="fa fa-angle-double-right"></i></a>
          </li>
        <?php
        endwhile;
        break;
      case 'bt_blog-style3':  
        while ( $r->have_posts() ) : $r->the_post();
        ?>
          <li <?php post_class('bt_recent_blog-style3'); ?>>
            <div class="bt_thumbnail">
          <?php             
              $format = get_post_format();
              switch ($format) {
                case 'audio':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget3'); }
                  ?>
                  <div class="bt_audio"><?php landmark_construction_theme_audio();?></div>
                  <?php
                  break;
                case 'video':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget3'); }
                  ?>
                <div id="prettyVideo-<?php the_ID();?>" class="bt_video hide"><?php landmark_construction_theme_video(); ?></div>
                <div class="bt-video-icon"><a class="prettyPhoto" data-rel="prettyPhoto" href="#prettyVideo-<?php the_ID();?>"><i class="fa fa-play"></i></a></div>                 
                  <?php
                  break;
                case 'gallery':
                  landmark_construction_theme_gallery('landmark_construction_theme-blog_widget3');
                  break;
                default:
                  if (has_post_thumbnail()) { 
                  ?><a class="prettyPhoto" data-rel="prettyPhoto" href="<?php echo wp_get_attachment_url(get_post_thumbnail_id(get_the_ID())); ?>">
                  <?php
                    the_post_thumbnail('landmark_construction_theme-blog_widget3'); 
                  ?></a><?php  
                  }
                  ?>                  
                  <?php
                  break;
              }
            ?>
                  <div class="overdate"><span class="dateonly-j"><?php the_time('j'); ?></span><span class="dateonly-m"><?php the_time('M'); ?></span></div>
            </div>
            <div class="bt_content">
              <h3 class="blog-title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>                     
              <div class="blog-subtitle">
                <?php echo esc_html($by_translate); echo ' '; echo the_author_posts_link(); ?>
                <span class="bt_blog_title_sep"> | </span>
                <?php the_category('<span>,</span> '); ?>
              </div>
              <div class="blog-content">
                <?php echo '<p>' . wp_trim_words( get_the_content(), 36 ) . '</p>'; ?>
              </div>
            </div>
            <div class="bt_blog_widget_footer">
              <?php if( function_exists('zilla_likes') ) { ?><div class="blog-icon-box pull-left"><?php zilla_likes(); ?></div><?php } ?>
              <div class="blog-icon-box pull-left"><i class="fa fa-comment-o"></i> <?php comments_number( '0', '1', '%' ); ?></div>
              <div class="blog-icon-box pull-right"><a class="bt_blog_widget-more" href="<?php the_permalink(); ?>"><i class="fa fa-long-arrow-right"></i><?php echo esc_html($readmore); ?></a></div>
              <div class="clearfix"></div>
            </div>
          </li>
        <?php
        endwhile;
        break;
      case 'bt_blog-style4':  
        while ( $r->have_posts() ) : $r->the_post();
        ?>
          <li <?php post_class('bt_recent_blog-style4'); ?>>
            <div class="bt_thumbnail">
          <?php             
              $format = get_post_format();
              switch ($format) {
                case 'audio':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget3'); }
                  ?>
                  <div class="bt_audio"><?php landmark_construction_theme_audio();?></div>
                  <?php
                  break;
                case 'video':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget3'); }
                  ?>
                <div id="prettyVideo-<?php the_ID();?>" class="bt_video hide"><?php landmark_construction_theme_video(); ?></div>
                <div class="bt-video-icon"><a class="prettyPhoto" data-rel="prettyPhoto" href="#prettyVideo-<?php the_ID();?>"><i class="fa fa-play"></i></a></div>                 
                  <?php
                  break;
                case 'gallery':
                  landmark_construction_theme_gallery('landmark_construction_theme-blog_widget3');
                  break;
                default:
                  if (has_post_thumbnail()) { 
                  ?><a class="prettyPhoto" data-rel="prettyPhoto" href="<?php echo wp_get_attachment_url(get_post_thumbnail_id(get_the_ID())); ?>">
                  <?php
                    the_post_thumbnail('landmark_construction_theme-blog_widget3'); 
                  ?></a><?php  
                  }
                  ?>                  
                  <?php
                  break;
              }
            ?>
                <div class="overthumb-author"><?php echo get_avatar( get_the_author_meta('email') , 67 ); ?></div>
            </div>
            <div class="bt_content">
              <h3 class="blog-title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>                     
              <div class="blog-subtitle">
                <?php echo esc_html($by_translate); echo ' '; echo the_author_posts_link(); ?>
                <span class="bt_blog_title_sep"> . </span>
                <?php the_time('j F Y'); ?>
                <span class="bt_blog_title_sep"> . </span>
                <?php the_category('<span>,</span> '); ?>
              </div>
              <div class="blog-content">
                <?php echo '<p>' . wp_trim_words( get_the_content(), 36 ) . '</p>'; ?>
              </div>
            </div>
            <div class="bt_blog_widget_footer">
              <div class="blog-icon-box pull-left"><i class="fa fa-comment-o"></i> <?php comments_number( '0', '1', '%' ); ?></div>
              <?php if( function_exists('zilla_likes') ) { ?><div class="blog-icon-box pull-left"><?php zilla_likes(); ?></div><?php } ?>
              <div class="blog-icon-box pull-left blog-widget-share"><i class="fa fa-share"></i> <?php echo esc_html($share); ?><?php landmark_construction_theme_share_widget(); ?></div>
              <div class="blog-icon-box pull-right"><a class="bt_blog_widget-more" href="<?php the_permalink(); ?>"><?php echo esc_html($readmore); ?></a></div>
              <div class="clearfix"></div>
            </div>
          </li>
        <?php
        endwhile;
        break;
      case 'bt_blog-style5':  
        while ( $r->have_posts() ) : $r->the_post();
        ?>
          <li <?php post_class('bt_recent_blog-style5'); ?>>
            <div class="bt_thumbnail">
          <?php             
              $format = get_post_format();
              switch ($format) {
                case 'audio':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget5'); }
                  ?>
                  <div class="bt_audio"><?php landmark_construction_theme_audio();?></div>
                  <?php
                  break;
                case 'video':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget5'); }
                  ?>
                <div id="prettyVideo-<?php the_ID();?>" class="bt_video hide"><?php landmark_construction_theme_video(); ?></div>
                <div class="bt-video-icon"><a class="prettyPhoto" data-rel="prettyPhoto" href="#prettyVideo-<?php the_ID();?>"><i class="fa fa-play"></i></a></div>                 
                  <?php
                  break;
                case 'gallery':
                  landmark_construction_theme_gallery('landmark_construction_theme-blog_widget5');
                  break;
                default:
                  if (has_post_thumbnail()) { 
                  ?><a class="prettyPhoto" data-rel="prettyPhoto" href="<?php echo wp_get_attachment_url(get_post_thumbnail_id(get_the_ID())); ?>">
                  <?php
                    the_post_thumbnail('landmark_construction_theme-blog_widget5'); 
                  ?></a><?php  
                  }
                  ?>                  
                  <?php
                  break;
              }
            ?>
            <div class="bt-blog-widget-date"><div class="bt-blog-date-inner"><?php the_time('j F Y'); ?></div></div>
            </div>
            
            <div class="bt_content">
              <h3 class="blog-title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>                     
              <div class="blog-subtitle">
                <?php echo esc_html($by_translate); echo ' '; echo the_author_posts_link(); ?>
                <span class="bt_blog_title_sep"> . </span>
                <?php the_category('<span>,</span> '); ?>
                <span class="bt_blog_title_sep"> . </span>
                <?php comments_number( '0 '.$single_comment, '1 '.$plural_comment, '% '.$plural_comment ); ?>
              </div>
              <div class="blog-content">
                <?php echo '<p>' . wp_trim_words( get_the_content(), 15 ) . '</p>'; ?>
              </div>
            </div>
            <div class="bt_blog_widget_footer">
              <a class="bt_blog_widget-more" href="<?php the_permalink(); ?>"><?php echo esc_html($readmore); ?></a>             
            </div>
          </li>
        <?php
        endwhile;
        break;
      case 'bt_blog-style6':  
      while ( $r->have_posts() ) : $r->the_post();
        ?>
          <li <?php post_class('bt_recent_blog-style6'); ?>>
            <div class="bt_thumbnail">
          <?php             
              $format = get_post_format();
              switch ($format) {
                case 'audio':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget6'); }
                  ?>
                  <div class="bt_audio"><?php landmark_construction_theme_audio();?></div>
                  <?php
                  break;
                case 'video':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget6'); }
                  ?>
                <div id="prettyVideo-<?php the_ID();?>" class="bt_video hide"><?php landmark_construction_theme_video(); ?></div>
                <div class="bt-video-icon"><a class="prettyPhoto" data-rel="prettyPhoto" href="#prettyVideo-<?php the_ID();?>"><i class="fa fa-play"></i></a></div>                
                  <?php
                  break;
                case 'gallery':
                  landmark_construction_theme_gallery('landmark_construction_theme-blog_widget6');
                  break;
                default:
                  if (has_post_thumbnail()) { 
                  ?><a class="prettyPhoto" data-rel="prettyPhoto" href="<?php echo wp_get_attachment_url(get_post_thumbnail_id(get_the_ID())); ?>">
                  <?php
                    the_post_thumbnail('landmark_construction_theme-blog_widget6'); 
                  ?></a><?php  
                  }
                  ?>                  
                  <?php
                  break;
              }
            ?>   <div class="overdate"><span class="dateonly-j"><?php the_time('j'); ?></span><span class="dateonly-m"><?php the_time('M'); ?></span></div>
                 <div class="icon"></div> 
            </div>
            <div class="bt_content">
              <h3 class="blog-title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>                     
              <div class="blog-subtitle">
                <?php echo esc_html($by_translate); echo ' '; echo the_author_posts_link(); ?>
                <span class="bt_blog_title_sep"> . </span>
                <?php the_category('<span>,</span> '); ?>
                <span class="bt_blog_title_sep"> . </span>
                <?php comments_number( '0 '.$single_comment, '1 '.$plural_comment, '% '.$plural_comment ); ?>
              </div>
              <div class="blog-content">
                <?php echo '<p>' . wp_trim_words( get_the_content(), 23 ) . '</p>'; ?>
              </div>
            </div>
            <a class="bt_blog_widget-more" href="<?php the_permalink(); ?>"><?php echo esc_html($readmore); ?> <i class="fa fa-angle-double-right"></i></a>
          </li>
        <?php
        endwhile;
        break;     
      case 'bt_blog-style7':  
      while ( $r->have_posts() ) : $r->the_post();
        ?>
          <li <?php post_class('bt_recent_blog-style7'); ?>>
            <div class="bt_thumbnail">
          <?php             
              $format = get_post_format();
              switch ($format) {
                case 'audio':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget5'); }
                  ?>
                  <div class="bt_audio"><?php landmark_construction_theme_audio();?></div>
                  <?php
                  break;
                case 'video':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget5'); }
                  ?>
                <div id="prettyVideo-<?php the_ID();?>" class="bt_video hide"><?php landmark_construction_theme_video(); ?></div>
                <div class="bt-video-icon"><a class="prettyPhoto" data-rel="prettyPhoto" href="#prettyVideo-<?php the_ID();?>"><i class="fa fa-play"></i></a></div>                 
                  <?php
                  break;
                case 'gallery':
                  landmark_construction_theme_gallery('landmark_construction_theme-blog_widget5');
                  break;
                default:
                  if (has_post_thumbnail()) { 
                  ?>
                  <?php
                    the_post_thumbnail('landmark_construction_theme-blog_widget5'); 
                  }
                  ?>
                  <div class="blog-over-thumb">
                    <a class="prettyPhoto" data-rel="prettyPhoto" href="<?php echo wp_get_attachment_url(get_post_thumbnail_id(get_the_ID())); ?>"><i class="fa fa-eye"></i></a>
                    <a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><i class="fa fa-link"></i></a>
                  </div>
                  <?php
                  break;
              }
            ?>
            </div>
            <div class="bt_content">
              <div class="blog-subtitle">
                <i class="fa fa-user"></i><?php echo the_author_posts_link(); ?>
                <i class="fa fa-calendar"></i><?php the_time('M j'); ?>
                <i class="fa fa-comment"></i><?php comments_number( '0', '1', '%' ); ?>
                <?php if( function_exists('zilla_likes') ) { zilla_likes(); } ?>
              </div>
              <div class="blog_widget7-content">
                <h3 class="blog-title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>                                   
                <div class="blog-content">
                  <?php echo '<p>' . wp_trim_words( get_the_content(), 23 ) . '</p>'; ?>
                </div>
              </div>
            </div>       
          </li>
        <?php
        endwhile;
        break;
      case 'bt_blog-style8':  
      while ( $r->have_posts() ) : $r->the_post();
        ?>
          <li <?php post_class('bt_recent_blog-style8'); ?>>
            <div class="bt_thumbnail">
          <?php             
              $format = get_post_format();
              switch ($format) {
                case 'audio':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget8'); }
                  ?>
                  <div class="bt_audio"><?php landmark_construction_theme_audio();?></div>
                  <?php
                  break;
                case 'video':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget8'); }
                  ?>
                <div id="prettyVideo-<?php the_ID();?>" class="bt_video hide"><?php landmark_construction_theme_video(); ?></div>
                <div class="bt-video-icon"><a class="prettyPhoto" data-rel="prettyPhoto" href="#prettyVideo-<?php the_ID();?>"><i class="fa fa-play"></i></a></div>                 
                  <?php
                  break;
                case 'gallery':
                  landmark_construction_theme_gallery('landmark_construction_theme-blog_widget8');
                  break;
                default:
                  if (has_post_thumbnail()) { 
                  ?>
                  <?php
                    the_post_thumbnail('landmark_construction_theme-blog_widget8'); 
                  }
                  ?>
                  <?php
                  break;
              }
            ?>
                  <div class="blog-over-thumb">
                    <div class="blog-icon-box"><i class="fa fa-comment"></i> <?php comments_number( '0', '1', '%' ); ?></div>
                    <?php if( function_exists('zilla_likes') ) { ?><div class="blog-icon-box"><?php zilla_likes(); ?></div><?php } ?>
                    <div class="blog-icon-box blog-widget-share"><i class="fa fa-share"></i> <?php echo esc_html($share); ?>
                    <?php landmark_construction_theme_share_widget(); ?>
                    </div>
                  </div>              
            </div>
            <div class="bt_content">
              <h3 class="blog-title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
              <div class="blog-subtitle">
                <?php echo esc_html($by_translate); echo ' '; echo the_author_posts_link(); ?>
                <span class="bt_blog_title_sep"> | </span>
                <?php the_time('F j, Y'); ?>
              </div>                                   
              <div class="blog-content">
                <?php
                  the_content('...');
                ?>
              </div>
            </div>
            <div class="clearfix"></div>       
          </li>
        <?php
        endwhile;
        break;
      case 'bt_blog-style9':  
      while ( $r->have_posts() ) : $r->the_post();
        ?>
          <li <?php post_class('bt_recent_blog-style9'); ?>>
            <div class="bt_thumbnail">
          <?php             
              $format = get_post_format();
              switch ($format) {
                case 'audio':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget9'); }
                  ?>
                  <div class="bt_audio"><?php landmark_construction_theme_audio();?></div>
                  <?php
                  break;
                case 'video':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget9'); }
                  ?>
                <div id="prettyVideo-<?php the_ID();?>" class="bt_video hide"><?php landmark_construction_theme_video(); ?></div>
                <div class="bt-video-icon"><a class="prettyPhoto" data-rel="prettyPhoto" href="#prettyVideo-<?php the_ID();?>"><i class="fa fa-play"></i></a></div>                 
                  <?php
                  break;
                case 'gallery':
                  landmark_construction_theme_gallery('landmark_construction_theme-blog_widget9');
                  break;
                default:
                  if (has_post_thumbnail()) { 
                  ?>
                  <?php
                    the_post_thumbnail('landmark_construction_theme-blog_widget9'); 
                  }
                  ?>
                  <?php
                  break;
              }
            ?>              
            </div>
            <div class="bt_content">
              <h3 class="blog-title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
              <div class="blog-subtitle">
                <?php echo esc_html($by_translate); echo ' '; echo the_author_posts_link(); ?>
                <span class="bt_blog_title_sep"> . </span>
                <?php the_category('<span>,</span> '); ?>
                <span class="bt_blog_title_sep"> . </span>
                <?php comments_number( '0 '.$single_comment, '1 '.$plural_comment, '% '.$plural_comment ); ?>
              </div>                                   
              <div class="blog-content">
                <?php
                  echo '<p>' . wp_trim_words( get_the_content(), 12 ) . '</p>';
                ?>
              </div>
            </div>
            <div class="clearfix"></div>       
          </li>
        <?php
        endwhile;
        break;
      case 'bt_blog-style10':  
      while ( $r->have_posts() ) : $r->the_post();
        ?>
          <li <?php post_class('bt_recent_blog-style10'); ?>>
            <div class="bt_thumbnail">
          <?php             
              $format = get_post_format();
              switch ($format) {
                case 'audio':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget10'); }
                  ?>
                  <div class="bt_audio"><?php landmark_construction_theme_audio();?></div>
                  <?php
                  break;
                case 'video':
                  if (has_post_thumbnail()) { the_post_thumbnail('landmark_construction_theme-blog_widget10'); }
                  ?>
                <div id="prettyVideo-<?php the_ID();?>" class="bt_video hide"><?php landmark_construction_theme_video(); ?></div>
                <div class="bt-video-icon"><a class="prettyPhoto" data-rel="prettyPhoto" href="#prettyVideo-<?php the_ID();?>"><i class="fa fa-play"></i></a></div>                 
                  <?php
                  break;
                case 'gallery':
                  landmark_construction_theme_gallery('landmark_construction_theme-blog_widget10');
                  break;
                default:
                  if (has_post_thumbnail()) { 
                  ?>
                  <?php
                    the_post_thumbnail('landmark_construction_theme-blog_widget10'); 
                  }
                  ?>
                  <?php
                  break;
              }
            ?>
                  <div class="overdate"><span class="dateonly-j"><?php the_time('j'); ?></span><span class="dateonly-m"><?php the_time('M'); ?></span></div>
                  <div class="icon"></div>              
            </div>
            <div class="bt_content">
              <h3 class="blog-title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
              <div class="blog-subtitle">
                <?php echo esc_html($by_translate); echo ' '; echo the_author_posts_link(); ?>
                <span class="bt_blog_title_sep"> | </span>
                <?php the_time('F j, Y'); ?>
              </div>                                   
              <div class="blog-content">
                <?php
                  the_content('...');
                ?>
              </div>
            </div>
            <div class="clearfix"></div>       
          </li>
        <?php
        endwhile;
        break;      
      default:
        # code...
        break;
    }
    ?>
    </ul>
    </div>
    <?php
  endif;
    wp_reset_postdata(); 
    $content = ob_get_contents();
    ob_end_clean();
    return $content;
}
add_shortcode('bt_blog_widget', 'landmark_construction_blog_widget');
add_action( 'vc_before_init', 'bt_blog_widget_integrateWithVC' );
function bt_blog_widget_integrateWithVC() {

$vc_taxonomies_types = get_taxonomies( array( 'public' => true ), 'objects' );
$vc_taxonomies = get_terms( array_keys( $vc_taxonomies_types ), array( 'hide_empty' => false ) );
$taxonomies_list = array();
if ( is_array( $vc_taxonomies ) && ! empty( $vc_taxonomies ) ) {
  foreach ( $vc_taxonomies as $t ) {
    if ( is_object( $t ) ) {
      $taxonomies_list[] = array(
        'label' => $t->name,
        'value' => $t->term_id,
        'group_id' => $t->taxonomy,
        'group' =>
          isset( $vc_taxonomies_types[ $t->taxonomy ], $vc_taxonomies_types[ $t->taxonomy ]->labels, $vc_taxonomies_types[ $t->taxonomy ]->labels->name )
            ? $vc_taxonomies_types[ $t->taxonomy ]->labels->name
            : __( 'Taxonomies', "landmark-construction-theme" )
      );
    }
  }
}
$taxonomies_for_filter = array();
if ( is_array( $vc_taxonomies_types ) && ! empty( $vc_taxonomies_types ) ) {
  foreach ( $vc_taxonomies_types as $t => $data ) {
    if ( $t !== 'post_format' && is_object( $data ) ) {
      $taxonomies_for_filter[ $data->labels->name ] = $t;
    }
  }
}  
   vc_map( array(
      "name" => __( "Recent Blog Posts", "landmark-construction-theme" ),
      "base" => "bt_blog_widget",
      "class" => "",
      "category" => 'Content',
      "params" => array(
        array(
              "type" => "dropdown",
              "holder" => "div",
              "class" => "",
              "heading" => __("Choose your style", 'landmark-construction-theme'),
              "param_name" => "style",
              "value" => array(__('Style 1', "landmark-construction-theme") => "bt_blog-style1",  __('Style 2', "landmark-construction-theme") => "bt_blog-style2", __('Style 3', "landmark-construction-theme") => "bt_blog-style3", __('Style 4', "landmark-construction-theme") => "bt_blog-style4", __('Style 5', "landmark-construction-theme") => "bt_blog-style5" , __('Style 6', "landmark-construction-theme") => "bt_blog-style6", __('Style 7', "landmark-construction-theme") => "bt_blog-style7", __('Style 8', "landmark-construction-theme") => "bt_blog-style8", __('Style 9', "landmark-construction-theme") => "bt_blog-style9", __('Style 10', "landmark-construction-theme") => "bt_blog-style10"),
              "description" => __("Choose your style, content and options change depending on your style", 'landmark-construction-theme')
        ),
    array(
        'type' => 'autocomplete',
        'heading' => __( 'Narrow data source', "landmark-construction-theme" ),
        'param_name' => 'taxonomies',
        'settings' => array(
          'multiple' => true,
          // is multiple values allowed? default false
          // 'sortable' => true, // is values are sortable? default false
          'min_length' => 1,
          // min length to start search -> default 2
          // 'no_hide' => true, // In UI after select doesn't hide an select list, default false
          'groups' => true,
          // In UI show results grouped by groups, default false
          'unique_values' => true,
          // In UI show results except selected. NB! You should manually check values in backend, default false
          'display_inline' => true,
          // In UI show results inline view, default false (each value in own line)
          'delay' => 500,
          // delay for search. default 500
          'auto_focus' => true,
          // auto focus input, default true
          'values' => $taxonomies_list,
        ),
        'param_holder_class' => 'vc_not-for-custom',
        'description' => __( 'Enter categories (not working with tags now in landmark Widgets, you can use with grid builder)', "landmark-construction-theme" ),
        'dependency' => array(
          'element' => 'post_type',
          'value_not_equal_to' => array( 'ids', 'custom' ),
        ),
      ),         
        array(
            "type" => "dropdown",
            "holder" => "div",
            "class" => "",
            "heading" => __("Blog Order", 'landmark-construction-theme'),
            "param_name" => "order",
            "value" => array(__('Descending ', "landmark-construction-theme") => "DESC ", __('Ascending ', "landmark-construction-theme") => "ASC" ),
            "description" => __("Choose your order.", 'landmark-construction-theme')
        ),  

        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Items", 'landmark-construction-theme'),
            "param_name" => "item_count",
            "description" => __("How many items do you want to show?", 'landmark-construction-theme')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Translate text for read more", 'landmark-construction-theme'),
            "param_name" => "readmore",
            'group' => __( 'Translation', 'landmark-construction-theme' ),
            "description" => __("Leave it blank for default value, if your language is not same, add your text", 'landmark-construction-theme')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Translate text for share", 'landmark-construction-theme'),
            "param_name" => "share",
            'group' => __( 'Translation', 'landmark-construction-theme' ),
            "description" => __("Leave it blank for default value, if your language is not same, add your text", 'landmark-construction-theme')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Translate text for comment", 'landmark-construction-theme'),
            "param_name" => "single_comment",
            'group' => __( 'Translation', 'landmark-construction-theme' ),
            "description" => __("Leave it blank for default value, if your language is not same, add your text", 'landmark-construction-theme')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Translate text for comments", 'landmark-construction-theme'),
            "param_name" => "plural_comment",
            'group' => __( 'Translation', 'landmark-construction-theme' ),
            "description" => __("Leave it blank for default value, if your language is not same, add your text", 'landmark-construction-theme')
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __("Translate text for by", 'landmark-construction-theme'),
            "param_name" => "by_translate",
            'group' => __( 'Translation', 'landmark-construction-theme' ),           
            "description" => __("Leave it blank for default value, if your language is not same, add your text", 'landmark-construction-theme')
        ),

        array(
          "type" => "colorpicker",
          "heading" => __("Color Settings<br><p>these color options depend on your blog style. it may be useless to change color for some portfolio style.</p>Title Color", "landmark-construction-theme"),
          "param_name" => "title_color",
          "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
          'group' => __( 'Color Style', 'landmark-construction-theme' )   
        ),
        array(
          "type" => "colorpicker",
          "heading" => __("Main Content Background Color", "landmark-construction-theme"),
          "param_name" => "main_background",
          "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
          'group' => __( 'Color Style', 'landmark-construction-theme' )   
        ),
        array(
          "type" => "colorpicker",
          "heading" => __("Second Content Background Color", "landmark-construction-theme"),
          "param_name" => "blog_footer_color",
          "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
          'group' => __( 'Color Style', 'landmark-construction-theme' )   
        ),
        array(
          "type" => "colorpicker",
          "heading" => __("Excerpt Color", "landmark-construction-theme"),
          "param_name" => "excerpt_color",
          "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
          'group' => __( 'Color Style', 'landmark-construction-theme' )   
        ),
        array(
          "type" => "colorpicker",
          "heading" => __("Meta Text Color", "landmark-construction-theme"),
          "param_name" => "meta_color",
          "description" => __("Like author name, category text etc. Leave it blank if you want to use default color", "landmark-construction-theme"),
          'group' => __( 'Color Style', 'landmark-construction-theme' )   
        ),
        array(
          "type" => "colorpicker",
          "heading" => __("Read More Background Color", "landmark-construction-theme"),
          "param_name" => "read_bg",
          "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
          'group' => __( 'Color Style', 'landmark-construction-theme' )   
        ),
        array(
          "type" => "colorpicker",
          "heading" => __("Read More Text Color", "landmark-construction-theme"),
          "param_name" => "read_color",
          "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
          'group' => __( 'Color Style', 'landmark-construction-theme' )   
        ),
        array(
          "type" => "colorpicker",
          "heading" => __("Title Color", "landmark-construction-theme"),
          "param_name" => "title_hover_color",
          "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
          'group' => __( 'Hover Style', 'landmark-construction-theme' )   
        ),
        array(
          "type" => "colorpicker",
          "heading" => __("Read More Background Color", "landmark-construction-theme"),
          "param_name" => "read_bg_hover",
          "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
          'group' => __( 'Hover Style', 'landmark-construction-theme' )   
        ),
        array(
          "type" => "colorpicker",
          "heading" => __("Read More Text Color", "landmark-construction-theme"),
          "param_name" => "read_color_hover",
          "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
          'group' => __( 'Hover Style', 'landmark-construction-theme' )   
        )                                                                                             
      )
   ) );
}

/*********************/
/*   Client Slider   */
/*********************/
function landmark_construction_clients_slider($atts, $content = null) {
   extract(shortcode_atts ( array(
    'style' => 'bt_client_grid',
    'dark_style' => '',
    'animation' => 'no_animation'
    ), 
   $atts));
   
   $client_class ="bt_clients_light";
   if ($dark_style=="yes") { $client_class ="bt_clients_dark"; }
   $data_atts = "";
   $slider_check = " aktif_slider";
   switch ($style) {
        case "bt_client_4":
            $data_atts = 'data-btslidesToShow="4" data-btslidesToScroll="1" data-btarrows="true" data-btdots="false"';
            break;
        case "bt_client_42":
            $data_atts = 'data-btslidesToShow="4" data-btslidesToScroll="1" data-btarrows="true" data-btdots="false"';
            break;            
        case "bt_client_6":
            $data_atts = 'data-btslidesToShow="6" data-btslidesToScroll="6" data-btarrows="false" data-btdots="true"';
            break;           
        case "bt_client_62":
            $data_atts = 'data-btslidesToShow="6" data-btslidesToScroll="6" data-btarrows="true" data-btdots="false"';
            break;   
        default:
            $data_atts = 'data-btslidesToShow="0" data-btslidesToScroll="0" data-btarrows="0" data-btdots="0"';
            $slider_check = "";
    }  
   return '
   <div class="'.$animation. ' bt_clients ' . $style . ' ' . $client_class . ' animated">
    <div class="bt_clients_slider'.$slider_check.'" '.$data_atts.'>
            <div class="slides">
      '.do_shortcode($content).'              
            </div>
        </div>
   </div>';
}
add_shortcode('bt_clients_slider', 'landmark_construction_clients_slider');

function landmark_construction_client_slide($atts) {
   extract(shortcode_atts ( array(
    'client_image' => '',
    'client_link' => '',
    'link_target' => '_self'
    ), 
   $atts));
    
    if ( $link_target == "" ) {
      $link_target = "_self";
    }    
    $img_id = preg_replace('/[^\d]/', '', $client_image);
    $image = wp_get_attachment_image_src( $img_id, 'full');
    $alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
        
    $content = "<div>";  
    if ( !empty($client_link)) { 
      $content .= '<a href="'.esc_url($client_link).'" target="'.esc_attr($link_target).'">';
    } 

    $content .= '<img src="'.esc_url($image[0]).'" width="'.esc_attr($image[1]).'" height="'.esc_attr($image[2]).'" alt="'.esc_attr($alt).'">';

    if ( !empty($client_link)) { 
      $content .= '</a>';
    } 
    $content .= '</div>';

   return $content;
}

add_shortcode('bt_client_slide', 'landmark_construction_client_slide');

add_action( 'vc_before_init', 'bt_clients_slider_integrateWithVC' );
function bt_clients_slider_integrateWithVC() {
   vc_map( array(
      "name" => __( "Clients Slider", "landmark-construction-theme" ),
      "base" => "bt_clients_slider",
      "class" => "",
      "category" => 'Content',
      "as_parent" => array('only' => 'bt_client_slide'),
      "content_element" => true,
      "show_settings_on_create" => true,
      "params" => array(

      array(
          "type" => "dropdown",
          "holder" => "div",
          "class" => "",
          "heading" => __("Slider Type", 'landmark-construction-theme'),
          "param_name" => "style",
          "value" => array(
            __('Grid (no slider)', "landmark-construction-theme") => "bt_client_grid", 
            __('Grid Border', "landmark-construction-theme") => "bt_client_grid_border",
            __('Grid Three', "landmark-construction-theme") => "bt_client_three", 
            __('4 Item Slider', "landmark-construction-theme") => "bt_client_4", 
            __('4 Item Slider 2', "landmark-construction-theme") => "bt_client_42", 
            __('6 Item Slider', "landmark-construction-theme") => "bt_client_6",
            __('6 Item Slider 2', "landmark-construction-theme") => "bt_client_62", 
            __('6 Item Slider 3', "landmark-construction-theme") => "bt_client_63"
            ),
          "description" => __("Choose your style.", 'landmark-construction-theme')                   
      ),

      array(
          "type" => 'checkbox',
          "heading" => __("Use Dark Style", "landmark-construction-theme"),
          "param_name" => "dark_style",
          "description" => __("Use dark style of slider", "landmark-construction-theme"),
          "value" => Array(__("Yes, please", "landmark-construction-theme") => 'yes'),
          "dependency" => Array('element' => "style", 'value' => array('bt_client_6', 'bt_client_62', 'bt_client_63'))
          
      ),

      array(
          "type" => "dropdown",
          "holder" => "div",
          "class" => "",
          "heading" => __("CSS Animation", 'landmark-construction-theme'),
          "param_name" => "animation",
          "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind"),
          "description" => __("Choose your animation.", 'landmark-construction-theme')
      )
      ),
    "js_view" => 'VcColumnView',    
   ) );
}

add_action( 'vc_before_init', 'bt_client_slide_integrateWithVC' );
function bt_client_slide_integrateWithVC() {
   vc_map( array(
      "name" => __( "Clients Slide", "landmark-construction-theme" ),
      "base" => "bt_client_slide",
      "class" => "",
      "category" => 'Content',
      "as_child" => array('only' => 'bt_clients_slider'),
      "content_element" => true,     
      "params" => array(

      array(
        "type" => "attach_image",
        "heading" => __('Client Image', 'landmark-construction-theme'),
        "param_name" => "client_image",
        "description" => __("Select image for your client", "landmark-construction-theme")
      ),
      array(
          "type" => "textfield",
          "holder" => "div",
          "class" => "",
          "heading" => __("Client URL", 'landmark-construction-theme'),
          "param_name" => "client_link",
          "value" => "",
          "description" => __("If you dont want to add link, leave this area blank", 'landmark-construction-theme')
      ),
      array(
          "type" => "dropdown",
          "holder" => "div",
          "class" => "",
          "heading" => __("Link Target", 'landmark-construction-theme'),
          "param_name" => "link_target",
          "value" => array( __('Self Page', "landmark-construction-theme") => "_self", __('New Page', "landmark-construction-theme") => "_blank"),
          "description" => __("Choose your link target.", 'landmark-construction-theme')
      )
      )
   ) );
  
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_bt_clients_slider extends WPBakeryShortCodesContainer {
    }
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_bt_client_slide extends WPBakeryShortCode {
    }
}  
}
/**********************/
/* Testimonial Single */
/**********************/
function landmark_construction_testimonial($atts, $content = null) {
   extract(shortcode_atts ( array(
    'testimonial_style' => 'testimonial-style-1',
    'client_image' => '',
    'client_name' => '',
    'client_position' => '',
    'client_stars' => '',
    'client_subtitle' => ''
    ), 
   $atts));
  $testimonial = $t_stars = $t_image = $t_position = $t_subtitle = "";

  if ( $client_image != "" ) {
    $t_image = '<div class="testimonial-image">';
    $img_id = preg_replace('/[^\d]/', '', $client_image);
      $image = wp_get_attachment_image_src( $img_id, 'full');
    $alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
      
      $t_image .= '<img src="'.esc_url($image[0]).'" width="'.esc_attr($image[1]).'" height="'.esc_attr($image[2]).'" alt="'.esc_attr($alt).'">';
      $t_image .= '</div>';
    }
    if ( $client_stars != "" ) {
      $t_stars = '<div class="testimonial-stars">';
      for ( $i = 1; $i<6; $i++ ) {
        if ( $i <= $client_stars ) {
          $t_stars .= '<i class="fa fa-star btrated"></i>';
        }
        else {
          $t_stars .= '<i class="fa fa-star"></i>';
        }
      }
      $t_stars .= '</div>';
    }
    if ( $client_position != "" ) {
      $t_position = '<span class="testimonial-position">'.$client_position.'</span>';
    }
    if ( $client_subtitle != "" ) {
      $t_subtitle = '<div class="testimonial-extra">'.$client_subtitle.'</div>';
    }

    switch ($testimonial_style) {
      case 'testimonial-style-1':
        $testimonial .= '<div class="bt-testimonial wpb_content_element"><div class="testimonial-style-1">';
        $testimonial .= '<div class="testimonial-content">'.do_shortcode($content).'</div>';
        $testimonial .= $t_image;
        $testimonial .= '<div class="bt-testimonial-bottom">'.$client_name.' ' . $t_position . $t_stars.'</div>';
        $testimonial .= '</div></div>';
        break;
      case 'testimonial-style-2':
        $testimonial .= '<div class="bt-testimonial wpb_content_element"><div class="testimonial-style-2">';
        $testimonial .= $t_image; 
        $testimonial .= '<div class="testimonial-content"><div class="testimonial-client">'.$client_name.'</div>'.$t_position.do_shortcode($content).'<div class="bt-testimonial-bottom">'.$client_subtitle. $t_stars.'</div></div>';
        $testimonial .= '</div></div>';        
        break;
      case 'testimonial-style-3':
        $testimonial .= '<div class="bt-testimonial wpb_content_element"><div class="testimonial-style-3">';
        $testimonial .= '<div class="testimonial-content">'.do_shortcode($content).'</div>';
        $testimonial .= '<div class="bt-testimonial-bottom">'.$t_image.'<div class="testimonial-client">'.$client_name.' '.$t_position.'</div></div>';
        $testimonial .= '</div></div>';
        break;
      case 'testimonial-style-4':
        $testimonial .= '<div class="bt-testimonial wpb_content_element"><div class="testimonial-style-4">';
        $testimonial .= '<div class="testimonial-content">'.do_shortcode($content).'</div>';
        $testimonial .= '<div class="bt-testimonial-bottom">'.$t_image.'<div class="testimonial-client">'.$client_name.' '.$t_position.'</div></div>';
        $testimonial .= '</div></div>';
        break;
      case 'testimonial-style-5':
        $testimonial .= '<div class="bt-testimonial wpb_content_element"><div class="testimonial-style-5">';
        $testimonial .= '<div class="testimonial-content">'.$t_image.do_shortcode($content).'</div>';
        $testimonial .= '<div class="bt-testimonial-bottom">'.$client_name.' '.$t_position.'</div>';
        $testimonial .= '</div></div>';
        break;
      case 'testimonial-style-6':
        $testimonial .= '<div class="bt-testimonial wpb_content_element"><div class="testimonial-style-6">';
        $testimonial .= '<div class="testimonial-content">'.do_shortcode($content).'</div>';
        $testimonial .= '<div class="bt-testimonial-bottom"><div class="testimonial-client">'.$client_name.' '.$t_position.'</div>'.$t_stars.'<div class="clearfix"></div></div>';
        $testimonial .= '</div></div>';
        break; 
      case 'testimonial-style-7':
        $testimonial .= '<div class="bt-testimonial wpb_content_element"><div class="testimonial-style-7">';
        $testimonial .= '<div class="testimonial-content">'.do_shortcode($content).'<div class="testimonial-client">'.$client_name.' '.$t_position.'</div></div>';
        $testimonial .= $t_image.$t_subtitle;
        $testimonial .= '</div></div>';        
        break;
      case 'testimonial-style-8':
        $testimonial .= '<div class="bt-testimonial wpb_content_element"><div class="testimonial-style-8">';
        $testimonial .= '<div class="testimonial-content">'.do_shortcode($content).'<div class="testimonial-client">'.$client_name.' '.$t_position.'</div></div>';
        $testimonial .= $t_image;
        $testimonial .= '</div></div>';           
        break;
      case 'testimonial-style-9':
        $testimonial .= '<div class="bt-testimonial wpb_content_element"><div class="testimonial-style-9">';
        $testimonial .= '<div class="testimonial-content">'.do_shortcode($content).'</div>';
        $testimonial .= '<div class="bt-testimonial-bottom">'.$client_name.' '.$t_position.'</div>';
        $testimonial .= '</div></div>';        
        break;
      case 'testimonial-style-10':
        $testimonial .= '<div class="bt-testimonial wpb_content_element"><div class="testimonial-style-10">';
        $testimonial .= '<div class="testimonial-content">'.do_shortcode($content).'</div>';
        $testimonial .= '<div class="bt-testimonial-bottom">'.$client_name.' '.$t_position.'</div>';
        $testimonial .= '</div></div>';        
        break;       
      default:
        
        break;
    }

    return $testimonial;
}

add_shortcode('bt_testimonial', 'landmark_construction_testimonial');
add_action( 'vc_before_init', 'bt_testimonial_integrateWithVC' );
function bt_testimonial_integrateWithVC() {
   vc_map( array(
      "name" => __( "Testimonial Single", "landmark-construction-theme" ),
      "base" => "bt_testimonial",
      "class" => "",
      "category" => 'Content',
      "params" => array(
      array(
          "type" => "dropdown",
          "holder" => "div",
          "class" => "",
          "heading" => __("Choose your style", 'landmark-construction-theme'),
          "param_name" => "testimonial_style",
      "value" => array( "choose", "testimonial-style-1", "testimonial-style-2", "testimonial-style-3", "testimonial-style-4", "testimonial-style-5", "testimonial-style-6", "testimonial-style-7", "testimonial-style-8", "testimonial-style-9", "testimonial-style-10" ),          
      "description" => __("Choose your style, content and options change depending on your style", 'landmark-construction-theme')
      ),
      array(
        "type" => "attach_image",
        "heading" => __('Client Image', 'landmark-construction-theme'),
        "param_name" => "client_image",
        "description" => __("Select image for your client", "landmark-construction-theme")
      ),
      array(
          "type" => "textfield",
          "holder" => "div",
          "class" => "",
          "heading" => __("Client Name", 'landmark-construction-theme'),
          "param_name" => "client_name",
          "value" => "",
          "description" => __("Add your client name or company name", 'landmark-construction-theme')
      ),
      array(
          "type" => "textfield",
          "holder" => "div",
          "class" => "",
          "heading" => __("Client Position", 'landmark-construction-theme'),
          "param_name" => "client_position",
          "value" => "",
          "description" => __("Add your client position or you can use this area for your other text after client-company name", 'landmark-construction-theme')
      ),
      array(
          "type" => "textarea_html",
          "holder" => "div",
          "class" => "",
          "heading" => __("Client Comment", 'landmark-construction-theme'),
          "param_name" => "content",
          "value" => "",
          "description" => __("Add your client comment", 'landmark-construction-theme')
      ),              
      array(
          "type" => "dropdown",
          "holder" => "div",
          "class" => "",
          "heading" => __("Add Star Rating", 'landmark-construction-theme'),
          "param_name" => "client_stars",
          "value" => array(__('Choose Stars', "landmark-construction-theme") => "0", __('1 Rating', "landmark-construction-theme") => "1", __('2 Rating', "landmark-construction-theme") => "2", __('3 Rating', "landmark-construction-theme") => "3", __('4 Rating', "landmark-construction-theme") => "4", __('5 Rating', "landmark-construction-theme") => "5"),
          "description" => __("You can add rating to your testimonial, dont choose any star if you dont want to add", 'landmark-construction-theme')
      ),
      array(
          "type" => "textfield",
          "holder" => "div",
          "class" => "",
          "heading" => __("Subtitle", 'landmark-construction-theme'),
          "param_name" => "client_subtitle",
          "value" => "",
          "description" => __("You can use this area for adding date or any text. We have used it for date in our demo", 'landmark-construction-theme')
      ),      
      )
   ) );
}

/**************************/
/*   Testimonial Slider   */
/**************************/

function landmark_construction_testimonials_slider($atts, $content = null) {
   extract(shortcode_atts ( array(
    'style' => 'bt_testimonial_slider-1',
    'animation' => 'no_animation'
    ), 
   $atts));
   
   $data_atts = "";
   switch ($style) {
        case "bt_testimonial_slider-1":
            $data_atts = 'data-width="555" data-control="false" data-nav="true"';
            break;
        case "bt_testimonial_slider-2":
            $data_atts = 'data-width="555" data-control="true" data-nav="false"';
            break;
        case "bt_testimonial_slider-3":
            $data_atts = 'data-width="555" data-control="true" data-nav="false"';
            break;
        case "bt_testimonial_slider-4":
            $data_atts = 'data-width="555" data-control="false" data-nav="true"';
            break;
        case "bt_testimonial_slider-5":
            $data_atts = 'data-width="1140" data-control="true" data-nav="true"';
            break;
        case "bt_testimonial_slider-6":
            $data_atts = 'data-width="1140" data-control="false" data-nav="true"';
            break;      
        default:
            $data_atts = 'data-width="0" data-item="0" data-margin="0"';
    }  
   return '
   <div class="'.$animation. ' bt_testimonials_slider ' . $style . ' animated">
      <div class="bt_testimonials_slider_wrap" '.$data_atts.'>'.do_shortcode($content).'</div>
   </div>';
}
add_shortcode('bt_testimonials_slider', 'landmark_construction_testimonials_slider');

function landmark_construction_testimonials_slide($atts, $content = null) {
   extract(shortcode_atts ( array(
    'client_image' => '',
    'client_name' => '',
    'client_position' => '',
    'client_stars' => ''
    ), 
   $atts));
    $t_image = $testimonial = "";
    $img_id = preg_replace('/[^\d]/', '', $client_image);
    $image = wp_get_attachment_image_src( $img_id, 'full');
    $alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
        
    if ( $client_image != "" ) {
      $t_image = '<div class="testimonial-image">';
      $img_id = preg_replace('/[^\d]/', '', $client_image);
      $image = wp_get_attachment_image_src( $img_id, 'full');
      $alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
        
      $t_image .= '<img src="'.esc_url($image[0]).'" width="'.esc_attr($image[1]).'" height="'.esc_attr($image[2]).'" alt="'.esc_attr($alt).'">';
      $t_image .= '</div>';
    }
    $t_position = "";
    if ( $client_position != "" ) {
      $t_position = '<span class="testimonial-position">'.$client_position.'</span>';
    }


    $testimonial .= '<div class="bt-testimonial">';
    $testimonial .= '<div class="testimonial-content">'.do_shortcode($content).'</div>';
    $testimonial .= $t_image.'<div class="testimonial-client"><p>'.$client_name.' '.$t_position.'</p></div>';
    $testimonial .= '</div>';

    return $testimonial;

}

add_shortcode('bt_testimonials_slide', 'landmark_construction_testimonials_slide');

add_action( 'vc_before_init', 'bt_testimonials_slider_integrateWithVC' );
function bt_testimonials_slider_integrateWithVC() {
   vc_map( array(
      "name" => __( "Testimonial Slider", "landmark-construction-theme" ),
      "base" => "bt_testimonials_slider",
      "class" => "",
      "category" => 'Content',
      "as_parent" => array('only' => 'bt_testimonials_slide'),
      "content_element" => true,
      "show_settings_on_create" => true,
      "params" => array(

      array(
          "type" => "dropdown",
          "holder" => "div",
          "class" => "",
          "heading" => __("Slider Type", 'landmark-construction-theme'),
          "param_name" => "style",
          "value" => array(
            __('Slider 1', "landmark-construction-theme") => "bt_testimonial_slider-1", 
            __('Slider 2', "landmark-construction-theme") => "bt_testimonial_slider-2", 
            __('Slider 3', "landmark-construction-theme") => "bt_testimonial_slider-3", 
            __('Slider 4', "landmark-construction-theme") => "bt_testimonial_slider-4", 
            __('Slider 5', "landmark-construction-theme") => "bt_testimonial_slider-5",
            __('Slider 6', "landmark-construction-theme") => "bt_testimonial_slider-6", 
            __('Slider 7', "landmark-construction-theme") => "bt_testimonial_slider-7"
            ),
          "description" => __("Choose your style.", 'landmark-construction-theme')                   
      ),

      array(
          "type" => "dropdown",
          "holder" => "div",
          "class" => "",
          "heading" => __("CSS Animation", 'landmark-construction-theme'),
          "param_name" => "animation",
          "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind"),
          "description" => __("Choose your animation.", 'landmark-construction-theme')
      )
      ),
    "js_view" => 'VcColumnView',    
   ) );
}

add_action( 'vc_before_init', 'bt_testimonials_slide_integrateWithVC' );
function bt_testimonials_slide_integrateWithVC() {
   vc_map( array(
      "name" => __( "Testimonial Slide", "landmark-construction-theme" ),
      "base" => "bt_testimonials_slide",
      "class" => "",
      "category" => 'Content',
      "as_child" => array('only' => 'bt_testimonials_slider'),
      "content_element" => true,     
      "params" => array(

      array(
        "type" => "attach_image",
        "heading" => __('Client Image', 'landmark-construction-theme'),
        "param_name" => "client_image",
        "description" => __("Select image for your client", "landmark-construction-theme")
      ),
      array(
          "type" => "textfield",
          "holder" => "div",
          "class" => "",
          "heading" => __("Client Name", 'landmark-construction-theme'),
          "param_name" => "client_name",
          "value" => "",
          "description" => __("Add your client name or company name", 'landmark-construction-theme')
      ),
      array(
          "type" => "textfield",
          "holder" => "div",
          "class" => "",
          "heading" => __("Client Position", 'landmark-construction-theme'),
          "param_name" => "client_position",
          "value" => "",
          "description" => __("Add your client position or you can use this area for your other text after client-company name", 'landmark-construction-theme')
      ),
      array(
          "type" => "textarea_html",
          "holder" => "div",
          "class" => "",
          "heading" => __("Client Comment", 'landmark-construction-theme'),
          "param_name" => "content",
          "value" => "",
          "description" => __("Add your client comment", 'landmark-construction-theme')
      )             

      )
   ) );
  
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_bt_testimonials_slider extends WPBakeryShortCodesContainer {
    }
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_bt_testimonials_slide extends WPBakeryShortCode {
    }
}  
}


/*********************/
/*  Meet Team Tabs   */
/*********************/
function landmark_construction_meet_team_tabs($atts, $content = null) {
   extract(shortcode_atts ( array(
    'image_1' => '',
    'image_2' => '',
    'image_3' => '',
    'image_4' => ''
    ), 
   $atts));
   $image_tab = $output = "";
   $tabs_count = 1;

  if ( !empty($image_1) ) {  
    $img_id = preg_replace('/[^\d]/', '', $image_1);
    $image = wp_get_attachment_image_src( $img_id, 'full');
    $alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);  

    $image_tab .= '<div id="#bt_meet_team-tab'.$tabs_count.'" class="bt_team_member aktif">';
    $image_tab .= '<img src="'.esc_url($image[0]).'" width="'.esc_attr($image[1]).'" height="'.esc_attr($image[2]).'" alt="'.esc_attr($alt).'">';
    $image_tab .= '</div>';
    $tabs_count++;
  }

  if ( !empty($image_2) ) {  
    $img_id = preg_replace('/[^\d]/', '', $image_2);
    $image = wp_get_attachment_image_src( $img_id, 'full');
    $alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);  

    $image_tab .= '<div id="#bt_meet_team-tab'.$tabs_count.'" class="bt_team_member">';
    $image_tab .= '<img src="'.esc_url($image[0]).'" width="'.esc_attr($image[1]).'" height="'.esc_attr($image[2]).'" alt="'.esc_attr($alt).'">';
    $image_tab .= '</div>';
    $tabs_count++;
  }

  if ( !empty($image_3) ) {  
    $img_id = preg_replace('/[^\d]/', '', $image_3);
    $image = wp_get_attachment_image_src( $img_id, 'full');
    $alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);  

    $image_tab .= '<div id="#bt_meet_team-tab'.$tabs_count.'" class="bt_team_member">';
    $image_tab .= '<img src="'.esc_url($image[0]).'" width="'.esc_attr($image[1]).'" height="'.esc_attr($image[2]).'" alt="'.esc_attr($alt).'">';
    $image_tab .= '</div>';
    $tabs_count++;
  }

  if ( !empty($image_4) ) {  
    $img_id = preg_replace('/[^\d]/', '', $image_4);
    $image = wp_get_attachment_image_src( $img_id, 'full');
    $alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);  

    $image_tab .= '<div id="#bt_meet_team-tab'.$tabs_count.'" class="bt_team_member">';
    $image_tab .= '<img src="'.esc_url($image[0]).'" width="'.esc_attr($image[1]).'" height="'.esc_attr($image[2]).'" alt="'.esc_attr($alt).'">';
    $image_tab .= '</div>';
    $tabs_count++;
  }    
    
    $output .= '<div class="bt_meet_team_tabs">';
    $output .= '<div class="bt_meet_team_tabs_photos">'.$image_tab.'<div class="clearfix"></div></div>';
    $output .= '<div class="bt_meet_team_tabs_content">'.do_shortcode($content).'</div>';
    $output .= '</div>';
    return $output;
}
add_shortcode('bt_meet_team_tabs', 'landmark_construction_meet_team_tabs');

function landmark_construction_meet_team_tab($atts, $content= null) {
   extract(shortcode_atts ( array(

    ), 
   $atts));


   return '<div class="bt_team_tab_content">'.do_shortcode($content).'</div>';
}

add_shortcode('bt_meet_team_tab', 'landmark_construction_meet_team_tab');

add_action( 'vc_before_init', 'bt_meet_team_tabs_integrateWithVC' );
function bt_meet_team_tabs_integrateWithVC() {
   vc_map( array(
      "name" => __( "Team Tabs", "landmark-construction-theme" ),
      "base" => "bt_meet_team_tabs",
      "class" => "",
      "category" => 'Content',
      "as_parent" => array('only' => 'bt_meet_team_tab'),
      "content_element" => true,
      "show_settings_on_create" => true,
      "params" => array(

      array(
        "type" => "attach_image",
        "heading" => __('Team Image 1', 'landmark-construction-theme'),
        "param_name" => "image_1",
        "description" => __("Select image for your member", "landmark-construction-theme")
      ),

      array(
        "type" => "attach_image",
        "heading" => __('Team Image 2', 'landmark-construction-theme'),
        "param_name" => "image_2",
        "description" => __("Select image for your member", "landmark-construction-theme")
      ),

      array(
        "type" => "attach_image",
        "heading" => __('Team Image 3', 'landmark-construction-theme'),
        "param_name" => "image_3",
        "description" => __("Select image for your member", "landmark-construction-theme")
      ),

      array(
        "type" => "attach_image",
        "heading" => __('Team Image 4', 'landmark-construction-theme'),
        "param_name" => "image_4",
        "description" => __("Select image for your member", "landmark-construction-theme")
      )                  
      ),
    "js_view" => 'VcColumnView',    
   ) );
}

add_action( 'vc_before_init', 'bt_meet_team_tab_integrateWithVC' );
function bt_meet_team_tab_integrateWithVC() {
   vc_map( array(
      "name" => __( "Team Tab", "landmark-construction-theme" ),
      "base" => "bt_meet_team_tab",
      "class" => "",
      "category" => 'Content',
      "as_parent" => array('only' => array( 'vc_progress_bar', 'vc_icon', 'vc_column_text')),      
      "as_child" => array('only' => 'bt_meet_team_tabs'),
      "content_element" => true,
      "show_settings_on_create" => false,
      "params" => array(
      ),
      "js_view" => 'VcColumnView',       
   ) );
  
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_bt_meet_team_tabs extends WPBakeryShortCodesContainer {
    }
    class WPBakeryShortCode_bt_meet_team_tab extends WPBakeryShortCodesContainer {
    }    
}
  
}

  
  

/*************************************/
/**** Blicca Themes Count Widget  ****/
/*************************************/
function landmark_construction_count($atts) {
   extract(shortcode_atts ( array(
    'header' => '',
    'number' => '',
    'speed' => '',
    'refresh'=> '',
    'icon_color'=> '',
    'title_color' => '',
    'number_color' => '',
    'bt_style' => 'bt_count_1', 
    'icon_style' => '',
    'icon_fontawesome' => '', 
    'icon_openiconic' => '', 
    'typicons' => '', 
    'icon_entypo' => '', 
    'icon_linecons' => ''
    ), 
   $atts));
   $output ="";

  if ( $bt_style != "bt_count_1" ) { vc_icon_element_fonts_enqueue( $icon_style ); }
  $iconClass = isset( ${"icon_" . $icon_style} ) ? esc_attr( ${"icon_" . $icon_style} ) : 'fa fa-adjust';
  if ( $icon_color == "" ) {$color = "#000000";}
  else { $color = "$icon_color"; } 
  if ( $bt_style == "bt_count_2") {
  $add_icon = '<div style ="color:'.$color.'" class="bt-count-icon"><span class="'.$iconClass.'"></span></div>';
  }
  if ( $bt_style == "bt_count_3") {
  $add_icon = '<div class="bt-count-icon"><span class="'.$iconClass.'" style ="background-color:'.$color.'" ></span></div>';
  }  
  if ( $bt_style == "bt_count_1" ) {
    $add_icon = ""; 
  }
  
  if ( !empty($number_color) ) {
     $number_color = ' style ="color: '.$number_color.';"'; 
  }
  
  if ( !empty($title_color) ) {
     $title_color = ' style ="color: '.$title_color.';"'; 
  }  
  if ( $bt_style == "bt_count_1") {
    $output = '<div class="bliccaThemes-count bt_count_1"><span class="timer" data-from="0" data-to="'.$number.'" data-speed="'.$speed.'" data-refresh-interval="'.$refresh.'"'.$number_color.'>0</span><div class="bt-count-title"'.$title_color.'>'.$header.'</div></div>';
  }

  if ( $bt_style == "bt_count_2") {
        $output = '<div class="bliccaThemes-count bt_count_2">'.$add_icon.'<div class="bt-count-title"'.$title_color.'>'.$header.'</div><span class="timer" data-from="0" data-to="'.$number.'" data-speed="'.$speed.'" data-refresh-interval="'.$refresh.'"'.$number_color.'>0</span></div>';    
  }

  if ( $bt_style == "bt_count_3") {
        $output = '<div class="bliccaThemes-count bt_count_3">'.$add_icon.'<span class="timer" data-from="0" data-to="'.$number.'" data-speed="'.$speed.'" data-refresh-interval="'.$refresh.'"'.$number_color.'>0</span><div class="bt-count-title"'.$title_color.'>'.$header.'</div></div>';    
  } 
   return $output;

}
add_shortcode('landmark_construction_count_widget', 'landmark_construction_count');

add_action( 'init', 'landmark_construction_count_integrateWithVC' );
function landmark_construction_count_integrateWithVC() {
vc_map ( array(
   "name" => __("Count Widget", 'landmark-construction-theme'),
   "base" => "landmark_construction_count_widget",
   "class" => "",
   "category" => 'Content',
   'admin_enqueue_css' => array(get_template_directory_uri().'/css/visualcomposer.css'),   
   "icon" => "bliccaThemes-vc-icon",    
   "params" => array(    

    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Title", 'landmark-construction-theme'),
        "param_name" => "header",
        "value" => __("Title", 'landmark-construction-theme'),
        "description" => __("Title for section", 'landmark-construction-theme')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Number", 'landmark-construction-theme'),
        "param_name" => "number",
        "description" => __("Number", 'landmark-construction-theme')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Speed", 'landmark-construction-theme'),
        "param_name" => "speed",
        "description" => __("Speed of count, for example 1000", 'landmark-construction-theme')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Refresh Interval", 'landmark-construction-theme'),
        "param_name" => "refresh",
        "description" => __("Refresh Interval, for example 20", 'landmark-construction-theme')
    ),
      array(
          'type' => 'dropdown',
          'heading' => "Style",
          'param_name' => 'bt_style',
            "value" => array(
              __('Style 1', "landmark-construction-theme") => "bt_count_1", 
              __('Style 2', "landmark-construction-theme") => "bt_count_2", 
              __('Style 3', "landmark-construction-theme") => "bt_count_3", 
              ),
          'description' => __( "Choose counter style.", "landmark-construction-theme" )
      ),
      array(
        "type" => "colorpicker",
        "heading" => __("Title Color", "landmark-construction-theme"),
        "param_name" => "title_color",
        "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme")        
      ),
      array(
        "type" => "colorpicker",
        "heading" => __("Number Color", "landmark-construction-theme"),
        "param_name" => "number_color",
        "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme")      
      ),     
        array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon Fonticon", 'landmark-construction-theme'),
        "param_name" => "icon_style",
        "value" => array(
                __( 'Choose Library', 'landmark-construction-theme') => 'choose',
                __( 'Font Awesome', "landmark-construction-theme" ) => 'fontawesome',
                __( 'Open Iconic', "landmark-construction-theme" ) => 'openiconic',
                __( 'Typicons', "landmark-construction-theme" ) => 'typicons',
                __( 'Entypo', "landmark-construction-theme" ) => 'entypo',
                __( 'Linecons', "landmark-construction-theme" ) => 'linecons'
        ),
        "description" => __("Add icon to your heading", 'landmark-construction-theme'),
        "dependency" => Array( 'element' => 'bt_style', 'value' => array( 'bt_count_2', 'bt_count_3'))   
        ),
      array(
        "type" => "colorpicker",
        "heading" => __("Icon Color", "landmark-construction-theme"),
        "param_name" => "icon_color",
        "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
          "dependency" => Array( 'element' => 'bt_style', 'value' => array( 'bt_count_2', 'bt_count_3'))        
      ),        
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_fontawesome',
            'value' => 'fa fa-adjust', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
            ),
            'dependency' => Array( 'element' => 'icon_style', 'value' => 'fontawesome' ),

            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_openiconic',
            'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'openiconic',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'openiconic',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_typicons',
            'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'typicons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'typicons',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_entypo',
            'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'entypo',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'entypo',
            ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_linecons',
            'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'linecons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array( 'element' => 'icon_style','value' => 'linecons',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        )
)
));
}

/************************************/
/* Blicca Themes Services Footsteps */
/************************************/
function landmark_construction_services_footsteps($atts, $content = null) {
   extract(shortcode_atts ( array(
    'bt_style' => 'bt_footstep_1',
    'border_style' => 'bt_step_right_border',     
    'header' => '',
    'step_number' => '',
    'icon_style' => '',
    'step_asset'=> '',   
    'icon_fontawesome' => '', 
    'icon_openiconic' => '', 
    'typicons' => '', 
    'icon_entypo' => '', 
    'icon_linecons' => '',
    'footstep_image' => ''
    ), 
   $atts));
   $output = $icoimage = $css_class = "";

  if ( $step_asset == "" ) { $step_asset = "#31aae2"; } 


    if ( $icon_style != "choose" && $icon_style != "use_image" ) {
      vc_icon_element_fonts_enqueue( $icon_style );
    $iconClass = isset( ${"icon_" . $icon_style} ) ? esc_attr( ${"icon_" . $icon_style} ) : 'fa fa-adjust';

    $icoimage = '<span class="'.$iconClass.'"></span>';
    }

    if ( $icon_style == "use_image" && !empty($footstep_image)) {
    $img_id = preg_replace('/[^\d]/', '', $footstep_image);
    $image = wp_get_attachment_image_src( $img_id, 'full');
    $alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
    $icoimage = '<img src="'.$image[0].'" width="'.$image[1].'" height="'.$image[2].'" alt="'.$alt.'">';
    }


    switch($bt_style) {
        case 'bt_footstep_1':
      $output = '<div class="landmark_construction_services_footsteps '. $bt_style.'" style="background:'.$step_asset.'">';
      $output .= '<div class="bt_footstep_content">';
      $output .= '<div class="bt_footstep_title">'.esc_html($header).'</div>';
      $output .= '<div class="bt_footstep_text">'.do_shortcode($content).'</div>';
      $output .= '<div class="bt_footstep_number" style="background:'.$step_asset.'; color:'.$step_asset.'"><div class="bt_footstep_number_inner">'.esc_html($step_number).'</div></div>';
      $output .= '</div>';
      $output .= '</div>';            
        break;

        case 'bt_footstep_2':
            if ( !empty ($step_number) ) {
              $step_number = $step_number . '/ ';
            }      
      $output = '<div class="landmark_construction_services_footsteps '. $bt_style.' '.$border_style.'">';
      $output .= '<div class="icoimage"><div class="icoimagecontent" style="color:'.$step_asset.'">'.$icoimage.'</div><div class="icoimagehover" style="background:'.$step_asset.';">'.$icoimage.'</div></div>';
      $output .= '<div class="bt_footstep_title">'.esc_html($step_number).esc_html($header).'</div>';
      $output .= '<div class="bt_footstep_text">'.do_shortcode($content).'</div>';      
      $output .= '</div>';
        break;

        case 'bt_footstep_3':
            if ( !empty ($step_number) ) {
              $step_number = $step_number . '/ ';
            }      
      $output = '<div class="landmark_construction_services_footsteps '. $bt_style.' '.$border_style.'">';
      $output .= '<div class="icoimage"><div class="icoimagecontent" style="color:'.$step_asset.'">'.$icoimage.'</div></div>';
      $output .= '<div class="bt_footstep_title">'.esc_html($step_number).esc_html($header).'</div>';
      $output .= '<div class="bt_footstep_text">'.do_shortcode($content).'</div>';      
      $output .= '</div>'; 
        break;

        case 'bt_footstep_4':
      $output = '<div class="landmark_construction_services_footsteps '. $bt_style.' '.$border_style.'">';
      $output .= '<div class="icoimage"><div class="icoimagecontent" style="color:'.$step_asset.'">'.$icoimage.'</div><div class="bt_step_number" style="background:'.$step_asset.' ;">'.esc_html($step_number).'</div></div>';
      $output .= '<div class="bt_footstep_title">'.esc_html($header).'</div>';
      $output .= '<div class="bt_footstep_text">'.do_shortcode($content).'</div>';      
      $output .= '</div>'; 
        break;

        case 'bt_footstep_5':
            if ( !empty ($step_number) ) {
              $step_number = $step_number . '/ ';
            }      
      $output = '<div class="landmark_construction_services_footsteps '. $bt_style.' '.$border_style.'">';
      $output .= '<div class="icoimage"><div class="icoimagecontent">'.$icoimage.'</div><div class="icoimagehover" style="color:'.$step_asset.';">'.$icoimage.'</div><div class="fonticon"></div></div>';
      $output .= '<div class="bt_footstep_title">'.esc_html($step_number).esc_html($header).'</div>';
      $output .= '<div class="bt_footstep_text">'.do_shortcode($content).'</div>';      
      $output .= '</div>'; 
        break;

        case 'bt_footstep_6':
      $output = '<div class="landmark_construction_services_footsteps '. $bt_style.' '.$border_style.'">';
      $output .= '<div class="icoimage"><div class="icoimagecontent" style="color:'.$step_asset.'">'.$step_number.'</div><div class="icoimagehover" style="background:'.$step_asset.';">'.$step_number.'</div></div>';
      $output .= '<div class="bt_footstep_title">'.esc_html($header).'</div>';
      $output .= '<div class="bt_footstep_text">'.do_shortcode($content).'</div>';      
      $output .= '</div>'; 
        break;                                        
   }

   return $output;

}
add_shortcode('landmark_construction_services_footstep', 'landmark_construction_services_footsteps');

add_action( 'init', 'landmark_construction_services_footstep_integrateWithVC' );
function landmark_construction_services_footstep_integrateWithVC() {
vc_map ( 
  array(
   "name" => __("Services FootSteps", 'landmark-construction-theme'),
   "base" => "landmark_construction_services_footstep",
   "class" => "",
   "category" => 'Content',   
   "params" => array(    

  array(
      'type' => 'dropdown',
      'heading' => "Style",
      'param_name' => 'bt_style',
    "value" => array(
            __('Style 1', "landmark-construction-theme") => "bt_footstep_1", 
            __('Style 2', "landmark-construction-theme") => "bt_footstep_2", 
            __('Style 3', "landmark-construction-theme") => "bt_footstep_3", 
            __('Style 4', "landmark-construction-theme") => "bt_footstep_4",
            __('Style 5', "landmark-construction-theme") => "bt_footstep_5",
            __('Style 6', "landmark-construction-theme") => "bt_footstep_6",
         ),
      'description' => __( "Choose counter style.", "landmark-construction-theme" )
  ),
  array(
      'type' => 'dropdown',
      'heading' => "Direction Border",
      'param_name' => 'border_style',
      "value" => array(
            __('Only right', "landmark-construction-theme") => "bt_step_right_border", 
            __('Only left', "landmark-construction-theme") => "bt_step_left_border", 
            __('Double', "landmark-construction-theme") => "bt_step_double_border", 
            __('None', "landmark-construction-theme") => "bt_step_noneborder", 
         ),
      'description' => __( "Choose direction border", "landmark-construction-theme" )
  ),     
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Title", 'landmark-construction-theme'),
        "param_name" => "header",
        "value" => __("Title", 'landmark-construction-theme'),
        "description" => __("Title for service", 'landmark-construction-theme')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Add Number for your Step", 'landmark-construction-theme'),
        "param_name" => "step_number",
        "description" => __("Add Number for your Step", 'landmark-construction-theme')
    ),

    array(
        "type" => "textarea_html",
        "holder" => "div",
        "class" => "",
        "heading" => __("Content", 'landmark-construction-theme'),
        "param_name" => "content",
        "value" => "",
        "description" => __("You can write some information about your step", 'landmark-construction-theme')
    ),

    array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon Fonticon", 'landmark-construction-theme'),
        "param_name" => "icon_style",
        "value" => array(
                __( 'Choose Library', 'landmark-construction-theme') => 'choose',
                __( 'Use Image', 'landmark-construction-theme') => 'use_image',
                __( 'Font Awesome', "landmark-construction-theme" ) => 'fontawesome',
                __( 'Open Iconic', "landmark-construction-theme" ) => 'openiconic',
                __( 'Typicons', "landmark-construction-theme" ) => 'typicons',
                __( 'Entypo', "landmark-construction-theme" ) => 'entypo',
                __( 'Linecons', "landmark-construction-theme" ) => 'linecons'
        ),
        "description" => __("Add icon or image to your heading", 'landmark-construction-theme'),
        "dependency" => Array( 'element' => 'bt_style', 'value' => array( 'bt_footstep_2', 'bt_footstep_3', 'bt_footstep_4', 'bt_footstep_5', 'bt_footstep_6'))       

    ),
    array(
        "type" => "attach_image",
        "heading" => __("Image", "landmark-construction-theme"),
        "param_name" => "footstep_image",
        "value" => "",
        "description" => __("Choose image from media library.", "landmark-construction-theme"),
        'dependency' => Array( 'element' => 'icon_style', 'value' => 'use_image' ),      
    ),    
  array(
      "type" => "colorpicker",
      "heading" => __("Asset Color", "landmark-construction-theme"),
      "param_name" => "step_asset",
      "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
        "dependency" => Array( 'element' => 'bt_style', 'value' => array( 'bt_footstep_1', 'bt_footstep_2', 'bt_footstep_3', 'bt_footstep_4', 'bt_footstep_5', 'bt_footstep_6'))        
  ),        
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_fontawesome',
        'value' => 'fa fa-adjust', // default value to backend editor admin_label
        'settings' => array(
            'emptyIcon' => false, // default true, display an "EMPTY" icon?
             'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
            ),
        'dependency' => Array( 'element' => 'icon_style', 'value' => 'fontawesome' ),

        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
    ),
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_openiconic',
        'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
        'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'openiconic',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
          ),
        'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'openiconic',
        ),
        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
    ),
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_typicons',
        'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
        'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'typicons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
        'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'typicons',
            ),
        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
    ),
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_entypo',
        'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
        'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'entypo',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
        'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'entypo',
            ),
    ),
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_linecons',
        'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
        'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'linecons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
        'dependency' => Array( 'element' => 'icon_style','value' => 'linecons',
            ),
        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
    )
)
));
  
class WPBakeryShortCode_landmark_construction_services_footstep extends WPBakeryShortCode {
}  
}  

/*********************/
/* Heading Style landmark*/
/*********************/
function landmark_construction_heading($atts) {
   extract(shortcode_atts ( array(
    'style' => 'bt_heading_1',
    'title_text' => '',
    'title_color' => '',
    'title_text_size' => '',
    'title_text_font_weight'   => '800',
    'animation_title' => 'no_animation',
    'delay_title'=> '',
    'description_text' => '',
    'description_color' => '',
    'description_text_size' => '',
    'description_text_font_weight'   => '800',
    'animation_description' => 'no_animation_2',
    'delay_description'=> '',
    'animation_line_1' => 'no_animation_3',
    'delay_line_1'=> '',
    'animation_line_2' => 'no_animation_4',
    'delay_line_2'=> '',
    'photo' => '',
    'animation_photo' => 'no_animation_5',
    'delay_photo'=> '',
    'icon_style' => 'fontawesome',
    'icon_fontawesome' => 'fa fa-adjust',
    'icon_openiconic' => '',
    'icon_typicons' => '',
    'icon_entypoicons' => '',
    'icon_linecons' => '',
    'icon_entypo' => '',
    'icon_color' => '',
    'rotate_icon' => '',
    'animation_icon' => 'no_animation_6',
    'delay_icon'=> '',
    'icon_style_2' => 'fontawesome_2',
    'icon_fontawesome_2' => 'fa fa-adjust',
    'icon_openiconic_2' => '',
    'icon_typicons_2' => '',
    'icon_entypoicon_2' => '',
    'icon_linecons_2' => '',
    'icon_entypo_2' => '',
    'icon_color_2' => '',
    'rotate_icon_2' => '',
    'animation_icon_2' => 'no_animation_7',
    'delay_icon_2'=> '',
    ), 
   $atts));

    $mydelay_title = $mydelay_description = $mydelay_line_1 = $mydelay_line_2 = $mydelay_photo = $mydelay_icon = $mydelay_icon_2 = $myrotate_icon = $myrotate_icon_2 = $img = "";

// animation title
  if ( $delay_title != '') {
    $mydelay_title = 'animation-delay: '.$delay_title.'ms; -moz-animation-delay: '.$delay_title.'ms; -webkit-animation-delay: '.$delay_title.'ms;';
  }
// animation description
  if ( $delay_description != '') {
    $mydelay_description = 'animation-delay: '.$delay_description.'ms; -moz-animation-delay: '.$delay_description.'ms; -webkit-animation-delay: '.$delay_description.'ms;';
  }
// animation line 1
  if ( $delay_line_1 != '') {
    $mydelay_line_1 = 'animation-delay: '.$delay_line_1.'ms; -moz-animation-delay: '.$delay_line_1.'ms; -webkit-animation-delay: '.$delay_line_1.'ms;';
  }
// animation line 2
  if ( $delay_line_2 != '') {
    $mydelay_line_2 = 'animation-delay: '.$delay_line_2.'ms; -moz-animation-delay: '.$delay_line_2.'ms; -webkit-animation-delay: '.$delay_line_2.'ms;';
  }
// animation image
  if ( $delay_photo != '') {
    $mydelay_photo = 'animation-delay: '.$delay_photo.'ms; -moz-animation-delay: '.$delay_photo.'ms; -webkit-animation-delay: '.$delay_photo.'ms;';
  }
// animation icon
  if ( $delay_icon != '') {
    $mydelay_icon = 'animation-delay: '.$delay_icon.'ms; -moz-animation-delay: '.$delay_icon.'ms; -webkit-animation-delay: '.$delay_icon.'ms;';
  }
// animation icon 2
  if ( $delay_icon_2 != '') {
    $mydelay_icon_2 = 'animation-delay: '.$delay_icon_2.'ms; -moz-animation-delay: '.$delay_icon_2.'ms; -webkit-animation-delay: '.$delay_icon_2.'ms;';
  }

// Rotate icon
  if ( $rotate_icon != '') {
    $myrotate_icon = '  transform: rotate('.$rotate_icon.'deg); -webkit-transform: rotate('.$rotate_icon.'deg); -moz-transform: rotate('.$rotate_icon.'deg); -o-transform: rotate('.$rotate_icon.'deg); -ms-transform: rotate('.$rotate_icon.'deg);';
  }
// Rotate icon 2
  if ( $rotate_icon_2 != '') {
    $myrotate_icon_2 = '  transform: rotate('.$rotate_icon_2.'deg); -webkit-transform: rotate('.$rotate_icon_2.'deg); -moz-transform: rotate('.$rotate_icon_2.'deg); -o-transform: rotate('.$rotate_icon_2.'deg); -ms-transform: rotate('.$rotate_icon_2.'deg);';
  }
// Icon
   vc_icon_element_fonts_enqueue( $icon_style );

   $iconClass = isset( ${"icon_" . $icon_style} ) ? esc_attr( ${"icon_" . $icon_style} ) : 'fa fa-adjust';     
     $add_icon = '<span style ="color:'.$icon_color.';" class="icon"><span style="'.$myrotate_icon.'" class="'.$iconClass.'"></span></span>';
// Icon 2
   vc_icon_element_fonts_enqueue( $icon_style_2 );

   $iconClass_2 = isset( ${"icon_" . $icon_style_2} ) ? esc_attr( ${"icon_" . $icon_style_2} ) : 'fa fa-adjust';     
     $add_icon_2 = '<span style ="color:'.$icon_color_2.';" class="icon"><span style="'.$myrotate_icon_2.'" class="'.$iconClass_2.'"></span></span>';
// photo
    if ( !empty($photo)) {
    $img_id = preg_replace('/[^\d]/', '', $photo);
    $image = wp_get_attachment_image_src( $img_id, 'full');
    $alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

    $img = '<div class="bt_image"><img src="'.$image[0].'" width="'.$image[1].'" height="'.$image[2].'" alt="'.$alt.'"></div>';
    } 

    switch ($style) {
            case "bt_heading_1":
            return '<div class="'.$style.'">
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_line_1.' line_1 animated" style="'.$mydelay_line_1.'"></div>
            </div>';           
            break;
            case "bt_heading_2":
            return '<div class="'.$style.'">
            <div class="'.$animation_icon.' icon animated" style="'.$mydelay_icon.'">'.$add_icon.'</div>
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_icon_2.' icon2 animated" style="'.$mydelay_icon.'">'.$add_icon_2.'</div>           
            </div>';           
            break;
            case "bt_heading_3":
            return '<div class="'.$style.'">
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_line_1.' line_1 animated" style="'.$mydelay_line_1.'"></div>
            <div class="'.$animation_icon.' icon animated" style="'.$mydelay_icon.'">'.$add_icon.'</div>
            <div class="'.$animation_line_2.' line_2 animated" style="'.$mydelay_line_2.'"></div>           
            </div>';           
            break;
            case "bt_heading_4":
            return '<div class="'.$style.'">
            <div class="'.$animation_description.' description animated" style="color:'.$description_color.'; font-size:'.$description_text_size.'; font-weight:'.$description_text_font_weight.'; '.$mydelay_description.'">'.$description_text.'</div>
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_line_1.' line_1 animated" style="'.$mydelay_line_1.'"></div>
            </div>';           
            break;
            case "bt_heading_5":
            return '<div class="'.$style.'">
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_icon.' icon animated" style="'.$mydelay_icon.'">'.$add_icon.'</div>
            <div class="'.$animation_line_1.' line_1 animated" style="'.$mydelay_line_1.'"></div>
            </div>';           
            break;
            case "bt_heading_6":
            return '<div class="'.$style.'">
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_description.' description animated" style="color:'.$description_color.'; font-size:'.$description_text_size.'; font-weight:'.$description_text_font_weight.'; '.$mydelay_description.'">'.$description_text.'</div>            
            </div>';           
            break;
            case "bt_heading_7":
            return '<div class="'.$style.'">
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_line_1.' line_1 animated" style="'.$mydelay_line_1.'"></div>
            <div class="'.$animation_description.' description animated" style="color:'.$description_color.'; font-size:'.$description_text_size.'; font-weight:'.$description_text_font_weight.'; '.$mydelay_description.'">'.$description_text.'</div>            
            </div>';           
            break;
            case "bt_heading_8":
            return '<div class="'.$style.'">
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; border-color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>          
            </div>';           
            break;
            case "bt_heading_9":
            return '<div class="'.$style.'">
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_line_1.' line_1 animated" style="'.$mydelay_line_1.'"></div>
            <div class="'.$animation_icon.' icon animated" style="'.$mydelay_icon.'">'.$add_icon.'</div>
            <div class="'.$animation_line_2.' line_2 animated" style="'.$mydelay_line_2.'"></div>
            <div class="'.$animation_description.' description animated" style="color:'.$description_color.'; font-size:'.$description_text_size.'; font-weight:'.$description_text_font_weight.'; '.$mydelay_description.'">'.$description_text.'</div>            
            </div>';           
            break;
            case "bt_heading_10":
            return '<div class="'.$style.'">
            <div class="'.$animation_description.' description animated" style="color:'.$description_color.'; font-size:'.$description_text_size.'; font-weight:'.$description_text_font_weight.'; '.$mydelay_description.'">'.$description_text.'</div> 
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_icon.' icon animated" style="'.$mydelay_icon.'">'.$add_icon.'</div>
            </div>';           
            break;
            case "bt_heading_11":
            return '<div class="'.$style.'">
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_line_1.' line_1 animated" style="'.$mydelay_line_1.'"></div>
            <div class="'.$animation_icon.' icon animated" style="'.$mydelay_icon.'">'.$add_icon.'</div>
            <div class="'.$animation_line_2.' line_2 animated" style="'.$mydelay_line_2.'"></div>
            </div>';           
            break;
            case "bt_heading_12":
            return '<div class="'.$style.'">
            <div class="'.$animation_description.' description animated" style="color:'.$description_color.'; font-size:'.$description_text_size.'; font-weight:'.$description_text_font_weight.'; '.$mydelay_description.'">'.$description_text.'</div> 
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_icon.' icon animated" style="'.$mydelay_icon.'">'.$add_icon.'</div>
            <div class="'.$animation_line_1.' line_1 animated" style="'.$mydelay_line_1.'"></div>
            <div class="'.$animation_icon_2.' icon2 animated" style="'.$mydelay_icon.'">'.$add_icon_2.'</div>
            </div>';           
            break;
            case "bt_heading_13":
            return '<div class="'.$style.'">
 <div class="'.$animation_line_1.' line_1 animated" style="'.$mydelay_line_1.'"><div class="line_1_inside"></div></div>
            <div class="'.$animation_description.' description animated" style="color:'.$description_color.'; font-size:'.$description_text_size.'; font-weight:'.$description_text_font_weight.'; '.$mydelay_description.'">'.$description_text.'</div> 
            <div class="'.$animation_line_2.' line_2 animated" style="'.$mydelay_line_2.'"><div class="line_2_inside"></div></div>          
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>

            </div>';           
            break;
            case "bt_heading_14":
            return '<div class="'.$style.'">
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_line_1.' line_1 animated" style="'.$mydelay_line_1.'"></div>
            <div class="'.$animation_icon.' icon animated" style="'.$mydelay_icon.'">'.$add_icon.'</div>
            <div class="'.$animation_line_2.' line_2 animated" style="'.$mydelay_line_2.'"></div>
            </div>';           
            break;
            case "bt_heading_15":
            return '<div class="'.$style.'">
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_line_1.' line_1 animated" style="'.$mydelay_line_1.'"></div>
            <div class="'.$animation_description.' description animated" style="color:'.$description_color.'; font-size:'.$description_text_size.'; font-weight:'.$description_text_font_weight.'; '.$mydelay_description.'">'.$description_text.'</div> 
            </div>';           
            break;
            case "bt_heading_16":
            return '<div class="'.$style.'">
            <div class="'.$animation_icon.' icon animated" style="'.$mydelay_icon.'">'.$add_icon.'</div>
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_description.' description animated" style="color:'.$description_color.'; font-size:'.$description_text_size.'; font-weight:'.$description_text_font_weight.'; '.$mydelay_description.'">'.$description_text.'</div> 
            </div>';           
            break;
            case "bt_heading_17":
            return '<div class="'.$style.'">
            <div class="'.$animation_icon.' icon animated" style="'.$mydelay_icon.'">'.$add_icon.'</div>
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_description.' description animated" style="color:'.$description_color.'; font-size:'.$description_text_size.'; font-weight:'.$description_text_font_weight.'; '.$mydelay_description.'">'.$description_text.'</div> 
            </div>';           
            break;
            case "bt_heading_18":
            return '<div class="'.$style.'">
            <div class="'.$animation_line_1.' line_1 animated" style="'.$mydelay_line_1.'"></div>
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_description.' description animated" style="color:'.$description_color.'; font-size:'.$description_text_size.'; font-weight:'.$description_text_font_weight.'; '.$mydelay_description.'">'.$description_text.'</div> 
            <div class="'.$animation_line_2.' line_2 animated" style="'.$mydelay_line_2.'"></div>
            </div>';           
            break;
            case "bt_heading_19":
            return '<div class="'.$style.'">
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_photo.' image animated" style="'.$mydelay_photo.'">'.$img.'</div>
            <div class="'.$animation_description.' description animated" style="color:'.$description_color.'; font-size:'.$description_text_size.'; font-weight:'.$description_text_font_weight.'; '.$mydelay_description.'">'.$description_text.'</div> 
            </div>';           
            break;
            case "bt_heading_20":
            return '<div class="'.$style.'">
            <div class="'.$animation_title.' text animated" style="color:'.$title_color.'; font-size:'.$title_text_size.'; font-weight:'.$title_text_font_weight.'; '.$mydelay_title.'">'.$title_text.'</div>
            <div class="'.$animation_description.' description animated" style="color:'.$description_color.'; font-size:'.$description_text_size.'; font-weight:'.$description_text_font_weight.'; '.$mydelay_description.'">'.$description_text.'</div> 
            <div class="'.$animation_line_1.' line_1 animated" style="'.$mydelay_line_1.'"></div>
            <div class="'.$animation_icon.' icon animated" style="'.$mydelay_icon.'">'.$add_icon.'</div>
            <div class="'.$animation_icon_2.' icon animated" style="'.$mydelay_icon_2.'">'.$add_icon_2.'</div>
            <div class="'.$animation_line_2.' line_2 animated" style="'.$mydelay_line_2.'"></div>
            </div>';           
            break;        
        default:         
            break;
        
        break;
    }     

}
add_shortcode('landmark_construction_Heading_Styles', 'landmark_construction_heading');


add_action( 'init', 'landmark_construction_Heading_Styles_integrateWithVC' );
function landmark_construction_Heading_Styles_integrateWithVC() {
vc_map ( array(
    "name" => __("landmark Heading", "landmark-construction-theme"),
    "base" => "landmark_construction_Heading_Styles",
    "content_element" => true,
    "show_settings_on_create" => true,
    "params" => array(
        array(
          "type" => "dropdown",
          "holder" => "div",
          "class" => "",
          "heading" => __("Heading Style", 'landmark-construction-theme'),
          "param_name" => "style",
          "value" => array(
            __('Style 1', "landmark-construction-theme") => "bt_heading_1", 
            __('Style 2', "landmark-construction-theme") => "bt_heading_2", 
            __('Style 3', "landmark-construction-theme") => "bt_heading_3", 
            __('Style 4', "landmark-construction-theme") => "bt_heading_4", 
            __('Style 5', "landmark-construction-theme") => "bt_heading_5",
            __('Style 6', "landmark-construction-theme") => "bt_heading_6", 
            __('Style 7', "landmark-construction-theme") => "bt_heading_7",
            __('Style 8', "landmark-construction-theme") => "bt_heading_8",
            __('Style 9', "landmark-construction-theme") => "bt_heading_9",
            __('Style 10', "landmark-construction-theme") => "bt_heading_10", 
            __('Style 11', "landmark-construction-theme") => "bt_heading_11", 
            __('Style 12', "landmark-construction-theme") => "bt_heading_12", 
            __('Style 13', "landmark-construction-theme") => "bt_heading_13", 
            __('Style 14', "landmark-construction-theme") => "bt_heading_14",
            __('Style 15', "landmark-construction-theme") => "bt_heading_15", 
            __('Style 16', "landmark-construction-theme") => "bt_heading_16",
            __('Style 17', "landmark-construction-theme") => "bt_heading_17",
            __('Style 18', "landmark-construction-theme") => "bt_heading_18", 
            __('Style 19', "landmark-construction-theme") => "bt_heading_19",
            __('Style 20', "landmark-construction-theme") => "bt_heading_20"
            ),
          "description" => __("Choose your style.", 'landmark-construction-theme')                   
        ),
        array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Title", 'landmark-construction-theme'),
        "param_name" => "title_text"
        ),
        array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Title Font Size", 'landmark-construction-theme'),
        "param_name" => "title_text_size"
        ),
        array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __("Title Font weight",'landmark-construction-theme'),
            "param_name" => "title_text_font_weight",
            "value" => array ("Extra bold" => "800","Bold" => "700","Semi Bold" => "600","Normal" => "400","Light" => "300", ), 
            "description" => __("Choose the Button Font weight",'landmark-construction-theme')
         ), 
        array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Title Color",'landmark-construction-theme'),
            "param_name" => "title_color",
            "value" => ''
         ),
        array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Title Animation", 'landmark-construction-theme'),
        "param_name" => "animation_title",
        "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind")
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Title Animaition Delay", 'landmark-construction-theme'),
        "param_name" => "delay_title",
        "description"=> __("If you write 1000, it means your animation will work after 1 second", 'landmark-construction-theme')
    ),
        array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Extra Content", 'landmark-construction-theme'),
        "param_name" => "description_text",
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_4', 'bt_heading_6', 'bt_heading_7', 'bt_heading_9', 'bt_heading_10', 'bt_heading_12', 'bt_heading_13', 'bt_heading_15', 'bt_heading_16', 'bt_heading_17', 'bt_heading_18', 'bt_heading_19', 'bt_heading_20'))
        ),
        array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Extra Content Font Size", 'landmark-construction-theme'),
        "param_name" => "description_text_size",
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_4', 'bt_heading_6', 'bt_heading_7', 'bt_heading_9', 'bt_heading_10', 'bt_heading_12', 'bt_heading_13', 'bt_heading_15', 'bt_heading_16', 'bt_heading_17', 'bt_heading_18', 'bt_heading_19', 'bt_heading_20'))
        ),
        array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __("Extra Content Font weight",'landmark-construction-theme'),
            "param_name" => "description_text_font_weight",
            "value" => array ("Extra bold" => "800","Bold" => "700","Semi Bold" => "600","Normal" => "400","Light" => "300", ), 
            "description" => __("Choose the Button Font weight",'landmark-construction-theme'),
            "dependency" => Array('element' => "style", 'value' => array('bt_heading_4', 'bt_heading_6', 'bt_heading_7', 'bt_heading_9', 'bt_heading_10', 'bt_heading_12', 'bt_heading_13', 'bt_heading_15', 'bt_heading_16', 'bt_heading_17', 'bt_heading_18', 'bt_heading_19', 'bt_heading_20'))
         ),
        array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Extra Content Color",'landmark-construction-theme'),
            "param_name" => "description_color",
            "value" => '',
            "dependency" => Array('element' => "style", 'value' => array('bt_heading_4', 'bt_heading_6', 'bt_heading_7', 'bt_heading_9', 'bt_heading_10', 'bt_heading_12', 'bt_heading_13', 'bt_heading_15', 'bt_heading_16', 'bt_heading_17', 'bt_heading_18', 'bt_heading_19', 'bt_heading_20'))
         ),
        array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Extra Content Animation", 'landmark-construction-theme'),
        "param_name" => "animation_description",
        "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation_2", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind"),
          "dependency" => Array('element' => "style", 'value' => array('bt_heading_4', 'bt_heading_6', 'bt_heading_7', 'bt_heading_9', 'bt_heading_10', 'bt_heading_12', 'bt_heading_13', 'bt_heading_15', 'bt_heading_16', 'bt_heading_17', 'bt_heading_18', 'bt_heading_19', 'bt_heading_20'))
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Extra Content Animation Delay", 'landmark-construction-theme'),
        "param_name" => "delay_description",
        "description"=> __("If you write 1000, it means your animation will work after 1 second", 'landmark-construction-theme'),
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_4', 'bt_heading_6', 'bt_heading_7', 'bt_heading_9', 'bt_heading_10', 'bt_heading_12', 'bt_heading_13', 'bt_heading_15', 'bt_heading_16', 'bt_heading_17', 'bt_heading_18', 'bt_heading_19', 'bt_heading_20'))
    ),
        array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Line Animation", 'landmark-construction-theme'),
        "param_name" => "animation_line_1",
        "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation_3", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind"),
          "dependency" => Array('element' => "style", 'value' => array('bt_heading_1', 'bt_heading_3', 'bt_heading_4', 'bt_heading_5', 'bt_heading_7', 'bt_heading_9', 'bt_heading_11', 'bt_heading_12', 'bt_heading_13', 'bt_heading_14', 'bt_heading_18', 'bt_heading_20'))
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Line Animation Delay", 'landmark-construction-theme'),
        "param_name" => "delay_line_1",
        "description"=> __("If you write 1000, it means your animation will work after 1 second", 'landmark-construction-theme'),
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_1', 'bt_heading_3', 'bt_heading_4', 'bt_heading_5', 'bt_heading_7', 'bt_heading_9', 'bt_heading_11', 'bt_heading_12', 'bt_heading_13', 'bt_heading_14', 'bt_heading_18', 'bt_heading_20'))
    ),
    array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Line 2 Animation", 'landmark-construction-theme'),
        "param_name" => "animation_line_2",
        "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation_4", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind"),
          "dependency" => Array('element' => "style", 'value' => array('bt_heading_3', 'bt_heading_9', 'bt_heading_11', 'bt_heading_13', 'bt_heading_14', 'bt_heading_18', 'bt_heading_20'))
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Line 2 Animation Delay", 'landmark-construction-theme'),
        "param_name" => "delay_line_2",
        "description"=> __("If you write 1000, it means your animation will work after 1 second", 'landmark-construction-theme'),
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_3', 'bt_heading_9', 'bt_heading_11', 'bt_heading_13', 'bt_heading_14', 'bt_heading_18', 'bt_heading_20'))
    ),
        array(
          "type" => "attach_image",
          "heading" => __("Image", "landmark-construction-theme"),
          "param_name" => "photo",
          "value" => "",
          "dependency" => Array('element' => "style", 'value' => array('bt_heading_19'))
        ),
        array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Image Animation", 'landmark-construction-theme'),
        "param_name" => "animation_photo",
        "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation_5", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind"),
         "dependency" => Array('element' => "style", 'value' => array('bt_heading_19'))
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Image Animaition Delay", 'landmark-construction-theme'),
        "param_name" => "delay_photo",
        "description"=> __("If you write 1000, it means your animation will work after 1 second", 'landmark-construction-theme'),
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_19'))
    ),
         array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon Fonticon", 'landmark-construction-theme'),
        "param_name" => "icon_style",
        "value" => array( 
                __( 'Font Awesome', "landmark-construction-theme" ) => 'fontawesome',
                __( 'Open Iconic', "landmark-construction-theme" ) => 'openiconic',
                __( 'Typicons', "landmark-construction-theme" ) => 'typicons',
                __( 'Entypo', "landmark-construction-theme" ) => 'entypo',
                __( 'Linecons', "landmark-construction-theme" ) => 'linecons'
        ),
        "description" => __("Add icon to your heading", 'landmark-construction-theme'),
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_2', 'bt_heading_3', 'bt_heading_5', 'bt_heading_9', 'bt_heading_10', 'bt_heading_11', 'bt_heading_12', 'bt_heading_14', 'bt_heading_16', 'bt_heading_17', 'bt_heading_20'))
    ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_fontawesome',
            'value' => 'fa fa-adjust', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
            ),
            'dependency' => Array( 'element' => 'icon_style', 'value' => 'fontawesome' ),

            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_openiconic',
            'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'openiconic',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'openiconic',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_typicons',
            'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'typicons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'typicons',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_entypo',
            'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'entypo',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'entypo',
            ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_linecons',
            'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'linecons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array( 'element' => 'icon_style','value' => 'linecons',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Icon Color",'landmark-construction-theme'),
            "param_name" => "icon_color",
            "value" => '',
            "description" => __("Select icon color",'landmark-construction-theme'),
            "dependency" => Array('element' => "style", 'value' => array('bt_heading_2', 'bt_heading_3', 'bt_heading_5', 'bt_heading_9', 'bt_heading_10', 'bt_heading_11', 'bt_heading_12', 'bt_heading_14', 'bt_heading_16', 'bt_heading_17', 'bt_heading_20'))
         ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon Rotate", 'landmark-construction-theme'),
        "param_name" => "rotate_icon",
        "description"=> __("Write degree like 45", 'landmark-construction-theme'),
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_2', 'bt_heading_3', 'bt_heading_5', 'bt_heading_9', 'bt_heading_10', 'bt_heading_11', 'bt_heading_12', 'bt_heading_14', 'bt_heading_16', 'bt_heading_17', 'bt_heading_20'))
    ),
    array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon Animation", 'landmark-construction-theme'),
        "param_name" => "animation_icon",
        "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation_6", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind"),
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_2', 'bt_heading_3', 'bt_heading_5', 'bt_heading_9', 'bt_heading_10', 'bt_heading_11', 'bt_heading_12', 'bt_heading_14', 'bt_heading_16', 'bt_heading_17', 'bt_heading_20'))
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon Animation Delay", 'landmark-construction-theme'),
        "param_name" => "delay_icon",
        "description"=> __("If you write 1000, it means your animation will work after 1 second", 'landmark-construction-theme'),
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_2', 'bt_heading_3', 'bt_heading_5', 'bt_heading_9', 'bt_heading_10', 'bt_heading_11', 'bt_heading_12', 'bt_heading_14', 'bt_heading_16', 'bt_heading_17', 'bt_heading_20'))
    ),
         array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon 2 Fonticon", 'landmark-construction-theme'),
        "param_name" => "icon_style_2",
        "value" => array( 
                __( 'Font Awesome', "landmark-construction-theme" ) => 'fontawesome_2',
                __( 'Open Iconic', "landmark-construction-theme" ) => 'openiconic_2',
                __( 'Typicons', "landmark-construction-theme" ) => 'typicons_2',
                __( 'Entypo', "landmark-construction-theme" ) => 'entypo_2',
                __( 'Linecons', "landmark-construction-theme" ) => 'linecons_2'
        ),
        "description" => __("Add icon to your heading", 'landmark-construction-theme'),
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_2', 'bt_heading_12', 'bt_heading_20'))
    ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon 2', "landmark-construction-theme" ),
            'param_name' => 'icon_fontawesome_2',
            'value' => 'fa fa-adjust', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
            ),
            'dependency' => Array( 'element' => 'icon_style_2', 'value' => 'fontawesome_2' ),

            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_openiconic_2',
            'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'openiconic',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style_2',
                'value' => 'openiconic_2',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_typicons_2',
            'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'typicons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style_2',
                'value' => 'typicons_2',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_entypo_2',
            'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'entypo',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style_2',
                'value' => 'entypo_2',
            ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_linecons_2',
            'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'linecons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array( 'element' => 'icon_style_2','value' => 'linecons_2',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Icon 2 Color",'landmark-construction-theme'),
            "param_name" => "icon_color_2",
            "value" => '',
            "description" => __("Select icon color",'landmark-construction-theme'),
            "dependency" => Array('element' => "style", 'value' => array('bt_heading_2', 'bt_heading_12', 'bt_heading_20'))
         ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon 2 Rotate", 'landmark-construction-theme'),
        "param_name" => "rotate_icon_2",
        "description"=> __("Write degree like 45", 'landmark-construction-theme'),
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_2', 'bt_heading_12', 'bt_heading_20'))
    ),
    array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon 2 Animation", 'landmark-construction-theme'),
        "param_name" => "animation_icon_2",
        "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation_7", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind"),
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_2', 'bt_heading_12', 'bt_heading_20'))
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon 2 Animation Delay", 'landmark-construction-theme'),
        "param_name" => "delay_icon_2",
        "description"=> __("If you write 1000, it means your animation will work after 1 second", 'landmark-construction-theme'),
        "dependency" => Array('element' => "style", 'value' => array('bt_heading_2', 'bt_heading_12', 'bt_heading_20'))
    )    
    ),
) );

}

/*****************/
/* Imagebox landmark*/
/*****************/
function landmark_construction_ImageBox($atts, $content = null) {
   extract(shortcode_atts ( array(
    'style' => 'bt_imagebox_1',
    'photo' => '',
    'icon_style' => 'fontawesome',
    'icon_fontawesome' => 'fa fa-adjust',
    'icon_openiconic' => '',
    'icon_typicons' => '',
    'icon_entypoicons' => '',
    'icon_linecons' => '',
    'icon_entypo' => '',
    'color' => '',
    'add_button' => '',      
    'button_text' => '',
    'button_link' => '',
    'button_window' => '_self',
    'animation' => 'no_animation',
    'delay'=> ''
    ), 
   $atts));

    $mydelay = $echo_button = $boximage ="";

// animation
  if ( $delay != '') {
    $mydelay = 'animation-delay: '.$delay.'ms; -moz-animation-delay: '.$delay.'ms; -webkit-animation-delay: '.$delay.'ms;';
  }
// Icon
   vc_icon_element_fonts_enqueue( $icon_style );

   $iconClass = isset( ${"icon_" . $icon_style} ) ? esc_attr( ${"icon_" . $icon_style} ) : 'fa fa-adjust';     
     $add_icon = '<span style ="background-color:'.$color.'" class="icon"><span class="'.$iconClass.'"></span></span>';
// Button

  if ( $add_button == "yes") {
    $echo_button = '<div class="bt-imagebox-button"><div class="bt-imagebox-button-style"><a href="'.esc_url($button_link).'" target="'.$button_window.'">'.$button_text.'</a></div></div>';
  }
// photo
    if ( !empty($photo)) {
    $img_id = preg_replace('/[^\d]/', '', $photo);
    $image = wp_get_attachment_image_src( $img_id, 'full');
    $alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

    $boximage = '<div class="bt_image"><img src="'.$image[0].'" width="'.$image[1].'" height="'.$image[2].'" alt="'.$alt.'"></div>';
    } 

    switch ($style) {
            case "bt_imagebox_1":
            return '<div class="'.$animation.' bt_imagebox '.$style.' animated" style="'.$mydelay.'">
                    '.$boximage.'<div class="bt_image_content">'.do_shortcode($content).''.$echo_button.'</div>
                    </div>';           
            break;
            case "bt_imagebox_3":
            return '<div class="'.$animation.' bt_imagebox '.$style.' animated" style="'.$mydelay.'">
                    <div class="bt-img-icon">'.$add_icon.''.$boximage.'</div><div class="bt_image_content">'.do_shortcode($content).'</div>
                    </div>';           
            break;
            case "bt_imagebox_5":
            return '<div class="'.$animation.' bt_imagebox '.$style.' animated" style="'.$mydelay.'">
                    '.$boximage.'<div class="bt_image_content">'.do_shortcode($content).''.$echo_button.'</div>
                    </div>';           
            break;
            case "bt_imagebox_7":
            return '<div class="'.$animation.' bt_imagebox '.$style.' animated" style="'.$mydelay.'">
                    '.$boximage.'<div class="bt_image_content">'.do_shortcode($content).''.$echo_button.'</div>
                    </div>';           
            break;
        
        default:
        return '<div class="'.$animation.' bt_imagebox '.$style.' animated" style="'.$mydelay.'">
                    '.$boximage.'<div class="bt_image_content">'.do_shortcode($content).'</div>
                    </div>';           
            break;
        
        break;
    }     

}
add_shortcode('landmark_construction_Image_Box', 'landmark_construction_ImageBox');


add_action( 'init', 'landmark_construction_Image_Box_integrateWithVC' );
function landmark_construction_Image_Box_integrateWithVC() {
vc_map ( array(
    "name" => __("Image Box", "landmark-construction-theme"),
    "base" => "landmark_construction_Image_Box",
    "class" => "",
    "category" => 'Content', 
    "content_element" => true,
    "show_settings_on_create" => true,
    "params" => array(
        array(
          "type" => "dropdown",
          "holder" => "div",
          "class" => "",
          "heading" => __("Image Box Style", 'landmark-construction-theme'),
          "param_name" => "style",
          "value" => array(
            __('Style 1', "landmark-construction-theme") => "bt_imagebox_1", 
            __('Style 2', "landmark-construction-theme") => "bt_imagebox_2", 
            __('Style 3', "landmark-construction-theme") => "bt_imagebox_3", 
            __('Style 4', "landmark-construction-theme") => "bt_imagebox_4", 
            __('Style 5', "landmark-construction-theme") => "bt_imagebox_5",
            __('Style 6', "landmark-construction-theme") => "bt_imagebox_6", 
            __('Style 7', "landmark-construction-theme") => "bt_imagebox_7",
            __('Style 8', "landmark-construction-theme") => "bt_imagebox_8",
            __('Style 9', "landmark-construction-theme") => "bt_imagebox_9"
            ),
          "description" => __("Choose your style.", 'landmark-construction-theme')                   
        ),
        array(
          "type" => "attach_image",
          "heading" => __("Image", "landmark-construction-theme"),
          "param_name" => "photo",
          "value" => "",
          "description" => __("Choose image from media library.", "landmark-construction-theme")
        ),
         array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon", 'landmark-construction-theme'),
        "param_name" => "icon_style",
        "value" => array( 
                __( 'Font Awesome', "landmark-construction-theme" ) => 'fontawesome',
                __( 'Open Iconic', "landmark-construction-theme" ) => 'openiconic',
                __( 'Typicons', "landmark-construction-theme" ) => 'typicons',
                __( 'Entypo', "landmark-construction-theme" ) => 'entypo',
                __( 'Linecons', "landmark-construction-theme" ) => 'linecons'
        ),
        "description" => __("Add icon to your imagebox", 'landmark-construction-theme'),
        "dependency" => Array('element' => "style", 'value' => array('bt_imagebox_3'))
    ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_fontawesome',
            'value' => 'fa fa-adjust', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
            ),
            'dependency' => Array( 'element' => 'icon_style', 'value' => 'fontawesome' ),

            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_openiconic',
            'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'openiconic',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'openiconic',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_typicons',
            'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'typicons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'typicons',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_entypo',
            'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'entypo',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'entypo',
            ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_linecons',
            'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'linecons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array( 'element' => 'icon_style','value' => 'linecons',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Icon Background Color",'landmark-construction-theme'),
            "param_name" => "color",
            "value" => '',
            "description" => __("Select icon background color",'landmark-construction-theme'),
            "dependency" => Array('element' => "style", 'value' => array('bt_imagebox_3'))
         ), 
        array(
            "type" => "textarea_html",
            "holder" => "div",
            "class" => "",
            "heading" => __("Content", 'landmark-construction-theme'),
            "param_name" => "content",
            "value" => "This is your content",
            "description" => __("You can write your image box content here.", 'landmark-construction-theme')
        ),
      array(
        "type" => 'checkbox',
        "heading" => __("Add Button", "landmark-construction-theme"),
        "param_name" => "add_button",
        "description" => __("Add button to your image box.", "landmark-construction-theme"),
        "value" => Array(__("Yes, please", "landmark-construction-theme") => 'yes'),
        "dependency" => Array('element' => "style", 'value' => array('bt_imagebox_1', 'bt_imagebox_5', 'bt_imagebox_7'))
    ),

    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Button Text", 'landmark-construction-theme'),
        "param_name" => "button_text",
        "description" => __("Button Text", 'landmark-construction-theme'),
        "dependency" => Array('element' => "add_button", 'value' => 'yes')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Button Link", 'landmark-construction-theme'),
        "param_name" => "button_link",
        "description" => __("Button Link", 'landmark-construction-theme'),
        "dependency" => Array('element' => "add_button", 'value' => 'yes')
    ),

    array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Link Target", 'landmark-construction-theme'),
        "param_name" => "button_window",
        "value" => array(__('Self', "landmark-construction-theme") => "_self", __('Blank', "landmark-construction-theme") => "_blank"),
        "description" => __("Choose your target", 'landmark-construction-theme'),
        "dependency" => Array('element' => "add_button", 'value' => 'yes')
    ),
        array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("CSS Animation", 'landmark-construction-theme'),
        "param_name" => "animation",
        "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind"),
        "description" => __("Choose your animation.", 'landmark-construction-theme')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("CSS Animation Delay", 'landmark-construction-theme'),
        "param_name" => "delay",
        "description"=> __("If you write 1000, it means your animation will work after 1 second", 'landmark-construction-theme')
    )              
    ),
    "js_view" => 'VcColumnView'
) );

}
  
/*********************/
/*   Mail Chimp Form */
/*********************/
function landmark_construction_mailchimps($atts) {
   extract(shortcode_atts ( array(
    'mailchimp' => '',
    ), 
   $atts));
  
  $mailchimp = '['.$mailchimp.']';
  return '<div class="bt-mailchimp">'.do_shortcode( $mailchimp ) .'</div>';
}
add_shortcode('landmark_construction_mailchimp', 'landmark_construction_mailchimps');
add_action( 'init', 'landmark_construction_mailchimp_integrateWithVC' );
function landmark_construction_mailchimp_integrateWithVC() {
vc_map( array(
   "name" => __("Mail Chimp", 'landmark-construction-theme'),
   "base" => "landmark_construction_mailchimp",
   "class" => "",
   "category" => 'Content',
   'admin_enqueue_css' => array(get_template_directory_uri().'/css/visualcomposer.css'),   
   "icon" => "bliccaThemes-vc-icon",    
   "params" => array(    

    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Mail Chimp Shortcode", 'landmark-construction-theme'),
        "param_name" => "mailchimp",
        "description" => __("Paste your mail chimp shortcode without [ ], just paste content of between [ and ]. you should install mailchimp plugin for WordPress and create your form before using these.", 'landmark-construction-theme')
    )
)
));
}       
/***************************************/
/*     BliccaThemes Countdown   landmark   */
/***************************************/

function landmark_construction_countdown($atts) {
   extract(shortcode_atts ( array(
    'style' => 'style_1',
    'year' => '',  
    'month' => '', 
    'day' => '', 
    'hour' => '', 
    'minute' => '', 
    'second' => ''
    ), 
   $atts)); 


    switch ($style) {
      case 'style_1':
        return '<div id="DateCountdown1" class="countdown_'.$style.'" data-date="'.$year.'-'.$month.'-'.$day.' '.$hour.':'.$minute.':'.$second.'"></div>';
        break;
      case 'style_2':
        return '<div id="DateCountdown2" class="countdown_'.$style.'" data-date="'.$year.'-'.$month.'-'.$day.' '.$hour.':'.$minute.':'.$second.'"></div>';
        break;
      case 'style_3':
        return '<div id="DateCountdown3" class="countdown_'.$style.'" data-date="'.$year.'-'.$month.'-'.$day.' '.$hour.':'.$minute.':'.$second.'"></div>';
        break;
      case 'style_4':
        return '<div id="DateCountdown4" class="countdown_'.$style.'" data-date="'.$year.'-'.$month.'-'.$day.' '.$hour.':'.$minute.':'.$second.'"></div>';        
        break;
      case 'style_5':
        return '<div id="DateCountdown5" class="countdown_'.$style.'" data-date="'.$year.'-'.$month.'-'.$day.' '.$hour.':'.$minute.':'.$second.'"></div>';
        break;
      case 'style_6':
        return '<div id="DateCountdown6" class="countdown_'.$style.'" data-date="'.$year.'-'.$month.'-'.$day.' '.$hour.':'.$minute.':'.$second.'"></div>';        
        break;   
      case 'style_7':
        return '<div id="DateCountdown7" class="countdown_'.$style.'" data-date="'.$year.'-'.$month.'-'.$day.' '.$hour.':'.$minute.':'.$second.'"></div>';     
        break;
      case 'style_8': 
        return '<div id="DateCountdown8" class="countdown_'.$style.'" data-date="'.$year.'-'.$month.'-'.$day.' '.$hour.':'.$minute.':'.$second.'"></div>';      
        break;
      case 'style_9':
        return '<div id="DateCountdown9" class="countdown_'.$style.'" data-date="'.$year.'-'.$month.'-'.$day.' '.$hour.':'.$minute.':'.$second.'"></div>';        
        break;
      default:
        
        break;
    }



}
add_shortcode('bcountdown', 'landmark_construction_countdown');

add_action( 'init', 'landmark_construction_countdown_integrateWithVC' );
function landmark_construction_countdown_integrateWithVC() {
vc_map ( array(
   "name" => __("Add Countdown", 'landmark-construction-theme'),
   "base" => "bcountdown",
   "class" => "",
   "category" => 'Content',
   'admin_enqueue_css' => array(get_template_directory_uri().'/css/vc_extend_admin.css'),
   "icon" => "bliccaThemes-vc-icon", 
   "params" => array(   

   array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __("Countwodn style",'landmark-construction-theme'),
            "param_name" => "style",
            "value" => array ("Style 1" => "style_1", 
                              "Style 2" => "style_2", 
                              "Style 3" => "style_3", 
                              "Style 4" => "style_4", 
                              "Style 5" => "style_5", 
                              "Style 6" => "style_6",
                              "Style 7" => "style_7",
                              "Style 8" => "style_8",
                              "Style 9" => "style_9"), 
            "description" => __("Choose countdown style",'landmark-construction-theme')
         ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Years", 'landmark-construction-theme'),
        "param_name" => "year",
        "value" => '',
        "description" => __("write year as number. 2016 e.g.", 'landmark-construction-theme')     
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Months", 'landmark-construction-theme'),
        "param_name" => "month",
        "value" => '',
        "description" => __("Write month as number. 05 e.g.", 'landmark-construction-theme'),
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Days", 'landmark-construction-theme'),
        "param_name" => "day",
        "value" => '',
        "description" => __("Write day as number. 24 e.g.", 'landmark-construction-theme'),
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Hours", 'landmark-construction-theme'),
        "param_name" => "hour",
        "value" => '',
        "description" => __("Write hour as number. 16 e.g.", 'landmark-construction-theme'),
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Minutes", 'landmark-construction-theme'),
        "param_name" => "minute",
        "value" => '',
        "description" => __("Write minute as number. 56 e.g.", 'landmark-construction-theme'),
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Seconds", 'landmark-construction-theme'),
        "param_name" => "second",
        "value" => '',
        "description" => __("Write second as number. 45 e.g.", 'landmark-construction-theme'),
    )
   )
) );
}

/*****************/
/* Meet The Team landmark*/
/*****************/
function landmark_construction_meet_the_teams($atts, $content = null) {
   extract(shortcode_atts ( array(
    'style' => 'bt_teams_1',
    'meet_name' => '',
    'meet_position' => '',
    'photo' => '',
    'team_text' => '',
    'add_button' => '',      
    'button_text' => '',
    'button_link' => '',
    'button_window' => '_self',
    'animation' => 'no_animation',
    'delay'=> ''
    ), 
   $atts));

    $mydelay = $member_position = $echo_button = $member_image = $member_text = $member_social = "";

// animation
  if ( $delay != '') {
    $mydelay = 'animation-delay: '.$delay.'ms; -moz-animation-delay: '.$delay.'ms; -webkit-animation-delay: '.$delay.'ms;';
  }
// Button

  if ( $add_button == "yes") {
    $echo_button = '<div class="bt-team-button"><div class="bt-team-button-style"><a href="'.esc_url($button_link).'" target="'.$button_window.'">'.$button_text.'</a></div></div>';
  }
// photo
    if ( !empty($photo)) {
    $img_id = preg_replace('/[^\d]/', '', $photo);
    $image = wp_get_attachment_image_src( $img_id, 'full');
    $alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

    $member_image = '<div class="bt_member_photo"><img src="'.$image[0].'" width="'.$image[1].'" height="'.$image[2].'" alt="'.$alt.'"></div>';
    }
// position
    if ( !empty($meet_position) ) {
      $member_position = '<span class="bt_member_position">'.$meet_position.'</span>';
    }

    $member_name = '<div class="bt_member_name">'.$meet_name.' '.$member_position.'</div>';
// member information
    if ( !empty($team_text) ) {
      $member_text = '<div class="bt_member_text">'.$team_text.'</div>';
    } 
// social

    if ( !empty($content) ) {
      $member_social = '<div class="bt_member_social">'.do_shortcode($content).'</div>';
    }

    switch ($style) {
            case "bt_teams_1":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    '.$member_image.'<div class="bt_team_content">'.$member_name.''.$member_text.''.$member_social.'</div>
                    </div>';           
            break;
            case "bt_teams_2":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    '.$member_image.'<div class="bt_team_content">'.$member_social.''.$member_name.''.$member_text.'</div>
                    </div>';                   
            break;
            case "bt_teams_3":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    '.$member_image.'<div class="bt_team_content">'.$member_name.'</div>
                    </div>';            
            break;
            case "bt_teams_4":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    <div class="team_absolute">'.$member_image.''.$member_social.'<div class="team-overlay"></div></div><div class="bt_team_content">'.$member_name.''.$member_text.'</div>
                    </div>';             
            break;
            case "bt_teams_5":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    <div class="team_absolute">'.$member_image.''.$member_social.'</div><div class="bt_team_content">'.$member_name.'</div>
                    </div>'; 
            break;
            case "bt_teams_6":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    '.$member_image.'<div class="bt_team_content">'.$member_name.''.$member_text.''.$member_social.'</div>
                    </div>';           
            break;
            case "bt_teams_7":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    '.$member_image.'<div class="bt_team_content">'.$member_name.''.$member_social.'</div>
                    </div>';           
            break;
            case "bt_teams_8":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    <div class="team_absolute">'.$member_image.''.$member_social.'</div><div class="bt_team_content">'.$member_name.''.$member_text.'</div>
                    </div>'; 
            break;
            case "bt_teams_9":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    <div class="team_absolute">'.$member_image.''.$member_name.''.$member_social.'</div>
                    </div>'; 
            break;
            case "bt_teams_10":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    <div class="bt_team_left">'.$member_image.'</div><div class="bt_team_content">'.$member_name.''.$member_text.'</div>'.$member_social.'
                    </div>'; 
            break;
      case "bt_teams_11":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    '.$member_image.'<div class="bt_team_content">'.$member_name.''.$member_text.'</div>'.$member_social.'
                    </div>';           
            break;
            case "bt_teams_12":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    <div class="team_absolute">'.$member_image.''.$member_name.''.$member_social.'</div>
                    </div>'; 
            break;
            case "bt_teams_13":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    <div class="team_absolute">'.$member_image.''.$member_social.'</div>
<div class="bt_team_content">'.$member_name.'</div>
                    </div>'; 
            break;
            case "bt_teams_14":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    <div class="bt_team_left">'.$member_image.''.$member_social.'</div><div class="bt_team_content">'.$member_name.''.$member_text.'</div>
                    </div>'; 
            break;
            case "bt_teams_15":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    <div class="team_absolute">'.$member_image.''.$member_name.'</div><div class="bt_team_content">'.$member_social.'</div>
                    </div>'; 
            break;
            case "bt_teams_16":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    '.$member_image.'<div class="bt_team_content">'.$member_name.''.$member_text.''.$echo_button.'</div>
                    </div>';           
            break;
            case "bt_teams_17":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    <div class="team_absolute">'.$member_image.'<div class="team_overlay">'.$member_social.'</div><div class="socialbutton"></div></div>
<div class="bt_team_content">'.$member_name.'</div>
                    </div>'; 
            break;
            case "bt_teams_18":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    <div class="bt_team_left">'.$member_image.'</div><div class="bt_team_content">'.$member_name.''.$member_text.''.$member_social.'</div>
                    </div>'; 
            break;
            case "bt_teams_19":
            return '<div class="'.$animation.' bt_meet_teams '.$style.' animated" style="'.$mydelay.'">
                    <div class="team_absolute">'.$member_image.''.$member_social.'</div><div class="bt_team_content">'.$member_name.'</div>
                    </div>'; 
            break;
        
        default:
        
        break;
    }     


}
add_shortcode('landmark_construction_meet_the_team', 'landmark_construction_meet_the_teams');


add_action( 'init', 'landmark_construction_meet_the_team_integrateWithVC' );
function landmark_construction_meet_the_team_integrateWithVC() {
vc_map ( array(
    "name" => __("Meet The Team", "landmark-construction-theme"),
    "base" => "landmark_construction_meet_the_team",
    "as_parent" => array('only' => 'vc_icon'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
    "content_element" => true,
    "show_settings_on_create" => true,
    "params" => array(
        array(
          "type" => "dropdown",
          "holder" => "div",
          "class" => "",
          "heading" => __("Team Style", 'landmark-construction-theme'),
          "param_name" => "style",
          "value" => array(
            __('Style 1', "landmark-construction-theme") => "bt_teams_1", 
            __('Style 2', "landmark-construction-theme") => "bt_teams_2", 
            __('Style 3', "landmark-construction-theme") => "bt_teams_3", 
            __('Style 4', "landmark-construction-theme") => "bt_teams_4", 
            __('Style 5', "landmark-construction-theme") => "bt_teams_5",
            __('Style 6', "landmark-construction-theme") => "bt_teams_6", 
            __('Style 7', "landmark-construction-theme") => "bt_teams_7",
            __('Style 8', "landmark-construction-theme") => "bt_teams_8",
            __('Style 9', "landmark-construction-theme") => "bt_teams_9",
            __('Style 10', "landmark-construction-theme") => "bt_teams_10",
            __('Style 11', "landmark-construction-theme") => "bt_teams_11",
            __('Style 12', "landmark-construction-theme") => "bt_teams_12",
            __('Style 13', "landmark-construction-theme") => "bt_teams_13",
            __('Style 14', "landmark-construction-theme") => "bt_teams_14",
            __('Style 15', "landmark-construction-theme") => "bt_teams_15",
            __('Style 16', "landmark-construction-theme") => "bt_teams_16",
            __('Style 17', "landmark-construction-theme") => "bt_teams_17",
            __('Style 18', "landmark-construction-theme") => "bt_teams_18",
            __('Style 19', "landmark-construction-theme") => "bt_teams_19"
            ),
          "description" => __("Choose your style.", 'landmark-construction-theme')                   
        ),
        array(
            "type" => "textfield",
            "heading" => __("Name", "landmark-construction-theme"),
            "param_name" => "meet_name",
            "description" => __("Add a name for team member", "landmark-construction-theme")
        ),
        array(
            "type" => "textfield",
            "heading" => __("Position", "landmark-construction-theme"),
            "param_name" => "meet_position",
            "description" => __("Add a position for team member", "landmark-construction-theme"),
            "dependency" => Array('element' => "style", 'value' => array('bt_teams_2', 'bt_teams_3', 'bt_teams_4', 'bt_teams_5', 'bt_teams_6', 'bt_teams_7', 'bt_teams_8', 'bt_teams_9', 'bt_teams_10', 'bt_teams_11', 'bt_teams_12', 'bt_teams_13', 'bt_teams_14', 'bt_teams_15', 'bt_teams_16', 'bt_teams_17', 'bt_teams_18', 'bt_teams_19'))
        ),
        array(
          "type" => "attach_image",
          "heading" => __("Photo", "landmark-construction-theme"),
          "param_name" => "photo",
          "value" => "",
          "description" => __("Choose image from media library.", "landmark-construction-theme")
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => __("Team Member Text", 'landmark-construction-theme'),
            "param_name" => "team_text",
            "value" => "",
            "description" => __("You can write some information about your member", 'landmark-construction-theme'),
            "dependency" => Array('element' => "style", 'value' => array('bt_teams_1', 'bt_teams_2', 'bt_teams_4', 'bt_teams_6', 'bt_teams_8', 'bt_teams_10', 'bt_teams_11', 'bt_teams_14', 'bt_teams_16', 'bt_teams_18'))
        ),
      array(
        "type" => 'checkbox',
        "heading" => __("Add Button", "landmark-construction-theme"),
        "param_name" => "add_button",
        "description" => __("Add button to your team", "landmark-construction-theme"),
        "value" => Array(__("Yes, please", "landmark-construction-theme") => 'yes'),
      "dependency" => Array('element' => "style", 'value' => array('bt_teams_16'))
    ),

    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Button Text", 'landmark-construction-theme'),
        "param_name" => "button_text",
        "description" => __("Button Text", 'landmark-construction-theme'),
        "dependency" => Array('element' => "add_button", 'value' => 'yes')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Button Link", 'landmark-construction-theme'),
        "param_name" => "button_link",
        "description" => __("Button Link", 'landmark-construction-theme'),
        "dependency" => Array('element' => "add_button", 'value' => 'yes')
    ),

    array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Link Target", 'landmark-construction-theme'),
        "param_name" => "button_window",
        "value" => array(__('Self', "landmark-construction-theme") => "_self", __('Blank', "landmark-construction-theme") => "_blank"),
        "description" => __("Choose your target", 'landmark-construction-theme'),
        "dependency" => Array('element' => "add_button", 'value' => 'yes')
    ),
        array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("CSS Animation", 'landmark-construction-theme'),
        "param_name" => "animation",
        "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind"),
        "description" => __("Choose your animation.", 'landmark-construction-theme')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("CSS Animation Delay", 'landmark-construction-theme'),
        "param_name" => "delay",
        "description"=> __("If you write 1000, it means your animation will work after 1 second", 'landmark-construction-theme')
    )              
    ),
    "js_view" => 'VcColumnView'
) );
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_landmark_construction_meet_the_team extends WPBakeryShortCodesContainer {
    }
}

}    

/**********************/
/**** landmark Price Tables ****/
/**********************/

function landmark_construction_table_container($atts, $content = null) {
  extract(shortcode_atts ( array (
      'table_type' => 'bt-table-1',
      'table_featured' => '',
      'featured_color' => '',
      'table_title' => '',
      'table_subtitle'=> '',
      'price' => '',
      'price_currency' => '',
      'price_extra' => '',
      'add_button' => '',      
      'button_text' => '',
      'button_link' => '',
      'button_window' => '_self',
      'button_back' => '',
      'button_color' => '',
      'table_tag'=> '',      
      'animation' => 'no_animation',
      'icon_style' => 'fontawesome',     
      'icon_fontawesome' => 'fa fa-adjust',
      'icon_openiconic' => '',
      'icon_typicons' => '',
      'icon_entypoicons' => '',
      'icon_linecons' => '',
      'icon_entypo' => '',
      'delay'=> ''
    ),
  $atts));
 
  $mydelay = $echo_price = $echo_button = $table_user_background =   $add_icon  = $table_user_border = $table_user_t1 = $table_user_t2 = $table_user_t3 = $table_user_t4 = $table_user_color = $echo_tag = $echo_tag_3 = $echo_tag_6 = $table_user_t6 = $output = '';

/* Animation */
  if ( $delay != '') {
    $mydelay = 'animation-delay: '.$delay.'ms; -moz-animation-delay: '.$delay.'ms; -webkit-animation-delay: '.$delay.'ms;';
  }

/* Subtitle */
  if( $table_subtitle != "" ) {
    $table_subtitle = '<div class="bt-table-subtitle-outer"><span class="bt-table-subtitle">'.$table_subtitle.'</span></div>';
  }

/* Button */

  if ( $add_button == "yes") {
    $echo_button = '<div class="bt-table-button"><div class="bt-table-button-style"><a href="'.esc_url($button_link).'" target="'.$button_window.'" style="background: '.$button_back.'; color: '.$button_color.';">'.$button_text.'</a></div></div>';
  }

/* Price Part */
  if ( $price != "" ) {

    if ( $price_currency != "" ) {
      $echo_price .= '<span class="bt-table-currency">'.$price_currency.'</span>';
    }

    $echo_price .= '<span class="bt-table-price">'.$price.'</span>';

    if ( $price_extra != "" ) {
      $echo_price .= '<div class="bt-table-price-extra">'.$price_extra.'</div>';
    }

  }
  $table_type2 = $table_type;
/* Featured Table */  
  if( $table_featured == "yes" ) {
    $table_type2 .= ' bt-featuread-table';
    $table_user_background = 'background:'.$featured_color.';';
    $table_user_border = 'border-color:'.$featured_color.';';
    $table_user_color = 'color:'.$featured_color.';'; 
    $table_user_t1 = 'border-color:'.$featured_color.' '.$featured_color.' '.$featured_color.' transparent;'; 
    $table_user_t2 = 'border-color:'.$featured_color.' transparent '.$featured_color.' '.$featured_color.';'; 
    $table_user_t6 = 'border-color:'.$featured_color.' transparent transparent transparent;';
    $table_user_t3 = 'border-color: transparent '.$featured_color.' transparent transparent;';
    $table_user_t4 = 'border-color: transparent transparent transparent '.$featured_color.';';
    
    
    
  }

/* Extra Tags */

  if ( $table_tag != "" ) {
    $echo_tag = '<div class="bt-table-tag">'.$table_tag.'</div>';
    $echo_tag_3 = '<div class="bt-table-tag" style="color:'.$featured_color.'; border-color:'.$featured_color.';">'.$table_tag.'</div>';
    $echo_tag_6 = '<div class="bt-table-tag" style="background-color:'.$featured_color.';"><span class="t6" style="'.$table_user_t6.'"></span>'.$table_tag.'</div>';
  }  
  
 /* Random Class */
 $table_random = landmark_construction_theme_random_string(20); 

/* Add Icon */
 if ( $table_type == "bt-table-7") {
 vc_icon_element_fonts_enqueue( $icon_style );
  $iconClass = isset( ${"icon_" . $icon_style} ) ? esc_attr( ${"icon_" . $icon_style} ) : 'fa fa-adjust';

  $add_icon = '<div class="vc_icon_element-icon '. $iconClass . '" style="color:'.$featured_color.';"></div>';  
  }


    switch ($table_type) {
      case 'bt-table-1':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';
        $output .= $table_subtitle;
        $output .= '<div class="bt-table-title" style="'.$table_user_background.'"><span class="t1" style="'.$table_user_t1.'"></span>'.$table_title.'<span class="t2" style="'.$table_user_t2.'"></span></div>';
        $output .= '</div>';
        $output .= do_shortcode($content);
        $output .= $echo_button;
        $output .= '</div>';
        break;
      case 'bt-table-2':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= $echo_tag;
        $output .= '<div class="bt-table-top" style="'.$table_user_background.'">';
        $output .= '<div class="bt-table-title">'.$table_title.'</div>';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';
        $output .= $table_subtitle;      
        $output .= '</div>';
        $output .= do_shortcode($content);
        $output .= '</div>';
        break;
      case 'bt-table-3':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top" style="'.$table_user_background.'">';
        $output .= $echo_tag_3;
        $output .= '<div class="bt-table-title">'.$table_title.'</div>';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';
        $output .= $echo_button;      
        $output .= '</div>';
        $output .= '<div class="bt-table-content">';
        $output .= do_shortcode($content);  
        $output .= '</div>';
        $output .= '</div>';
        break;
      case 'bt-table-4':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top" style="'.$table_user_background.'">';
        $output .= '<div class="bt-table-title">'.$table_title.'</div>';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';     
        $output .= '</div>';
        $output .= '<div class="bt-table-content">';
        $output .= do_shortcode($content);
        $output .= $echo_button; 
        $output .= '</div>';
        $output .= '</div>';        
        break;
      case 'bt-table-5':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$table_user_background.' '.$mydelay.'">';
        $output .= '<div class="bt-table-title">'.$table_title.'</div>';
        $output .= do_shortcode($content);
        $output .= '<div class="bt-table-top">';
        $output .= $table_subtitle;
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';
        $output .= $echo_button;
        $output .= '</div>';
        $output .= '</div>';
        break;
      case 'bt-table-6':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= $echo_tag_6;
        $output .= '<div class="content" style="'.$table_user_background.'">';
        $output .= $table_subtitle;
        $output .= '<div class="bt-table-title">'.$table_title.'</div>';
        $output .= do_shortcode($content);
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';
        $output .= $echo_button;
        $output .= '</div>';
        $output .= '</div>';
        $output .= '</div>';        
        break;   
      case 'bt-table-7':
    $output = '<style scoped>#table_'.$table_random.':hover{border-color:'.$featured_color.';}</style> ';
    $output .= '<div id="table_'.$table_random.'" class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-title" style="color:'.$featured_color.';">'.$table_title.'</div>';
        $output .= $add_icon;
        $output .= do_shortcode($content);
        $output .= '<div class="bt-table-top">';
        $output .= $table_subtitle;
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';
        $output .= '</div>';
        $output .= $echo_button;
        $output .= '</div>';      
        break;
      case 'bt-table-8': 
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$table_user_background.' '.$mydelay.'">';
        $output .= '<div class="bt-table-title">'.$table_title.'</div>';
        $output .= do_shortcode($content);
        $output .= '<div class="bt-table-top">';
        $output .= $table_subtitle;
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';
        $output .= $echo_button;
        $output .= '</div>';
        $output .= '</div>';      
        break;
      case 'bt-table-9':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-title">'.$table_title.'</div>';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';
        $output .= $table_subtitle;      
        $output .= '</div>';
        $output .= do_shortcode($content);
        $output .= '</div>';        
        break;
      case 'bt-table-10':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-title">'.$table_title.'</div>';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';     
        $output .= '</div>';
        $output .= do_shortcode($content);
        $output .= $echo_button; 
        $output .= '</div>';        
        break;
      case 'bt-table-11':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';
        $output .= $table_subtitle;
        $output .= '<div class="bt-table-title" style="'.$table_user_background.'"><span class="t1" style="'.$table_user_t3.'"></span>'.$table_title.'<span class="t2" style="'.$table_user_t4.'"></span></div>';
        $output .= '</div>';
        $output .= do_shortcode($content);
        $output .= $echo_button;
        $output .= '</div>';
        break;
      case 'bt-table-12':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-title" style="'.$table_user_background.'">'.$table_title.'</div>';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';
        $output .= $table_subtitle;      
        $output .= '</div>';
        $output .= do_shortcode($content);
        $output .= $echo_button;
        $output .= '</div>'; 
        break;
       case 'bt-table-13':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';     
        $output .= '</div>';
        $output .= '<div class="bt-table-title">'.$table_title.'</div>';
        $output .= do_shortcode($content);
        $output .= $echo_button;
        $output .= '</div>'; 
        break;
       case 'bt-table-14':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-title">'.$table_title.'</div>';
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';      
        $output .= '</div>';
        $output .= do_shortcode($content);
        $output .= $echo_button;
        $output .= '</div>'; 
        break;
       case 'bt-table-15':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-title" style="'.$table_user_background.' border-color:'.$featured_color.';">'.$table_title.'</div>';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';     
        $output .= '</div>';
        $output .= '<div class="content">';
        $output .= do_shortcode($content);
        $output .= '</div>'; 
        $output .= $echo_button;
        $output .= '</div>'; 
        break;
       case 'bt-table-16':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';      
        $output .= '</div>';
        $output .= $table_subtitle;
        $output .= '<div class="bt-table-title">'.$table_title.'</div>';
        $output .= do_shortcode($content);
        $output .= $echo_button;
        $output .= '</div>'; 
        break;
      case 'bt-table-17':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-title">'.$table_title.'</div>';
        $output .= '<div class="priceabs" style="'.$table_user_background.' border-color:'.$featured_color.';">';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>'; 
        $output .= '</div>';
        $output .= '</div>';
        $output .= '<div class="content">';
        $output .= do_shortcode($content);
        $output .= '</div>'; 
        $output .= $echo_button;
        $output .= '</div>';
        break;
      case 'bt-table-18':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>';
        $output .= $table_subtitle;
        $output .= '<div class="bt-table-title" style="'.$table_user_background.'"><span class="t1" style="'.$table_user_background.'"></span>'.$table_title.'<span class="t2" style="'.$table_user_background.'"></span></div>';
        $output .= '</div>';
        $output .= do_shortcode($content);
        $output .= $echo_button;
        $output .= '</div>';
        break;
      case 'bt-table-19':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-title" style="'.$table_user_background.'">'.$table_title.'</div>';
        $output .= '<div class="priceabs">';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>'; 
        $output .= '</div>';
        $output .= '</div>';
        $output .= '<div class="content">';
        $output .= $table_subtitle;
        $output .= do_shortcode($content);
        $output .= '</div>'; 
        $output .= $echo_button;
        $output .= '</div>';
        break;
       case 'bt-table-20':
        $output .= '<div class="'.$animation.' bt-table '.$table_type2.' animated" style="'.$mydelay.'">';
        $output .= '<div class="bt-table-top">';
        $output .= '<div class="bt-table-title">'.$table_title.'</div>';
        $output .= '<div class="priceabs">';
        $output .= '<div class="bt-table-price-outer">'.$echo_price.'</div>'; 
        $output .= '</div>';
        $output .= '</div>';
        $output .= '<div class="content">';
        $output .= do_shortcode($content);
        $output .= '</div>'; 
        $output .= '<div class="bt-table-button"><div class="bt-table-button-style"><a href="'.esc_url($button_link).'" target="'.$button_window.'" style="background: '.$button_back.'; color: '.$button_color.';">'.$button_text.'<span class="t2" style="'.$table_user_t4.'"></span></a></div></div>';
        $output .= '</div>';
        break;
      default:
        
        break;
    }

    return $output;

}
add_shortcode('bt_table', 'landmark_construction_table_container');

function landmark_construction_table_row($atts) {
  extract(shortcode_atts ( array (
      'row_back' => '',
      'row_color' => '',
      'row_content' => '',    
      'icon_add' => '',
      'icon_style' => 'fontawesome',     
      'icon_fontawesome' => 'fa fa-adjust',
      'icon_openiconic' => '',
      'icon_typicons' => '',
      'icon_entypoicons' => '',
      'icon_linecons' => '',
      'icon_entypo' => '',
      'icon_color' => ''
    ),
  $atts));
  $add_icon  = $echo_icon_color = $echo_row_style = "";

  if ( $icon_color != "" ) {
    $echo_icon_color = 'style ="color:'.$icon_color.'"';
  } 

  if ( $row_back != "" || $row_color != "" ) {
    $echo_row_style = 'style = "';

    if ( $row_back != "" ) {
      $echo_row_style .= 'background:'.$row_back.';';
    }

    if ( $row_color != "" ) {
      $echo_row_style .= 'color:'.$row_color.';';
    }

    $echo_row_style .= '"';
  }


  if ( $icon_add != "") {
vc_icon_element_fonts_enqueue( $icon_style );
  $iconClass = isset( ${"icon_" . $icon_style} ) ? esc_attr( ${"icon_" . $icon_style} ) : 'fa fa-adjust';

  $add_icon = '<div class="vc_icon_element-icon '. $iconClass . '" '.$echo_icon_color.'></div>'; 
  }

  $bt_row = '<div class="bt-row-inner" '.$echo_row_style.'>'.$add_icon.''.$row_content.'</div>';

  
  return '<div class="bt-table-row">'.$bt_row.'</div>';

}
add_shortcode('bt_table_row', 'landmark_construction_table_row');

add_action( 'init', 'landmark_construction_table_container_integrateWithVC' );
function landmark_construction_table_container_integrateWithVC() {
vc_map ( array(
   "name" => __("Tables", 'landmark-construction-theme'),
   "base" => "bt_table",
   "class" => "",
   "category" => 'Content', 
   "content_element" => true,
   'admin_enqueue_css' => array(get_template_directory_uri().'/css/visualcomposer.css'),   
   "icon" => "bliccaThemes-vc-icon",  
   "as_parent" => array('only' => 'bt_table_row'),
   "js_view" => 'VcColumnView',
   "params" => array(    

    array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Table Style", 'landmark-construction-theme'),
        "param_name" => "table_type",
        "value" => array(__('Style 1', "landmark-construction-theme") => "bt-table-1", __('Style 2', "landmark-construction-theme") => "bt-table-2"
                        , __('Style 3', "landmark-construction-theme") => "bt-table-3", __('Style 4', "landmark-construction-theme") => "bt-table-4"
                        , __('Style 5', "landmark-construction-theme") => "bt-table-5", __('Style 6', "landmark-construction-theme") => "bt-table-6"
                        , __('Style 7', "landmark-construction-theme") => "bt-table-7", __('Style 8', "landmark-construction-theme") => "bt-table-8"
                        , __('Style 9', "landmark-construction-theme") => "bt-table-9", __('Style 10', "landmark-construction-theme") => "bt-table-10"
                        , __('Style 11', "landmark-construction-theme") => "bt-table-11", __('Style 12', "landmark-construction-theme") => "bt-table-12"
                        , __('Style 13', "landmark-construction-theme") => "bt-table-13", __('Style 14', "landmark-construction-theme") => "bt-table-14"
                        , __('Style 15', "landmark-construction-theme") => "bt-table-15", __('Style 16', "landmark-construction-theme") => "bt-table-16"
                        , __('Style 17', "landmark-construction-theme") => "bt-table-17", __('Style 18', "landmark-construction-theme") => "bt-table-18"
                        , __('Style 19', "landmark-construction-theme") => "bt-table-19", __('Style 20', "landmark-construction-theme") => "bt-table-20"
          ),
        "description" => __("Choose your style", 'landmark-construction-theme')
    ),
    array(
        "type" => 'checkbox',
        "heading" => __("Featured Table", "landmark-construction-theme"),
        "param_name" => "table_featured",
        "description" => __("Highlight your table with color", "landmark-construction-theme"),
        "value" => Array(__("Yes, please", "landmark-construction-theme") => 'yes'),
        "dependency" => Array('element' => "table_type", 'value' => array('bt-table-1', 'bt-table-3', 'bt-table-5', 'bt-table-7', 'bt-table-11', 'bt-table-12', 'bt-table-15', 'bt-table-17', 'bt-table-18', 'bt-table-19', 'bt-table-20', 'bt-table-6'))
    ),
     array(
      "type" => "colorpicker",
      "heading" => __("Featured Color", "landmark-construction-theme"),
      "param_name" => "featured_color",
      "edit_field_class" => "vc_col-sm-12 vc_column vc_shortcode-param",
      "description" => __("Select featured color, color will be applied if your table style available", "landmark-construction-theme"),
      "dependency" => Array('element' => "table_featured", 'value' => 'yes')
    ),    
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Title", 'landmark-construction-theme'),
        "param_name" => "table_title",
        "value" => __("Title", 'landmark-construction-theme'),
        "description" => __("Title for the table", 'landmark-construction-theme')
    ),

    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Extra Desc", 'landmark-construction-theme'),
        "param_name" => "table_subtitle",
        "description" => __("Extra text area for your table", 'landmark-construction-theme'),
        "dependency" => Array('element' => "table_type", 'value' => array('bt-table-1', 'bt-table-2', 'bt-table-5', 'bt-table-6', 'bt-table-7', 'bt-table-9', 'bt-table-12', 'bt-table-16', 'bt-table-19'))
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Price", 'landmark-construction-theme'),
        "param_name" => "price",
        "description" => __("Write a price", 'landmark-construction-theme')
    ),

    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Price Currency", 'landmark-construction-theme'),
        "param_name" => "price_currency",
        "description" => __("Write a currency", 'landmark-construction-theme')
    ),

    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Price Desc", 'landmark-construction-theme'),
        "param_name" => "price_extra",
        "description" => __("You can add some text to your price( for exmp: month ) if your table style is available", 'landmark-construction-theme')
    ),
    array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon", 'landmark-construction-theme'),
        "param_name" => "icon_style",
        "value" => array(
                __( 'Font Awesome', "landmark-construction-theme" ) => 'fontawesome',
                __( 'Open Iconic', "landmark-construction-theme" ) => 'openiconic',
                __( 'Typicons', "landmark-construction-theme" ) => 'typicons',
                __( 'Entypo', "landmark-construction-theme" ) => 'entypo',
                __( 'Linecons', "landmark-construction-theme" ) => 'linecons'
        ),
        "description" => __("You can add image or icon to your services", 'landmark-construction-theme'),
        "dependency" => Array('element' => "table_type", 'value' => 'bt-table-7'),
    ),

    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_fontawesome',
        'value' => 'fa fa-adjust', // default value to backend editor admin_label
        'settings' => array(
        'emptyIcon' => false, // default true, display an "EMPTY" icon?
        'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
        ),
        'dependency' => Array( 'element' => 'icon_style', 'value' => 'fontawesome' ),

        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
    ),
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_openiconic',
        'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
        'settings' => array(
        'emptyIcon' => false, // default true, display an "EMPTY" icon?
        'type' => 'openiconic',
        'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => Array(
        'element' => 'icon_style',
        'value' => 'openiconic',
        ),
        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
    ),
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_typicons',
        'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
        'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'typicons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
        'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'typicons',
            ),
        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
    ),
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_entypo',
        'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
        'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'entypo',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
        'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'entypo',
            ),
    ),
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_linecons',
        'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
        'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'linecons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
        'dependency' => Array( 'element' => 'icon_style','value' => 'linecons',
            ),
        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
    ),
    array(
        "type" => 'checkbox',
        "heading" => __("Add Button", "landmark-construction-theme"),
        "param_name" => "add_button",
        "description" => __("Add button to your table", "landmark-construction-theme"),
        "value" => Array(__("Yes, please", "landmark-construction-theme") => 'yes'),
      "dependency" => Array('element' => "table_type", 'value' => array('bt-table-1', 'bt-table-3', 'bt-table-4', 'bt-table-5', 'bt-table-6', 'bt-table-7', 'bt-table-8', 'bt-table-10', 'bt-table-11', 'bt-table-12', 'bt-table-13', 'bt-table-14', 'bt-table-15', 'bt-table-16', 'bt-table-17', 'bt-table-18', 'bt-table-19', 'bt-table-20'))
    ),

    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Button Text", 'landmark-construction-theme'),
        "param_name" => "button_text",
        "description" => __("Button Text", 'landmark-construction-theme'),
        "dependency" => Array('element' => "add_button", 'value' => 'yes')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Button Link", 'landmark-construction-theme'),
        "param_name" => "button_link",
        "description" => __("Button Link", 'landmark-construction-theme'),
        "dependency" => Array('element' => "add_button", 'value' => 'yes')
    ),

    array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Link Target", 'landmark-construction-theme'),
        "param_name" => "button_window",
        "value" => array(__('Self', "landmark-construction-theme") => "_self", __('Blank', "landmark-construction-theme") => "_blank"),
        "description" => __("Choose your target", 'landmark-construction-theme'),
        "dependency" => Array('element' => "add_button", 'value' => 'yes')
    ),

    array(
      "type" => "colorpicker",
      "heading" => __("Button Background Color", "landmark-construction-theme"),
      "param_name" => "button_back",
      "edit_field_class" => "vc_col-sm-12 vc_column vc_shortcode-param",
      "description" => __("Select button background color", "landmark-construction-theme"),
      "dependency" => Array('element' => "add_button", 'value' => 'yes')
    ),

    array(
      "type" => "colorpicker",
      "heading" => __("Button Text Color", "landmark-construction-theme"),
      "param_name" => "button_color",
      "edit_field_class" => "vc_col-sm-12 vc_column vc_shortcode-param",
      "description" => __("Select button text color", "landmark-construction-theme"),
      "dependency" => Array('element' => "add_button", 'value' => 'yes')
    ),

    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Table Tag", 'landmark-construction-theme'),
        "param_name" => "table_tag",
        "description" => __("In some style we have used extra title top and out of table, for example: most popular . You can add some text if you want", 'landmark-construction-theme'),
        "dependency" => Array('element' => "table_type", 'value' => array('bt-table-2', 'bt-table-3', 'bt-table-6'))
    ),

    array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("CSS Animation", 'landmark-construction-theme'),
        "param_name" => "animation",
        "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind"),
        "description" => __("Choose your animation.", 'landmark-construction-theme')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("CSS Animation Delay", 'landmark-construction-theme'),
        "param_name" => "delay",
        "description"=> __("If you write 1000, it means your animation will work after 1 second", 'landmark-construction-theme')
    )
   )
) );
}

/*********************************/
/* BliccaThemes Buttons   landmark   */
/*********************************/

function landmark_construction_buttons($atts, $content = null) {
   extract(shortcode_atts ( array(
    'style' => 'standard_btn',
    'text_color' => '', 
    'text_hover_color' => '', 
    'back_color' => '',
    'back_hover_color' => '', 
    'radius'   => '0',
    'border_size'   => 'border1px', 
    'border_color'   => '', 
    'font_weight'   => '800',
    'full_width_btn'   => '',
    'url' => '#',
    'target'     => '_self',
    'margin_btn'   => '', 
    'position' => 'pos_left',
    'size' => 'button_mini'
    ), 
   $atts));

   $button_random = landmark_construction_theme_random_string(20);
   if ( $target != "yes") {
    $target = "_self";
   }
   if ( $target == "yes" ) {
    $target = "_blank";
   }   

   if( $style == 'standard_btn' && $full_width_btn !== ''){
    $output = '<div class="bt-button-style"><style scoped>#button_'.$button_random.' a{color:'.$text_color.'; background: '.$back_color.';margin:'.$margin_btn.';font-weight:'.$font_weight.'; border-radius:'.$radius.'px;} #button_'.$button_random.' a:hover{color:'.$text_hover_color.' ; background:'.$back_hover_color.' ;}</style> ';

    $output .= '<div id="button_'.$button_random.'" class="'.$position.'" ><a class="'.$style.' '.$size.' '.$full_width_btn.'" href="'.$url.'" target="'.$target.'">'.do_shortcode($content).'</a></div></div>';
   }
   elseif($style == 'bordered_btn' && $full_width_btn !== ''){
    $output = '<div class="bt-button-style"><style scoped>#button_'.$button_random.' a{color:'.$text_color.'; border-style:solid; border-color:'.$border_color.'; font-weight:'.$font_weight.'; background: '.$back_color.';margin:'.$margin_btn.'; border-radius:'.$radius.'px;} #button_'.$button_random.' a:hover{color:'.$text_hover_color.' ; background:'.$back_hover_color.' ;border-color:'.$back_hover_color.';}</style> ';

    $output .= '<div id="button_'.$button_random.'" class="'.$position.' '.$style.'" ><a class="'.$size.' '.$border_size.'" href="'.$url.'" target="'.$target.'">'.do_shortcode($content).'</a></div></div>';

   }

   elseif( $style == 'standard_btn'){
    $output = '<div class="bt-button-style"><style scoped>#button_'.$button_random.' a{color:'.$text_color.'; background: '.$back_color.';margin:'.$margin_btn.';font-weight:'.$font_weight.'; border-radius:'.$radius.'px;} #button_'.$button_random.' a:hover{color:'.$text_hover_color.' ; background:'.$back_hover_color.' ;}</style> ';

    $output .= '<div id="button_'.$button_random.'" class="'.$position.'" ><a class="'.$style.' '.$size.' '.$full_width_btn.'" href="'.$url.'" target="'.$target.'">'.do_shortcode($content).'</a></div></div>';
   }
   elseif($style == 'bordered_btn'){
    $output = '<div class="bt-button-style"><style scoped>#button_'.$button_random.' a{color:'.$text_color.'; border-style:solid; border-color:'.$border_color.'; font-weight:'.$font_weight.'; background: '.$back_color.';margin:'.$margin_btn.'; border-radius:'.$radius.'px;} #button_'.$button_random.' a:hover{color:'.$text_hover_color.' ; background:'.$back_hover_color.' ;border-color:'.$back_hover_color.';}</style> ';

    $output .= '<div id="button_'.$button_random.'" class="'.$position.' '.$style.'" ><a class="'.$size.' '.$border_size.'" href="'.$url.'" target="'.$target.'">'.do_shortcode($content).'</a></div></div>';

   }

   return $output;



}
add_shortcode('mbuttons', 'landmark_construction_buttons');

add_action( 'init', 'landmark_construction_buttons_integrateWithVC' );
function landmark_construction_buttons_integrateWithVC() {
vc_map ( array(
   "name" => __("bliccaThemes Buttons", 'landmark-construction-theme'),
   "base" => "mbuttons",
   "class" => "",
   "category" => 'Content',
   'admin_enqueue_css' => array(get_template_directory_uri().'/css/vc_extend_admin.css'),
   "icon" => "bliccaThemes-vc-icon", 
   "params" => array(   

   array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __("Button style",'landmark-construction-theme'),
            "param_name" => "style",
            "value" => array ("Normal" => "standard_btn", "Bordered" => "bordered_btn"), 
            "description" => __("Choose the Button style",'landmark-construction-theme')
         ), 
    array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __("Button size",'landmark-construction-theme'),
            "param_name" => "size",
            "value" => array ("Mini" => "button_mini", "Small" => "button_small", "Medium" => "button_medium","Large" => "button_large", "Extra Large" => "button_extra_large"), 
            "description" => __("Choose the Button size",'landmark-construction-theme')
         ),
    array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Button text color",'landmark-construction-theme'),
            "param_name" => "text_color",
            "value" => '',
            "description" => __("Select button text color",'landmark-construction-theme'),
         ), 
    array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Button backgorund color",'landmark-construction-theme'),
            "param_name" => "back_color",
            "value" => '',
            "description" => __("Select button background color",'landmark-construction-theme'),
         ), 
    array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Button text hover color",'landmark-construction-theme'),
            "param_name" => "text_hover_color",
            "value" => '', 
            "description" => __("Select button hover text color",'landmark-construction-theme'),
         ), 
    array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Button background hover color",'landmark-construction-theme'),
            "param_name" => "back_hover_color",
            "value" => '', 
            "description" => __("Select button hover background color",'landmark-construction-theme'),
         ),
    array(
            "type" => "textfield",
            "class" => "",
            "heading" => __("Border radius",'landmark-construction-theme'),
            "param_name" => "radius",
            "value" => '', 
            "description" => __("Enter radius number",'landmark-construction-theme'),         
         ), 
    array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __("Border size",'landmark-construction-theme'),
            "param_name" => "border_size",
            "value" => array ("1px" => "border1px","2px" => "border2px","3px" => "border3px","4px" => "border4px","5px" => "border5px","6px" => "border6px", ), 
            "description" => __("Choose the Button border size",'landmark-construction-theme'),  
            'dependency' =>  array( 'element' => 'style', 'value' => array('bordered_btn'))    
         ),
     array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Border color",'landmark-construction-theme'),
            "param_name" => "border_color",
            "value" => '', 
            "description" => __("Select border color",'landmark-construction-theme'),
            'dependency' =>  array( 'element' => 'style', 'value' => array('bordered_btn'))
         ),
    array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __("Font weight",'landmark-construction-theme'),
            "param_name" => "font_weight",
            "value" => array ("Extra bold" => "800","Bold" => "700","Semi Bold" => "600","Normal" => "400","Light" => "300", ), 
            "description" => __("Choose the Button Font weight",'landmark-construction-theme')
         ), 
    array(
            'type' => 'checkbox',
            'heading' => __("Make it full width?",'landmark-construction-theme'),
            'param_name' => 'full_width_btn',
            'value' => array(  'Yes'  => 'full_width' ),
            'description' => __("Select if you want to make full width button",'landmark-construction-theme'),
    ), 
     array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Button Text", 'landmark-construction-theme'),
        "param_name" => "content",
        "value" => __("Button Text", 'landmark-construction-theme'),
        "description" => __("Text on buttons", 'landmark-construction-theme')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Button link", 'landmark-construction-theme'),
        "param_name" => "url",
        "value" => "",
        "description" => __("Link of your button.", 'landmark-construction-theme')
    ),
    array(
            'type' => 'checkbox',
            'heading' => __("Open in a new tab?",'landmark-construction-theme'),
            'param_name' => 'target',
            'value' => array(  'Yes'  => 'yes' ),
            'description' => __("Select if you the link to open in a new tab",'landmark-construction-theme'),
            'dependency' => array( 'element' => 'url', 'not_empty' => true),
    ),
    array(
            "type" => "textfield",
            "class" => "",
            "heading" => __("Margin",'landmark-construction-theme'),
            "param_name" => "margin_btn",
            "value" => "5px 5px 5px 5px",
            "description" => __("Margin for the button (e.g 10px 10px 10px 10px )",'landmark-construction-theme')
         ),
     array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __("Position",'landmark-construction-theme'),
            "param_name" => "position",
            "value" => array ("Left" => "pos_left", "Right" => "pos_right", "Center" => "pos_center"), 
            "description" => __("Choose the Button position",'landmark-construction-theme')
         ),


    )
    ) );
}
  
/***************************************/
/* BliccaThemes Social Button   landmark   */
/***************************************/

function landmark_construction_social_buttons($atts) {
   extract(shortcode_atts ( array(
    'style' => 'style_1',
    'title' => '', 
    'subtitle' => '', 
    'icon_style' => 'fontawesome',
    'icon_fontawesome' => 'fa fa-adjust',
    'icon_openiconic' => '',
    'icon_typicons' => '',
    'icon_entypoicons' => '',
    'icon_linecons' => '',
    'icon_entypo' => '',
    'color' => '',
    'hover_color' => '',
    'url' => '#',
    'target'     => '',
    'animation' => '',
    'delay' => '',
    'margin_btn'   => '', 
    'position' => '' 
    ), 
   $atts)); 
  
   $mydelay = '';
   if ( $delay != '') {
    $mydelay = ' style="animation-delay: '.$delay.'ms; -moz-animation-delay: '.$delay.'ms; -webkit-animation-delay: '.$delay.'ms;"';
   }

   vc_icon_element_fonts_enqueue( $icon_style );

   $iconClass = isset( ${"icon_" . $icon_style} ) ? esc_attr( ${"icon_" . $icon_style} ) : 'fa fa-adjust';     
     $add_icon = '<span class="'.$iconClass.'"></span>';

   $social_random = landmark_construction_theme_random_string(20);   
   if ( $target == "yes" ) {
    $target = "_blank";
   }
   else {
    $target = "_self";
   } 
   if( $style == 'style_1'){
    $output = '<div class="social-container"><style scoped>#social_'.$social_random.' a{margin:'.$margin_btn.';} #social_'.$social_random.' a .icon:hover{background:'.$hover_color.'!important;}</style> ';

    $output .= '<div id="social_'.$social_random.'" class="'.$animation.' social_1 '.$position.' animated"'.$mydelay.'>
    <a href="'.$url.'" target="'.$target.'">
       <div class="icon" style="background:'.$color.';">'.$add_icon.'</div><span class="title">'.$title.'</span><span class="subtitle">'.$subtitle.'</span></a></div></div>';
   }
   elseif( $style == 'style_2'){
    $output = '<div class="social-container"><style scoped>#social_'.$social_random.' {background:'.$color.'; margin:'.$margin_btn.';} #social_'.$social_random.':hover{background:'.$hover_color.';}</style> ';

    $output .= '<div id="social_'.$social_random.'" class="'.$animation.' social_2 '.$position.' animated"'.$mydelay.'>
    <a href="'.$url.'" target="'.$target.'">
       <div class="icon">'.$add_icon.'</div><div class="title">'.$title.'</div></a></div></div>';
   }

   elseif( $style == 'style_3'){
    $output = '<div class="social-container"><style scoped>#social_'.$social_random.' {background:'.$color.'; margin:'.$margin_btn.';} #social_'.$social_random.':hover{background:'.$hover_color.';}</style> ';

    $output .= '<div id="social_'.$social_random.'" class="'.$animation.' social_3 '.$position.' animated"'.$mydelay.'>
    <a href="'.$url.'" target="'.$target.'">
       <span class="icon">'.$add_icon.'</span></a></div></div>';
   }
   elseif( $style == 'style_4'){
    $output = '<div class="social-container"><style scoped>#social_'.$social_random.' {background:'.$color.'; margin:'.$margin_btn.';} #social_'.$social_random.':hover{background:'.$hover_color.';}</style> ';

    $output .= '<div id="social_'.$social_random.'" class="'.$animation.' social_4 '.$position.' animated"'.$mydelay.'>
    <a href="'.$url.'" target="'.$target.'">
       <span class="icon">'.$add_icon.'</span></a></div></div>';
   }

   return $output;



}
add_shortcode('sbuttons', 'landmark_construction_social_buttons');

add_action( 'init', 'landmark_construction_social_buttons_integrateWithVC' );
function landmark_construction_social_buttons_integrateWithVC() {
vc_map ( array(
   "name" => __("Add Social Button", 'landmark-construction-theme'),
   "base" => "sbuttons",
   "class" => "",
   "category" => 'Content',
   'admin_enqueue_css' => array(get_template_directory_uri().'/css/vc_extend_admin.css'),
   "icon" => "bliccaThemes-vc-icon", 
   "params" => array(   

   array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __("Social style",'landmark-construction-theme'),
            "param_name" => "style",
            "value" => array ("Style 1" => "style_1", "Style 2" => "style_2", "Style 3" => "style_3", "Style 4" => "style_4"), 
            "description" => __("Choose the social button style",'landmark-construction-theme')
         ),
   array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon", 'landmark-construction-theme'),
        "param_name" => "icon_style",
        "value" => array( 
                __( 'Font Awesome', "landmark-construction-theme" ) => 'fontawesome',
                __( 'Open Iconic', "landmark-construction-theme" ) => 'openiconic',
                __( 'Typicons', "landmark-construction-theme" ) => 'typicons',
                __( 'Entypo', "landmark-construction-theme" ) => 'entypo',
                __( 'Linecons', "landmark-construction-theme" ) => 'linecons'
        ),
        "description" => __("You can add image or icon to your services, if you use image please use square image and not bigger then 180x180 px", 'landmark-construction-theme')
    ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_fontawesome',
            'value' => 'fa fa-adjust', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
            ),
            'dependency' => Array( 'element' => 'icon_style', 'value' => 'fontawesome' ),

            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_openiconic',
            'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'openiconic',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'openiconic',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_typicons',
            'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'typicons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'typicons',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_entypo',
            'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'entypo',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'entypo',
            ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_linecons',
            'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'linecons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array( 'element' => 'icon_style','value' => 'linecons',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Title", 'landmark-construction-theme'),
        "param_name" => "title",
        "value" => '',
        "description" => __("Title", 'landmark-construction-theme'),
        'dependency' => array( 'element' => 'style', 'value' => array('style_1' , 'style_2')),
        
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Subtitle", 'landmark-construction-theme'),
        "param_name" => "subtitle",
        "value" => '',
        "description" => __("Write your subtitle", 'landmark-construction-theme'),
        'dependency' => array( 'element' => 'style', 'value' => array('style_1')),
    ), 
    array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Social color",'landmark-construction-theme'),
            "param_name" => "color",
            "value" => '',
            "description" => __("Select social button color",'landmark-construction-theme'),
         ), 
    array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Social hover color",'landmark-construction-theme'),
            "param_name" => "hover_color",
            "value" => '', 
            "description" => __("Select social button hover color",'landmark-construction-theme'),
         ), 
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Social button link", 'landmark-construction-theme'),
        "param_name" => "url",
        "value" => "#",
        "description" => __("Link of your social button.", 'landmark-construction-theme')
    ),
    array(
            'type' => 'checkbox',
            'heading' => __("Open in a new tab?",'landmark-construction-theme'),
            'param_name' => 'target',
            'value' => array(  'Yes'  => 'yes' ),
            'description' => __("Select if you the link to open in a new tab",'landmark-construction-theme'),
            'dependency' => array( 'element' => 'url', 'not_empty' => true),
    ),
    array(
            "type" => "textfield",
            "class" => "",
            "heading" => __("Margin",'landmark-construction-theme'),
            "param_name" => "margin_btn",
            "value" => "5px 5px 5px 5px",
            "description" => __("Margin for the social button (e.g 10px 10px 10px 10px )",'landmark-construction-theme')
         ),
    array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __("Position",'landmark-construction-theme'),
            "param_name" => "position",
            "value" => array ("Left" => "pos_left", "Right" => "pos_right", "Center" => "pos_center"), 
            "description" => __("Choose the social button position",'landmark-construction-theme')
         ),
     array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("CSS Animation", 'landmark-construction-theme'),
        "param_name" => "animation",
        "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind"),
        "description" => __("Choose your animation.", 'landmark-construction-theme')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("CSS Animation Delay", 'landmark-construction-theme'),
        "param_name" => "delay",
        "description"=> __("If you write 1000, it means your animation will work after 1 second", 'landmark-construction-theme')
    )
   )
) );
}


/**************************************/
/* Contact Widget for Custom Page landmark*/
/**************************************/
function landmark_construction_template_contacts($atts) {
   extract(shortcode_atts ( array(
    'telephone' => '',
    'email' => '',
    'address' => '',
    'social' => ''
    ), 
   $atts));

global $landmark_construction_theme_options;
$tel = $mail = $site = $zone = $adress = "";
$contact_social = '';

if ( isset($landmark_construction_theme_options['social_facebook']) && $landmark_construction_theme_options['social_facebook'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_facebook'].'"><div class="socialbox"><i class="fa fa-facebook"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_twitter']) && $landmark_construction_theme_options['social_twitter'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_twitter'].'"><div class="socialbox"><i class="fa fa-twitter"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_google']) && $landmark_construction_theme_options['social_google'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_google'].'"><div class="socialbox"><i class="fa fa-google-plus"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_dribbble']) && $landmark_construction_theme_options['social_dribbble'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_dribbble'].'"><div class="socialbox"><i class="fa fa-dribbble"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_youtube']) && $landmark_construction_theme_options['social_youtube'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_youtube'].'"><div class="socialbox"><i class="fa fa-youtube"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_vimeo']) && $landmark_construction_theme_options['social_vimeo'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_vimeo'].'"><div class="socialbox"><i class="fa fa-vine"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_linkedin']) && $landmark_construction_theme_options['social_linkedin'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_linkedin'].'"><div class="socialbox"><i class="fa fa-linkedin"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_digg']) && $landmark_construction_theme_options['social_digg'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_digg'].'"><div class="socialbox"><i class="fa fa-digg"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_skype']) && $landmark_construction_theme_options['social_skype'] != '') {
  $contact_social .= '<a href="skype:'.$landmark_construction_theme_options['social_skype'].'"><div class="socialbox"><i class="fa fa-skype"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_stumbleupon']) && $landmark_construction_theme_options['social_stumbleupon'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_stumbleupon'].'"><div class="socialbox"><i class="fa fa-stumbleupon"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_pinterest']) && $landmark_construction_theme_options['social_pinterest'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_pinterest'].'"><div class="socialbox"><i class="fa fa-pinterest"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_flickr']) && $landmark_construction_theme_options['social_flickr'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_flickr'].'"><div class="socialbox"><i class="fa fa-flickr"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_rss']) && $landmark_construction_theme_options['social_rss'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_rss'].'"><div class="socialbox"><i class="fa fa-rss"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_yahoo']) && $landmark_construction_theme_options['social_yahoo'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_yahoo'].'"><div class="socialbox"><i class="fa fa-yahoo"></i></div></a>';
}
if ( isset($landmark_construction_theme_options['social_foursquare']) && $landmark_construction_theme_options['social_foursquare'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_foursquare'].'"><div class="socialbox"><i class="fa fa-foursquare"></i></div></a>';
}

if ( isset($landmark_construction_theme_options['social_yelp']) && $landmark_construction_theme_options['social_yelp'] != '') {
  $contact_social .= '<a href="'.$landmark_construction_theme_options['social_yelp'].'"><div class="socialbox"><i class="fa fa-yelp"></i></div></a>';
}
   if( $social == 'yes') {
    $social = $contact_social;
   }

   else {
    $social = '';
   }

   if(!empty($telephone)){
   $tel ='<i class="fa fa-phone pull-left widget-icon"></i><p>'.$telephone.'</p>';
   }

   if(!empty($email)){
   $mail ='<i class="fa fa-envelope-o pull-left widget-icon"></i><p>'.$email.'</p>';
   }


   if(!empty($telephone)){
   $adress ='<i class="fa fa-map-marker pull-left widget-icon"></i><p>'.$address.'</p>';
   } 

   return '<div class="contact-info"><div class="contact-widget">'.$adress.$mail.$tel.'</div><div class="social-widget">'.$social.'</div></div>';
}
add_shortcode('landmark_construction_template_contact', 'landmark_construction_template_contacts');
add_action( 'init', 'landmark_construction_template_contact_integrateWithVC' );
function landmark_construction_template_contact_integrateWithVC() {
vc_map ( array(
   "name" => __("Contact Info", 'landmark-construction-theme'),
   "base" => "landmark_construction_template_contact",
   "class" => "",
   "icon" => "icon-wpb-vc_extend",
   "category" => 'Content',
   'admin_enqueue_css' => array(get_template_directory_uri().'/css/vc_extend.css'),
   "params" => array( 
        
        array(
        "type" => "textarea",
        "holder" => "div",
        "class" => "",
        "heading" => __("Your Address", 'landmark-construction-theme'),
        "param_name" => "address",
        "value" => __("", 'landmark-construction-theme')
        ),
     
        array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("E-Mail", 'landmark-construction-theme'),
        "param_name" => "email",
        "value" => __("", 'landmark-construction-theme')
        ),
     
        array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Phone", 'landmark-construction-theme'),
        "param_name" => "telephone",
        "value" => __("", 'landmark-construction-theme')
        ),
     
        array(
        "type" => 'checkbox',
        "heading" => __("Add your social", "landmark-construction-theme"),
        "param_name" => "social",
        "description" => __("Add your social to contact info.", "landmark-construction-theme"),
        "value" => Array(__("Yes, please", "landmark-construction-theme") => 'yes')
    )    
    )
));
}

/***********************/
/**** landmark Services ****/
/***********************/
function landmark_construction_services($atts, $content = null) {
   extract(shortcode_atts ( array(
    'style' => 'services-style-1',
    'icon_image' => '',
    'icon_color' => '',
    'icon_backcolor' => '',
    'icon_hover_color' => '',
    'icon_hover_back_color' => '',
    'icon_style' => 'fontawesome',     
    'icon_fontawesome' => 'fa fa-adjust',
    'icon_openiconic' => '',
    'icon_typicons' => '',
    'icon_entypoicons' => '',
    'icon_linecons' => '',
    'icon_entypo' => '',
    'icon_landmark' => '',
    'icon_image' => '',
    'header' => '',
    'title_color' => '',
    'animation' => 'no_animation',
    'extraclass' => '',
    'delay' => ''
    ), 
   $atts));
  $t_image = "";
  if ( $icon_image != "" ) {
    $t_image = '<div class="icon-image">';
    $img_id = preg_replace('/[^\d]/', '', $icon_image);
    $image = wp_get_attachment_image_src( $img_id, 'full');
    $alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);
      
    $t_image .= '<img src="'.esc_url($image[0]).'" width="'.esc_attr($image[1]).'" height="'.esc_attr($image[2]).'" alt="'.esc_attr($alt).'">';
    $t_image .= '</div>';
  }  
 $service_random = landmark_construction_theme_random_string(20);  
  vc_icon_element_fonts_enqueue( $icon_style );
    $iconClass = isset( ${"icon_" . $icon_style} ) ? esc_attr( ${"icon_" . $icon_style} ) : 'fa fa-adjust';

    $echo_icon = '<div class="vc_icon_element vc_icon_element-outer vc_icon_element-align-center">
<style scoped>#service_'.$service_random.' .vc_icon_element-icon{color:'.$icon_color.'!important; background-color:'.$icon_backcolor.'!important;} #service_'.$service_random.':before{border-top-color:'.$icon_backcolor.'!important;} .bliccaThemes-services:hover #service_'.$service_random.':before{border-top-color:'.$icon_hover_back_color.'!important;} .bliccaThemes-services:hover #service_'.$service_random.' .vc_icon_element-icon{background-color:'.$icon_hover_back_color.'!important; color:'.$icon_hover_color.'!important;}</style>
    <div id="service_'.$service_random.'" class="vc_icon_element-inner vc_icon_element-size-xs vc_icon_element-style-">
        <span class="vc_icon_element-icon '. $iconClass . '"></span>
    </div>
    </div>';

    $mydelay = '';
    if ( $delay != '') {
        $mydelay = ' style="animation-delay: '.$delay.'ms; -moz-animation-delay: '.$delay.'ms; -webkit-animation-delay: '.$delay.'ms;"';
    }
  
  
switch ($style) {
      case 'services-style-9':
            return '<div class="'.$animation.' bliccaThemes-services '.$extraclass.' '.$style.' wpb_content_element animated"'.$mydelay.'>
            <div class="services-content"><div class="services-title"><h4 style="color:'.$title_color.';">'.$header.'</h4></div>'.$echo_icon.'</div>
            <div class="services-text"><p>'.do_shortcode($content).'</p></div>          
            </div>';          
        break;
      case 'services-style-22':
            return '<div class="'.$animation.' bliccaThemes-services '.$extraclass.' '.$style.' wpb_content_element animated"'.$mydelay.'>
            <div class="services-content"><div class="services-title"><h4 style="color:'.$title_color.';">'.$header.'</h4></div>'.$echo_icon.'</div>
            <div class="services-text"><p>'.do_shortcode($content).'</p></div>     
            </div>';          
        break;
      case 'services-style-30':
            return '<div class="'.$animation.' bliccaThemes-services '.$extraclass.' '.$style.' wpb_content_element animated"'.$mydelay.'>
            '.$t_image.'<div class="services-content"><div class="services-title"><h4 style="color:'.$title_color.';">'.$header.'</h4></div>
            <div class="services-text"><p>'.do_shortcode($content).'</p></div>
            </div>
            </div>';         
        break;  
      default:
            return '<div class="'.$animation.' bliccaThemes-services '.$extraclass.' '.$style.' wpb_content_element animated"'.$mydelay.'>
            <div class="services-content">'.$echo_icon.'<div class="services-title"><h4 style="color:'.$title_color.';">'.$header.'</h4></div>
            <div class="services-text"><p>'.do_shortcode($content).'</p></div>
            </div>
            </div>';         
        break;
    }  



}
add_shortcode('landmark_construction_service', 'landmark_construction_services');

add_action( 'vc_before_init', 'landmark_construction_services_integrateWithVC' );
function landmark_construction_services_integrateWithVC() {
vc_map( array(
   "name" => __("Services", 'landmark-construction-theme'),
   "base" => "landmark_construction_service",
   "class" => "",
   "category" => 'Content',    
   'admin_enqueue_css' => array(get_template_directory_uri().'/css/visualcomposer.css'),   
   "icon" => "bliccaThemes-vc-icon", 
   "params" => array(    

    array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Services Style", 'landmark-construction-theme'),
        "param_name" => "style",
        "value" => array(            
            __('Icon on Left Style 1', "landmark-construction-theme") => "services-style-1"
          , __('Icon on Left Style 2', "landmark-construction-theme") => "services-style-2" 
            , __('Icon on Left Style 3', "landmark-construction-theme") => "services-style-3" 
            , __('Icon on Left Style 4', "landmark-construction-theme") => "services-style-4" 
          , __('Icon on Left Style 5', "landmark-construction-theme") => "services-style-5" 
          , __('Icon on Left Style 6', "landmark-construction-theme") => "services-style-6" 
          , __('Icon on Left Style 7', "landmark-construction-theme") => "services-style-7"
          , __('Icon on Left Style 8', "landmark-construction-theme") => "services-style-33"
          , __('Icon on Left Style 9', "landmark-construction-theme") => "services-style-36"         
          , __('Icon on Right Style 1', "landmark-construction-theme") => "services-style-41"
          , __('Icon on Right Style 2', "landmark-construction-theme") => "services-style-42" 
            , __('Icon on Right Style 3', "landmark-construction-theme") => "services-style-43" 
            , __('Icon on Right Style 4', "landmark-construction-theme") => "services-style-44" 
          , __('Icon on Right Style 5', "landmark-construction-theme") => "services-style-45" 
          , __('Icon on Right Style 6', "landmark-construction-theme") => "services-style-46" 
          , __('Icon on Right Style 7', "landmark-construction-theme") => "services-style-47"
          , __('Icon on Right Style 8', "landmark-construction-theme") => "services-style-48"
          , __('Icon on Right Style 9', "landmark-construction-theme") => "services-style-49"           
          , __('Icon on Top Style 1', "landmark-construction-theme") => "services-style-8" 
          , __('Icon on Top Style 2', "landmark-construction-theme") => "services-style-9"
          , __('Icon on Top Style 3', "landmark-construction-theme") => "services-style-10" 
          , __('Icon on Top Style 4', "landmark-construction-theme") => "services-style-11"
                    , __('Icon on Top Style 5', "landmark-construction-theme") => "services-style-12" 
          , __('Icon on Top Style 6', "landmark-construction-theme") => "services-style-13"
          , __('Icon on Top Style 7', "landmark-construction-theme") => "services-style-14" 
          , __('Icon on Top Style 8', "landmark-construction-theme") => "services-style-15"
          , __('Icon on Top Style 9', "landmark-construction-theme") => "services-style-16" 
          , __('Icon on Top Style 10', "landmark-construction-theme") => "services-style-17"
          , __('Icon on Top Style 11', "landmark-construction-theme") => "services-style-18"  
          , __('Icon on Top Style 12', "landmark-construction-theme") => "services-style-19"
          , __('Icon on Top Style 13', "landmark-construction-theme") => "services-style-20"
          , __('Icon on Top Style 14', "landmark-construction-theme") => "services-style-21"
          , __('Icon on Top Style 15', "landmark-construction-theme") => "services-style-22"
          , __('Icon on Top Style 16', "landmark-construction-theme") => "services-style-23" 
          , __('Icon on Top Style 17', "landmark-construction-theme") => "services-style-24"
          , __('Icon on Top Style 18', "landmark-construction-theme") => "services-style-25"
          , __('Icon on Top Style 19', "landmark-construction-theme") => "services-style-26"
          , __('Icon on Top Style 20', "landmark-construction-theme") => "services-style-27"
          , __('Icon on Top Style 21', "landmark-construction-theme") => "services-style-28"
          , __('Icon on Top Style 22', "landmark-construction-theme") => "services-style-29" 
          , __('Icon on Top Style 23', "landmark-construction-theme") => "services-style-30"
          , __('Icon on Top Style 24', "landmark-construction-theme") => "services-style-31" 
          , __('Icon on Top Style 25', "landmark-construction-theme") => "services-style-32"  
          , __('Icon on Top Style 26', "landmark-construction-theme") => "services-style-34" 
          , __('Icon on Top Style 27', "landmark-construction-theme") => "services-style-35" 
          , __('Icon on Top Style 28', "landmark-construction-theme") => "services-style-37"
          , __('Icon on Top Style 29', "landmark-construction-theme") => "services-style-38" 
          , __('Icon on Top Style 30', "landmark-construction-theme") => "services-style-39"
          , __('Icon on Top Style 31', "landmark-construction-theme") => "services-style-40"                          
            ),

        "description" => __("Choose your service icon style", 'landmark-construction-theme')
    ),
   array(
        "type" => "attach_image",
        "heading" => __('Icon Image', 'landmark-construction-theme'),
        "param_name" => "icon_image",
        "description" => __("Select image for your box", "landmark-construction-theme"),
                'dependency' => Array( 'element' => 'style', 'value' => 'services-style-30' ),
                "description" => __("You have choosen services style 30, please upload an image, your icon choice is not working in this style", 'landmark-construction-theme')     
      ),     
   array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon", 'landmark-construction-theme'),
        "param_name" => "icon_style",
        "value" => array(
                __( 'Font Awesome', "landmark-construction-theme" ) => 'fontawesome',
                __( 'Open Iconic', "landmark-construction-theme" ) => 'openiconic',
                __( 'Typicons', "landmark-construction-theme" ) => 'typicons',
                __( 'Entypo', "landmark-construction-theme" ) => 'entypo',
                __( 'Linecons', "landmark-construction-theme" ) => 'linecons',
                __( 'Landmark', "landmark-consturction-theme" ) => 'landmark'
        ),
        "description" => __("You can add image or icon to your services", 'landmark-construction-theme')
    ),
        array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_landmark',
        'value' => 'landicon-empty', // default value to backend editor admin_label
        'settings' => array(
          'emptyIcon' => false, // default true, display an "EMPTY" icon?
          'type' => 'landmark',
          'iconsPerPage' => 7, // default 100, how many icons per/page to display
        ),
        'dependency' => Array( 'element' => 'icon_style','value' => 'landmark'),
        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
      ),
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_fontawesome',
        'value' => 'fa fa-adjust', // default value to backend editor admin_label
        'settings' => array(
        'emptyIcon' => false, // default true, display an "EMPTY" icon?
        'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
        ),
        'dependency' => Array( 'element' => 'icon_style', 'value' => 'fontawesome' ),

        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
    ),
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_openiconic',
        'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
        'settings' => array(
        'emptyIcon' => false, // default true, display an "EMPTY" icon?
        'type' => 'openiconic',
        'iconsPerPage' => 4000, // default 100, how many icons per/page to display
        ),
        'dependency' => Array(
        'element' => 'icon_style',
        'value' => 'openiconic',
        ),
        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
    ),
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_typicons',
        'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
        'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'typicons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
        'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'typicons',
            ),
        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
    ),
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_entypo',
        'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
        'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'entypo',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
        'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'entypo',
            ),
    ),
    array(
        'type' => 'iconpicker',
        'heading' => __( 'Icon', "landmark-construction-theme" ),
        'param_name' => 'icon_linecons',
        'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
        'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'linecons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
        'dependency' => Array( 'element' => 'icon_style','value' => 'linecons',
            ),
        'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
    ),
         array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Icon Color",'landmark-construction-theme'),
            "param_name" => "icon_color",
            "value" => '',
            "description" => __("Select icon color",'landmark-construction-theme'),
         ),
     array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Icon Hover Color",'landmark-construction-theme'),
            "param_name" => "icon_hover_color",
            "value" => '',
            "description" => __("Select icon hover color",'landmark-construction-theme'),
         ),
     array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Icon Background Color",'landmark-construction-theme'),
            "param_name" => "icon_backcolor",
            "value" => '',
            "description" => __("Works if your chosen style has background.",'landmark-construction-theme'),
         ),
     array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Icon Hover Background Color",'landmark-construction-theme'),
            "param_name" => "icon_hover_back_color",
            "value" => '',
            "description" => __("Works if your chosen style has background.",'landmark-construction-theme'),
         ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Title", 'landmark-construction-theme'),
        "param_name" => "header",
        "value" => __("Title", 'landmark-construction-theme'),
        "description" => __("Title for the service", 'landmark-construction-theme')
    ),
     array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __("Title Color",'landmark-construction-theme'),
            "param_name" => "title_color",
            "value" => '',
            "description" => __("Select your title color.",'landmark-construction-theme'),
         ),

    array(
        "type" => "textarea_html",
        "holder" => "div",
        "class" => "",
        "heading" => __("Box Content", 'landmark-construction-theme'),
        "param_name" => "content",
        "value" => __("This is your Content", 'landmark-construction-theme'),
        "description" => __("Content of the service", 'landmark-construction-theme')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("Extra Class Name", 'landmark-construction-theme'),
        "param_name" => "extraclass",
        "value" => __("", 'landmark-construction-theme'),
        "description" => __("Style particular content element differently - add a class name and refer to it in custom CSS.", 'landmark-construction-theme')
    ),     
    array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("CSS Animation", 'landmark-construction-theme'),
        "param_name" => "animation",
        "value" => array(__('No Animation', "landmark-construction-theme") => "no_animation", __('Tada', "landmark-construction-theme") => "tadab-1 blind", __('Flip In X', "landmark-construction-theme") => "flipInX-1 blind", __('Flip In Y', "landmark-construction-theme") => "flipInY-1 blind", __('Fade In', "landmark-construction-theme") => "fadeIn-1 blind", __('Fade In Up', "landmark-construction-theme") => "fadeInUp-1 blind", __('Fade In Down', "landmark-construction-theme") => "fadeInDown-1 blind", __('Fade In Left', "landmark-construction-theme") => "fadeInLeft-1 blind", __('Fade In Right', "landmark-construction-theme") => "fadeInRight-1 blind", __('Fade In Up Big', "landmark-construction-theme") => "fadeInUpBig-1 blind", __('Fade In Down Big', "landmark-construction-theme") => "fadeInDownBig-1 blind", __('Fade In Left Big', "landmark-construction-theme") => "fadeInLeftBig-1 blind", __('Fade In Right Big', "landmark-construction-theme") => "fadeInRightBig-1 blind", __('Bounce In', "landmark-construction-theme") => "bounceIn-1 blind", __('Bounce In Down', "landmark-construction-theme") => "bounceInDown-1 blind",  __('Bounce In Left', "landmark-construction-theme") => "bounceInLeft-1 blind", __('Bounce In Right', "landmark-construction-theme") => "bounceInRight-1 blind", __('Rotate In', "landmark-construction-theme") => "rotateIn-1 blind", __('Rotate In Down Left', "landmark-construction-theme") => "rotateInDownLeft-1 blind", __('Rotate In Down Right', "landmark-construction-theme") => "rotateInDownRight-1 blind", __('Rotate In Up Left', "landmark-construction-theme") => "rotateInUpLeft-1 blind", __('Rotate In Up Right', "landmark-construction-theme") => "rotateInUpRight-1 blind", __('Light Speed In', "landmark-construction-theme") => "lightSpeedIn-1 blind", __('Roll In', "landmark-construction-theme") => "rollIn-1 blind", __('Special Effect 1', "landmark-construction-theme") => "blogeffect4-1 blind", __('Special Effect 2', "landmark-construction-theme") => "blogeffect5-1 blind", __('Special Effect 3', "landmark-construction-theme") => "blogeffect6-1 blind"),
        "description" => __("Choose your animation.", 'landmark-construction-theme')
    ),
    array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => __("CSS Animation Delay", 'landmark-construction-theme'),
        "param_name" => "delay",
        "description"=> __("If you write 1000, it means your animation will work after 1 second", 'landmark-construction-theme')
    )
   )
) );
}
  
/************************************/
/* Blicca Themes Masonry Image Gal  */
/************************************/
function landmark_construction_image_masonry_gals($atts) {
   extract(shortcode_atts ( array(
      'images' => '',
      'colorpicker' => ''
    ), 
   $atts));
    wp_enqueue_script( 'isotope' );
    $item_check = 1;
    $output = '<div id="bt_image_masonry_gal"><div class="bt_image_masonry-sizer"></div><div class="bt_image_masonry-gutter"></div>';
  if ( '' === $images ) {
    $images = '-1,-2,-3';
  }

  $images = explode( ',', $images );
  $i = - 1;

   foreach ( $images as $attach_id ):
    $thumb_check = "masonry2";
    if ( $item_check == 1 ) { $thumb_check = "masonry1"; }
    if ( $item_check == 4 ) { $thumb_check = "masonry3"; }
    $item_check = $item_check + 1;    
    $i ++;
    if ( $attach_id > 0 ) {
      $post_thumbnail = wpb_getImageBySize( array(
        'attach_id' => $attach_id,
        'thumb_size' => $thumb_check
    ) );
    } else {
      $post_thumbnail = array();
      $post_thumbnail['thumbnail'] = '<img src="' . vc_asset_url( 'vc/no_image.png' ) . '" />';
      $post_thumbnail['p_img_large'][0] = vc_asset_url( 'vc/no_image.png' );
    }
    $thumbnail = $post_thumbnail['thumbnail'];
    $p_img_large = $post_thumbnail['p_img_large'];
        $output .= '<div class="bt_image_masonry-item bt-gal-'.$thumb_check.'">';
        $output .= $thumbnail;
        $output .= '<div class="bt_image_masonry-hover"><a href="'.$p_img_large[0].'" class="prettyPhoto" data-rel="prettyPhoto"><i class="fa fa-search"></i></a></div>';
        $output .= '</div>';

  endforeach;

   $output .= '</div>';
   return $output;

}
add_shortcode('landmark_construction_image_masonry_gal', 'landmark_construction_image_masonry_gals');

add_action( 'init', 'landmark_construction_image_masonry_gal_integrateWithVC' );
function landmark_construction_image_masonry_gal_integrateWithVC() {
vc_map ( 
  array(
   "name" => __("BT Images Gallery", 'landmark-construction-theme'),
   "base" => "landmark_construction_image_masonry_gal",
   "class" => "",
   "category" => 'Content',   
   "params" => array(    

    array(
      'type' => 'attach_images',
      'heading' => __( 'Images', "landmark-construction-theme" ),
      'param_name' => 'images',
      'value' => '',
      'description' => __( 'Select images from media library.', "landmark-construction-theme" )
    ),
      array(
        "type" => "colorpicker",
        "heading" => __("Hover Color", "landmark-construction-theme"),
        "param_name" => "hover_color",
        "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme")        
      )   
)
));
 
}
    
// -----------------------------
// Visual Composer Edit Widgets
// -----------------------------

//  
// Visual Composer Progress Bar
//
add_action( 'vc_after_init', 'landmark_construction_visual_add_param' );
function landmark_construction_visual_add_param() {
  $progress_attributes = array(
      array(
          'type' => 'dropdown',
          'heading' => "Style",
          'param_name' => 'bt_style',
            "value" => array(
              __('Style 1', "landmark-construction-theme") => "bt_progress_1", 
              __('Style 2', "landmark-construction-theme") => "bt_progress_2", 
              __('Style 3', "landmark-construction-theme") => "bt_progress_3", 
              __('Style 4', "landmark-construction-theme") => "bt_progress_4", 
              __('Style 5', "landmark-construction-theme") => "bt_progress_5",
              __('Style 6', "landmark-construction-theme") => "bt_progress_6", 
              __('Style 7', "landmark-construction-theme") => "bt_progress_7"
              ),
          'description' => __( "Progress Bar Style", "landmark-construction-theme" )
      )
  );
  vc_add_params( 'vc_progress_bar', $progress_attributes );
  
  $pie_chart_attributes = array(
      array(
          'type' => 'dropdown',
          'heading' => "Style",
          'param_name' => 'bt_style',
            "value" => array(
              __('Style 1', "landmark-construction-theme") => "bt_pie_chart_1", 
              __('Style 2', "landmark-construction-theme") => "bt_pie_chart_2", 
              __('Style 3', "landmark-construction-theme") => "bt_pie_chart_3", 
              ),
          'description' => __( "Progress Bar Style", "landmark-construction-theme" )
      ),
         array(
        "type" => "dropdown",
        "holder" => "div",
        "class" => "",
        "heading" => __("Icon Fonticon", 'landmark-construction-theme'),
        "param_name" => "icon_style",
        "value" => array(
                __( 'Choose Library', 'landmark-construction-theme') => 'choose',
                __( 'Font Awesome', "landmark-construction-theme" ) => 'fontawesome',
                __( 'Open Iconic', "landmark-construction-theme" ) => 'openiconic',
                __( 'Typicons', "landmark-construction-theme" ) => 'typicons',
                __( 'Entypo', "landmark-construction-theme" ) => 'entypo',
                __( 'Linecons', "landmark-construction-theme" ) => 'linecons'
        ),
        "description" => __("Add icon to your heading", 'landmark-construction-theme'),
        'dependency' => Array( 'element' => 'bt_style', 'value' => 'bt_pie_chart_2' ),   
    ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_fontawesome',
            'value' => 'fa fa-adjust', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
            ),
            'dependency' => Array( 'element' => 'icon_style', 'value' => 'fontawesome' ),

            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_openiconic',
            'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'openiconic',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'openiconic',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_typicons',
            'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'typicons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'typicons',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_entypo',
            'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'entypo',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array(
                'element' => 'icon_style',
                'value' => 'entypo',
            ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => __( 'Icon', "landmark-construction-theme" ),
            'param_name' => 'icon_linecons',
            'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'linecons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => Array( 'element' => 'icon_style','value' => 'linecons',
            ),
            'description' => __( 'Select icon from library.', "landmark-construction-theme" ),
        )
  );
  vc_add_params( 'vc_pie', $pie_chart_attributes );
  
$tabsstyle = array(
    'type' => 'dropdown',
    'heading' =>  __('Tabs Style', 'landmark-construction-theme'),
    'param_name' => 'tabs_style',
    'value' => array( "no-style", "tabs-style-1", "tabs-style-2", "tabs-style-3", "tabs-style-4", "tabs-style-5", "tabs-style-6", "tabs-style-7", "tabs-style-8", "tabs-style-9", "tabs-style-10", "tabs-style-11", "tabs-style-12" ),
    'description' => __( "This is an extra tabs style from bliccaThemes, if you want to use it, dont customise your tabs, choose a default value for all options.", "landmark-construction-theme" )  
);
vc_add_param( 'vc_tta_tabs', $tabsstyle ); 

$tourstyle = array(
    'type' => 'dropdown',
    'heading' =>  __('Tour Style', 'landmark-construction-theme'),
    'param_name' => 'tour_style',
    'value' => array( "no-style", "tour-style-1", "tour-style-2", "tour-style-3", "tour-style-4", "tour-style-5", "tour-style-6", "tour-style-7" ),
    'description' => __( "This is an extra tour style from bliccaThemes, if you want to use it, dont customise your tabs, choose a default value for all options.", "landmark-construction-theme" )  
);
vc_add_param( 'vc_tta_tour', $tourstyle );
  


// init   
}
function vc_gitem_template_attribute_bt_demo_url( $value, $data ) {
  /**
   * @var null|Wp_Post $post ;
   */
  extract( array_merge( array(
    'post' => null,
    'extra_class' => ''
  ), $data ) );
  ob_start();
  $templateclass = "bt-demo-page-url";
  if (!empty($extra_class) ) {
  $templateclass="bt-demo-page-url '.$extra_class.'";
  }
  ?>
  <div class="<?php echo esc_attr($templateclass); ?>">
  <a href="<?php echo get_post_meta($post->ID, '_landmark_construction_page_demo_url', true); ?>" target="_blank"><i class="fa fa-share"></i></a>
  </div>
  <?php
  $content = ob_get_contents();
  ob_end_clean();
  return $content;
}

add_filter( 'vc_gitem_template_attribute_bt_demo_url', 'vc_gitem_template_attribute_bt_demo_url', 1, 2 );


add_filter( 'vc_grid_item_shortcodes', 'landmark_construction_add_bt_demo_url', 1, 2 );
function landmark_construction_add_bt_demo_url( $shortcodes ) {

   $shortcodes['bt_demo_url'] = array(
        'name' => __( 'Demo Page URL', 'landmark-construction-theme' ),
        'base' => 'bt_demo_url',
        'category' => __( 'Post', 'landmark-construction-theme' ),
        'description' => __( 'Add URL ', 'landmark-construction-theme' ),
        'params' => array(
            array(
              "type" => "textfield",
              "heading" => __("Extra Class", "landmark-construction-theme"),
              "param_name" => "extra_class",
              "description" => __("You can add a class to customise area", "landmark-construction-theme")               
            )          
        ),
        'post_type' => Vc_Grid_Item_Editor::postType(),

    );
    return $shortcodes;
}

add_shortcode( 'bt_demo_url', 'bt_demo_url_shortcode' );
function bt_demo_url_shortcode( $atts ) {
   return '{{ bt_demo_url:' . http_build_query( (array) $atts ) . ' }}';
}  
//
// Zilla Likes to Grid Builder
function vc_gitem_template_attribute_landmark_construction_zilla_likes( $value, $data ) {
  /**
   * @var null|Wp_Post $post ;
   */
  extract( array_merge( array(
    'post' => null,
    'extra_class' => ''
  ), $data ) );
  ob_start();
  $templateclass = "bt-portfolio-zilla";
  if (!empty($extra_class) ) {
  $templateclass="bt-portfolio-zilla '.$extra_class.'";
  }
  ?>
  <div class="<?php echo esc_attr($templateclass); ?>">
  <?php
  if( function_exists('zilla_likes') ) { 
    zilla_likes();  
  }
  ?>
  </div>
  <?php
  $content = ob_get_contents();
  ob_end_clean();
  return $content;
}

add_filter( 'vc_gitem_template_attribute_landmark_construction_zilla_likes', 'vc_gitem_template_attribute_landmark_construction_zilla_likes', 1, 2 );


add_filter( 'vc_grid_item_shortcodes', 'landmark_construction_add_landmark_construction_zilla_likes', 1, 2 );
function landmark_construction_add_landmark_construction_zilla_likes( $shortcodes ) {

   $shortcodes['landmark_construction_zilla_likes'] = array(
        'name' => __( 'Zilla Likes', 'landmark-construction-theme' ),
        'base' => 'landmark_construction_zilla_likes',
        'category' => __( 'Post', 'landmark-construction-theme' ),
        'description' => __( 'Add like icon to your grid', 'landmark-construction-theme' ),
        'params' => array(
            array(
              "type" => "textfield",
              "heading" => __("Extra Class", "landmark-construction-theme"),
              "param_name" => "extra_class",
              "description" => __("You can add a class to customise area", "landmark-construction-theme")               
            )          
        ),
        'post_type' => Vc_Grid_Item_Editor::postType(),

    );
    return $shortcodes;
}

add_shortcode( 'landmark_construction_zilla_likes', 'landmark_construction_zilla_likes_shortcode' );
function landmark_construction_zilla_likes_shortcode( $atts ) {
   return '{{ landmark_construction_zilla_likes:' . http_build_query( (array) $atts ) . ' }}';
}
//
// Portfolio Category to Grid Builder
function vc_gitem_template_attribute_portfolio_category( $value, $data ) {
  /**
   * @var null|Wp_Post $post ;
   */
  extract( array_merge( array(
    'post' => null,
    'meta_color' => '#ffffff'
  ), $data ) );

  $allcats = '<p>';
  $categories = wp_get_object_terms( $post->ID, 'portfolio-category');
    foreach($categories as $category){
        $allcats .= '<span class="portfolio-cat" style="color:'.esc_attr($meta_color).' ">'.esc_attr($category->name).'</span>'; 
    }
    $allcats .= '</p>';
  return $allcats;
}

add_filter( 'vc_gitem_template_attribute_portfolio_category', 'vc_gitem_template_attribute_portfolio_category', 1, 2 );


add_filter( 'vc_grid_item_shortcodes', 'landmark_construction_add_portfolio_category', 1, 2 );
function landmark_construction_add_portfolio_category( $shortcodes ) {

   $shortcodes['landmark_construction_portfolio_category'] = array(
        'name' => __( 'Portfolio Category', 'landmark-construction-theme' ),
        'base' => 'landmark_construction_portfolio_category',
        'category' => __( 'Post', 'landmark-construction-theme' ),
        'description' => __( 'Portfolio Category', 'landmark-construction-theme' ),
        'params' => array(
            array(
              "type" => "colorpicker",
              "heading" => __("Tags/Category Color", "landmark-construction-theme"),
              "param_name" => "meta_color",
              "description" => __("Leave it blank if you want to use default color", "landmark-construction-theme"),
              'group' => __( 'Color Style', 'landmark-construction-theme' )   
            )          
        ),
        'post_type' => Vc_Grid_Item_Editor::postType(),

    );
    return $shortcodes;
}

add_shortcode( 'landmark_construction_portfolio_category', 'landmark_construction_portfolio_category_shortcode' );
function landmark_construction_portfolio_category_shortcode( $atts ) {
   return '{{ portfolio_category:' . http_build_query( (array) $atts ) . ' }}';
}  


// Visual Composer End 
}
add_filter( 'vc_iconpicker-type-landmark', 'vc_iconpicker_type_landmark' );

/**
 * 
 *
 * @param $icons - taken from filter - vc_map param field settings['source'] provided icons (default empty array).
 * If array categorized it will auto-enable category dropdown
 *
 * @since 4.4
 * @return array - of icons for iconpicker, can be categorized, or not.
 */
function vc_iconpicker_type_landmark( $icons ){
  $landmark = array(
    array( 'landicon-empty' => 'Empty' ),
    array( 'landicon-building' => 'Build' ),
    array( 'landicon-home' => 'Home' ),
    array( 'landicon-palette' => 'Palette' ),
    array( 'landicon-machine' => 'Machine' ),
    array( 'landicon-wall' => 'Wall' ),
    array( 'landicon-worker' => 'Work' ),       
  );

  return array_merge( $icons, $landmark );
}
  
add_action( 'vc_base_register_front_css', 'landmark_construction_iconfont_register' );
add_action( 'vc_base_register_admin_css', 'landmark_construction_iconfont_register' );
add_action( 'vc_backend_editor_enqueue_js_css', 'landmark_construction_iconfont_enque' );
add_action( 'vc_frontend_editor_enqueue_js_css', 'landmark_construction_iconfont_enque' );  
function landmark_construction_iconfont_register() {
    wp_register_style('landmark', get_template_directory_uri(). '/css/landmark.css');
}
function landmark_construction_iconfont_enque() {
    wp_enqueue_style( 'landmark' );  
}
/* remove empty p from our shortcode */
add_filter("the_content", "landmark_construction_the_content_filter");
function landmark_construction_the_content_filter($content) {
  // array of custom shortcodes requiring the fix 
  $block = join("|",array("landmark_construction_Image_Box"));
  // opening tag
  $rep = preg_replace("/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/","[$2$3]",$content);
    
  // closing tag
  $rep = preg_replace("/(<p>)?\[\/($block)](<\/p>|<br \/>)?/","[/$2]",$rep);
  return $rep;
}
// -------------------
// WordPress Editor Button
// -------------------
/********************************/
/*      Highlight Shortcode      */
/********************************/

function landmark_construction_highlight_shortcode($atts) {
   extract(shortcode_atts ( array(
       'highlight_content' => '',
       'highlight_style' => ''
    ), 
   $atts));
 
  return '<span class="'.$highlight_style.'">'.$highlight_content.'</span>';
}
add_shortcode('landmark_construction_highlight', 'landmark_construction_highlight_shortcode');
/********************************/
/*      Drop Cap Shortcode      */
/********************************/
function landmark_construction_dropcap_shortcode($atts) {
   extract(shortcode_atts ( array(
       'drop_text' => '',
       'drop_style' => ''
    ), 
   $atts));
 
  return '<span class="dropcap '.$drop_style.'">'.$drop_text.'</span>';
}
add_shortcode('landmark_construction_dropcap', 'landmark_construction_dropcap_shortcode');

/********************************/
/*      Tooltips Shortcode      */
/********************************/
function landmark_construction_tooltip($atts) {
   extract(shortcode_atts ( array(
       'tooltip_text' => '',
       'tooltip_hover' => '',
       'tooltip_style' => ''
    ), 
   $atts));
 
  return '<span class="bt_tooltip '.$tooltip_style.'">'.$tooltip_text.'<span class="bt_tooltip_hover">'.$tooltip_hover.'</span></span>';
}
add_shortcode('landmark_construction_tooltip', 'landmark_construction_tooltip');
/*****************************/
/* ADD BUTTON TO WP EDITOR  */
/***************************/
add_action( 'init', 'landmark_construction_tiny' );
function landmark_construction_tiny() {
    add_filter( "mce_external_plugins", "landmark_construction_add_buttons" );
    add_filter( 'mce_buttons', 'landmark_construction_register_buttons' );
}
function landmark_construction_add_buttons( $plugin_array ) {
    $plugin_array['landmark_construction_tiny'] = get_template_directory_uri() . '/js/wpeditor.js';
    return $plugin_array;
}
function landmark_construction_register_buttons( $buttons ) {
    array_push( $buttons, 'landmark_construction_highlight', 'landmark_construction_dropcap', 'landmark_construction_tooltip' ); 
    return $buttons;
}