<?php
/**
 * Theme functions and definitions
 *
 * @package mik_azure
 */ 


if ( ! function_exists( 'mik_azure_enqueue_styles' ) ) :
	/**
	 * Load assets.
	 *
	 * @since 1.0.0
	 */
	function mik_azure_enqueue_styles() {
		wp_enqueue_style( 'mik-style-parent', get_template_directory_uri() . '/style.css' );
		wp_enqueue_style( 'mik-azure-style', get_stylesheet_directory_uri() . '/style.css', array( 'mik-style-parent' ), '1.0.0' );
	}
endif;
add_action( 'wp_enqueue_scripts', 'mik_azure_enqueue_styles', 99 );

function mik_azure_remove_action() {
    remove_filter( 'mik_filter_slider_section_details', 'mik_get_slider_section_details' );
}
add_action( 'init', 'mik_azure_remove_action');

if ( ! function_exists( 'mik_azure_theme_defaults' ) ) :
    /**
     * Customize theme defaults.
     *
     * @since 1.0.0
     *
     * @param array $defaults Theme defaults.
     * @param array Custom theme defaults.
     */
    function mik_azure_theme_defaults( $defaults ) {
        $defaults['enable_slider'] = false;
        $defaults['blog_column_type'] = 'column-3';

        return $defaults;
    }
endif;
add_filter( 'mik_default_theme_options', 'mik_azure_theme_defaults', 99 );

if ( ! function_exists( 'mik_azure_get_slider_section_details' ) ) :
    /**
    * slider section details.
    *
    * @since Mik 1.0.0
    * @param array $input slider section details.
    */
    function mik_azure_get_slider_section_details( $input ) {

        $content = array();
        $post_ids = array();

        for ( $i = 1; $i <= 5; $i++ )  :
            $post_ids[] = mik_theme_option( 'slider_content_post_' . $i );
        endfor;
        
        $args = array(
            'post_type'         => 'post',
            'post__in'          =>  ( array ) $post_ids,
            'posts_per_page'    => 5,
            'orderby'           => 'post__in',
            'ignore_sticky_posts' => true,
            );                    

        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : '';
                $page_post['small_image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : '';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();
            
        if ( ! empty( $content ) )
            $input = $content;
       
        return $input;
    }
endif;
// slider section content details.
add_filter( 'mik_filter_slider_section_details', 'mik_azure_get_slider_section_details' );

function mik_render_slider_section( $content_details = array() ) {
    if ( empty( $content_details ) )
        return;

    $slider_control = mik_theme_option( 'slider_arrow' );
    $auto_slide = mik_theme_option('slider_auto_slide', false );
    $readmore = mik_theme_option( 'slider_btn_label', '' );
    ?>
	<div id="custom-header" class="homepage-section">
        <div class="section-content banner-slider column-1 has-post-nav left-align" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": true, "speed": 1200, "dots": false, "arrows":<?php echo $slider_control ? 'true' : 'false'; ?>, "autoplay": <?php echo $auto_slide ? 'true' : 'false'; ?>, "fade": false, "draggable": true }'>
            <?php foreach ( $content_details as $content ) : ?>
                <div class="custom-header-content-wrapper slide-item">
                    <div class="overlay"></div>
                    <?php if ( ! empty( $content['image'] ) ) : ?>
                        <img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>">
                    <?php endif; ?>

                    <div class="wrapper">
                        <div class="custom-header-content">
                            <span class="cat-links">
                                <?php the_category( ', ', '', $content['id'] ); ?>
                            </span>

                            <?php if ( ! empty( $content['title'] ) ) : ?>
                                <h2><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                            <?php endif; 

                            if ( ! empty( $content['url'] ) && ! empty( $readmore ) ) : ?>
                                <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn btn-transparent"><?php echo esc_html( $readmore ); ?></a>
                            <?php endif; ?>
                        </div><!-- .custom-header-content -->
                    </div><!-- .wrapper -->
                </div><!-- .custom-header-content-wrapper -->
            <?php endforeach; ?>
        </div><!-- .banner-slider -->

        <div id="banner-slider-nav" class="right-align">
            <div class="wrapper">
                <div class="banner-slider-pagination" data-slick='{"slidesToShow": 3, "vertical": true, "slidesToScroll": 1, "infinite": true, "speed": 1200, "dots": false, "arrows": false, "autoplay": <?php echo $auto_slide ? 'true' : 'false'; ?>, "fade": false, "draggable": true }'>
                    <?php foreach ( $content_details as $content ) : ?>
                        <div class="slide-item">
                            <div class="banner-slider-pagination-wrapper">
                                <?php if ( ! empty( $content['small_image'] ) ) : ?>
                                    <div class="featured-image">
                                        <img src="<?php echo esc_url( $content['small_image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>">
                                    </div>
                                <?php endif; ?>

                                <div class="banner-slider-pagination-content">
                                    <?php if ( ! empty( $content['title'] ) ) : ?>
                                        <h5><?php echo esc_html( $content['title'] ); ?></h5>
                                    <?php endif; ?>
                                </div><!-- .custom-header-content -->
                            </div><!-- .custom-header-content-wrapper -->
                        </div><!-- .slide-item -->
                    <?php endforeach; ?>
                </div><!-- .banner-slider-pagination -->
            </div><!-- .wrapper -->
        </div><!-- #banner-slider-nav -->
    </div><!-- #custom-header -->
<?php 
}
