<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en"
	  xmlns:v="urn:schemas-microsoft-com:vml"
	  xmlns:o="urn:schemas-microsoft-com:office:office">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<!--[if !mso]><!-->
	<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
	<!--<![endif]-->
	<meta name="viewport" content="width=device-width, initial-scale=1.0"/>
	<meta name="color-scheme" content="light dark"/>
	<meta name="supported-color-schemes" content="light dark"/>
	<meta name="description" content="Optimization Status for $sitename.com"/>
	<title>Optimization Status for $sitename.com</title>
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&family=Roboto:wght@400;700&display=swap" rel="stylesheet">
	<style>
		:root {color-scheme: light dark; supported-color-schemes: light dark;}
		body {margin: 0; padding: 0; width: 100% !important; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100%;}
		img {max-width: 100%; outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; display: block !important; border: none;}
		#backgroundTable {margin: 0; width: 100% !important; line-height: 100%;}
		@media screen and (max-width: 480px), screen and (max-device-width: 480px) {
			.flex, [class=flex] {width: 100% !important;}
			.dblock, [class=dblock] {display: block !important; width: 100% !important; max-width: 100%; padding: 0 !important; max-height: none !important;}
			a {word-break: break-word;}
		}
		@media (prefers-color-scheme: dark) {
			.dark-img {display: block !important; width: auto !important; overflow: visible !important; float: none !important; max-height: inherit !important; max-width: inherit !important; line-height: auto !important; margin-top: 0 !important; visibility: inherit !important;}
			.light-img {display: none !important;}
			#backgroundTable, body {background: #363636 !important;;}
			.body-text, h1, h2, p, strong, em, b {color: #f2f2f2 !important;}
			.infobox {background: #666 !important;}
			.datatable td, .datatable th {background: #363636 !important;}
			a, a strong {color: #b2b2f8 !important;}
			[data-ogsc] .dark-img {display: block !important; width: auto !important; overflow: visible !important; float: none !important; max-height: inherit !important; max-width: inherit !important; line-height: auto !important; margin-top: 0px !important; visibility: inherit !important;}
			[data-ogsc] .light-img {display: none !important;}
			[data-ogsb] #backgroundTable, [data-ogsb] body {background: #363636 !important;}
			[data-ogsc] .body-text, [data-ogsb] h1, [data-ogsb] h2, [data-ogsb] p, [data-ogsb] strong, [data-ogsb] em, [data-ogsb] b {color: #f2f2f2 !important;}
			[data-ogsb] .infobox {background: #666 !important;}
			[data-ogsb] .datatable td, [data-ogsb] .datatable th {background: #363636 !important;}
			[data-ogsc] a, [data-ogsb] a strong {color: #b2b2f8 !important;}
		}
	</style>
	<!--Fallback For Outlook -->
	<!--[if mso]>
	<style type=”text/css”>
		.body-text {
			font-family: Arial, sans-serif !important;
		}
	</style>
	<![endif]-->
	<!--MS Outlook 120 DPI fix-->
	<!--[if gte mso 9]>
	<xml>
		<o:OfficeDocumentSettings>
			<o:AllowPNG/>
			<o:PixelsPerInch>96</o:PixelsPerInch>
		</o:OfficeDocumentSettings>
	</xml>
	<![endif]-->
</head>
<body style="margin: 0; padding: 0;">
<table class="flex" border="0" cellpadding="0" cellspacing="0" width="100%" id="backgroundTable" style="background: #ffffff;">
	<tr>
		<td style="padding: 0 20px; ">
			<!-- Main Container -->
			<table class="flex" align="center" border="0" cellpadding="0" cellspacing="0" width="600"
				   style="border-collapse: collapse; font-family: 'Roboto', Arial, Helvetica, sans-serif;">
				<tr>
					<td>
						<!-- Header -->
						<table border="0" cellpadding="0" cellspacing="0" width="100%">
							<tr>
								<td height="30"
									style="padding: 20px 0 30px 0;">
									<a style="border: none" href="https://www.siteground.com/?utm_source=newsletter&utm_medium=email&utm_campaign=logo" target="_blank" rel="noreferrer">
										<img class="light-img" style="border: none; outline: none;" src="https://www.siteground.com/static/en/img/emails/logo_b.png" width="170" alt="SiteGround"/>
										<!--[if !mso]><! -->
										<div class="dark-img" style="display:none; overflow:hidden; float:left; width:0px; max-height:0px; max-width:0px; line-height:0px; visibility:hidden;"><img style="border: none; outline: none;" src="https://www.siteground.com/static/en/img/emails/logo_w.png" width="170" alt="SiteGround"/></div>
										<!--<![endif]-->
									</a>
								</td>
							</tr>
						</table>
						<!-- End Header -->
					</td>
				</tr>
				<tr>
					<td style="padding: 0 0 30px 0;">
						<a href="#" class="body-text"
						   target="_blank" rel="noreferrer"><img
								src="<?php echo esc_url( $args['image'] ); ?>"
								width="600" alt="Optimization Status for '<?php echo esc_url( $args['domain'] ); ?>'"
								style="max-height: 300px;"/></a>
					</td>
				</tr>
				<tr>
					<td class="body-text"
						style="color: #363636; font-weight: 600; font-family: 'Poppins', Arial, Helvetica, sans-serif; font-size: 30px; line-height: 40px; padding: 0 0 30px 0">
						<?php esc_html_e( 'Hey there,', 'sg-cachepress' ); ?>
					</td>
				</tr>
				<tr>
					<td class="body-text"
						style="color: #363636; font-weight: 400; font-family: 'Roboto', Arial, Helvetica, sans-serif; font-size: 18px; line-height: 30px; padding: 0px 0 60px 0">
						<?php echo esc_html( $args['summary_1'] ); ?> <a href="<?php echo esc_url( $args['domain'] ); ?>" target="_blank" rel="noreferrer" style="color: #4343f0; outline: none; text-decoration: none;"><?php echo esc_html( $args['domain'] ); ?></a> <?php echo esc_html( $args['summary_2'] ); ?>
					</td>
				</tr>
				<tr>
					<td style="padding: 0 0 60px 0; text-align: center">
						<table class="infobox" border="0" cellpadding="0" cellspacing="0" width="100%" style="border-radius: 16px; background: #dfecfc;">
							<tr>
								<td style="padding: 40px 30px 0 30px;">
									<table border="0" cellpadding="0" cellspacing="0" width="100%">
										<tr>
											<td width="255" valign="top" class="dblock" >
												<table border="0" cellpadding="0" cellspacing="0" width="100%">
													<tr >
														<td class="body-text"
															style="color: #363636; font-weight: 600; font-family: 'Poppins', Arial, Helvetica, sans-serif; font-size: 30px; line-height: 40px; padding: 0 0 10px 0" align="center"><?php echo esc_html( $args['percentage'] ); ?>% <?php esc_html_e( 'Optimized', 'sg-cachepress' ); ?></td>
													</tr>
													<tr>
														<td class="body-text"
															style="color: #363636; font-weight: 400; font-family: 'Roboto', Arial, Helvetica, sans-serif; font-size: 18px; line-height: 30px; padding: 0 0 45px 0" align="center">
															<?php
															esc_html_e( 'You are using ', 'sg-cachepress' );
															echo esc_html( $args['score'] );
															esc_html_e( ' out of ', 'sg-cachepress' );
															echo esc_html( $args['total_score'] );
															esc_html_e( ' recommended speed optimization features', 'sg-cachepress' );
															?>
															</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<?php include_once( \SiteGround_Optimizer\DIR . '/templates/performance_reports/features.php' ); ?>
				<!-- Footer Clients -->
				<tr>
					<td class="body-text"
						style="color: #a4a4a4; font-weight: 400; font-family: 'Roboto', Arial, Helvetica, sans-serif; font-size: 14px; line-height: 20px; padding: 0 0 30px 0"><?php echo esc_html( $args['unsubscribe_text'] ); ?><a
							href="<?php echo esc_url( $args['unsubscribe_link'] ); ?>" target="_blank" rel="noreferrer"
							style="color: #4343f0; text-decoration: none;"><?php echo esc_html( $args['unsubscribe_button'] ); ?></a><br/>
				  </td>
				</tr>
			</table>
			<!-- End Main Container -->
		</td>
	</tr>
</table>

</body>
</html>
