import type { SVGProps } from 'react';

interface CustomIconProps extends SVGProps<SVGSVGElement> {
    size?: number;
    fill?: string;
    stroke?: string;
    strokeWidth?: number;
    viewBox?: string;
}

const settings = ({
                                                size = 48,
                                                fill = 'none',
                                                stroke = 'none',
                                                strokeWidth = 2,
                                                viewBox = '0 0 48 48',
                                                ...props
                                            }:CustomIconProps) => (
    <svg
        width={size}
        height={size}
        fill={fill}
        stroke={stroke}
        strokeWidth={strokeWidth}
        viewBox={viewBox}
        strokeLinecap="round"
        strokeLinejoin="round"
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path
            d="M21.6509 44C20.7509 44 19.9759 43.7 19.3259 43.1C18.6759 42.5 18.2843 41.7667 18.1509 40.9L17.7009 37.6C17.2676 37.4333 16.8593 37.2333 16.4759 37C16.0926 36.7667 15.7176 36.5167 15.3509 36.25L12.2509 37.55C11.4176 37.9167 10.5843 37.95 9.75094 37.65C8.9176 37.35 8.2676 36.8167 7.80094 36.05L5.45094 31.95C4.98427 31.1833 4.85094 30.3667 5.05094 29.5C5.25094 28.6333 5.70094 27.9167 6.40094 27.35L9.05094 25.35C9.0176 25.1167 9.00094 24.8917 9.00094 24.675V23.325C9.00094 23.1083 9.0176 22.8833 9.05094 22.65L6.40094 20.65C5.70094 20.0833 5.25094 19.3667 5.05094 18.5C4.85094 17.6333 4.98427 16.8167 5.45094 16.05L7.80094 11.95C8.2676 11.1833 8.9176 10.65 9.75094 10.35C10.5843 10.05 11.4176 10.0833 12.2509 10.45L15.3509 11.75C15.7176 11.4833 16.1009 11.2333 16.5009 11C16.9009 10.7667 17.3009 10.5667 17.7009 10.4L18.1509 7.1C18.2843 6.23333 18.6759 5.5 19.3259 4.9C19.9759 4.3 20.7509 4 21.6509 4H26.3509C27.2509 4 28.0259 4.3 28.6759 4.9C29.3259 5.5 29.7176 6.23333 29.8509 7.1L30.3009 10.4C30.7343 10.5667 31.1426 10.7667 31.5259 11C31.9093 11.2333 32.2843 11.4833 32.6509 11.75L35.7509 10.45C36.5843 10.0833 37.4176 10.05 38.2509 10.35C39.0843 10.65 39.7343 11.1833 40.2009 11.95L42.5509 16.05C43.0176 16.8167 43.1509 17.6333 42.9509 18.5C42.7509 19.3667 42.3009 20.0833 41.6009 20.65L38.9509 22.65C38.9843 22.8833 39.0009 23.1083 39.0009 23.325V24.675C39.0009 24.8917 38.9676 25.1167 38.9009 25.35L41.5509 27.35C42.2509 27.9167 42.7009 28.6333 42.9009 29.5C43.1009 30.3667 42.9676 31.1833 42.5009 31.95L40.1009 36.05C39.6343 36.8167 38.9843 37.35 38.1509 37.65C37.3176 37.95 36.4843 37.9167 35.6509 37.55L32.6509 36.25C32.2843 36.5167 31.9009 36.7667 31.5009 37C31.1009 37.2333 30.7009 37.4333 30.3009 37.6L29.8509 40.9C29.7176 41.7667 29.3259 42.5 28.6759 43.1C28.0259 43.7 27.2509 44 26.3509 44H21.6509ZM22.0009 40H25.9509L26.6509 34.7C27.6843 34.4333 28.6426 34.0417 29.5259 33.525C30.4093 33.0083 31.2176 32.3833 31.9509 31.65L36.9009 33.7L38.8509 30.3L34.5509 27.05C34.7176 26.5833 34.8343 26.0917 34.9009 25.575C34.9676 25.0583 35.0009 24.5333 35.0009 24C35.0009 23.4667 34.9676 22.9417 34.9009 22.425C34.8343 21.9083 34.7176 21.4167 34.5509 20.95L38.8509 17.7L36.9009 14.3L31.9509 16.4C31.2176 15.6333 30.4093 14.9917 29.5259 14.475C28.6426 13.9583 27.6843 13.5667 26.6509 13.3L26.0009 8H22.0509L21.3509 13.3C20.3176 13.5667 19.3593 13.9583 18.4759 14.475C17.5926 14.9917 16.7843 15.6167 16.0509 16.35L11.1009 14.3L9.15094 17.7L13.4509 20.9C13.2843 21.4 13.1676 21.9 13.1009 22.4C13.0343 22.9 13.0009 23.4333 13.0009 24C13.0009 24.5333 13.0343 25.05 13.1009 25.55C13.1676 26.05 13.2843 26.55 13.4509 27.05L9.15094 30.3L11.1009 33.7L16.0509 31.6C16.7843 32.3667 17.5926 33.0083 18.4759 33.525C19.3593 34.0417 20.3176 34.4333 21.3509 34.7L22.0009 40ZM24.1009 31C26.0343 31 27.6843 30.3167 29.0509 28.95C30.4176 27.5833 31.1009 25.9333 31.1009 24C31.1009 22.0667 30.4176 20.4167 29.0509 19.05C27.6843 17.6833 26.0343 17 24.1009 17C22.1343 17 20.4759 17.6833 19.1259 19.05C17.7759 20.4167 17.1009 22.0667 17.1009 24C17.1009 25.9333 17.7759 27.5833 19.1259 28.95C20.4759 30.3167 22.1343 31 24.1009 31Z"
            fill={fill}
            stroke={stroke}
            strokeWidth={strokeWidth}
        />
    </svg>
);

export default settings;