<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace MailPoetVendor\Symfony\Component\Validator\Constraints;

if (!defined('ABSPATH')) exit;


use MailPoetVendor\Symfony\Component\Validator\Constraint;
/**
 * @Annotation
 * @Target({"PROPERTY", "METHOD", "ANNOTATION"})
 *
 * @author Bernhard Schussek <bschussek@gmail.com>
 */
class Type extends \MailPoetVendor\Symfony\Component\Validator\Constraint
{
    const INVALID_TYPE_ERROR = 'ba785a8c-82cb-4283-967c-3cf342181b40';
    protected static $errorNames = [self::INVALID_TYPE_ERROR => 'INVALID_TYPE_ERROR'];
    public $message = 'This value should be of type {{ type }}.';
    public $type;
    /**
     * {@inheritdoc}
     */
    public function getDefaultOption()
    {
        return 'type';
    }
    /**
     * {@inheritdoc}
     */
    public function getRequiredOptions()
    {
        return ['type'];
    }
}
