<?php
	/**
	 * Top bar ( above the logo )
	 * @package wpv
	 */

	$layout = wpv_get_option( 'top-bar-layout' );

	$layout = ! empty( $layout ) ? explode( '-', $layout ) : null;
?>
<?php if ( $layout ): ?>
	<div id="top-nav-wrapper">
		<?php do_action( 'wpv_top_nav_before' ) ?>
		<nav class="top-nav <?php echo esc_attr( implode( '-', $layout ) ) ?>">
			<div class="<?php echo ( wpv_get_option( 'header-layout' ) !== 'logo-menu' || ! wpv_get_option( 'full-width-header' ) ) ? 'limit-wrapper' : '' ?> header-padding top-nav-inner">
				<div class="row">
					<div class="row <?php if ( count( $layout ) === 1 ) echo esc_attr( 'single-cell' ) ?>">
						<?php
							foreach ( $layout as $part ) {
								get_template_part( 'templates/header/top/nav', $part );
							}
						?>
					</div>
				</div>
			</div>
		</nav>
		<?php do_action( 'wpv_top_nav_after' ) ?>
	</div>
<?php endif ?>