<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace MailPoetVendor\Symfony\Component\Validator\Constraints;

if (!defined('ABSPATH')) exit;


/**
 * @Annotation
 * @Target({"PROPERTY", "METHOD", "ANNOTATION"})
 *
 * @author Daniel Holmes <daniel@danielholmes.org>
 * @author Bernhard Schussek <bschussek@gmail.com>
 */
class GreaterThan extends \MailPoetVendor\Symfony\Component\Validator\Constraints\AbstractComparison
{
    const TOO_LOW_ERROR = '778b7ae0-84d3-481a-9dec-35fdb64b1d78';
    protected static $errorNames = [self::TOO_LOW_ERROR => 'TOO_LOW_ERROR'];
    public $message = 'This value should be greater than {{ compared_value }}.';
}
