<?php
return array(
	'name'    => __( 'Buttons', 'construction' ) ,
	'value'   => 'button',
	'options' => array(
		array(
			'name'    => __( 'Text', 'construction' ) ,
			'id'      => 'text',
			'default' => '',
			'type'    => 'text',
		) ,
		array(
			'name'    => __( 'Style', 'construction' ) ,
			'id'      => 'style',
			'default' => 'filled',
			'type'    => 'select',
			'options' => array(
				'filled'         => __( 'Filled', 'construction' ),
				'border'         => __( 'Border', 'construction' ),
				'style-3'        => __( 'Style 3', 'construction' ),
			),
		) ,
		array(
			'name'    => __( 'Font size', 'construction' ) ,
			'id'      => 'font',
			'default' => 24,
			'type'    => 'range',
			'min'     => 10,
			'max'     => 64,
		) ,
		array(
			'name'    => __( 'Background', 'construction' ) ,
			'id'      => 'bgColor',
			'default' => 'accent1',
			'type'    => 'select',
			'options' => array(
				'accent1' => __( 'Accent 1', 'construction' ),
				'accent2' => __( 'Accent 2', 'construction' ),
				'accent3' => __( 'Accent 3', 'construction' ),
				'accent4' => __( 'Accent 4', 'construction' ),
				'accent5' => __( 'Accent 5', 'construction' ),
				'accent6' => __( 'Accent 6', 'construction' ),
				'accent7' => __( 'Accent 7', 'construction' ),
				'accent8' => __( 'Accent 8', 'construction' ),
			),
		) ,
		array(
			'name'    => __( 'Hover Background', 'construction' ) ,
			'id'      => 'hover_color',
			'default' => 'accent1',
			'type'    => 'select',
			'options' => array(
				'accent1' => __( 'Accent 1', 'construction' ),
				'accent2' => __( 'Accent 2', 'construction' ),
				'accent3' => __( 'Accent 3', 'construction' ),
				'accent4' => __( 'Accent 4', 'construction' ),
				'accent5' => __( 'Accent 5', 'construction' ),
				'accent6' => __( 'Accent 6', 'construction' ),
				'accent7' => __( 'Accent 7', 'construction' ),
				'accent8' => __( 'Accent 8', 'construction' ),
			),
		) ,
		array(
			'name'    => __( 'Alignment', 'construction' ) ,
			'id'      => 'align',
			'default' => '',
			'prompt'  => '',
			'type'    => 'select',
			'options' => array(
				'left'   => __( 'Left', 'construction' ) ,
				'right'  => __( 'Right', 'construction' ) ,
				'center' => __( 'Center', 'construction' ) ,
			) ,
		) ,
		array(
			'name'    => __( 'Link', 'construction' ) ,
			'id'      => 'link',
			'default' => '',
			'type'    => 'text',
		) ,
		array(
			'name'    => __( 'Link Target', 'construction' ) ,
			'id'      => 'linkTarget',
			'default' => '_self',
			'type'    => 'select',
			'options' => array(
				'_blank' => __( 'Load in a new window', 'construction' ) ,
				'_self'  => __( 'Load in the same frame as it was clicked', 'construction' ) ,
			) ,
		) ,
		array(
			'name'    => __( 'Icon', 'construction' ) ,
			'id'      => 'icon',
			'default' => '',
			'type'    => 'icons',
		) ,
		array(
			'name'    => __( 'Icon Size', 'construction' ) ,
			'id'      => 'icon_size',
			'default' => 0,
			'type'    => 'range',
			'min'     => 0,
			'max'     => 100,
		) ,
		array(
			'name'    => __( 'Icon Style', 'construction' ),
			'type'    => 'select-row',
			'selects' => array(
				'icon_color' => array(
					'desc'    => __( 'Color:', 'construction' ),
					"default" => "",
					"prompt"  => '',
					"options" => array(
						'accent1' => __( 'Accent 1', 'construction' ),
						'accent2' => __( 'Accent 2', 'construction' ),
						'accent3' => __( 'Accent 3', 'construction' ),
						'accent4' => __( 'Accent 4', 'construction' ),
						'accent5' => __( 'Accent 5', 'construction' ),
						'accent6' => __( 'Accent 6', 'construction' ),
						'accent7' => __( 'Accent 7', 'construction' ),
						'accent8' => __( 'Accent 8', 'construction' ),
					) ,
				),
				'icon_placement' => array(
					'desc'    => __( 'Placement:', 'construction' ),
					"default" => 'left',
					"options" => array(
						'left'  => __( 'Left', 'construction' ),
						'right' => __( 'Right', 'construction' ),
					) ,
				),
			),
		),

		array(
			'name'    => __( 'ID', 'construction' ) ,
			'desc'    => __( 'ID attribute added to the button element.', 'construction' ),
			'id'      => 'id',
			'default' => '',
			'type'    => 'text',
		) ,
		array(
			'name'    => __( 'Class', 'construction' ) ,
			'desc'    => __( 'Class attribute added to the button element.', 'construction' ),
			'id'      => 'class',
			'default' => '',
			'type'    => 'text',
		) ,
	) ,
);
