<?php

namespace MailPoetVendor;

if (!defined('ABSPATH')) exit;


/*
 * This file is part of SwiftMailer.
 * (c) 2004-2009 Chris Corbyn
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
/**
 * Generated when a response is received on a SMTP connection.
 *
 * @author Chris Corbyn
 */
class Swift_Events_ResponseEvent extends \MailPoetVendor\Swift_Events_EventObject
{
    /**
     * The overall result.
     *
     * @var bool
     */
    private $valid;
    /**
     * The response received from the server.
     *
     * @var string
     */
    private $response;
    /**
     * Create a new ResponseEvent for $source and $response.
     *
     * @param string $response
     * @param bool   $valid
     */
    public function __construct(\MailPoetVendor\Swift_Transport $source, $response, $valid = \false)
    {
        parent::__construct($source);
        $this->response = $response;
        $this->valid = $valid;
    }
    /**
     * Get the response which was received from the server.
     *
     * @return string
     */
    public function getResponse()
    {
        return $this->response;
    }
    /**
     * Get the success status of this Event.
     *
     * @return bool
     */
    public function isValid()
    {
        return $this->valid;
    }
}
