<?php

/*
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the MIT license. For more information, see
 * <http://www.doctrine-project.org>.
 */
namespace MailPoetVendor\Doctrine\Common\Reflection;

if (!defined('ABSPATH')) exit;


use ReflectionException;
use ReflectionProperty;
class StaticReflectionProperty extends \ReflectionProperty
{
    /**
     * The PSR-0 parser object.
     *
     * @var StaticReflectionParser
     */
    protected $staticReflectionParser;
    /**
     * The name of the property.
     *
     * @var string|null
     */
    protected $propertyName;
    /**
     * @param StaticReflectionParser $staticReflectionParser
     * @param string|null            $propertyName
     */
    public function __construct(\MailPoetVendor\Doctrine\Common\Reflection\StaticReflectionParser $staticReflectionParser, $propertyName)
    {
        $this->staticReflectionParser = $staticReflectionParser;
        $this->propertyName = $propertyName;
    }
    /**
     * {@inheritDoc}
     */
    public function getName()
    {
        return $this->propertyName;
    }
    /**
     * @return StaticReflectionParser
     */
    protected function getStaticReflectionParser()
    {
        return $this->staticReflectionParser->getStaticReflectionParserForDeclaringClass('property', $this->propertyName);
    }
    /**
     * {@inheritDoc}
     */
    public function getDeclaringClass()
    {
        return $this->getStaticReflectionParser()->getReflectionClass();
    }
    /**
     * {@inheritDoc}
     */
    public function getDocComment()
    {
        return $this->getStaticReflectionParser()->getDocComment('property', $this->propertyName);
    }
    /**
     * @return array
     */
    public function getUseStatements()
    {
        return $this->getStaticReflectionParser()->getUseStatements();
    }
    /**
     * {@inheritDoc}
     */
    public static function export($class, $name, $return = \false)
    {
        throw new \ReflectionException('Method not implemented');
    }
    /**
     * {@inheritDoc}
     */
    public function getModifiers()
    {
        throw new \ReflectionException('Method not implemented');
    }
    /**
     * {@inheritDoc}
     */
    public function getValue($object = null)
    {
        throw new \ReflectionException('Method not implemented');
    }
    /**
     * {@inheritDoc}
     */
    public function isDefault()
    {
        throw new \ReflectionException('Method not implemented');
    }
    /**
     * {@inheritDoc}
     */
    public function isPrivate()
    {
        throw new \ReflectionException('Method not implemented');
    }
    /**
     * {@inheritDoc}
     */
    public function isProtected()
    {
        throw new \ReflectionException('Method not implemented');
    }
    /**
     * {@inheritDoc}
     */
    public function isPublic()
    {
        throw new \ReflectionException('Method not implemented');
    }
    /**
     * {@inheritDoc}
     */
    public function isStatic()
    {
        throw new \ReflectionException('Method not implemented');
    }
    /**
     * {@inheritDoc}
     */
    public function setAccessible($accessible)
    {
        throw new \ReflectionException('Method not implemented');
    }
    /**
     * {@inheritDoc}
     */
    public function setValue($object, $value = null)
    {
        throw new \ReflectionException('Method not implemented');
    }
    /**
     * {@inheritDoc}
     */
    public function __toString()
    {
        throw new \ReflectionException('Method not implemented');
    }
}
