<?php

// =============================================================================
// VIEWS/ADMIN/METABOX-CONTACT-OPTIONAL.PHP
// -----------------------------------------------------------------------------
// Optional contact settings.
// =============================================================================

// =============================================================================
// TABLE OF CONTENTS
// -----------------------------------------------------------------------------
//   01. Metabox
// =============================================================================

// Metabox
// =============================================================================


?>

<p>
  <?php _e( 'Optional (and useful!) info about the main contact of your organization.', '__tco__' ); ?>
</p>

<table class="form-table">

  <tr>
    <th>
      <label for="<?php echo $plugin_slug . '_contact_option'; ?>">
        <strong><?php _e( 'Option', '__tco__' ); ?></strong>
        <span><?php _e( 'Select if your telephone service supports the hearing impaired or toll free options.', '__tco__' ); ?></span>
      </label>
    </th>
    <td>
      <select class="select" id="<?php echo $plugin_slug . '_contact_option'; ?>">
        <?php if ( empty( $contact_option_list ) ) : ?>
          <option><?php _e( 'No Lists Found', '__tco__' ); ?></option>
        <?php else :
          $contact_option = isset($contact_option) ? $contact_option : '';
          ?>
          <option value="" <?php echo ( '' == $contact_option ) ? 'selected' : ''; ?>><?php echo _e( '-- Select an option --', '__tco__' ); ?></option>
          <?php foreach ( $contact_option_list as $value => $label ) : ?>
            <option value="<?php echo $value; ?>">
              <?php echo _e( $label, '__tco__' ); ?>
            </option>
          <?php endforeach; ?>
        <?php endif; ?>
      </select>
    </td>
  </tr>

  <tr>
    <th>
      <label for="<?php echo $plugin_slug . '_contact_area_served'; ?>">
        <strong><?php _e( 'Area Served', '__tco__' ); ?></strong>
        <span><?php _e( 'Which area/country is supported by this contact.', '__tco__' ); ?></span>
      </label>
    </th>
    <td>
      <select class="select" id="<?php echo $plugin_slug . '_contact_area_served'; ?>">
        <?php if ( empty( $country_list ) ) : ?>
          <option><?php _e( 'No Lists Found', '__tco__' ); ?></option>
        <?php else :
          $contact_area_served = isset($contact_area_served) ? $contact_area_served : '';
          ?>
          <option value="" <?php echo ( '' == $contact_area_served ) ? 'selected' : ''; ?>><?php echo _e( '-- Select a country --', '__tco__' ); ?></option>
          <?php foreach ( $country_list as $value => $label ) : ?>
            <option value="<?php echo $value; ?>">
              <?php echo $label; ?>
            </option>
          <?php endforeach; ?>
        <?php endif; ?>
      </select>
    </td>
  </tr>

  <tr>
    <th>
      <label for="<?php echo $plugin_slug . '_contact_available_language'; ?>">
        <strong><?php _e( 'Language', '__tco__' ); ?></strong>
        <span><?php _e( 'Language supported by this contact.', '__tco__' ); ?></span>
      </label>
    </th>
    <td>
      <select class="select" id="<?php echo $plugin_slug . '_contact_available_language'; ?>">
        <?php if ( empty( $language_list ) ) : ?>
          <option><?php _e( 'No Lists Found', '__tco__' ); ?></option>
        <?php else :
          $contact_available_language = isset($contact_available_language) ? $contact_available_language : '';
          ?>
          <option value="" <?php echo ( '' == $contact_available_language ) ? 'selected' : ''; ?>><?php echo _e( '-- Select a language --', '__tco__' ); ?></option>
          <?php foreach ( $language_list as $value ) : ?>
            <option value="<?php echo $value; ?>">
              <?php echo _e( $value, '__tco__' ); ?>
            </option>
          <?php endforeach; ?>
        <?php endif; ?>
      </select>
    </td>
  </tr>

  <tr>
    <th>
      <label for="<?php echo $plugin_slug . '_contact_hours_available'; ?>">
        <strong><?php _e( 'Hours Available', '__tco__' ); ?></strong>
        <span><?php _e( 'Enter what times this contact is available to be contacted by the public. Use a 24hr format.', '__tco__' ); ?></span>
      </label>
    </th>
    <td>
      <div id="snippet_hours_add_widget">
        From <input type="text" class="small-text snippet-time" id="snippet_hours_start" />
        to <input type="text" class="small-text snippet-time" id="snippet_hours_end" /><br/>
        on: <input type="checkbox" class="snippet_hours_weekday" value="Mo" />Mon
        <input type="checkbox" class="snippet_hours_weekday" value="Tu" />Tue
        <input type="checkbox" class="snippet_hours_weekday" value="We" />Wed
        <input type="checkbox" class="snippet_hours_weekday" value="Th" />Thu
        <input type="checkbox" class="snippet_hours_weekday" value="Fr" />Fri
        <input type="checkbox" class="snippet_hours_weekday" value="Sa" />Sat
        <input type="checkbox" class="snippet_hours_weekday" value="Su" />Sun
        <input type="hidden" class="large-text" id="snippet_hours_id'; ?>" />
        <a href="#" class="button button-primary" id="snippet_hours_add" style="margin-top: -10px;">Add Entry</a>
      </div>
      <hr/>
      <ul id="snippet_hours_list">
      </ul>
      <input type="hidden" class="large-text" id="<?php echo $plugin_slug . '_contact_hours_available'; ?>" value="" />
    </td>
  </tr>

</table>

<hr/>
<div id="snippet-contact-save-div" style="display:none; clear:both; text-align: center">
  <input id="snippet-contact-save" class="button button-primary" style="text-align:center;" value="Update contact">
</div>
