<?php

namespace Themeco\Cornerstone\API;

use function Cornerstone\Api\Controls\controls_global;

/**
 * Ready to setup
 */
add_action("after_setup_theme", function() {
  $values = array_merge(
    BUILTIN_VALUES,
    cs_api_extension_values(),
    [
      'global_id' => '',
    ],
  );

  // Unset so we receive defaults from global
  foreach ($values as $key => $value) {
    $values[$key] = '';
  }

  // Run should still be here
  $values['run'] = true;

  /**
   * API Looper
   */
  cs_looper_provider_register("apiglobal", [
    'label' => __("External API Global", "cornerstone"),
    'controls' => controls_global(),

    'values' => $values,

    'loop_keys' => true,

    /**
     * Main
     */
    'filter' => function($result, $args) {
      return cs_api_global_run($args);
    },
  ]);

});
