<?php

// =============================================================================
// CORNERSTONE/INCLUDES/ELEMENTS/MIXINS_ELEMENTS/VIDEO.PHP
// -----------------------------------------------------------------------------
// V2 element mixins.
// =============================================================================

// =============================================================================
// TABLE OF CONTENTS
// -----------------------------------------------------------------------------
//   01. Controls
//   02. Control Group
//   03. Values
// =============================================================================

// Controls
// =============================================================================

function x_controls_element_video( $adv = false ) {

  include( dirname( __FILE__ ) . '/../mixins_setup/_.php' );

  if ( $adv ) {

    $controls = array_merge(
      x_controls_video_adv( array( 'adv' => $adv ) ),
      x_controls_frame_adv( array( 'frame_content_type' => 'video', 'adv' => $adv ) ),
      x_controls_omega()
    );

  } else {

    $controls = array_merge(

      x_controls_video_std_content(),

      x_controls_video_std_design_setup(),
      x_controls_frame_std_design_setup(),

      x_controls_video_std_design_colors(),
      x_controls_frame_std_design_colors(),

      x_controls_omega( $settings_std_customize )

    );

  }

  return $controls;

}



// Control Groups
// =============================================================================

function x_control_groups_element_video( $adv = false ) {

  include( dirname( __FILE__ ) . '/../mixins_setup/_.php' );

  if ( $adv ) {

    $control_groups = array_merge(
      x_control_groups_video(),
      x_control_groups_frame( array( 'frame_content_type' => 'video' ) ),
      x_control_groups_omega()
    );

  } else {

    $control_groups = x_control_groups_std( array( 'group_title' => __( 'Video', '__x__' ) ) );

  }

  return $control_groups;

}



// Values
// =============================================================================

function x_values_element_video( $settings = array() ) {

  include( dirname( __FILE__ ) . '/../mixins_setup/_.php' );

  $values = array_merge(
    x_values_video(),
    x_values_frame( array( 'frame_content_type' => 'video' ) ),
    x_values_omega()
  );

  return x_bar_mixin_values( $values, $settings );

}
