<?php

// =============================================================================
// CORNERSTONE/INCLUDES/ELEMENTS/MIXINS_ELEMENTS/ACCORDION-ITEM.PHP
// -----------------------------------------------------------------------------
// V2 element mixins.
// =============================================================================

// =============================================================================
// TABLE OF CONTENTS
// -----------------------------------------------------------------------------
//   01. Controls
//   02. Control Groups
//   03. Values
// =============================================================================

// Controls
// =============================================================================

function x_controls_element_accordion_item( $adv = false ) {

  include( dirname( __FILE__ ) . '/../mixins_setup/_.php' );

  if ( $adv ) {

    $controls = array_merge(
      x_controls_accordion_item( array( 'adv' => $adv ) ),
      x_controls_omega( $settings_add_toggle_hash )
    );

  } else {

    $controls = array_merge(
      x_controls_accordion_item(),
      x_controls_omega( array_merge( $settings_std_customize, $settings_add_toggle_hash ) )
    );

  }

  return $controls;

}



// Control Groups
// =============================================================================

function x_control_groups_element_accordion_item( $adv = false ) {

  include( dirname( __FILE__ ) . '/../mixins_setup/_.php' );

  if ( $adv ) {

    $control_groups = array_merge(
      x_control_groups_accordion_item(),
      x_control_groups_omega()
    );

  } else {

    $control_groups = x_control_groups_std( array( 'group_title' => __( 'Accordion Item', '__x__' ), 'no_design' => true ) );

  }

  return $control_groups;

}



// Values
// =============================================================================

function x_values_element_accordion_item( $settings = array() ) {

  include( dirname( __FILE__ ) . '/../mixins_setup/_.php' );

  $values = array_merge(
    x_values_accordion_item(),
    x_values_omega( $settings_add_toggle_hash )
  );

  return x_bar_mixin_values( $values, $settings );

}
