<?php
/**
* The template for displaying posts
*
* This is the template that displays all pages by default.
* Please note that this is the WordPress construct of pages and that
* other "pages" on your WordPress site will use a different template.
*/
get_header(); ?>
<?php while ( have_posts() ) : the_post(); ?>

<section class="page-hero" id="start-content" data-type="background" data-speed="10" id="section1">
    <div class="container">
      <h1 class="entry-title"><?php the_title_attribute(); ?></h1>
        <span class="muted">Category: <?php the_category(); ?> Posted on: <?php the_time('m/j/y g:i A') ?></span>
    </div>
  </section>
  <section class="page-content">
    <div class="container">
      <main id="page" role="main">
        <div class="breadcrumbs-nav">
          <?php if ( function_exists('yoast_breadcrumb') )
                {yoast_breadcrumb('<p id="breadcrumbs">','</p>');} ?>
        </div>
        <article <?php post_class('main-content') ?> id="post-<?php the_ID(); ?>">
          <?php the_post_thumbnail(); ?>

          <?php the_content(); ?>
          		<?php edit_post_link(); ?>
        </article>
          </main>

      </div>
  </section>
<?php endwhile;?>
<?php get_footer(); ?>
