<?php

/* Template Name: Sidebar Template */

get_header(); ?>

<section class="page-hero" id="start-content" data-type="background" data-speed="10" id="section1">
  <?php while ( have_posts() ) : the_post(); ?>
    <h1 class="entry-title"><?php the_title(); ?></h1>
  </section>
  <?php if ( is_page() ) { ?>
    <section aria-label="Breadcrumbs">
    <div class="container">
    <div class="breadcrumbs-nav">
    <?php get_breadcrumb(); ?>
    </div>
    </div>
  </section>
  <?php } ?>
  <section class="page-content" data-type="background" data-speed="10">

    <div class="container">
      <main id="page" role="main">
        <div class="row">
          <article class="col-md-9" <?php post_class('main-content') ?> id="post-<?php the_ID(); ?>">
            <div class="entry-content">
              <?php the_content(); ?>
            </div>
          </article>
          <aside class="col-md-3" id="sidebar">
            <ul>
              <?php
              if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('sidebar') ) :
              endif; ?>
            </ul>
          </aside>
        </div>
        </main>
      </div>
  </section>
<?php endwhile;?>

<?php get_footer(); ?>
