<?php
function sitestyles_styles() {
wp_enqueue_style( 'icon_styles','//cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css');

wp_enqueue_style( 'bootstrap_styles','//stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css');
wp_enqueue_style( 'animate_styif yoles','//cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.min.css');
wp_enqueue_style( 'style', get_stylesheet_uri() );
wp_enqueue_style( 'slick_css','//cdn.jsdelivr.net/jquery.slick/1.6.0/slick.css');
}
add_action( 'wp_enqueue_scripts', 'sitestyles_styles' );

function sitescripts_scripts() {
  wp_enqueue_script('jquery');
  wp_enqueue_script('bootstrap_tether_js', '//cdnjs.cloudflare.com/ajax/libs/tether/1.4.0/js/tether.min.js');
  wp_enqueue_script('bootstrap_popper_js', '//cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js');
  wp_enqueue_script('bootstrap_js', '//stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js');
  wp_enqueue_script('slick_js', '//cdn.jsdelivr.net/jquery.slick/1.6.0/slick.min.js');
  wp_enqueue_script('wow_js', '//cdn.jsdelivr.net/wow/1.1.2/wow.min.js');
//  wp_enqueue_script('fontawesome_5', '//kit.fontawesome.com/723ba897a3.js');
  wp_enqueue_script( 'custom_script', get_template_directory_uri() . '/js/custom.js');
}
add_action( 'wp_enqueue_scripts', 'sitescripts_scripts' );

add_theme_support( 'post-thumbnails' );

function register_menus() {
  register_nav_menu('main-nav',__( 'Main Nav' ));
  register_nav_menu('top-nav',__( 'Top Nav' ));
}
add_action( 'init', 'register_menus' );

// Register custom navigation walker
require_once('class-wp-bootstrap-navwalker.php');

add_post_type_support( 'page', 'excerpt' );

function namespace_add_custom_types( $query ) {
  if( (is_category() || is_tag()) && $query->is_archive() && empty( $query->query_vars['suppress_filters'] ) ) {
    $query->set( 'post_type', array(
     'post', 'products'
        ));
    }
    return $query;
}

add_filter( 'pre_get_posts', 'namespace_add_custom_types' );

if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Sidebar',
'id' => 'sidebar',
'description' => 'Sidebar',
'before_widget' => '
<li id="%1$s" class="widget %2$s">',
'after_widget' => '</li>',
'before_title' => '<h2 class="widgettitle">',
'after_title' => '</h2>',
));
}

add_theme_support( 'custom-logo', array(
	'height'      => 100,
	'width'       => 400,
	'flex-height' => true,
	'flex-width'  => true,
	'header-text' => array( 'site-title', 'site-description' ),
) );

/**
 * Generate breadcrumbs
 */
function get_breadcrumb() {
    echo '<a href="'.home_url().'" rel="nofollow">Home</a>';
    if (is_category() || is_single()) {
        echo "&nbsp;&nbsp;&#187;&nbsp;&nbsp;";
        the_category(' &bull; ');
            if (is_single()) {
                echo " &nbsp;&nbsp;&#187;&nbsp;&nbsp; ";
                the_title();
            }
    } elseif (is_page()) {
        echo "&nbsp;&nbsp;&#187;&nbsp;&nbsp;";
        echo the_title();
    } elseif (is_search()) {
        echo "&nbsp;&nbsp;&#187;&nbsp;&nbsp;Search Results for... ";
        echo '"<em>';
        echo the_search_query();
        echo '</em>"';
    }
}

function add_file_types_to_uploads($file_types){
$new_filetypes = array();
$new_filetypes['svg'] = 'image/svg+xml';
$file_types = array_merge($file_types, $new_filetypes );
return $file_types;
}
add_filter('upload_mimes', 'add_file_types_to_uploads');

// Formidable Forms accessibility: add "required" attribute to required radio buttons in forms
function jemc_add_required_on_radio($field, $echo = true)
{
	$html = '';
	if (($field['type'] == 'checkbox' || $field['type'] == 'radio') && $field['required'] == 1)
	{
		$html = ' required';
	}
	if($echo)
	echo $html;
	return $html;
}
add_action('frm_field_input_html', 'jemc_add_required_on_radio');

// Fight spam by preventing URLs in Formidable form submissions
function jemc_form_field_content_check($errors, $values)
{
	$checkedFieldTypes = ['text', 'textarea', 'html'];
	$regexes = [
		'/\b((http|https?|ftp)\:\/\/)?([a-z0-9+!*(),;?&=$_.-]+(\:[a-z0-9+!*(),;?&=$_.-]+)?@)?([a-z0-9-.]*)\.([a-z]{2,3})(\:[0-9]{2,5})?(\/([a-z0-9+$_-]\.?)+)*\/?(\?[a-z+&$_.-][a-z0-9;:@&%=+\/$_.-]*)?(#[a-z_.-][a-z0-9+$_.-]*)?\b/i',
		'/www\.|http:|https:\/\/[a-z0-9_]+([\-\.]{1}[a-z_0-9]+)*\.[_a-z]{2,5}'.'((:[0-9]{1,5})?\/.*)?$/i',
		'/\b(?:(?:https?|ftp|http):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i'
	];
	foreach($_POST['item_meta'] as $fieldID=>$fieldValue)
	{
		$field = FrmField::getOne($fieldID);
		if (($fieldID == 0 && empty($fieldValue)) || !in_array($field->type, $checkedFieldTypes) || !is_string($fieldValue))
		{
			continue;
		}
		foreach($regexes as $regex)
		{
			if (preg_match($regex, $fieldValue))
			{
				$errors[$fieldID] = 'The ' . strtolower($field->name) . ' field contains invalid characters.';
				break;
			}
		}
	}
	return $errors;
}
add_filter( 'frm_validate_entry', 'jemc_form_field_content_check', 20, 2 );
?>
