(function() {
  function initCategoryToggle() {
    let toggler = document.querySelector("#gspro-categories-toggle");
    let categories = document.querySelector("#gspro-categories");
    let body = document.querySelector("body");
    if (!toggler || !categories) {
      return;
    }
    console.log("Goodshuffle Website Integration: Enabling category toggle");
    body.addEventListener("click", () => {
      categories.classList.remove("gspro-u-active");
    });

    toggler.addEventListener("click", event => {
      categories.classList.toggle("gspro-u-active");
      event.stopImmediatePropagation();
    });
  }

  function initDetailToggle() {
    var detail = document.querySelector("gspro-item-detail.gspro-u-fullscreen");
    if (detail) {
      console.log(
        "Goodshuffle Website Integration: Enabling item detail close handler"
      );
      detail.addEventListener("click", e => {
        if (e.target == detail) {
          detail.close();
        }
      });
    }
  }

  document.addEventListener("DOMContentLoaded", () => {
    initCategoryToggle();
    initDetailToggle();
  });
})();
