<?php

/**
 * Fired during plugin activation
 *
 * @link       http://github.com/goodshuffle/gspro-gallery
 * @since      0.1.0
 *
 * @package    Gspro_Gallery
 * @subpackage Gspro_Gallery/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      0.1.0
 * @package    Gspro_Gallery
 * @subpackage Gspro_Gallery/includes
 * @author     Jon Morton <jon@goodshuffle.com>
 */
class Gspro_Gallery_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    0.1.0
	 */
	public static function activate() {
		update_option('gspro_on', true);
		$gspro_wishlist_active = get_option('gspro_wishlist_active', false);
		update_option('gspro_wishlist_active', $gspro_wishlist_active);
		$gspro_gallery_page = get_option('gspro_gallery_page_name', 'goodshuffle');
		update_option('gspro_gallery_page_name', $gspro_gallery_page);
		Gspro_Gallery_Rewrites::activate();
	}

}
