<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://github.com/goodshuffle/gspro-gallery
 * @since      0.1.0
 *
 * @package    Gspro_Gallery
 * @subpackage Gspro_Gallery/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Gspro_Gallery
 * @subpackage Gspro_Gallery/admin
 * @author     Jon Morton <jon@goodshuffle.com>
 */
class Gspro_Gallery_Admin
{

	/**
	 * The ID of this plugin.
	 *
	 * @since    0.1.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    0.1.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    0.1.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct($plugin_name, $version)
	{

		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    0.1.0
	 */
	public function enqueue_styles()
	{

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Gspro_Gallery_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Gspro_Gallery_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/gspro-gallery-admin.css', array(), $this->version, 'all');
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    0.1.0
	 */
	public function enqueue_scripts()
	{

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Gspro_Gallery_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Gspro_Gallery_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/gspro-gallery-admin.js', array('jquery'), $this->version, false);
	}

	/**
	 * Register the admin menu.
	 * 
	 * @since 0.1.0
	 */
	public function add_plugin_admin_menu()
	{
		$page_title = "Goodshuffle Pro Gallery";
		$menu_title = "Goodshuffle";
		$capability = "manage_options";
		$menu_slug  = $this->plugin_name;
		$function   = array($this, 'display_plugin_setup_page');
		add_options_page($page_title, $menu_title, $capability, $menu_slug, $function);
	}

	/**
	 * Add a link to this plugin to the action links.
	 */
	public function add_action_links($links)
	{
		$settings_link = array(
			'<a href="' . admin_url('options-general.php?page=' . $this->plugin_name) . '">' . __('Settings', $this->plugin_name) . '</a>'
		);
		return array_merge($settings_link, $links);
	}

	/**
	 * Render the admin page.
	 */
	public function display_plugin_setup_page()
	{
		include_once('partials/gspro-gallery-admin-display.php');
	}

}
