<?php

/**
 * Provide elements to be embedded on the designated gallery page.
 *
 * @link       http://github.com/goodshuffle/gspro-gallery
 * @since      0.1.0
 *
 * @package    Gspro_Gallery
 * @subpackage Gspro_Gallery/public/partials
 *
 * conditionally checks whether values are present, and appends them as attributes if so
 * this was change was necessary as the empty group attribute was causing issues with routing to the next page
 */
?>

<gspro-item-gallery id="gspro-gallery"

    <?php
    $category = get_option('gspro_default_category', '');
    if (strlen($category) > 0) {
        echo "category='" . $category . "'";
    }
    ?>

    <?php
    $group = get_option('gspro_default_group', '');
    if (strlen($group) > 0) {
        echo "group='" . $group . "'";
    }
    ?>

    <?php
    $search = get_option('gspro_default_search', '');
    if (strlen($search) > 0) {
        echo "search='" . $search . "'";
    }
    ?>

    <?php
    $tags = get_option('gspro_default_tags', '');
    if (strlen($tags) > 0) {
        echo "tags='" . $tags . "'";
    }
    ?>

    <?php
    $scopeAttributeName = get_option('gspro_scope_attribute_name', '');
    if (strlen($scopeAttributeName) > 0) {
        echo "scope-attribute-1-name='" . $scopeAttributeName . "'";
    }
    ?>

    <?php
    $scopeAttributeValue = get_option('gspro_scope_attribute_value', '');
    if (strlen($scopeAttributeValue) > 0) {
        echo "scope-attribute-1-value='" . $scopeAttributeValue . "'";
    }
    ?>

    <?php
    $size = get_option('gspro_default_item_list_size', '');
    if (strlen($size) > 0) {
        echo "size='" . $size . "'";
    }
    ?>


                    show-categories="<?= get_option('gspro_show_categories', "") ? "true" : "false" ?>"
                    show-filters="<?= get_option('gspro_show_filters', "") ? "true" : "false" ?>"
</gspro-item-gallery>
