<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       http://github.com/goodshuffle/gspro-gallery
 * @since      0.1.0
 *
 * @package    Gspro_Gallery
 * @subpackage Gspro_Gallery/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Gspro_Gallery
 * @subpackage Gspro_Gallery/public
 * @author     Jon Morton <jon@goodshuffle.com>
 */
class Gspro_Gallery_Public
{

    /**
     * The ID of this plugin.
     *
     * @since    0.1.0
     * @access   private
     * @var      string $plugin_name The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    0.1.0
     * @access   private
     * @var      string $version The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @param string $plugin_name The name of the plugin.
     * @param string $version The version of this plugin.
     * @since    0.1.0
     */
    public function __construct($plugin_name, $version)
    {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    /**
     * Register the JavaScript for the public-facing side of the site.
     *
     * @since    0.1.0
     */
    public function enqueue_meta()
    {
        $svg_default = esc_url(plugins_url('/img/icons.svg', __FILE__));
        $svg = get_option('gspro_icon_url', $svg_default);
        echo '<meta name="gspro-icon-url" content="' . $svg . '">';

        $base = get_option('gspro_data_url', 'https://data.goodshuffle.com/vendor');
        $key = get_option('gspro_company_key', 'none');
        $dataURL = $base . '/' . $key;
        $gspro_wishlist_active = get_option('gspro_wishlist_active', false);
        $gspro_disable_scroll_lock = get_option('gspro_disable_scroll_lock', false);
        $gspro_wishlist_alias = get_option('gspro_wishlist_alias', '');
        $gspro_notes_help_text = get_option('gspro_notes_help_text', '');
        $gspro_disable_time_selection = get_option('gspro_disable_time_selection', false);
        $gspro_show_quantity_on_card = get_option('gspro_show_quantity_on_card', false);
        $gspro_show_quantity_on_detail = get_option('gspro_show_quantity_on_detail', false);
        $gspro_require_phone = get_option('gspro_require_phone', false);


        $wishlist_config_element = '<gspro-wishlist-config data-url="' . $dataURL . '"';
        if (!$gspro_wishlist_active) {
            $wishlist_config_element .= ' wishlist-show-on-all-pages="false" ';
        }
        if ($gspro_disable_scroll_lock) {
            $wishlist_config_element .= ' disable-body-scroll-lock="true" ';
        }
        if(strlen($gspro_wishlist_alias) > 0) {
            $wishlist_config_element .= ' wishlist-alias="' . $gspro_wishlist_alias . '"';
        }

        if(strlen($gspro_notes_help_text) > 0) {
            $wishlist_config_element .= ' notes-help-text="' . $gspro_notes_help_text . '"';
        }

        if ($gspro_disable_time_selection) {
            $wishlist_config_element .= ' disable-time-selection="true" ';
        }

        if ($gspro_show_quantity_on_card) {
            $wishlist_config_element .= ' show-quantity-on-card="true" ';
        }

        if ($gspro_show_quantity_on_detail) {
            $wishlist_config_element .= ' show-quantity-on-detail="true" ';
        }

        if ($gspro_require_phone) {
            $wishlist_config_element .= ' require-phone-number="true" ';
        }

        $wishlist_config_element .= '></gspro-wishlist-config>';
        echo $wishlist_config_element;
    }

    public function enqueue_legacy_webcomponents()
    {
        $gspro_legacy_js_default = 'https://unpkg.com/@goodshuffle/gspro-wc@0.5.6/dist/gspro-wc/gspro-wc.js';
        $src = get_option('gspro_legacy_js_url', $gspro_legacy_js_default);
        echo '<script nomodule="" src="' . $src . '"></script>';
    }

    public function enqueue_modern_webcomponents()
    {
        $gspro_modern_js_default = 'https://unpkg.com/@goodshuffle/gspro-wc@0.5.6/dist/gspro-wc/gspro-wc.esm.js';
        $src = get_option('gspro_modern_js_url', $gspro_modern_js_default);
        echo '<script type="module" src="' . $src . '"></script>';
    }

    /**
     * Register the stylesheets for the public-facing side of the site.
     *
     * @since    0.1.0
     */
    public function enqueue_styles()
    {
        wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/gspro-gallery-public.css', array(), $this->version, 'all');
    }

    /**
     * Register the JavaScript for the public-facing side of the site.
     *
     * @since    0.1.0
     */
    public function enqueue_scripts()
    {
        wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/gspro-gallery-public.css', array(), $this->version, 'all');
        wp_enqueue_script($this->plugin_name . '-gal', plugin_dir_url(__FILE__) . 'js/gspro-gallery-public.js', array(), $this->version, false);
    }

    public function list_inject()
    {
        add_filter('the_content', function ($template) {
            if (in_the_loop() && is_main_query()) {
                $view = plugin_dir_path(__FILE__) . 'partials/gspro-gallery-list.php';
                $slug = get_option('gspro_gallery_page_name');
                if (is_page($slug) && file_exists($view)) {
                    include_once('partials/gspro-gallery-list.php');
                }
            }
            return $template;
        });
    }

}
