<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://github.com/goodshuffle/wp-gspro-gallery
 * @since             0.1.0
 * @package           Gspro_Gallery
 *
 * @wordpress-plugin
 * Plugin Name:       Goodshuffle Website Integration
 * Plugin URI:        http://github.com/goodshuffle/wp-gspro-gallery
 * Description:       Attract new leads and save hours of time on sales by integrating your Goodshuffle Pro inventory system directly with your WordPress website.
 * Version:           0.5.6
 * Author:            The Goodshuffle Team
 * Author URI:        http://github.com/goodshuffle
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       gspro-gallery
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}

/**
 * Currently plugin version.
 * Use SemVer - https://semver.org
 * We will bump to version 1.0.0 when a WordPress marketplace plugin is released.
 */
define('GSPRO_GALLERY_VERSION', '0.5.6');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-gspro-gallery-activator.php
 */
function activate_gspro_gallery()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-gspro-gallery-activator.php';
	Gspro_Gallery_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-gspro-gallery-deactivator.php
 */
function deactivate_gspro_gallery()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-gspro-gallery-deactivator.php';
	Gspro_Gallery_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_gspro_gallery');
register_deactivation_hook(__FILE__, 'deactivate_gspro_gallery');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-gspro-gallery.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    0.1.0
 */
function run_gspro_gallery()
{

	$plugin = new Gspro_Gallery();
	$plugin->run();
}
run_gspro_gallery();
