<?php

/**
 * Provide admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       http://github.com/goodshuffle/gspro-gallery
 * @since      0.1.0
 *
 * @package    Gspro_Gallery
 * @subpackage Gspro_Gallery/admin/partials
 */
?>

<?php
error_reporting(E_ALL);
ini_set('display_errors', true);
?>

<div class="gs-admin">
    <div class="gs-admin-header">
        <div class="gs-admin-pull-left">
            <img src="<?php echo esc_url(plugins_url('../img/brand@3x.png', __FILE__)); ?>" alt="gspro" width="239"/>
        </div>
        <div class="gs-admin-pull-right">
            <a href="http://help.goodshuffle.com/en/articles/3517420-how-can-i-connect-my-goodshuffle-pro-account-with-my-wordpress-site"
               target="_blank" rel="noopener" class="button gs-admin-help">Help</a>
        </div>
    </div>

    <div>
        <h2>Connect your Account</h2>
        <?php
        if (isset($_REQUEST['gspro_settings_form'])) {
            $company = sanitize_text_field($_POST['gspro_company_key']);
            update_option('gspro_company_key', $company);

            $gspro_gallery_page_name = sanitize_text_field($_POST['gspro_gallery_page_name']);
            update_option('gspro_gallery_page_name', $gspro_gallery_page_name);

            $gspro_default_category = sanitize_text_field($_POST['gspro_default_category']);
            update_option('gspro_default_category', $gspro_default_category);

            $gspro_default_group = sanitize_text_field($_POST['gspro_default_group']);
            update_option('gspro_default_group', $gspro_default_group);

            $gspro_default_tags = sanitize_text_field($_POST['gspro_default_tags']);
            update_option('gspro_default_tags', $gspro_default_tags);

            $gspro_default_search = sanitize_text_field($_POST['gspro_default_search']);
            update_option('gspro_default_search', $gspro_default_search);

            $gspro_default_item_list_size = sanitize_text_field($_POST['gspro_default_item_list_size']);
            update_option('gspro_default_item_list_size', $gspro_default_item_list_size);

            $gspro_scope_attribute_name = sanitize_text_field($_POST['gspro_scope_attribute_name']);
            update_option('gspro_scope_attribute_name', $gspro_scope_attribute_name);

            $gspro_scope_attribute_value = sanitize_text_field($_POST['gspro_scope_attribute_value']);
            update_option('gspro_scope_attribute_value', $gspro_scope_attribute_value);

            $gspro_wishlist_alias = sanitize_text_field($_POST['gspro_wishlist_alias']);
            update_option('gspro_wishlist_alias', $gspro_wishlist_alias);

            $gspro_notes_help_text = sanitize_text_field($_POST['gspro_notes_help_text']);
            update_option('gspro_notes_help_text', $gspro_notes_help_text);

            if (isset($_POST['gspro_wishlist_active'])) {
                update_option('gspro_wishlist_active', true);
                $gspro_wishlist_active = true;
            } else {
                delete_option('gspro_wishlist_active');
                $gspro_wishlist_active = false;
            }

            if (isset($_POST['gspro_disable_scroll_lock'])) {
                update_option('gspro_disable_scroll_lock', true);
                $gspro_disable_scroll_lock = true;
            } else {
                delete_option('gspro_disable_scroll_lock');
                $gspro_disable_scroll_lock = false;
            }

            if (isset($_POST['gspro_show_categories'])) {
                update_option('gspro_show_categories', true);
                $gspro_show_categories = true;
            } else {
                delete_option('gspro_show_categories');
                $gspro_show_categories = false;
            }

            if (isset($_POST['gspro_show_filters'])) {
                update_option('gspro_show_filters', true);
                $gspro_show_filters = true;
            } else {
                delete_option('gspro_show_filters');
                $gspro_show_filters = false;
            }

            if (isset($_POST['gspro_disable_time_selection'])) {
                update_option('gspro_disable_time_selection', true);
                $gspro_disable_time_selection = true;
            } else {
                delete_option('gspro_disable_time_selection');
                $gspro_disable_time_selection = false;
            }

            if (isset($_POST['gspro_show_quantity_on_card'])) {
                update_option('gspro_show_quantity_on_card', true);
                $gspro_show_quantity_on_card = true;
            } else {
                delete_option('gspro_show_quantity_on_card');
                $gspro_show_quantity_on_card = false;
            }

            if (isset($_POST['gspro_show_quantity_on_detail'])) {
                update_option('gspro_show_quantity_on_detail', true);
                $gspro_show_quantity_on_detail = true;
            } else {
                delete_option('gspro_show_quantity_on_detail');
                $gspro_show_quantity_on_detail = false;
            }

            if (isset($_POST['gspro_require_phone'])) {
                update_option('gspro_require_phone', true);
                $gspro_require_phone = true;
            } else {
                delete_option('gspro_require_phone');
                $gspro_require_phone = false;
            }

            ?>
            <div>
                <p><strong>Settings updated.</strong></p>
            </div>
            <?php
        } else {
            $company = get_option('gspro_company_key');
            $gspro_wishlist_active = get_option('gspro_wishlist_active', false);
            $gspro_disable_scroll_lock = get_option('gspro_disable_scroll_lock', false);
            $gspro_show_categories = get_option('gspro_show_categories', true);
            $gspro_show_filters = get_option('gspro_show_filters', true);
            $gspro_disable_time_selection = get_option('gspro_disable_time_selection', false);
            $gspro_show_quantity_on_card = get_option('gspro_show_quantity_on_card', false);
            $gspro_show_quantity_on_detail = get_option('gspro_show_quantity_on_detail', false);
            $gspro_require_phone = get_option('gspro_require_phone', false);
            $gspro_gallery_page_name = get_option('gspro_gallery_page_name', 'goodshuffle');
            $gspro_default_category = get_option('gspro_default_category', '');
            $gspro_default_group = get_option('gspro_default_group', '');
            $gspro_default_search = get_option('gspro_default_search', '');
            $gspro_default_tags = get_option('gspro_default_tags', '');
            $gspro_default_item_list_size = get_option('gspro_default_item_list_size', '20');
            $gspro_scope_attribute_name = get_option('gspro_scope_attribute_name', '');
            $gspro_scope_attribute_value = get_option('gspro_scope_attribute_value', '');
            $gspro_wishlist_alias = get_option('gspro_wishlist_alias', 'Wishlist');
            $gspro_notes_help_text = get_option('gspro_notes_help_text', '');

        }
        ?>
        <p class="gs-admin-subtitle">
            Need one? <a href="https://pro.goodshuffle.com/signup" target="_blank" rel="noopener">Sign-up!</a>.
        </p>
        <hr/>
        <form name="gspro_form" method="post" action="<?= $_SERVER['REQUEST_URI'] ?>">
            <input type="hidden" name="gspro_settings_form" value="yes">
            <table class="form-table">
                <tbody>
                <tr>
                    <th scope="row">
                        <label for="gspro_company_key">Public Browser Key</label>
                    </th>
                    <td>
                        <input type="text" name="gspro_company_key" value="<?= $company ?>" size="20"
                               class="regular-text">
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_gallery_page_name">Display Gallery on Page</label>
                    </th>
                    <td>
                        <input type="text" name="gspro_gallery_page_name" value="<?= $gspro_gallery_page_name ?>"
                               size="20" class="regular-text">
                        <p class="description">The page slug where your gallery will be displayed.</p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_default_category">Default Gallery Category</label>
                    </th>
                    <td>
                        <input type="text" name="gspro_default_category" value="<?= $gspro_default_category ?>"
                               size="20" class="regular-text">
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_default_group">Default Gallery Group</label>
                    </th>
                    <td>
                        <input type="text" name="gspro_default_group" value="<?= $gspro_default_group ?>" size="20"
                               class="regular-text">
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_default_search"">Default Gallery Search</label>
                    </th>
                    <td>
                        <input type="text" name="gspro_default_search" value="<?= $gspro_default_search ?>" size="20"
                               class="regular-text">
                        <p class="description">Use keyword search to select initially displayed items?</p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_default_tags">Default Gallery Tags</label>
                    </th>
                    <td>
                        <input type="text" name="gspro_default_tags" value="<?= $gspro_default_tags ?>" size="20"
                               class="regular-text">
                        <p class="description">Use tags to select initially displayed items?</p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_default_item_list_size">Default # of Items Listed</label>
                    </th>
                    <td>
                        <input type="text" name="gspro_default_item_list_size"
                               value="<?= $gspro_default_item_list_size ?>" size="20" class="regular-text">
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_scope_attribute_name">Scoped Attribute Name</label>
                    </th>
                    <td>
                        <input type="text" name="gspro_scope_attribute_name"
                               value="<?= $gspro_scope_attribute_name ?>" size="30" class="regular-text">
                        <p class="description">
                            Restricts the gallery's displayed items using attributes. This field is
                            the item attribute name. <br/> For example: Warehouse Location
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_scope_attribute_value">Scope Attribute Values</label>
                    </th>
                    <td>
                        <input type="text" name="gspro_scope_attribute_value"
                               value="<?= $gspro_scope_attribute_value ?>" size="100" class="regular-text">
                        <p class="description">
                            Paired with Scoped Attribute Name, this field is the item attribute
                            values. Multiple values are separated with a | character. <br/> For example: San Fransisco | Austin | New
                            York
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_wishlist_alias">Wishlist Alias</label>
                    </th>
                    <td>
                        <input type="text" name="gspro_wishlist_alias"
                               value="<?= $gspro_wishlist_alias ?>" size="100" class="regular-text">
                        <p class="description">
                            Changes the label on the Website Integration "Cart". Default is 'Wishlist'.
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_show_categories">Show Categories</label>
                    </th>
                    <td>
                        <label>
                            <input type="checkbox" id="gspro_show_categories" name="gspro_show_categories"
                                   value="true" <?= $gspro_show_categories ? "checked" : "" ?>>
                            Display list of clickable categories.
                        </label>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_show_filters">Show Filters</label>
                    </th>
                    <td>
                        <label>
                            <input type="checkbox" id="gspro_show_filters" name="gspro_show_filters"
                                   value="true" <?= $gspro_show_filters ? "checked" : "" ?>>
                            Display expandable button to filter by attribute.
                        </label>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_wishlist_active">Wishlist</label>
                    </th>
                    <td>
                        <label>
                            <input type="checkbox" id="gspro_wishlist_active" name="gspro_wishlist_active"
                                   value="true" <?= $gspro_wishlist_active ? "checked" : "" ?>>
                            Display wishlist on all pages.
                        </label>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_disable_scroll_lock">Scroll Lock</label>
                    </th>
                    <td>
                        <label>
                            <input type="checkbox" id="gspro_disable_scroll_lock" name="gspro_disable_scroll_lock"
                                   value="true" <?= $gspro_disable_scroll_lock ? "checked" : "" ?>>
                            Disable body scroll lock.
                        </label>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_disable_time_selection">Time Selection</label>
                    </th>
                    <td>
                        <label>
                            <input type="checkbox" id="gspro_disable_time_selection" name="gspro_disable_time_selection"
                                   value="true" <?= $gspro_disable_time_selection ? "checked" : "" ?>>
                            Disable time selection.
                        </label>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_show_quantity_on_card">Quantity on Cards</label>
                    </th>
                    <td>
                        <label>
                            <input type="checkbox" id="gspro_show_quantity_on_card" name="gspro_show_quantity_on_card"
                                   value="true" <?= $gspro_show_quantity_on_card ? "checked" : "" ?>>
                            Show quantities on item cards.
                        </label>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_show_quantity_on_detail">Quantity on Detail</label>
                    </th>
                    <td>
                        <label>
                            <input type="checkbox" id="gspro_show_quantity_on_detail" name="gspro_show_quantity_on_detail"
                                   value="true" <?= $gspro_show_quantity_on_detail ? "checked" : "" ?>>
                            Show quantity on item detail popups.
                        </label>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_require_phone">Require Phone Numbers</label>
                    </th>
                    <td>
                        <label>
                            <input type="checkbox" id="gspro_require_phone" name="gspro_require_phone"
                                   value="true" <?= $gspro_require_phone ? "checked" : "" ?>>
                            Require phone numbers on wishlist submissions.
                        </label>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="gspro_notes_help_text">Notes Help Text</label>
                    </th>
                    <td>
                        <input type="text" name="gspro_notes_help_text"
                               value="<?= $gspro_notes_help_text ?>" size="100" class="regular-text">
                        <p class="description">
                            Adds help text below the label for the "Notes" field.
                        </p>
                    </td>
                </tr>
                </tbody>
            </table>
            <div class="submit">
                <input type="submit" name="Submit" value="<?php _e('Update Options', 'gspro_trdom') ?>"
                       class="button button-primary"/>
            </div>
        </form>
    </div>

    <?php

    # TBD: Provide a built-in library?
    # $gspro_modern_js_default = '/wp-content/plugins/gspro-gallery/public/js/dist/gspro-wc/gspro-wc.esm.js';
    # $gspro_legacy_js_default = '/wp-content/plugins/gspro-gallery/public/js/dist/gspro-wc/gspro-wc.js';

    $gspro_modern_js_default = 'https://unpkg.com/@goodshuffle/gspro-wc@0.5.6/dist/gspro-wc/gspro-wc.esm.js';
    $gspro_legacy_js_default = 'https://unpkg.com/@goodshuffle/gspro-wc@0.5.6/dist/gspro-wc/gspro-wc.js';

    if (isset($_GET['advanced'])) {
        ?>
        <div>
            <h2>Advanced Settings</h2>
            <?php
            if (isset($_REQUEST['gspro_developer_form'])) {
                ?>
                <div><strong>Advanced options saved.</strong></div>
                <?php
                if (empty($_POST['gspro_legacy_js_url'])) {
                    delete_option('gspro_legacy_js_url');
                } else {
                    $gspro_legacy_js_url = sanitize_text_field($_POST['gspro_legacy_js_url']);
                    update_option('gspro_legacy_js_url', $gspro_legacy_js_url);
                }
                if (empty($_POST['gspro_modern_js_url'])) {
                    delete_option('gspro_modern_js_url');
                } else {
                    $gspro_modern_js_url = sanitize_text_field($_POST['gspro_modern_js_url']);
                    update_option('gspro_modern_js_url', $gspro_modern_js_url);
                }
                $gspro_data_url = sanitize_text_field($_POST['gspro_data_url']);
                if (empty($gspro_data_url)) {
                    delete_option('gspro_data_url');
                } else {
                    update_option('gspro_data_url', $gspro_data_url);
                }
                $gspro_icon_url = sanitize_text_field($_POST['gspro_icon_url']);
                if (empty($gspro_icon_url)) {
                    delete_option('gspro_icon_url');
                } else {
                    update_option('gspro_icon_url', $gspro_icon_url);
                }
            }
            $gspro_modern_js_url = get_option('gspro_modern_js_url', $gspro_modern_js_default);
            $gspro_legacy_js_url = get_option('gspro_legacy_js_url', $gspro_legacy_js_default);
            $gspro_data_url = get_option('gspro_data_url', 'https://data.goodshuffle.com/vendor');
            $gspro_icon_url = get_option('gspro_icon_url', plugins_url('/gspro-gallery/public/img/icons.svg'));
            ?>
            <p class="gs-admin-subtitle">
                Changing these settings without a full understanding of what they do may
                cause serious problems with your site.
            </p>
            <hr/>
            <form name="gspro_developer_form" method="post" action="<?= $_SERVER['REQUEST_URI'] ?>">
                <input type="hidden" name="gspro_developer_form" value="yes">
                <table class="form-table">
                    <tbody>
                    <tr>
                        <th scope="row">
                            <label for="gspro_data_url">Data Source</label>
                        </th>
                        <td>
                            <input type="text" name="gspro_data_url" value="<?= $gspro_data_url ?>" size="20"
                                   class="regular-text">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="gspro_icon_url">Icon URL</label>
                        </th>
                        <td>
                            <input type="text" name="gspro_icon_url" value="<?= $gspro_icon_url ?>" size="20"
                                   class="regular-text">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="gspro_modern_js_url">Modern JS</label>
                        </th>
                        <td>
                            <input type="text" name="gspro_modern_js_url" value="<?= $gspro_modern_js_url ?>" size="20"
                                   class="regular-text">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="gspro_legacy_js_url">Legacy JS</label>
                        </th>
                        <td>
                            <input type="text" name="gspro_legacy_js_url" value="<?= $gspro_legacy_js_url ?>" size="20"
                                   class="regular-text">
                        </td>
                    </tr>
                    </tbody>
                </table>
                <div class="submit">
                    <input type="submit" name="Submit" value="<?php _e('Save Advanced Options', 'gspro_trdom') ?>"
                           class="button button-primary"/>
                </div>
            </form>
        </div>
    <?php } ?>

</div>
