<?php

/**
 * Register the shortcodes provided by this plugin.
 *
 * @link       http://github.com/goodshuffle/gspro-gallery
 * @since      0.1.0
 *
 * @package    Gspro_Gallery
 * @subpackage Gspro_Gallery/includes
 */
 
/**
 * Register the shortcodes provided by this plugin.
 *
 * @package    Gspro_Gallery
 * @subpackage Gspro_Gallery/includes
 * @author     Jon Morton <jon@goodshuffle.com>
 */
class Gspro_Gallery_Shortcodes
{

  public function __construct()
  {
    add_shortcode('gspro-gallery', array($this, 'gspro_gallery'));
    add_shortcode('gspro-item', array($this, 'gspro_item'));
    add_shortcode('gspro-item-list', array($this, 'gspro_item-list'));
    add_shortcode('gspro-wishlist', array($this, 'gspro_wishlist'));
    add_shortcode('gspro-setup', array($this, 'gspro_setup'));
    add_shortcode('gspro-item-detail', array($this, 'gspro_detail'));
  }

  public function gspro_gallery($atts) {
    $default = shortcode_atts(array(
      'default-category' => ''
    ), $atts);
    return
    '<div id="gspro">' .
      '<button id="gspro-category-toggle" class="gspro-o-btn toggle">Categories</button>' .
      '<gspro-categories></gspro-categories>' .
      '<gspro-item-list category="' . $default['default-category'] . '"></gspro-item-list>' .
      '<gspro-wishlist></gspro-wishlist>' .
      '<gspro-item-detail data-mode="inactive" ></gspro-item-detail>' .
    '</div>';
  }

  public function gspro_item($atts, $content = "")
  {
    $a = shortcode_atts(array(
      'item-id' => 'missing'
    ), $atts);
    $e = "<gspro-item-card item-id={$a['item-id']}></gspro-item-card>";
    return $e;
  }

  public function gspro_item_list($atts, $content = "")
  {
    $a = shortcode_atts(array(
      'tags' => '*'
    ), $atts);
    $e = "<gspro-item-list category={$a['category']}></gspro-item-list>";
    return $e;
  }

  public function gspro_wishlist($atts, $content = "")
  {
    $a = shortcode_atts(array(
      'id' => 'missing'
    ), $atts);
    $e =
      "<gspro-wishlist></gspro-wishlist>";
    return $e;
  }

  public function gspro_detail($atts, $content = "")
  {
    $a = shortcode_atts(array(
      'id' => 'missing'
    ), $atts);
    $item_id = get_query_var("item_id", "missing");
    $e =
      "<gspro-item-detail item-id={$item_id}></gspro-item-detail>";
    return $e;
  }

  /**
   * Add attributes to avoid loading incompatible scripts.
   * 
   * `wp_enqueue_script` does not accept parameters that generate `type` or `nomodule` attributes.
   */
  // public function modern_script($tag, $handle, $src)
  // {
  //   return '<script type="module" src="' . $src . '"></script>';
  // }

  // public function legacy_script($tag) {
  //   return '<script nomodule src="' . $src . '"></script>';
  // }

}
