<?php
define ( 'JS_PATH' , get_template_directory_uri().'/inc/shortcodes/customcodes.js');


add_action('admin_head','html_quicktags');
function html_quicktags() {

	$output = "<script type='text/javascript'>\n
	/* <![CDATA[ */ \n";
	wp_print_scripts( 'quicktags' );

	$buttons = array();

	/*$buttons[] = array(
		'name' => 'raw',
		'options' => array(
			'display_name' => 'raw',
			'open_tag' => '\n[raw]',
			'close_tag' => '[/raw]\n',
			'key' => ''
	));*/


	$buttons[] = array(
		'name' => 'ads1',
		'options' => array(
			'display_name' => 'ADS1',
			'open_tag' => '\n[ads1]',
			'close_tag' => '',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'ads2',
		'options' => array(
			'display_name' => 'ADS2',
			'open_tag' => '\n[ads2]',
			'close_tag' => '',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'is_logged_in',
		'options' => array(
			'display_name' => 'is logged in',
			'open_tag' => '\n[is_logged_in]',
			'close_tag' => '[/is_logged_in]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'is_guest',
		'options' => array(
			'display_name' => 'is guest',
			'open_tag' => '\n[is_guest]',
			'close_tag' => '[/is_guest]\n',
			'key' => ''
	));


	$buttons[] = array(
		'name' => 'one_third',
		'options' => array(
			'display_name' => 'one third',
			'open_tag' => '\n[one_third]',
			'close_tag' => '[/one_third]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'one_third_last',
		'options' => array(
			'display_name' => 'one third last',
			'open_tag' => '\n[one_third_last]',
			'close_tag' => '[/one_third_last]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'two_third',
		'options' => array(
			'display_name' => 'two third',
			'open_tag' => '\n[two_third]',
			'close_tag' => '[/two_third]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'two_third_last',
		'options' => array(
			'display_name' => 'two third last',
			'open_tag' => '\n[two_third_last]',
			'close_tag' => '[/two_third_last]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'one_half',
		'options' => array(
			'display_name' => 'one half',
			'open_tag' => '\n[one_half]',
			'close_tag' => '[/one_half]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'one_half_last',
		'options' => array(
			'display_name' => 'one half last',
			'open_tag' => '\n[one_half_last]',
			'close_tag' => '[/one_half_last]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'one_fourth',
		'options' => array(
			'display_name' => 'one fourth',
			'open_tag' => '\n[one_fourth]',
			'close_tag' => '[/one_fourth]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'one_fourth_last',
		'options' => array(
			'display_name' => 'one fourth last',
			'open_tag' => '\n[one_fourth_last]',
			'close_tag' => '[/one_fourth_last]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'three_fourth',
		'options' => array(
			'display_name' => 'three fourth',
			'open_tag' => '\n[three_fourth]',
			'close_tag' => '[/three_fourth]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'three_fourth_last',
		'options' => array(
			'display_name' => 'three fourth last',
			'open_tag' => '\n[three_fourth_last]',
			'close_tag' => '[/three_fourth_last]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'one_fifth',
		'options' => array(
			'display_name' => 'one fifth',
			'open_tag' => '\n[one_fifth]',
			'close_tag' => '[/one_fifth]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'one_fifth_last',
		'options' => array(
			'display_name' => 'one fifth last',
			'open_tag' => '\n[one_fifth_last]',
			'close_tag' => '[/one_fifth_last]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'two_fifth',
		'options' => array(
			'display_name' => 'two fifth',
			'open_tag' => '\n[two_fifth]',
			'close_tag' => '[/two_fifth]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'two_fifth_last',
		'options' => array(
			'display_name' => 'two fifth last',
			'open_tag' => '\n[two_fifth_last]',
			'close_tag' => '[/two_fifth_last]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'three_fifth',
		'options' => array(
			'display_name' => 'three fifth',
			'open_tag' => '\n[three_fifth]',
			'close_tag' => '[/three_fifth]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'three_fifth_last',
		'options' => array(
			'display_name' => 'three fifth last',
			'open_tag' => '\n[three_fifth_last]',
			'close_tag' => '[/three_fifth_last]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'four_fifth',
		'options' => array(
			'display_name' => 'four fifth',
			'open_tag' => '\n[four_fifth]',
			'close_tag' => '[/four_fifth]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'four_fifth_last',
		'options' => array(
			'display_name' => 'four fifth last',
			'open_tag' => '\n[four_fifth_last]',
			'close_tag' => '[/four_fifth_last]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'one_sixth',
		'options' => array(
			'display_name' => 'one sixth',
			'open_tag' => '\n[one_sixth]',
			'close_tag' => '[/one_sixth]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'one_sixth_last',
		'options' => array(
			'display_name' => 'one sixth last',
			'open_tag' => '\n[one_sixth_last]',
			'close_tag' => '[/one_sixth_last]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'five_sixth',
		'options' => array(
			'display_name' => 'five sixth',
			'open_tag' => '\n[five_sixth]',
			'close_tag' => '[/five_sixth]\n',
			'key' => ''
	));

	$buttons[] = array(
		'name' => 'five_sixth_last',
		'options' => array(
			'display_name' => 'five sixth last',
			'open_tag' => '\n[five_sixth_last]',
			'close_tag' => '[/five_sixth_last]\n',
			'key' => ''
	));


	for ($i=0; $i <= (count($buttons)-1); $i++) {
		$output .= "edButtons[edButtons.length] = new edButton('ed_{$buttons[$i]['name']}'
			,'{$buttons[$i]['options']['display_name']}'
			,'{$buttons[$i]['options']['open_tag']}'
			,'{$buttons[$i]['options']['close_tag']}'
			,'{$buttons[$i]['options']['key']}'
		); \n";
	}

	$output .= "\n /* ]]> */ \n
	</script>";
	echo $output;
}



function asalah_custom_addbuttons() {
	if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') )
		return;

	if ( get_user_option('rich_editing') == 'true') {
		add_filter("mce_external_plugins", "add_tcustom_tinymce_plugin");
		add_filter('mce_buttons_3', 'register_tcustom_button');
	}
}
function register_tcustom_button($buttons) {
	array_push(
		$buttons,
		"AddBox",
		"AddAlert",
		"AddButtons",		"Toggle",
		"|",
		"AddMap",
		"|",
		"highlight",
		"dropcap",
		"|",
		"checklist",
		"starlist",
		"|",
		"Video",
		"|",
		"Tooltip",
		"ShareButtons",
		"divider"	);
	return $buttons;
}
function add_tcustom_tinymce_plugin($plugin_array) {
	$plugin_array['asalahShortCodes'] = JS_PATH;
	return $plugin_array;
}


## Team -------------------------------------------------- #
function asalah_shortcode_team( $atts, $content = null ) {
    @extract($atts);
	//title
	//number
	$title = (isset($title)) ? ' '.$title : __('Team', 'asalah');
	$number = (isset($number)) ? ' '.$number : '4';
	$max = (isset($max)) ? ' '.$max : '4';
	$block_id = "team_car_".random_id(25);
	$url ="";
	$number;
	$desc = "";
	$cycle ="";
	$wp_query = new WP_Query(array('post_type' => 'team', 'posts_per_page' => $number));



	$out = '<div class="team_carousel team_car" id="'. $block_id.'">';
		$out .= '<h3 class="page-header"><span class="page_header_title">'.$title.'</span><span class="right_car_arrow3 cars_arrow_control right_car_arrow hidden" style="display: none;"><i class="icon-angle-right"></i></span><span class="left_car_arrow3 cars_arrow_control left_car_arrow hidden" style="display: none;"><i class="icon-angle-left"></i></span></h3>';
		$out .= '<div class="carousel">';
			$out .= '<div class="slides list_carousel responsive clearfix">';
			$out .= '<div class="team_cars">';
				while ( $wp_query->have_posts() ) : $wp_query->the_post();
				$get_meta = get_post_custom(get_the_ID());
				$out .= '<div class="the_portfolio_list_li_div" id="post-' . get_the_ID() . '">';
				$out .= '<div class="portfolio_item team_item">';
					$out .= '<div class="portfolio_thumbnail">';
						$out .= asalah_get_blog_thumb("370","240");

					$out .='</div>';
					$out .= '<div class="portfolio_info">';
						$out .='<h4>'.get_the_title().'</h4>';
						if ($get_meta["asalah_team_position"][0] != "" ):
						$out .= '<div class="portfolio_time">'.$get_meta["asalah_team_position"][0].'</div>';
						endif;

						if ($get_meta["asalah_team_fb"][0] != "" || $get_meta["asalah_team_tw"][0] != "" || $get_meta["asalah_team_gp"][0] != "" || $get_meta["asalah_team_linked"][0] != "" || $get_meta["asalah_team_pin"][0] != "" || $get_meta["asalah_team_mail"][0] != "") {

						$out .= '<div class="team_social_bar clearfix">';
							$out .= '<ul class="team_social_list">';
								if ($get_meta["asalah_team_fb"][0] != "") {
									$out .= '<li><a target="_blank" href="'.$get_meta["asalah_team_fb"][0].'"><i class="icon-facebook" title="Facebook"></i></a></li>';
								}
								if ($get_meta["asalah_team_tw"][0] != "" ) {
									$out .= '<li><a target="_blank" href="'. $get_meta["asalah_team_tw"][0].'"><i class="icon-twitter" title="Twitter"></i></a></li>';
								}
								if ($get_meta["asalah_team_gp"][0] != "" ) {
									$out .='<li><a target="_blank" href="'.$get_meta["asalah_team_gp"][0].'"><i class="icon-gplus" title="Google Plus"></i></a></li>';
								}
								if ($get_meta["asalah_team_linked"][0] != "" ) {
									$out .= '<li><a target="_blank" href="'.$get_meta["asalah_team_linked"][0].'"><i class="icon-linkedin" title="Linkedin"></i></a></li>';
								}
								if ($get_meta["asalah_team_pin"][0] != "" ) {
									$out .= '<li><a target="_blank" href="'.$get_meta["asalah_team_pin"][0].'"><i class="icon-pinterest" title="Pinterest"></i></a></li>';
								}
								if ($get_meta["asalah_team_mail"][0] != "" ) {
									$out .='<li><a href="mailto:'.$get_meta["asalah_team_mail"][0].'"><i class="icon-mail" title="Mail"></i></a></li>';
								}
							$out .='</ul>';
						$out .='</div>';
					   }

					$out .='</div>';
				$out .= '</div>';
				$out .= '</div>';
				endwhile;
			$out .= '</div>';
			$out .= '</div>';
		$out .= '</div>';
	$out .= '</div>';

	$out .='<script type="text/javascript" language="javascript">';
	$out .= 'jQuery(document).ready(function() {';
	$out .= 'jQuery("#'.$block_id.' .team_cars").carouFredSel({';
		$out .= 'responsive: true,';
		$out .= 'prev: "#'.$block_id.' .left_car_arrow3",';
		$out .= 'next: "#'.$block_id.' .right_car_arrow3",';
		$out .= 'auto: false,';
		$out .= 'swipe: {';
			$out .= 'onTouch: true,';
		$out .= '},';
		$out .= 'items: {';
			$out .= 'visible: {';
				$out .= 'min: 1,';
				$out .= 'max: ' . $max;
			$out .= '}';
		$out .= '}';
	$out .= '});';

	$out .= 'jQuery("#'.$block_id.' .team_cars").imagesLoaded( function() {';
	$out .= 'jQuery("#'.$block_id.' .team_cars").carouFredSel({';
		$out .= 'responsive: true,';
		$out .= 'prev: "#'.$block_id.' .left_car_arrow3",';
		$out .= 'next: "#'.$block_id.' .right_car_arrow3",';
		$out .= 'auto: false,';
		$out .= 'swipe: {';
			$out .= 'onTouch: true,';
		$out .= '},';
		$out .= 'items: {';
			$out .= 'visible: {';
				$out .= 'min: 1,';
				$out .= 'max: ' . $max;
			$out .= '}';
		$out .= '}';
	$out .= '});';
	$out .= '});';
	$out .= '});';
	$out .= '</script>';
	return $out;
	wp_reset_query();
}
add_shortcode('team', 'asalah_shortcode_team');

## Projects -------------------------------------------------- #
function asalah_shortcode_projects( $atts, $content = null ) {
    @extract($atts);
	//title
	//number
	$title = (isset($title)) ? ' '.$title : __('Projects', 'asalah');
	$number = (isset($number)) ? ' '.$number : '4';
	$max = (isset($max)) ? ' '.$max : '4';
	$url = (isset($url)) ? ' '.$url : '';
	$block_id = "project_car_".random_id(25);
	$number;
	$desc = (isset($desc)) ? $desc : "";
	$cycle = (isset($cycle)) ? $cycle : "";
	$pos = (isset($pos)) ? $pos : '' ;
	$tags_ids = (isset($tags_ids)) ? $tags_ids : '' ;
	$exception = (isset($exception)) ? $exception : '' ;
	$posttype= (isset($posttype)) ? $posttype : 'project';
	$projects_order = (isset($projects_order)) ? $projects_order : 'date';
	$autoplay = (isset($autoplay_car) && ($autoplay_car == 'yes')) ? 'true' : 'false';

	if ($exception == '') {
		$args = array('post_type' => $posttype, 'posts_per_page' => $number);
	}else{
		$args = array('post_type' => $posttype, 'posts_per_page' => $number, 'post__not_in' => array($exception));
	}

	if ($tags_ids != '') {
		$args['tagportfolio'] = $tags_ids;
	}

	if ($projects_order != '') {
		$args['orderby'] = $projects_order;
		if ($projects_order == 'title') {
			$args['order'] = 'ASC';
		}
	}
	$wp_query = new WP_Query($args);


	$out = '<div class="portfolio_carousel" id="'. $block_id.'">';
		$out .= '<h3 class="page-header"><span class="page_header_title">';
			if ($url == ''):
			$out .= $title;
			else:
			$out .= '<a href="'. $url.'" title="'. $title.'">'.$title.'</a>';
			endif;
			$out .='</span><span class="right_car_arrow1 cars_arrow_control right_car_arrow"><i class="icon-angle-right"></i></span><span class="left_car_arrow1 cars_arrow_control left_car_arrow"><i class="icon-angle-left"></i></span></h3>';
		$out .= '<div class="carousel">';
			$out .= '<div class="slides list_carousel responsive clearfix">';
			$out .= '<div class="portfolio_cars">';
				while ( $wp_query->have_posts() ) : $wp_query->the_post();
				$out .= '<div class="the_portfolio_list_li_div" id="post-'.get_the_ID().'">';
				$out .= '<div class="portfolio_item">';
				$out .= get_asalah_slideshow();
					$out .= '<div class="portfolio_thumbnail">';
						$out .= asalah_get_blog_thumb("370","240");
						$out .= '<div class="portfolio_overlay">';
						$out .= '</div>';
						$out .= '<div class="center-bar">';
						if (isset($asalah_data['asalah_portfolio_icon']) && $asalah_data['asalah_portfolio_icon'] == 'url'):
							$out .= '<a class="icon-link" href="'.get_the_permalink().'"></a>';
							else:
							$out .= '<a class="prettyPhotolink icon-search goup" rel="slideshow_'. get_the_ID() .'"></a>';
							endif;
						$out .='</div>';

					$out .= '</div>';
					$out .= '<div class="portfolio_info">';
						$out .= '<a href="'.get_permalink().'"><h5>'. get_the_title().'</h5></a>';
						$post_id = get_the_ID();
						$tags_list = get_the_term_list( $post_id , 'tagportfolio', '',', ','');
						$out .= '<span class="portfolio_category">'.$tags_list.'</span>';
					$out .= '</div>';
				$out .= '</div>';
				$out .= '</div>';
				endwhile;
			$out .= '</div>';
			$out .= '</div>';
		$out .= '</div>';
	$out .= '</div>';

	$out .='<script type="text/javascript" language="javascript">';
	$out .= 'jQuery(document).ready(function() {';
	$out .= 'jQuery("#'.$block_id.' .portfolio_cars").carouFredSel({';
		$out .= 'responsive: true,';
		$out .= 'prev: "#'.$block_id.' .left_car_arrow1",';
		$out .= 'next: "#'.$block_id.' .right_car_arrow1",';
		$out .= 'auto: '.$autoplay.',';
		$out .= 'scroll: {items: 4},';
		$out .= 'swipe: {';
			$out .= 'onTouch: true,';
		$out .= '},';
		$out .= 'items: {';
			$out .= 'visible: {';
				$out .= 'min: 1,';
				$out .= 'max: ' . $max;
			$out .= '}';
		$out .= '}';
	$out .= '});';

	$out .= 'jQuery("#'.$block_id.' .portfolio_cars").imagesLoaded( function() {';
	$out .= 'jQuery("#'.$block_id.' .portfolio_cars").carouFredSel({';
		$out .= 'responsive: true,';
		$out .= 'prev: "#'.$block_id.' .left_car_arrow1",';
		$out .= 'next: "#'.$block_id.' .right_car_arrow1",';
		$out .= 'auto: '.$autoplay.',';
		$out .= 'swipe: {';
			$out .= 'onTouch: true,';
		$out .= '},';
		$out .= 'items: {';
			$out .= 'visible: {';
				$out .= 'min: 1,';
				$out .= 'max: ' . $max;
			$out .= '}';
		$out .= '}';
	$out .= '});';
	$out .= '});';

	$out .= '});';
	$out .= "portfolio_thumb_width();";
	$out .= "jQuery(window).resize(function() {";
	$out .= "portfolio_thumb_width();";
  $out .= "});";

	$out .= "function portfolio_thumb_width() {";
	$out .= "var width = jQuery('body .portfolio_carousel').width();";
	$out .= "if (width > 784) {";
	$out .= "if ( (".$max." % 2) == 0) {";
	$out .= "var new_width = ((width - (16 * (".$max.") - 1)) / ".$max.");";
	$out .= "} else {";
	$out .= "var new_width = ((width - (16 * (".$max."))) / ".$max.");";
	$out .= "}";
	$out .= "jQuery('body').append('<style>#".$block_id." .portfolio_cars .the_portfolio_list_li_div { max-width:'+new_width+'px;}');";
  $out .= "} else if ((width <= 784) && (width > 400))  {";
	$out .= "var new_width = (width - 16) / 2;";
	$out .= "jQuery('#".$block_id." .portfolio_cars .the_portfolio_list_li_div').css('max-width', new_width).css('width', new_width);";
  $out .= "} else if (width <= 400) {";
	$out .= "jQuery('#".$block_id." .portfolio_cars .the_portfolio_list_li_div').css('max-width', width);";
	$out .= "}";
	$out .= "}";
	$out .= '</script>';
	return $out;
	wp_reset_query();
}
add_shortcode('projects', 'asalah_shortcode_projects');

## Clients -------------------------------------------------- #
function asalah_shortcode_clients( $atts, $content = null ) {
    @extract($atts);
	//title
	//number
	$title = (isset($title)) ? ' '.$title : __('Clients', 'asalah');
	$number = (isset($number)) ? ' '.$number : '6';

	$block_id = "clients_car_".random_id(25);
	$url ="";
	$desc = "";
	$max = "4";
	$cycle ="";
	global $post;
	$show_number = ((isset($show_number))&&($show_number != '')) ? $show_number : '6';
	$order = (isset($projects_order)) ? $projects_order : 'date';
	if ((isset($autoplay_car))&&($autoplay_car == 'yes')) {
		$autoplay = 'true';
	} else {
		$autoplay = 'false';
	}
	$args = array('post_type' => 'Client', 'posts_per_page' => $number, 'orderby' => $order);
	if ($order == 'title') {
		$args['order'] = 'ASC';
	}
	 $wp_query = new WP_Query($args);

	$out = '<div class="clients_content team_carousel" id="'. $block_id.'">';
		$out .= '<h3 class="page-header"><span class="page_header_title">'.$title.'</span><span class="right_car_arrow3 cars_arrow_control right_car_arrow hidden" style="display: none;"><i class="icon-angle-right"></i></span><span class="left_car_arrow3 cars_arrow_control left_car_arrow hidden" style="display: none;"><i class="icon-angle-left"></i></span></h3>';
		$out .= '<div class="clients_box ">';
			$out .= '<ul class="clients_list">';
			while ( $wp_query->have_posts() ) : $wp_query->the_post();
			$the_client_url = get_post_meta($post->ID, 'client_url', true);
			$out .= '<li><a style="display:block" href="'.$the_client_url.'" target="_blank" class="post-tooltip tooltip-n" original-title="'. get_the_title().'"><div class="client_item clearfix" style="position: relative;">'.get_client_logo().'</div></a></li>';
			endwhile;
			$out .= '</ul>';
		$out .= '</div>';
	$out .= '</div>';


	$out .='<script type="text/javascript" language="javascript">';
	$out .= 'jQuery(document).ready(function() {';
	$out .= 'jQuery("#'.$block_id.' .clients_list").carouFredSel({';
		$out .= 'responsive: true,';
		$out .= 'prev: "#'.$block_id.' .left_car_arrow3",';
		$out .= 'next: "#'.$block_id.' .right_car_arrow3",';
		$out .= 'auto: '.$autoplay.',';
		$out .= 'height: "100%",';
		$out .= 'swipe: {';
			$out .= 'onTouch: true,';
		$out .= '},';
		$out .= 'items: {';
			$out .= 'width: 160,';
			$out .= 'visible: {';
				$out .= 'min: 1,';
				$out .= 'max: '.$show_number;
			$out .= '}';
		$out .= '}';
	$out .= '});';

	$out .= 'jQuery("#'.$block_id.' .clients_list").imagesLoaded( function() {';
	$out .= 'jQuery("#'.$block_id.' .clients_list").carouFredSel({';
		$out .= 'responsive: true,';
		$out .= 'prev: "#'.$block_id.' .left_car_arrow3",';
		$out .= 'next: "#'.$block_id.' .right_car_arrow3",';
		$out .= 'auto: '.$autoplay.',';
		$out .= 'height: "100%",';
		$out .= 'swipe: {';
			$out .= 'onTouch: true,';
		$out .= '},';
		$out .= 'items: {';
			$out .= 'width: 160,';
			$out .= 'visible: {';
				$out .= 'min: 1,';
				$out .= 'max: '.$show_number;
			$out .= '}';
		$out .= '}';
	$out .= '});';
	$out .= '});';

	$out .= '});';
	$out .= '</script>';
	return $out;
}
add_shortcode('clients', 'asalah_shortcode_clients');

## Testimonials -------------------------------------------------- #
function asalah_shortcode_testimonials( $atts, $content = null ) {
    @extract($atts);
	//title
	//number
	$title = (isset($title)) ? $title : __('Testimonials', 'asalah');
	$number = (isset($number)) ? $number : '3';

	$block_id = "testimonials_car_".random_id(25);
	$url ="";
	$number;
	$desc = "";
	$max = "4";
	$cycle ="";
	$wp_query = new WP_Query(array('post_type' => 'testimonial', 'posts_per_page' => $number));


	$out = '<div class="testimonial_content carousel list_carousel responsive clearfix" id="'. $block_id.'">';
	$out .= '<h3 class="page-header"><span class="page_header_title">'.$title.'</span><span class="right_car_arrow3 cars_arrow_control right_car_arrow hidden" style="display: none;"><i class="icon-angle-right"></i></span><span class="left_car_arrow3 cars_arrow_control left_car_arrow hidden" style="display: none;"><i class="icon-angle-left"></i></span></h3>';
		$out .= '<ul class="testy_carousel clearfix">';
			while ( $wp_query->have_posts() ) : $wp_query->the_post();
			$out .= '<li class="clearfix">';
				$out .= '<div class="testimonial_box ">';
					$out .= '<p>'.get_the_content().'</p>';
				$out .= '</div>';
				$out .= '<a target="_blank" href="'. get_testimonial_url().'">';
				$out .= '<div class="testimonials_author clearfix">';

					if ( has_post_thumbnail(get_the_ID()) ){
						$image_url = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) );

						$out .= get_the_post_thumbnail('');
					}
					$out .= '<div class="tetimonials_namejob clearfix">';
					$out .= '<span class="testimonial_name">'.get_testimonial_author().'</span><span class="testimonial_job">'. get_testimonial_job().'</span>';
					$out .= '</div>';
				$out .= '</div>';
				$out .= '</a>';
			$out .= '</li>';
			endwhile;
		$out .= '</ul>';
	$out .= '</div>';

	$out .='<script type="text/javascript" language="javascript">';
	$out .= 'jQuery(document).ready(function() {';
	$out .= 'jQuery("#'.$block_id.' .testy_carousel").carouFredSel({';
		$out .= 'responsive: true,';
		$out .= 'prev: "#'.$block_id.' .left_car_arrow3",';
		$out .= 'next: "#'.$block_id.' .right_car_arrow3",';
		$out .= 'auto: false,';
		$out .= 'scroll: {';
			$out .= 'fx: "cover-fade",';
		$out .= '},';
		$out .= 'swipe: {';
			$out .= 'onTouch: true,';
		$out .= '},';
		$out .= 'items: {';
			$out .= 'visible: {';
				$out .= 'min: 1,';
				$out .= 'max: 1';
			$out .= '}';
		$out .= '}';
	$out .= '});';

	$out .= 'jQuery("#'.$block_id.' .testy_carousel").imagesLoaded( function() {';
	$out .= 'jQuery("#'.$block_id.' .testy_carousel").carouFredSel({';
		$out .= 'responsive: true,';
		$out .= 'prev: "#'.$block_id.' .left_car_arrow3",';
		$out .= 'next: "#'.$block_id.' .right_car_arrow3",';
		$out .= 'auto: false,';
		$out .= 'scroll: {';
			$out .= 'fx: "cover-fade",';
		$out .= '},';
		$out .= 'swipe: {';
			$out .= 'onTouch: true,';
		$out .= '},';
		$out .= 'items: {';
			$out .= 'visible: {';
				$out .= 'min: 1,';
				$out .= 'max: 1';
			$out .= '}';
		$out .= '}';
	$out .= '});';
	$out .= '});';

	$out .= '});';
	$out .= '</script>';
	return $out;

	asalah_testimonials_carousel($the_id,$number,$title);
}
add_shortcode('testimonials', 'asalah_shortcode_testimonials');


## Tooltip -------------------------------------------------- #
function asalah_shortcode_Tooltip( $atts, $content = null ) {
    @extract($atts);
	if( empty($direction) ) $direction = 'n';
	$out = '<span class="post-tooltip tooltip-'.$direction.'" title="'.$text.'">'.$content.'</span>';
   return $out;
}
add_shortcode('tooltip', 'asalah_shortcode_Tooltip');

## Boxes -------------------------------------------------- #
function asalah_shortcode_box( $atts, $content = null ) {
    @extract($atts);
	// type : download, warning, info, shadow, success
	$type =  (isset($type))  ? ' '.$type  :'shadow' ;
	$align = (isset($align)) ? ' '.$align : '';
	$class = (isset($class)) ? ' '.$class : '';
	$width = (isset($width)) ? ' style="width:'.$width.'"' : '';

	$out = '<div class="box'.$type.$class.$align.'"'.$width.'><div>
			' .do_shortcode($content). '
			</div></div>';
    return $out;
}
add_shortcode('box', 'asalah_shortcode_box');


## Alerts --------------------------------------------------#

function asalah_shortcode_alert($atts, $content = null) {
    @extract($atts);
	// type : alert-success, alert-block, alert-info
	$type =  (isset($type))  ? ' '.$type  :'shadow' ;
	$class = (isset($class)) ? ' '.$class : '';
	$title = (isset($title)) ? '<h4>'.$title.'</h4>' : '';

	$out = '<div class="alert '.$type.'" "' . $class.'">
	<button type="button" class="close" data-dismiss="alert">&times;</button>
	'.$title.''.do_shortcode($content). '</div>';

	return $out;
}
add_shortcode('alert', 'asalah_shortcode_alert');


## Toggle -------------------------------------------------- #
function asalah_shortcode_Toggle( $atts, $content = null ) {
    @extract($atts);
	//state : open
	if( !isset($GLOBALS['current_collapse']) )
      $GLOBALS['current_collapse'] = 0;
    else
      $GLOBALS['current_collapse']++;

	$state =  (isset($state))  ? $state  :'' ;
	$title = (isset($title)) ? $title : '';
	$output = "";
	if ($state == "open") { $state = " in"; }
	$output .= '<div class="toggle-group">';
		$output .= '<div class="accordion-heading">';
			$output .= '<a class="accordion-toggle" data-toggle="collapse" href="#collapse_' . $GLOBALS['current_collapse'] . '">';
				$output .= do_shortcode( $title );
			$output .= '</a>';
		$output .= '</div>';
		$output .= '<div id="collapse_' . $GLOBALS['current_collapse'] . '" class="accordion-body collapse ' . $state . '">';
			$output .= '<div class="accordion-inner">';
				$output .= do_shortcode($content);
			$output .= '</div>';
		$output .= '</div>';
	$output .= '</div>';

	return $output;
}
add_shortcode('toggle', 'asalah_shortcode_Toggle');


## Buttons -------------------------------------------------- #
function asalah_shortcode_button( $atts, $content = null ) {
    @extract($atts);
	//size: small, medium, big
	// color: primary, red, orange, blue, green, black, gray, white, pink, purple
	// target: _blank
	$size  = (isset($size))  ? ' '.$size  :' small' ;
	$color = (isset($color)) ? ' '.$color : ' primary';
	$align = (isset($align)) ? ' '.$align : '';
	$link  = (isset($link)) ? ' '.$link : '';
	$target = (isset($target)) ? ' target="_blank"' : '';

	$out = '<a href="'.$link.'"'.$target.' class="button'.$size.$color.$align.'">' .do_shortcode($content). '</a>';
    return $out;
}
add_shortcode('button', 'asalah_shortcode_button');


## Google Map -------------------------------------------------- #
function asalah_shortcode_googlemap( $atts, $content = null ) {
    @extract($atts);
	// src
	$src = (isset($src)) ? $src : '' ;
	$width  = (isset($width))  ? $width  :'100%' ;
	$height = (isset($height)) ? $height : '440';

	return asalah_google_maps( $src , $width, $height );
}
add_shortcode('googlemap', 'asalah_shortcode_googlemap');



## is_logged_in shortcode -------------------------------------------------- #
function asalah_shortcode_is_logged_in( $atts, $content = null ) {
	global $user_ID ;
	if( $user_ID )
		return do_shortcode($content) ;
}
add_shortcode('is_logged_in', 'asalah_shortcode_is_logged_in');


## is_guest shortcode -------------------------------------------------- #
function asalah_shortcode_is_guest( $atts, $content = null ) {
	global $user_ID ;
	if( !$user_ID  )
		return do_shortcode($content) ;
}
add_shortcode('is_guest', 'asalah_shortcode_is_guest');


## Follow Twitter -------------------------------------------------- #
function asalah_shortcode_follow( $atts, $content = null ) {
	//id
	// count = true, false
	// size: large
    @extract($atts);

	if($size == "large") $size = 'data-size="large"' ;
		else $size="";

	if($count == "true") $count = "true" ;
	else $count = "false" ;

	$out = '
	<a href="https://twitter.com/'. $id .'" class="twitter-follow-button" data-show-count="'.$count.'" '.$size.'>Follow @'. $id .'</a>
	<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src="//platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>';

    return $out;
}
add_shortcode('follow', 'asalah_shortcode_follow');




## AddVideo -------------------------------------------------- #
function asalah_shortcode_AddVideo( $atts, $content = null ) {
    @extract($atts);


	$video_url = @parse_url($content);
	$height = (isset($height)) ? $height : '' ;
	$width = (isset($width)) ? $width : "" ;


	if ( $video_url['host'] == 'www.youtube.com' || $video_url['host']  == 'youtube.com' ) {
		parse_str( @parse_url( $content, PHP_URL_QUERY ), $my_array_of_vars );
		$video =  $my_array_of_vars['v'] ;
		$out ='<div class="video_fit_container"><iframe width="'.$width.'" height="'.$height.'" src="http://www.youtube.com/embed/'.$video.'?wmode=transparent&wmode=opaque" frameborder="0" allowfullscreen></iframe></div>';
	}
	elseif( $video_url['host'] == 'www.vimeo.com' || $video_url['host']  == 'vimeo.com' ){
		$video = (int) substr(@parse_url($content, PHP_URL_PATH), 1);
		$out='<div class="video_fit_container"> <iframe src="http://player.vimeo.com/video/'.$video.'" width="'.$width.'" height="'.$height.'" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe></div>';
	}

    return $out;
}
add_shortcode('video', 'asalah_shortcode_AddVideo');


## Facebook Subscribe-------------------------------------------------- #
function asalah_facebooksub_shortcode( $atts, $content = null ) {
	@extract($atts);
	$username  = (isset($username))  ? $username  : '' ;
	$app_id = (isset($app_id)) ? $app_id : '' ;
	$secret_id = (isset($secret_id)) ? $secret_id : '' ;
	$url = 'https://graph.facebook.com/' . $username. '?fields=name,likes&access_token='.$app_id.'|'.$secret_id.'';

	return '<div class="facebook_counter social_counter clearfix">
                <a href="https://www.facebook.com/'.$username.'" class="social_counter_link">
                    <span class="counter_icon facebook_counter_icon"><i class="icon-facebook"></i></span>
                    <strong class="counter_number">'. json_decode(file_get_contents($url))->likes.'</strong>
                    <span class="counter_users_word">'. __("fans", "asalah").'</span>
                </a>
            </div>';
}
add_shortcode("facebook_subscribe", "asalah_facebooksub_shortcode");

## Twitter Subscribe-------------------------------------------------- #
function asalah_twittersub_shortcode( $atts, $content = null ) {
	@extract($atts);
	$username  = (isset($username))  ? $username  :'' ;
	$data = file_get_contents('https://cdn.syndication.twimg.com/widgets/followbutton/info.json?screen_names='.$username);
	$parsed =  json_decode($data,true);
	$tw_followers =  $parsed[0]['followers_count'];
	return '<div class="twitter_counter social_counter clearfix">
                <a href="https://twitter.com/'.$username.'" class="social_counter_link">
                    <span class="counter_icon twitter_counter_icon"><i class="icon-twitter"></i></span>
                    <strong class="counter_number">'.$tw_followers.'</strong>
                    <span class="counter_users_word">'. __("Followers", "asalah").'</span>
                </a>
            </div>';

}
add_shortcode("twitter_subscribe", "asalah_twittersub_shortcode");

## RSS Subscribe-------------------------------------------------- #
function asalah_rsssub_shortcode( $atts, $content = null ) {
	@extract($atts);
	$url  = (isset($url))  ? $url  :'' ;

	return '<div class="rss_counter social_counter clearfix">
                <a href="' . $url .'" class="social_counter_link">
                    <span class="counter_icon rss_counter_icon"><i class="icon-rss"></i></span>
                    <strong class="counter_number">'. __("Subscribe", "asalah") .'</strong>
                    <span class="counter_users_word">'. __("To RSS", "asalah") . '</span>
                </a>
            </div>';

}
add_shortcode("rss_subscribe", "asalah_rsssub_shortcode");


## highlight -------------------------------------------------- #
function asalah_highlight_shortcode( $atts, $content = null ) {
    return '<span class="highlight">'.$content.'</span>';
}
add_shortcode("highlight", "asalah_highlight_shortcode");


## Dropcap  -------------------------------------------------- #
function asalah_dropcap_shortcode( $atts, $content = null ) {
    return '<span class="dropcap">'.$content.'</span>';
}
add_shortcode("dropcap", "asalah_dropcap_shortcode");



## checklist -------------------------------------------------- #
function asalah_checklist_shortcode( $atts, $content = null ) {
    return '<div class="checklist">'.do_shortcode($content).'</div>';
}
add_shortcode("checklist", "asalah_checklist_shortcode");


## starlist -------------------------------------------------- #
function asalah_starlist_shortcode( $atts, $content = null ) {
    return '<div class="starlist">'.do_shortcode($content).'</div>';
}
add_shortcode("starlist", "asalah_starlist_shortcode");


## iconlist -------------------------------------------------- #
function asalah_iconlist_shortcode( $atts, $content = null ) {
	//type : check, star, empty, finish, circle, right, hand
	extract(shortcode_atts(array(
      "type" => 'check',
    ), $atts));
    return '<div class="asalah_list list-'.$type.'">'.do_shortcode($content).'</div>';
}
add_shortcode("iconlist", "asalah_iconlist_shortcode");

## Facebook -------------------------------------------------- #
function asalah_facebook_shortcode( $atts, $content = null ) {
	global $post;
		return '<div class="fb-like" data-href="'.get_permalink($post->ID).'" data-layout="standard" data-action="like" data-size="small" data-show-faces="true" data-share="false"></div>';
}
add_shortcode("facebook", "asalah_facebook_shortcode");


## Tweet -------------------------------------------------- #
function asalah_tweet_shortcode( $atts, $content = null ) {
	global $post, $asalah_data;
    return '<a href="http://twitter.com/share" class="twitter-share-button" data-url="'. get_permalink($post->ID) .'" data-text="'. get_the_title($post->ID) .'" data-via="'. $asalah_data['asalah_tw_url'] .'" data-lang="en" data-count="vertical" >tweet</a><script type="text/javascript" src="http://platform.twitter.com/widgets.js"></script>';
}
add_shortcode("tweet", "asalah_tweet_shortcode");


## Digg -------------------------------------------------- #
function asalah_digg_shortcode( $atts, $content = null ) {
	global $post;
	$output = '<a style="text-decoration:none;" href="http://digg.com/" rel="nofollow" onclick="window.open(\'http://digg.com/submit?phase=2&amp;url=\'+encodeURIComponent(location.href)+\'&amp;bodytext=&amp;tags=&amp;title=\'+encodeURIComponent(document.title));return false;" title="Digg it"><img src="https://3.bp.blogspot.com/-HsmMH6ibC8U/Vx9Z4Ee2AsI/AAAAAAAABT0/p3KFsK_Vfbc3W2FXKB1uaDujTv9gLXrqACLcB/s1600/Digg_icon.png" style="height:32px; width:32px;" /></a>';

  return $output;
}
add_shortcode("digg", "asalah_digg_shortcode");


## stumble -------------------------------------------------- #
function asalah_stumble_shortcode( $atts, $content = null ) {
	global $post;
    return "<su:badge layout='5' location='". get_permalink($post->ID) ."'></su:badge>
<script type='text/javascript'>
  (function() {
    var li = document.createElement('script'); li.type = 'text/javascript'; li.async = true;
    li.src = 'https://platform.stumbleupon.com/1/widgets.js';
    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(li, s);
  })();
</script>";
}
add_shortcode("stumble", "asalah_stumble_shortcode");



## Google + -------------------------------------------------- #
function asalah_google_shortcode( $atts, $content = null ) {
	global $post;
    return "<g:plusone size='tall'></g:plusone>
<script type='text/javascript'>
  (function() {
    var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
    po.src = 'https://apis.google.com/js/plusone.js';
    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
  })();
</script>
";
}
add_shortcode("google", "asalah_google_shortcode");




## Tabs -------------------------------------------------- #
function asalah_shortcode_tabs( $atts, $content = null ) {
   if( isset($GLOBALS['tabs_count']) )
      $GLOBALS['tabs_count']++;
    else
      $GLOBALS['tabs_count'] = 0;
    extract( shortcode_atts( array(
		'title' => '',
    'tabtype' => 'nav-tabs',
    'tabdirection' => '',
	'vertical' => '',

  ), $atts ) );
    preg_match_all( '/tab title="([^\"]+)"/i', $content, $matches, PREG_OFFSET_CAPTURE );

    $tab_titles = array();
    if( isset($matches[1]) ){ $tab_titles = $matches[1]; }

    $output = '';
		if ($title):
			$output .= '<h3 class="page-header"><span class="page_header_title">'.$title.'</span></h3>';
		endif;
	$pos_class = "";
    if ($vertical == 'true') {
		$pos_class = "vertical_tab";
	}else{
		$pos_class = "horizontal_tab";
	}
    if( count($tab_titles) ){
      $output .= '<div class="tabbable tabs-'.$tabdirection.' '.$pos_class.'"><ul class="nav '. $tabtype .'" id="custom-tabs-'. rand(1, 100) .'">';

      $i = 0;
      foreach( $tab_titles as $tab ){
        if($i == 0)
          $output .= '<li class="active">';
        else
          $output .= '<li>';

        $output .= '<a href="#custom-tab-' . $GLOBALS['tabs_count'] . '-' . sanitize_title( $tab[0] ) . '"  data-toggle="tab">' . $tab[0] . '</a></li>';
        $i++;
      }

        $output .= '</ul>';
        $output .= '<div class="tab-content">';
        $output .= do_shortcode( $content );
        $output .= '</div></div>';
    } else {
      $output .= do_shortcode( $content );
    }

    return $output;
}
function asalah_shortcode_tab( $atts, $content = null ) {

    if( !isset($GLOBALS['current_tabs']) ) {
      $GLOBALS['current_tabs'] = $GLOBALS['tabs_count'];
      $state = 'active';
    } else {

      if( $GLOBALS['current_tabs'] == $GLOBALS['tabs_count'] ) {
        $state = '';
      } else {
        $GLOBALS['current_tabs'] = $GLOBALS['tabs_count'];
        $state = 'active';
      }
    }

    $defaults = array( 'title' => 'Tab');
    extract( shortcode_atts( $defaults, $atts ) );

    return '<div id="custom-tab-' . $GLOBALS['tabs_count'] . '-'. sanitize_title( $title ) .'" class="tab-pane ' . $state . '">'. do_shortcode( $content ) .'</div>';
  }
add_shortcode('tabs', 'asalah_shortcode_tabs');
add_shortcode('tab', 'asalah_shortcode_tab');


## Divider -------------------------------------------------- #
function asalah_shortcode_divider( $atts, $content = null ) {
	@extract($atts);

	$title = (isset($title)) ? $title : '';
	$size = (isset($size)) ? $size : 'h3';
	$icon = (isset($icon)) ? $icon : 'h3';

	if ($title == '') {
	$out ='<hr class="bs-docs-separator">';
	}else{
	$out ='<'.$size.' class="page-header">';
		if ($icon != '') {
			$out .='<i class="divider_icon icon-'.$icon.'"></i> ';
		}
	$out .= $title;
	$out .= '</'.$size.'>';
	}
   return $out;

}
add_shortcode('divider', 'asalah_shortcode_divider');

## progress -------------------------------------------------- #
function asalah_shortcode_progress( $atts, $content = null ) {
	@extract($atts);
	//pos: right, left
	$title = (isset($title)) ? $title : '';
	$percent = (isset($percent)) ? $percent : '';
	$type = (isset($type)) ? $type : 'striped' ;

	if (isset($GLOBALS['prog_bar_type'])) {
		$type = $GLOBALS['prog_bar_type'];
	}

	if ($type == 'striped') {
		$style = 'progress-striped';
	} else if ($type == 'animated') {
		$style = 'progress-striped active';
	} else {
		$style = '';
	}

	if ($title != '' && $percent != '') {
		$out = '<div class="skills_content">';
			$out .= '<span class="skill_title meta_title">'.$title .' '. $percent .'%</span>';
			$out .= '<div class="progress '. $style .'">';
				$out .= '<div class="bar" style="width: '. $percent .'%;"></div>';
			$out .= '</div>';
		$out .= '</div>';


	}else{
		$out = '';
	}
   return $out;

}
add_shortcode('progress', 'asalah_shortcode_progress');


## pullquote -------------------------------------------------- #
function asalah_shortcode_pull( $atts, $content = null ) {
	@extract($atts);
	//pos: right, left
	$pos = (isset($pos)) ? $pos : '';

	if ($pos == 'left') {
	$out ='<span class="pullquote text-left">' . $content .'</span>';
	}elseif($pos == 'right'){
	$out ='<span class="pullquote text-right">' . $content .'</span>';
	}else{
	$out ='<blockquote>' . $content .'</blockquote>';
	}
   return $out;

}
add_shortcode('pull', 'asalah_shortcode_pull');

## Icons
function asalah_shortcode_icon( $atts, $content = null ) {
    extract(shortcode_atts(array(
      "type" => 'type',
      "size" => 'normal',
    ), $atts));

    return '<i class="icon icon-'.$type.'" style="font-size:'. $size .'px;"></i>';
  }

  add_shortcode('icon', 'asalah_shortcode_icon');

/* Action Block Shortcode */

add_shortcode( 'action', 'asalah_action_shortcode' );
function asalah_action_shortcode($atts, $content) {
	extract(shortcode_atts( array(
		'text' => '',
		'title' => '',
		'button' => '',
		'url' => '',
		'imageurl' => '',
		'imagewidth' => '',
		'margintop' => '',
		'color' => 'white',
		'button_size' => 'small',
		'buttontarget' => ''
	), $atts));

	$output = '';

	$output .= '<div class="push_button"';
	if($margintop) {
		$output .= 'style="margin-top:'.$margintop.'px;" ';
	}
	$output .= '>';

	$output .= '<div class="container">';
	$output .= '<div class="row-fluid">';
	$output .= '<div class="span12">';
	if($imageurl) :
			$imageurl = wp_get_attachment_image_src($imageurl, 'large');
			$output .= '<div class="push_button_image" ';
			if($imagewidth) {
				$output .= 'style="width:'. $imagewidth .'px;" ';
			}
			$output .= '>';
				$output .= '<img src="'. strip_tags($imageurl[0]) .'" alt="';
				if ($title) {
					$output .= strip_tags($title);
				}
				$output .= '" />';
			$output .= '</div>';
	endif;
	$content_margin = $imagewidth + 40;
	$output .= '<div class="push_button_content" ';
	if($imagewidth) {
		$output .= 'style="margin-left: '. strip_tags($content_margin).'px;"';
	}
	$output .= '>';


	if ($button && $url) :
					$output .=  '<div class="push_button_button for_desktop"><a ';
					if ($buttontarget == "blank") {
						$output .= ' target="_blank" ';
					}
					$output .= ' href=" '. strip_tags($url) .'" class="button '. $button_size .' '. $color .' ">'. strip_tags($button) .'</a></div>';
	endif;

	$output .=  '<div class="push_button_info">';
	  if ($title) :
			$output .=  '<h2>'. strip_tags($title) .'</h2>';
		endif;
	  if($text) :
			$output .= '<p>'. strip_tags($text) .'</p>';
		endif;
	$output .=  '</div>';

	if ($button && $url) :
		$output .=  '<div class="push_button_button for_mobile"><a ';
		if ($buttontarget == "blank") {
			$output .= 'target="_blank"';
		}
		$output .= ' href="'. strip_tags($url) .'" class="button '. $button_size .' '. $color .'">'. strip_tags($button) .'</a></div>';
	endif;

	$output .=  '</div>';
	$output .=  '</div>';
	$output .=  '</div>';
	$output .=  '</div>';
	$output .=  '</div>';


	return $output;
}

add_shortcode( 'bloglist', 'asalah_bloglist_shortcode' );
function asalah_bloglist_shortcode($atts, $content) {
	extract(shortcode_atts( array(
		'title' => '',
		'url' => '',
		'postnumber' => '',
		'tags_ids' => '',
		'readmore_pharse' => '',
		'cats' => '',
		'order' => '',
	), $atts));

	$output = '';



	$output .= '<div class="row-fluid"><div class="span12">';
	if ($title) :
						$output .= '<h3 class="page-header">';
							if ($url) :
									$output .= '<a href="'. $url .'"><span class="page_header_title">'. strip_tags($title) .'</span></a>';
							else:
									$output .= '<span class="page_header_title">'. strip_tags($title) .'</span>';
							endif;
						$output .= '</h3>';
	endif;
	ob_start();
	asalah_blog_posts($postnumber, $tags_ids, $readmore_pharse, $cats, $order);
	$output .= ob_get_contents();
	ob_end_clean();
	$output .= '</div></div>';

	$output .= '';
	return $output;
}


add_shortcode( 'clear', 'asalah_clear_shortcode' );
function asalah_clear_shortcode($atts, $content) {
	extract(shortcode_atts( array(
		'horizontal_line' => 'none',
		'line_color' => '#353535',
		'pattern' => '1',
		'height' => ''
	), $atts));

	$output = '';

	switch($horizontal_line) {
		case 'none':
			break;
		case 'single':
			$output .= '<hr class="aq-block-clear aq-block-hr-single" style="background:'.$line_color.';"/>';
			break;
		case 'double':
			$output .= '<hr class="aq-block-clear aq-block-hr-double" style="background:'.$line_color.';"/>';
			$output .= '<hr class="aq-block-clear aq-block-hr-single" style="background:'.$line_color.';"/>';
			break;
		case 'image':
			$output .= '<hr class="aq-block-clear aq-block-hr-image cf"/>';
			break;
	}

	if($height) {
		$output .= '<div class="cf" style="height:'.$height.'px;"></div>';
	}

	$output .= '';
	return $output;
}


add_shortcode( 'pricingblock', 'asalah_pricingblock_shortcode' );
function asalah_pricingblock_shortcode($atts, $content) {
	extract(shortcode_atts(  array(
		'tableid' => '',
		'columns'	=> '',
		'title' => '',
	), $atts));

	$output = '';

	$output .= '<div class="row-fluid">';
		$output .= '<div class="span12">';
				if ($title) :
					$output .= '<h3 class="page-header"><span class="page_header_title">'. strip_tags($title) .'</span></h3>';
				endif;
				$output .= do_shortcode('[pricing_table id="'.$tableid.'" column="'.$columns.'"]');
		$output .= '</div>';
	$output .= '</div>';

	$output .= '';
	return $output;
}


add_shortcode( 'revslider', 'asalah_revslider_shortcode' );
function asalah_revslider_shortcode($atts) {
	extract(shortcode_atts( array(
		'alias' => '',
	), $atts));

	$output = '';

	$output .= '<div class="row-fluid">';
		$output .= '<div class="span12">';
		ob_start();
			putRevSlider($alias);
			$output .= ob_get_contents();
			ob_end_clean();
		$output .= '</div>';
	$output .= '</div>';

	$output .= '';
	return $output;
}



add_shortcode( 'asalah_richtext', 'asalah_richtext_shortcode' );
function asalah_richtext_shortcode($atts, $content) {
	extract(shortcode_atts( array(
		'title' => ''
	), $atts));

	$output = '';

	if($title) $output .= '<h4 class="aq-block-title">'.strip_tags($title).'</h4>';
	$output .= wpautop(do_shortcode(htmlspecialchars_decode($content)));

	$output .= '';
	return $output;
}



add_shortcode( 'widget', 'asalah_widget_shortcode' );
function asalah_widget_shortcode($atts, $content) {
	global $wp_registered_sidebars;
	$sidebar_options = array(); $default_sidebar = '';
	foreach ($wp_registered_sidebars as $registered_sidebar) {
		$default_sidebar = empty($default_sidebar) ? $registered_sidebar['id'] : $default_sidebar;
		$sidebar_options[$registered_sidebar['id']] = $registered_sidebar['name'];
	}

	extract(shortcode_atts( array(
		'sidebar' => $default_sidebar,
	), $atts));

	$output = '';

	ob_start();
  $output = '';
  dynamic_sidebar($sidebar);
  $output .= ob_get_contents();
  ob_end_clean();

	$output .= '';
	return $output;
}



add_shortcode( 'space', 'asalah_space_shortcode' );
function asalah_space_shortcode($atts, $content) {
	extract(shortcode_atts( array(), $atts));

	$output = '';

	$output .= '<div class="new_section"></div>';

	return $output;
}



add_shortcode( 'service', 'asalah_service_shortcode' );
function asalah_service_shortcode($atts, $content) {
	extract(shortcode_atts( array(
		'title' => '',
		'text' => '',
		'icon_class' => '',
		'custom_image' => '',
		'url' => '',
	), $atts));

	$output = '';

	$output .= '<div class="row-fluid">';
	$output .= '<div class="span12 service_item new_lifted">';

				if ($url) :
					$output .= '<a href="'. $url .'">';
				endif;

				if ($custom_image) :
				$custom_image = wp_get_attachment_image_src( $custom_image );
				$output .= '<div class="service_icon_image">';
				$output .= '<img src="'. $custom_image[0] .'" />';
				$output .= '</div>';
				elseif($icon_class) :
				$output .= '<div class="service_icon hi-icon-wrap hi-icon-effect-3 hi-icon-effect-3a">';
				$output .= '<a ';
				if ($url) {
					$output .= 'href="'. $url .'"';
				}
				$output .= ' class="'. $icon_class .' hi-icon"></a>';
				$output .=  '</div>';
				endif;

				if ($url) :
					$output .= '</a>';
				endif;

		$output .=  '<div class="services_info">';
		if ($url) :
			$output .= '<a href="'. $url .'">';
		endif;
		if ($title) :
			$output .=  '<h3>'. strip_tags($title) .'</h3>';
		endif;
		if ($url) :
			$output .= '</a>';
		endif;
		if($text) :
			$output .= '<p>'. wpautop(do_shortcode(htmlspecialchars_decode($text))) .'</p>';
		endif;
		$output .=  '</div>';
	$output .=  '</div>';
	$output .=  '</div>';

	$output .= '';
	return $output;
}



add_shortcode( 'progresscon', 'asalah_prog_con_shortcode' );
function asalah_prog_con_shortcode($atts, $content) {
	extract(shortcode_atts( array(
		'type'	=> 'basic',
		'title' => '',
	), $atts));

	$output = '';
	$GLOBALS['prog_bar_type'] = $type;

	$output .= '<div class="row-fluid"><div class="span12"><div class="new_content"><h3 class="page-header"><span class="page_header_title">'.$title.'</span></h3>';
	$output .= do_shortcode( $content );
	$output .= '</div></div></div>';
	$output .= '';
	return $output;
}

add_shortcode( 'teamblock', 'asalah_teamblock_shortcode' );
function asalah_teamblock_shortcode( $atts, $content)  {
	extract(shortcode_atts( array(
		'title' => '',
		'desc' => '',
		'url' => '',
		'postnumber' => '',
		'max' => '',
		'cycle' => '',
		'team_order' => '',
		'autoplay_car' => '',
	), $atts));

	$output = '';

	$the_id = "aq-block-row" . random_id(5);

	$output .= '<div class="row-fluid">';
	$output .= '<div class="span12">';
	$output .= asalah_team_carousel($the_id, $url, $postnumber, $title, $desc, $max, $cycle, $team_order, $autoplay_car);
	$output .= '</div>';
	$output .= '</div>';

	$output .= '';
	return $output;
}


## Columns  -------------------------------------------------- #
function asalah_one_third( $atts, $content = null ) {
   return '<div class="one_third">' . do_shortcode($content) . '</div>';
}
add_shortcode('one_third', 'asalah_one_third');

function asalah_one_third_last( $atts, $content = null ) {
   return '<div class="one_third last">' . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('one_third_last', 'asalah_one_third_last');

function asalah_two_third( $atts, $content = null ) {
   return '<div class="two_third">' . do_shortcode($content) . '</div>';
}
add_shortcode('two_third', 'asalah_two_third');

function asalah_two_third_last( $atts, $content = null ) {
   return '<div class="two_third last">' . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('two_third_last', 'asalah_two_third_last');

function asalah_one_half( $atts, $content = null ) {
   return '<div class="one_half">' . do_shortcode($content) . '</div>';
}
add_shortcode('one_half', 'asalah_one_half');

function asalah_one_half_last( $atts, $content = null ) {
   return '<div class="one_half last">' . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('one_half_last', 'asalah_one_half_last');

function asalah_one_fourth( $atts, $content = null ) {
   return '<div class="one_fourth">' . do_shortcode($content) . '</div>';
}
add_shortcode('one_fourth', 'asalah_one_fourth');

function asalah_one_fourth_last( $atts, $content = null ) {
   return '<div class="one_fourth last">' . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('one_fourth_last', 'asalah_one_fourth_last');

function asalah_three_fourth( $atts, $content = null ) {
   return '<div class="three_fourth">' . do_shortcode($content) . '</div>';
}
add_shortcode('three_fourth', 'asalah_three_fourth');

function asalah_three_fourth_last( $atts, $content = null ) {
   return '<div class="three_fourth last">' . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('three_fourth_last', 'asalah_three_fourth_last');

function asalah_one_fifth( $atts, $content = null ) {
   return '<div class="one_fifth">' . do_shortcode($content) . '</div>';
}
add_shortcode('one_fifth', 'asalah_one_fifth');

function asalah_one_fifth_last( $atts, $content = null ) {
   return '<div class="one_fifth last">' . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('one_fifth_last', 'asalah_one_fifth_last');

function asalah_two_fifth( $atts, $content = null ) {
   return '<div class="two_fifth">' . do_shortcode($content) . '</div>';
}
add_shortcode('two_fifth', 'asalah_two_fifth');

function asalah_two_fifth_last( $atts, $content = null ) {
   return '<div class="two_fifth last">' . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('two_fifth_last', 'asalah_two_fifth_last');

function asalah_three_fifth( $atts, $content = null ) {
   return '<div class="three_fifth">' . do_shortcode($content) . '</div>';
}
add_shortcode('three_fifth', 'asalah_three_fifth');

function asalah_three_fifth_last( $atts, $content = null ) {
   return '<div class="three_fifth last">' . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('three_fifth_last', 'asalah_three_fifth_last');

function asalah_four_fifth( $atts, $content = null ) {
   return '<div class="four_fifth">' . do_shortcode($content) . '</div>';
}
add_shortcode('four_fifth', 'asalah_four_fifth');

function asalah_four_fifth_last( $atts, $content = null ) {
   return '<div class="four_fifth last">' . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('four_fifth_last', 'asalah_four_fifth_last');

function asalah_one_sixth( $atts, $content = null ) {
   return '<div class="one_sixth">' . do_shortcode($content) . '</div>';
}
add_shortcode('one_sixth', 'asalah_one_sixth');

function asalah_one_sixth_last( $atts, $content = null ) {
   return '<div class="one_sixth last">' . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('one_sixth_last', 'asalah_one_sixth_last');

function asalah_five_sixth( $atts, $content = null ) {
   return '<div class="five_sixth">' . do_shortcode($content) . '</div>';
}
add_shortcode('five_sixth', 'asalah_five_sixth');

function asalah_five_sixth_last( $atts, $content = null ) {
   return '<div class="five_sixth last">' . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('five_sixth_last', 'asalah_five_sixth_last');
?>