<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>

<head>
 <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
 <title><?php if( is_home() || is_front_page()) { bloginfo('name'); echo " - "; bloginfo('description'); } else { wp_title('',true,''); } ?></title>
 <link rel="shortcut icon" href="<?php mframe_option('favicon', 1); ?>" />
 <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
 <base href="<?php echo home_url( '/' ); ?>" />

 <?php wp_head(); ?>
 
</head>

<body <?php body_class('noscript'); ?> id="style<?php mframe_option('style', 1); ?>">

<div id="header" class="wrap">
 <div id="logo" class="<?php echo mframe_option('logo-image-support') == false ? 'text' : 'image'; ?>">
  <a href="<?php echo home_url( '/' ); ?>" title="<?php bloginfo('description'); ?>"><?php if ( mframe_option('logo-image-support') == false ) { mframe_option( 'logo-text', 1 ); } else { echo '<img src="' . mframe_option('logo-image') . '" width="' . mframe_option('logo-image-w') . '" height="' . mframe_option('logo-image-h') . '" />'; } ?>
  </a>
 </div>
 
 <div id="nav"><?php mframe_display( 'nav', array( 'depth' => 1, 'show_home' => 1 )); ?></div>
</div>

<?php if( mframe_option( 'slider-show' ))
	{
		if( mframe_enable( 'location', array( 'location' => mframe_option( 'slider-location' ))))
			get_template_part( 'theme/slider' );
	} ?>

<div id="subnav" class="wrap">
 <div class="body">
  <?php if ( mframe_option( 'show-cat-drop' )) { ?>

  <ul id="catlist">
   <li id="cat-nav-btn">
    <a class="heading" href="#"><?php _e('Categories', 'mframe'); ?></a>
    <ul><?php wp_list_categories( array( 'title_li' => '', 'depth' => 1 )); ?></ul>
   </li>
  </ul><?php
  
  }

  mframe_display( 'nav', array( 'depth' => 1, 'show_home' => 0, 'theme_location' => 'subnav' ));

  if ( mframe_option( 'show-search' )) { ?>

  <div id="topsearch">
   <form method="get" action="<?php echo home_url( '/' ); ?>">
    <input type="text" name="s" value="" placeholder="<?php _e( 'Search...', 'mframe' ); ?>" />
    <input type="submit" value="" />
   </form>
  </div>

  <?php } ?>
 </div>
</div>

<div class="wrap">
 <div id="content">
  <div class="head content">
   <div class="foot content">