<?php
/*
Plugin Name: Theme Services
Plugin URI: http://themeforest.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
Description: Theme Services Plugin
Author: QuanticaLabs
Author URI: http://themeforest.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
Version: 1.5
Text Domain: ql_services
*/

//translation
function ql_services_load_textdomain()
{
	load_plugin_textdomain("ql_services", false, dirname(plugin_basename(__FILE__)) . '/languages');
}
add_action('plugins_loaded', 'ql_services_load_textdomain');
//custom post type - services
function ql_services_init()
{
	$labels = array(
		'name' => _x('Services', 'post type general name', 'ql_services'),
		'singular_name' => _x('Service', 'post type singular name', 'ql_services'),
		'add_new' => _x('Add New', 're_sidebar', 'ql_services'),
		'add_new_item' => __('Add New Service', 'ql_services'),
		'edit_item' => __('Edit Service', 'ql_services'),
		'new_item' => __('New Service', 'ql_services'),
		'all_items' => __('Services', 'ql_services'),
		'view_item' => __('View Service', 'ql_services'),
		'search_items' => __('Search Services', 'ql_services'),
		'not_found' =>  __('No services found', 'ql_services'),
		'not_found_in_trash' => __('No services found in Trash', 'ql_services'), 
		'parent_item_colon' => '',
		'menu_name' => __("Services", 'ql_services')
	);
	
	$args = array(  
		"labels" => $labels, 
		"public" => true,  
		"show_ui" => true,  
		"capability_type" => "post",
		"menu_position" => 20,
		"hierarchical" => false,  
		"rewrite" => array("slug" => "services"),
		"supports" => array("title", "editor", "excerpt", "thumbnail", "page-attributes") 
	);
	register_post_type("ql_services", $args);
	
	//check for re_services posts
	/*if(!get_option("services_updated"))
	{	
		$services = get_posts(array(
			'post_type' => 're_services',
			'posts_per_page' => -1
		));
		foreach($services as $service)
			set_post_type($service->ID, "ql_services");
		global $wp_rewrite;
		$wp_rewrite->flush_rules();
		add_option("services_updated", 1);
	}*/
}  
add_action("init", "ql_services_init"); 

//custom sidebars items list
function ql_services_services_edit_columns($columns)
{
	$columns = array(  
		"cb" => "<input type=\"checkbox\" />",  
		"title" => _x('Service name', 'post type singular name', 'ql_services'),
		"order" =>  _x('Order', 'post type singular name', 'ql_services'),
		"date" => __('Date', 'ql_services')
	);    

	return $columns;  
}  
add_filter("manage_edit-ql_services_columns", "ql_services_services_edit_columns");

function manage_ql_services_services_posts_custom_column($column)
{
	global $post;
	switch($column)
	{
		case "order":
			echo get_post($post->ID)->menu_order;
			break;
	}
}
add_action("manage_ql_services_posts_custom_column", "manage_ql_services_services_posts_custom_column");

// Register the column as sortable
function ql_services_services_sortable_columns($columns) 
{
    $columns = array(
		"title" => "title",
		"order" => "order",
		"date" => "date"
	);

    return $columns;
}
add_filter("manage_edit-ql_services_sortable_columns", "ql_services_services_sortable_columns");

function ql_services_shortcode($atts)
{
	$currentTheme = wp_get_theme();
	extract(shortcode_atts(array(
		"type" => "images_list",
		"display" => "list",
		"borders" => 0,
		"featured_image_bg" => 0,
		"items_per_page" => "-1",
		"ids" => "",
		"order_by" => "title,menu_order",
		"order" => "ASC",
		"headers" => 1,
		"headers_links" => 1,
		"headers_border" => 1,
		"show_excerpt" => 1,
		"excerpt_size" => "small",
		"show_icon" => 1,
		"icons_links" => 1,
		"icon_size" => "small",
		"icon_tick" => 0,
		"show_featured_image" => 1,
		"featured_image_links" => 1,
		"scroll_control" => 1,
		"read_more" => 0,
		"read_more_label" => __("Learn more", 'ql_services'),
		"class" => "",
		"top_margin" => "none" 
	), $atts));
	
	$ids = explode(",", $ids);
	if($ids[0]=="-" || $ids[0]=="")
	{
		unset($ids[0]);
		$ids = array_values($ids);
	}
	$args = array(
		'include' => $ids,
		'post_type' => 'ql_services',
		'posts_per_page' => $items_per_page,
		'post_status' => 'publish',
		'orderby' => implode(" ", explode(",", $order_by)),
		'order' => $order
	);
	$posts_list = get_posts($args);
	if($display=="carousel" && is_rtl())
		$posts_list = array_reverse($posts_list);
	
	$output = "";
	if(count($posts_list))
	{
		$i=0;
		$divider = ($type=="icons_list" && $currentTheme!="CleanMate" ? 2 : 3);
		if($display=="carousel")
			$output .= '<div class="carousel-container clearfix' . (!empty($class) ? ' ' . esc_attr($class) : '') . (!empty($top_margin) && $top_margin!="none" ? ' ' . esc_attr($top_margin) : '') . '">';
		$output .= '<ul class="services-list clearfix' . (!empty($type) && $type=="icons_list" ? ' services-icons' : '') . (!empty($display) && $display=="carousel" ? ' horizontal-carousel' : '') . ((int)$borders ? ' services-items-border' : '') . (!empty($class) && $display!="carousel" ? ' ' . esc_attr($class) : '') . (!empty($top_margin) && $top_margin!="none" && $display!="carousel" ? ' ' . esc_attr($top_margin) : '') . '">';
		global $post;
		$currentPost = $post;
		foreach($posts_list as $post) 
		{
			setup_postdata($post);
			if(($i==0 || $i%$divider==0) && $display!="carousel")
			{
				if($i%$divider==0 && $i>0)
				{
					$output .= '</ul></li>';
				}
				$output .= '<li class="vc_row wpb_row vc_row-fluid"><ul>';
			}
			$output .= '<li' . (($type=="icons_list" && (int)$featured_image_bg && has_post_thumbnail(get_the_ID())) || ((int)$show_excerpt && has_excerpt() && $excerpt_size=="big") ? ' class="' : '') . ($type=="icons_list" && (int)$featured_image_bg && has_post_thumbnail(get_the_ID()) ? 'cm-background cm-overlay' : '') . ((int)$show_excerpt && has_excerpt() && $excerpt_size=="big" ? ' excerpt-big-size' : '') . (($type=="icons_list" && (int)$featured_image_bg && has_post_thumbnail(get_the_ID())) || ((int)$show_excerpt && has_excerpt() && $excerpt_size=="big") ? '"' : '') . ($type=="icons_list" && (int)$featured_image_bg && has_post_thumbnail(get_the_ID()) ? ' style="background-image: url(' . esc_url(get_the_post_thumbnail_url(get_the_ID(), "medium-square-thumb")) . ')"' : '') .'>';
			$custom_url = get_post_meta(get_the_ID(), "ql_services_custom_url", true);
			if($type=="icons_list")
			{
				if((int)$show_icon)
				{
					$icon = "";
					$icon = get_post_meta(get_the_ID(), "icon", true);
					if(!empty($icon))
					{
						if($currentTheme=="Carservice")
							$output .= '<div class="hexagon small">';
						if((int)$icons_links)
							$output .= '<a href="' . (!empty($custom_url) ? esc_url($custom_url) : get_permalink()) . '" title="' . esc_attr(get_the_title()) . '">';
						$output .= '<span class="service-icon ' . (substr($icon, 0, 9)=="sl-small-" || substr($icon, 0, 9)=="features-" ? '' : 'sl-small-') . esc_attr($icon) . ($icon_size=="big" ? ' big' : '') . ((int)$icon_tick==1 ? ' tick' : ''). '"></span>';
						if((int)$icons_links)
							$output .= '</a>';
						if($currentTheme=="Carservice")
							$output .= '</div>';
						$output .= '<div class="service-content">';
					}
				}
			}
			else if((int)$show_featured_image)
			{
				if((int)$featured_image_links)
					$output .= '<a href="' . (!empty($custom_url) ? esc_url($custom_url) : get_permalink()) . '" title="' . esc_attr(get_the_title()) . '">';
				$output .= get_the_post_thumbnail(get_the_ID(), "medium-thumb" , array("alt" => get_the_title(), "title" => ""));
				if((int)$featured_image_links)
					$output .= '</a>';
			}
			if((int)$headers)
				$output .= '<h4' . ((int)$headers_border ? ' class="box-header"' : '') . '>' . ((int)$headers_links ? '<a href="' . (!empty($custom_url) ? esc_url($custom_url) : get_permalink()) . '" title="' . esc_attr(get_the_title()) . '">' : '') . get_the_title() .  ((int)$headers_links ? '</a>' : '') . '</h4>';
			if((int)$show_excerpt && has_excerpt())
				$output .= apply_filters('the_excerpt', do_shortcode(get_the_excerpt()));
			if((int)$read_more)
				$output .= '<div class="align-center margin-top-42 padding-bottom-16"><a class="more" href="' . (!empty($custom_url) ? esc_url($custom_url) : get_permalink()) . '" title="' . esc_attr($read_more_label) . '">' . $read_more_label . '</a></div>';
			if($type=="icons_list" && (int)$show_icon && !empty($icon))
				$output .= '</div>';
			$output .= '</li>';
			$i++;
		}
		if($display!="carousel")
			$output .= '</ul></li>';
		$output .= '</ul>';
		$post = $currentPost;
		if($display=="carousel")
		{
			if((int)$scroll_control)
				$output .= '<div class="cm-carousel-pagination"></div>';
			$output .= '</div>';
		}
	}
	return $output;
}
add_shortcode("ql_services", "ql_services_shortcode");
add_shortcode("re_services", "ql_services_shortcode");

//visual composer
function ql_services_vc_init()
{
	if(is_plugin_active("js_composer/js_composer.php") && function_exists('vc_map'))
	{
		//get services list
		$services_list = get_posts(array(
			'posts_per_page' => -1,
			'orderby' => 'title',
			'order' => 'ASC',
			'post_type' => 'ql_services'
		));
		$services_array = array();
		$services_array[__("All", 'ql_services')] = "-";
		foreach($services_list as $service)
			$services_array[$service->post_title . " (id:" . $service->ID . ")"] = $service->ID;
			
		$params = array(
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => __("Type", 'ql_services'),
				"param_name" => "type",
				"value" => array(__("List with images", 'ql_services') => "images_list", __("List with icons", 'ql_services') => "icons_list")
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => __("Borders on list items", 'ql_services'),
				"param_name" => "borders",
				"value" => array(__("No", 'ql_services') => 0, __("Yes", 'ql_services') => 1),
				"dependency" => array('element' => "type", 'value' => 'icons_list')
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => __("Items per page/Post count", 'ql_services'),
				"param_name" => "items_per_page",
				"value" => -1,
				"description" => __("Set -1 to display all.", 'ql_services')
			),
			array(
				"type" => "dropdownmulti",
				"class" => "",
				"heading" => __("Display selected", 'ql_services'),
				"param_name" => "ids",
				"value" => $services_array
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => __("Order by", 'ql_services'),
				"param_name" => "order_by",
				"value" => array(__("Title, menu order", 'ql_services') => "title,menu_order", __("Menu order", 'ql_services') => "menu_order", __("Date", 'ql_services') => "date", __("Random", 'ql_services') => "rand")
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => __("Order", 'ql_services'),
				"param_name" => "order",
				"value" => array(__("ascending", 'ql_services') => "ASC", __("descending", 'ql_services') => "DESC")
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => __("Headers", 'ql_services'),
				"param_name" => "headers",
				"value" => array(__("Yes", 'ql_services') => 1, __("No", 'ql_services') => 0)
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => __("Headers links", 'ql_services'),
				"param_name" => "headers_links",
				"value" => array(__("Yes", 'ql_services') => 1, __("No", 'ql_services') => 0)
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => __("Headers border", 'ql_services'),
				"param_name" => "headers_border",
				"value" => array(__("Yes", 'ql_services') => 1, __("No", 'ql_services') => 0)
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => __("Show excerpt", 'ql_services'),
				"param_name" => "show_excerpt",
				"value" => array(__("Yes", 'ql_services') => 1, __("No", 'ql_services') => 0)
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => __("Show icon", 'ql_services'),
				"param_name" => "show_icon",
				"value" => array(__("Yes", 'ql_services') => 1, __("No", 'ql_services') => 0),
				"dependency" => array('element' => "type", 'value' => 'icons_list')
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => __("Icons links", 'ql_services'),
				"param_name" => "icons_links",
				"value" => array(__("Yes", 'ql_services') => 1, __("No", 'ql_services') => 0),
				"dependency" => array('element' => "show_icon", 'value' => '1')
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => __("Show featured image", 'ql_services'),
				"param_name" => "show_featured_image",
				"value" => array(__("Yes", 'ql_services') => 1, __("No", 'ql_services') => 0),
				"dependency" => array('element' => "type", 'value' => array('images_list', 'carousel'))
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => __("Featured image links", 'ql_services'),
				"param_name" => "featured_image_links",
				"value" => array(__("Yes", 'ql_services') => 1, __("No", 'ql_services') => 0),
				"dependency" => array('element' => "show_featured_image", 'value' => '1')
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => __("Extra class name", 'ql_services'),
				"param_name" => "class",
				"value" => ""
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => __("Top margin", 'ql_services'),
				"param_name" => "top_margin",
				"value" => array(__("None", 'ql_services') => "none", __("Page (small)", 'ql_services') => "page-margin-top", __("Section (large)", 'ql_services') => "page-margin-top-section")
			)
		);
		if(wp_get_theme()=="CleanMate")
		{
			$new_params = array(
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Display as", 'ql_services'),
					"param_name" => "display",
					"value" => array(__("List", 'ql_services') => "list", __("Carousel", 'ql_services') => "carousel")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Scroll control (pagination)", 'ql_services'),
					"param_name" => "scroll_control",
					"value" => array(__("Yes", 'ql_services') => 1, __("No", 'ql_services') => 0),
					"dependency" => array('element' => "display", 'value' => 'carousel')
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Featured image as background", 'ql_services'),
					"param_name" => "featured_image_bg",
					"value" => array(__("No", 'ql_services') => 0, __("Yes", 'ql_services') => 1),
					"dependency" => array('element' => "type", 'value' => 'icons_list')
				)
			);
			array_splice($params, 1, 0, $new_params);
			$new_params = array(
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Read more button", 'ql_services'),
					"param_name" => "read_more",
					"value" => array(__("No", 'ql_services') => 0, __("Yes", 'ql_services') => 1)
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Read more button label", 'ql_services'),
					"param_name" => "read_more_label",
					"value" => __("Learn more", 'ql_services'),
					"dependency" => Array('element' => "read_more", 'value' => "1")
				)
			);
			array_splice($params, -2, 0, $new_params);
			$new_params = array(
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Excerpt font size", 'ql_services'),
					"param_name" => "excerpt_size",
					"value" => array(__("Small", 'ql_services') => "small", __("Big", 'ql_services') => "big"),
					"dependency" => array('element' => "show_excerpt", 'value' => '1')
				)
			);
			array_splice($params, -8, 0, $new_params);
			$new_params = array(
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Icon size", 'ql_services'),
					"param_name" => "icon_size",
					"value" => array(__("Small", 'ql_services') => "small", __("Big", 'ql_services') => "big"),
					"dependency" => array('element' => "show_icon", 'value' => '1')
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Icon tick", 'ql_services'),
					"param_name" => "icon_tick",
					"value" => array(__("No", 'ql_services') => 0, __("Yes", 'ql_services') => 1),
					"dependency" => array('element' => "show_icon", 'value' => '1')
				)
			);
			array_splice($params, -6, 0, $new_params);
		}

		vc_map( array(
			"name" => __("Services list", 'ql_services'),
			"base" => "ql_services",
			"class" => "",
			"controls" => "full",
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-layer-custom-post-type-list",
			"category" => __('Plugins', 'ql_services'),
			"params" => $params
		));
	}
}
add_action("init", "ql_services_vc_init"); 
?>