<?php

/**
 * Import / Export Page.
 *
 * @link    https://plugins360.com
 * @since   4.5.2
 *
 * @package All_In_One_Video_Gallery
 */

$restrictions_settings = aiovg_get_option( 'aiovg_restrictions_settings' );
?>

<div id="aiovg-import-export" class="aiovg aiovg-import-export">
    <div class="aiovg-container">
        <div class="aiovg-header">
            <h1><?php esc_html_e( 'Bulk Import / Export', 'all-in-one-video-gallery' ); ?></h1>
            <p><?php esc_html_e( 'Quickly import videos in bulk from folders, CSV files, YouTube, or Vimeo—and export your existing videos to a CSV file.', 'all-in-one-video-gallery' ); ?></p>
        </div>

        <div class="aiovg-body">
            <!-- Auto Import from YouTube / Vimeo -->
            <details id="aiovg-import-youtube-vimeo" open>
				<summary>
					<span class="dashicons dashicons-cloud-saved"></span>
                    <span class="aiovg-summary-text">
					    <?php esc_html_e( 'Auto Import from YouTube / Vimeo', 'all-in-one-video-gallery' ); ?>
                    </span>
				</summary>               

                <div class="aiovg-details-content">
                    <div class="aiovg-form-controls">
                        <div class="aiovg-form-control">
                            <p class="description">
                                <?php esc_html_e( 'Automatically import videos from your YouTube or Vimeo account. Ideal for syncing entire channels or playlists with your website.', 'all-in-one-video-gallery' ); ?>
                            </p>

                            <p class="description">
                                <?php
                                printf( 
                                    '<strong>%s</strong> <a href="%s" target="_blank" rel="noopener noreferrer">%s</a> / <a href="%s" target="_blank" rel="noopener noreferrer">%s</a>',
                                    esc_html__( 'Need help?', 'all-in-one-video-gallery' ),
                                    'https://plugins360.com/all-in-one-video-gallery/auto-import-youtube-videos/',
                                    esc_html__( 'YouTube Import Tutorial', 'all-in-one-video-gallery' ),
                                    'https://plugins360.com/all-in-one-video-gallery/auto-import-vimeo-videos/',
                                    esc_html__( 'Vimeo Import Tutorial', 'all-in-one-video-gallery' )
                                );                        
                                ?>
                            </p>
                        </div>
                    
                        <?php if ( aiovg_fs()->is_not_paying() ) : ?>
                            <a href="<?php echo esc_url( aiovg_fs()->get_upgrade_url() ); ?>" class="button button-primary button-hero">
                                <?php esc_html_e( 'Upgrade to PRO', 'all-in-one-video-gallery' ); ?>
                            </a>
                        <?php else : ?>
                            <a href="<?php echo esc_url( admin_url( 'post-new.php?post_type=aiovg_automations' ) ); ?>" class="button button-primary button-hero">
                                <?php esc_html_e( 'Import from YouTube / Vimeo', 'all-in-one-video-gallery' ); ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
			</details>

            <!-- Import from Folder -->
            <details id="aiovg-import-folder">
                <summary>
					<span class="dashicons dashicons-open-folder"></span>
                    <span class="aiovg-summary-text">
					    <?php esc_html_e( 'Import from Folder', 'all-in-one-video-gallery' ); ?>
                    </span>
				</summary>

                <div class="aiovg-details-content">
                    <form id="aiovg-form-import-folder" method="post" novalidate>
                        <div class="aiovg-form-controls">
                            <?php the_aiovg_php_server_limits_notice(); ?>

                            <p class="description">
                                <?php _e( 'Import videos from a folder within your website. Supported formats: <strong>mp4</strong>, <strong>webm</strong>, <strong>ogv</strong>, <strong>m4v</strong>, <strong>mov</strong>. To add poster images, include image files (<strong>jpg</strong>, <strong>png</strong>, <strong>webp</strong>) with the same names as the videos. Video titles will be autogenerated from the file names.', 'all-in-one-video-gallery' ); ?>
                            </p>
                            
                            <!-- Field: Folder Path -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-folder" class="aiovg-form-label">
                                    <?php esc_html_e( 'Folder Path', 'all-in-one-video-gallery' ); ?>
                                    <span class="aiovg-form-required">*</span>
                                </label>

                                <input type="text" name="folder" id="aiovg-folder" class="widefat" placeholder="<?php printf( esc_attr__( 'Example: %s', 'all-in-one-video-gallery' ), 'wp-content/uploads/my-videos/' ); ?>" required />
                                
                                <p class="description">
                                    <?php _e( 'Enter a folder path within your WordPress directory. For example: <strong>wp-content/uploads/my-videos/</strong>', 'all-in-one-video-gallery' ); ?>
                                </p>
                            </div>

                            <!-- Field: Include Subfolders -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-include_subfolders" class="aiovg-form-label">
                                    <input type="checkbox" name="include_subfolders" id="aiovg-include_subfolders" value="1" />
                                    <?php esc_html_e( 'Include Subfolders', 'all-in-one-video-gallery' ); ?>
                                </label>

                                <p class="description">
                                    <?php esc_html_e( 'Check this option to also import videos from subfolders inside the selected folder.', 'all-in-one-video-gallery' ); ?>
                                </p>
                            </div>

                            <!-- Field: Video Categories -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-categories" class="aiovg-form-label">
                                    <?php esc_html_e( 'Video Categories', 'all-in-one-video-gallery' ); ?>
                                </label>
                
                                <ul class="aiovg-checklist widefat">
                                    <?php
                                    $args = array(
                                        'taxonomy'      => 'aiovg_categories',
                                        'walker'        => null,
                                        'checked_ontop' => false
                                    ); 
                                
                                    wp_terms_checklist( 0, $args );
                                    ?>
                                </ul>

                                <p class="description">
                                    <?php esc_html_e( 'Assign categories to the imported videos.', 'all-in-one-video-gallery' ); ?>
                                </p>
                            </div>

                            <!-- Field: Video Tags -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-tags" class="aiovg-form-label">
                                    <?php esc_html_e( 'Video Tags', 'all-in-one-video-gallery' ); ?>
                                </label>

                                <ul class="aiovg-checklist widefat">
                                    <?php
                                    $args = array(
                                        'taxonomy'      => 'aiovg_tags',
                                        'walker'        => null,
                                        'checked_ontop' => false
                                    ); 
                                
                                    wp_terms_checklist( 0, $args );
                                    ?>
                                </ul>

                                <p class="description">
                                    <?php esc_html_e( 'Assign tags to the imported videos.', 'all-in-one-video-gallery' ); ?>
                                </p>
                            </div>                          

                            <!-- Field: Set Featured Images -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-set_featured_image" class="aiovg-form-label">
                                    <input type="checkbox" name="set_featured_image" id="aiovg-set_featured_image" value="1" />
                                    <?php esc_html_e( 'Set Featured Images', 'all-in-one-video-gallery' ); ?>
                                </label>

                                <p class="description">
                                    <?php esc_html_e( 'Check this option to set matching images as featured images for your videos. This works only if the folder already contains image files with the same names as your videos.', 'all-in-one-video-gallery' ); ?>
                                </p>
                            </div>

                            <!-- Field: Enable Downloads -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-enable_downloads" class="aiovg-form-label">
                                    <input type="checkbox" name="enable_downloads" id="aiovg-enable_downloads" value="1" checked />
                                    <?php esc_html_e( 'Enable Downloads', 'all-in-one-video-gallery' ); ?>
                                </label>

                                <p class="description">
                                    <?php esc_html_e( 'Check this option to allow users to download the imported video files.', 'all-in-one-video-gallery' ); ?>
                                </p>
                            </div>

                            <!-- Field: Allow Comments -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-enable_comments" class="aiovg-form-label">
                                    <input type="checkbox" name="enable_comments" id="aiovg-enable_comments" value="1" checked />
                                    <?php esc_html_e( 'Allow Comments', 'all-in-one-video-gallery' ); ?>
                                </label>

                                <p class="description">
                                    <?php esc_html_e( 'Check this option to allow users to post comments on the imported videos.', 'all-in-one-video-gallery' ); ?>
                                </p>
                            </div>
                            
                            <?php if ( ! empty( $restrictions_settings['enable_restrictions'] ) ) : ?>
                                <!-- Field: Restrict Video Access -->
                                <div id="aiovg-field-access_control" class="aiovg-form-control">
                                    <label for="aiovg-access_control" class="aiovg-form-label">
                                        <?php esc_html_e( 'Restrict Video Access', 'all-in-one-video-gallery' ); ?>
                                    </label>

                                    <select name="access_control" id="aiovg-access_control" class="widefat">
                                        <?php 
                                        $options = array(
                                            -1 => '— ' . __( 'Global', 'all-in-one-video-gallery' ) . ' —',
                                            0  => __( 'Everyone', 'all-in-one-video-gallery' ),
                                            1  => __( 'Logged out users', 'all-in-one-video-gallery' ),
                                            2  => __( 'Logged in users', 'all-in-one-video-gallery' )
                                        );

                                        foreach ( $options as $key => $label ) {
                                            printf( 
                                                '<option value="%s">%s</option>', 
                                                esc_attr( $key ), 
                                                esc_html( $label )
                                            );
                                        }
                                        ?>
                                    </select>

                                    <p class="description">
                                        <?php esc_html_e( 'Select who can access the imported videos.', 'all-in-one-video-gallery' ); ?>
                                    </p>
                                </div>

                                <!-- Field: Allowed User Roles -->
                                <div id="aiovg-field-restricted_roles" class="aiovg-form-control" style="display: none;">
                                    <label for="aiovg-restricted_roles" class="aiovg-form-label">
                                        <?php esc_html_e( 'Allowed User Roles', 'all-in-one-video-gallery' ); ?>
                                    </label>
                
                                    <ul class="aiovg-checklist widefat">
                                        <?php
                                        $roles = aiovg_get_user_roles();

                                        foreach ( $roles as $role => $name ) : ?>
                                            <li>
                                                <label>
                                                    <input type="checkbox" name="restricted_roles[]" value="<?php echo esc_attr( $role ); ?>" />
                                                    <?php echo esc_html( $name ); ?>
                                                </label>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>

                                    <p class="description">
                                        <?php esc_html_e( 'Select the user roles allowed to access the imported videos. Users with editing permissions always have access.', 'all-in-one-video-gallery' ); ?>
                                    </p>
                                </div>
                            <?php endif; ?>
                            
                            <!-- Form Actions -->
                            <div class="aiovg-form-action">
                                <button type="submit" name="action" id="aiovg-button-import-folder" class="button button-primary button-hero">
                                    <?php esc_html_e( 'Scan & Import', 'all-in-one-video-gallery' ); ?>
                                </button>

                                <div class="aiovg-form-status" class="aiovg-import-folder-status" aria-live="polite" role="status"></div>
                            </div>
                        </div>
                    </form>
                </div>
            </details>

            <!-- Import from CSV File -->
            <details id="aiovg-import-csv">
                <summary>
					<span class="dashicons dashicons-download"></span>
                    <span class="aiovg-summary-text">
					    <?php esc_html_e( 'Import from CSV File', 'all-in-one-video-gallery' ); ?>
                    </span>
				</summary>

                <div class="aiovg-details-content">
                    <form id="aiovg-form-import-csv" method="post" novalidate>
                        <div class="aiovg-form-controls">
                            <?php the_aiovg_php_server_limits_notice(); ?>

                            <p class="description">
                                <?php esc_html_e( 'Upload a CSV file to bulk import videos with titles, descriptions, file URLs, and more. You can also include video and image files in a ZIP archive or reference them from a folder on your website.', 'all-in-one-video-gallery' ); ?>
                            </p>

                            <!-- Field: CSV File -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-csv_file" class="aiovg-form-label">
                                    <?php esc_html_e( 'CSV File', 'all-in-one-video-gallery' ); ?>
                                    <span class="aiovg-form-required">*</span>
                                </label>

                                <div class="aiovg-media-uploader">                                                
                                    <input type="text" name="csv_file" id="aiovg-csv_file" class="widefat" placeholder="<?php esc_attr_e( 'Upload your file using the button here', 'all-in-one-video-gallery' ); ?> &rarr;" required />
                                    <button type="button" class="aiovg-upload-media button" data-format="csv">
                                        <?php esc_html_e( 'Upload File', 'all-in-one-video-gallery' ); ?>
                                    </button>
                                </div>

                                <p class="description">
                                    <?php esc_html_e( 'Download sample file:', 'all-in-one-video-gallery' ); ?>
                                    <a href="https://github.com/Plugins360/assets/releases/download/v1.0.0/sample-videos.csv" target="_blank" rel="noopener noreferrer">sample-videos.csv</a>
                                </p> 
                            </div>

                            <!-- Field: ZIP File -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-zip_file" class="aiovg-form-label">
                                    <?php esc_html_e( 'ZIP File (Optional)', 'all-in-one-video-gallery' ); ?>
                                </label>

                                <div class="aiovg-media-uploader">                                                
                                    <input type="text" name="zip_file" id="aiovg-zip_file" class="widefat" placeholder="<?php esc_attr_e( 'Enter your folder path or upload your ZIP file using the button here', 'all-in-one-video-gallery' ); ?> &rarr;" />
                                    <button type="button" class="aiovg-upload-media button" data-format="zip">
                                        <?php esc_html_e( 'Upload File', 'all-in-one-video-gallery' ); ?>
                                    </button>
                                </div>

                                <p class="description">
                                    <?php esc_html_e( 'Download sample ZIP:', 'all-in-one-video-gallery' ); ?>
                                    <a href="https://github.com/Plugins360/assets/releases/download/v1.0.0/sample-videos.zip" target="_blank" rel="noopener noreferrer">sample-videos.zip</a>
                                </p>

                                <ul class="description aiovg-margin-top">
                                    <li>
                                        <span class="dashicons dashicons-lightbulb"></span>
                                        <?php echo esc_html__( 'If your ZIP is too large, upload your files to a folder inside your website and enter the folder path here.', 'all-in-one-video-gallery' ); ?>
                                    </li>
                                    <li>
                                        <?php echo sprintf( esc_html__( 'Example: %s', 'all-in-one-video-gallery' ), '<strong>wp-content/uploads/my-videos/</strong>' ); ?>
                                    </li>
                                    <li>
                                        <?php echo esc_html__( 'Uploaded CSV/ZIP files will be removed from your Media Library after the import. Files linked from a folder path will not be deleted.', 'all-in-one-video-gallery' ); ?>
                                    </li>
                                </ul>
                            </div>

                            <!-- Field: Columns Separator -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-columns_separator" class="aiovg-form-label">
                                    <?php esc_html_e( 'Columns Separator', 'all-in-one-video-gallery' ); ?>
                                    <span class="aiovg-form-required">*</span>
                                </label>

                                <input type="text" name="columns_separator" id="aiovg-columns_separator" class="widefat" placeholder="," value="," required />
                            </div>

                            <!-- Field: Multi Values Separator -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-values_separator" class="aiovg-form-label">
                                    <?php esc_html_e( 'Multi Values Separator', 'all-in-one-video-gallery' ); ?>
                                    <span class="aiovg-form-required">*</span>
                                </label>

                                <input type="text" name="values_separator" id="aiovg-values_separator" class="widefat" placeholder=";" value=";" required />

                                <ul class="description">
                                    <li>
                                        <span class="dashicons dashicons-yes"></span>
                                        <?php _e( '<strong>Multi Values</strong> - are fields that may contain more than one value, for example, categories, tags, and user roles. Separate them in one CSV column with the special delimiter in this field.', 'all-in-one-video-gallery' ); ?>
                                    </li>
                                    <li>
                                        <span class="dashicons dashicons-yes"></span>
                                        <?php _e( 'Use this to separate multiple categories or tags in a single field. Example: "<strong>Action ; Comedy ; Drama</strong>".', 'all-in-one-video-gallery' ); ?>
                                    </li>
                                    <li>
                                        <span class="dashicons dashicons-yes"></span>
                                        <?php _e( 'Use ">" to define subcategory hierarchy. Example: "<strong>Sports > Football ; Movies > English > Comedy</strong>".', 'all-in-one-video-gallery' ); ?>
                                    </li>
                                </ul>
                            </div>

                            <!-- Field: Create Missing Categories / Tags -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-add_new_term" class="aiovg-form-label">
                                    <input type="checkbox" name="add_new_term" id="aiovg-add_new_term" value="1" checked />
                                    <?php esc_html_e( 'Create Missing Categories / Tags', 'all-in-one-video-gallery' ); ?>                                    
                                </label> 

                                <p class="description">
                                    <?php esc_html_e( 'Create categories or tags if they do not already exist.', 'all-in-one-video-gallery' ); ?>
                                </p>                         
                            </div>

                            <!-- Field: Create Missing Authors -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-add_new_user" class="aiovg-form-label">
                                    <input type="checkbox" name="add_new_user" id="aiovg-add_new_user" value="1" checked />
                                    <?php esc_html_e( 'Create Missing Authors', 'all-in-one-video-gallery' ); ?>                                    
                                </label>

                                <p class="description">
                                    <?php esc_html_e( 'Create a new user if the author’s email in the CSV file is not found.', 'all-in-one-video-gallery' ); ?>
                                </p>
                            </div>

                            <!-- Field: Set Featured Images -->
                            <div class="aiovg-form-control">
                                <label for="aiovg-set_featured_image" class="aiovg-form-label">
                                    <input type="checkbox" name="set_featured_image" id="aiovg-set_featured_image" value="1" />
                                    <?php esc_html_e( 'Set Featured Images', 'all-in-one-video-gallery' ); ?>
                                </label>

                                <p class="description">
                                    <?php esc_html_e( 'Check this option to set the imported images as featured images for your videos. This works only if your CSV file includes an image column.', 'all-in-one-video-gallery' ); ?>
                                </p>
                            </div>
                            
                            <!-- Field: CSV Columns -->              
                            <div id="aiovg-field-csv_columns" style="display: none;">
                                <hr />
                                
                                <h3>
                                    <span class="dashicons dashicons-controls-repeat"></span> 
                                    <?php esc_html_e( 'Map CSV Columns to Video Fields', 'all-in-one-video-gallery' ); ?>
                                    <span class="aiovg-form-required">*</span>
                                </h3>

                                <p class="description">
                                    <?php esc_html_e( 'Match each column in your CSV file to the corresponding video field below. You must configure a "Video Title" and "Video File" field to proceed.', 'all-in-one-video-gallery' ); ?>
                                </p>

                                <div class="aiovg-form-grid"></div>
                            </div>                        

                            <!-- Form Actions -->
                            <div class="aiovg-form-action">
                                <button type="submit" name="action" id="aiovg-button-import-csv" class="button button-primary button-hero">
                                    <?php esc_html_e( 'Import Videos', 'all-in-one-video-gallery' ); ?>
                                </button>

                                <div class="aiovg-form-status" id="aiovg-import-csv-status" aria-live="polite" role="status"></div>
                            </div>
                        </div>
                    </form>
                </div>
            </details>

            <!-- Export Videos to a CSV or Zip file -->
            <details id="aiovg-export-videos">
                <summary>
					<span class="dashicons dashicons-external"></span>
                    <span class="aiovg-summary-text">
					    <?php esc_html_e( 'Export Videos', 'all-in-one-video-gallery' ); ?>
                    </span>
				</summary>

                <div class="aiovg-details-content">
                    <div class="aiovg-form-controls">
                        <?php the_aiovg_php_server_limits_notice(); ?>

                        <p class="description">
                            <?php esc_html_e( 'Use the buttons below to export your existing video posts. You can download a structured CSV file or a ZIP archive separately. These exports are useful for creating backups, migrating content, or editing data offline.', 'all-in-one-video-gallery' ); ?>
                        </p>

                        <!-- Form Actions -->
                        <div class="aiovg-form-action">
                            <div class="aiovg-button-group">
                                <button type="button" id="aiovg-button-export-csv" class="button button-primary button-hero">
                                    <?php esc_html_e( 'Export CSV', 'all-in-one-video-gallery' ); ?>
                                </button>

                                <button type="button" id="aiovg-button-export-zip" class="button button-hero">
                                    <?php esc_html_e( 'Export ZIP (Media Files)', 'all-in-one-video-gallery' ); ?>
                                </button>
                            </div>

                            <div class="aiovg-form-status" id="aiovg-export-status" aria-live="polite" role="status"></div>
                        </div>
                    </div>
                </div>
            </details>
        </div>
    </div>
</div>