<?php
/**
 * Autoloader based on tutorial by
 * Tom McFarlin https://tommcfarlin.com/  Licensed    GPL-2.0+
 */

spl_autoload_register( 'fullworks_Stop_Wp_Emails_Going_To_Spam_autoload' );

function fullworks_Stop_Wp_Emails_Going_To_Spam_autoload( $class_name ) {


	// If the specified $class_name does not include our namespace, duck out.
	if ( false === strpos( $class_name, 'Stop_Wp_Emails_Going_To_Spam' ) ) {
		return;
	}

	// Split the class name into an array to read the namespace and class.
	$file_parts = explode( '\\', $class_name );

	// Do a reverse loop through $file_parts to build the path to the file.
	$namespace = '';
	$file_path = '';
	for ( $i = count( $file_parts ) - 1; $i > 0; $i -- ) {

		// Read the current component of the file part.
		$current = strtolower( $file_parts[ $i ] );
		$current = str_ireplace( '_', '-', $current );

		// If we're at the first entry, then we're at the filename.
		if ( count( $file_parts ) - 1 === $i ) {

			/* If 'interface' is contained in the parts of the file name, then
			 * define the $file_name differently so that it's properly loaded.
			 * Otherwise, just set the $file_name equal to that of the class
			 * filename structure.
			 */
			if ( strpos( strtolower( $file_parts[ count( $file_parts ) - 1 ] ), 'interface' ) ) {

				// Grab the name of the interface from its qualified name.
				$interface_name = explode( '_', $file_parts[ count( $file_parts ) - 1 ] );
				$interface_name = $interface_name[0];

				$file_name = "interface-$interface_name.php";

			} else {
				$file_name = "class-$current.php";
			}
		} else {
			$namespace = '/' . $current . $namespace;
		}
	}

	// Now build a path to the file using mapping to the file location.
	$filepath = trailingslashit( dirname( dirname( __FILE__ ) ) . $namespace );
	$filepath .= $file_name;

	// If the file exists in the specified path, then include it.
	if ( file_exists( $filepath ) ) {
		include_once $filepath;
	} else {
		// changed to be translatable
		wp_die( sprintf( esc_html__( 'The system file attempting to be loaded at %1$s does not exist.', 'stop-wp-emails-going-to-spam' ), esc_html( $filepath ) ) );
	}
}