<?php
if ( !is_admin() ) { die( 'Access Denied.' ); }

$settings_form = new pb_backupbuddy_settings( 'advanced_settings', '', 'tab=1', 320 );



$settings_form->add_setting( array(
	'type'		=>		'title',
	'name'		=>		'title_basic',
	'title'		=>		__( 'Basic Operation', 'it-l10n-backupbuddy' ),
) );





$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'backup_reminders',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__( 'Enable backup reminders', 'it-l10n-backupbuddy' ),
	'tip'		=>		__( '[Default: enabled] - When enabled links will be displayed upon post or page edits and during WordPress upgrades to remind and allow rapid backing up after modifications or before upgrading.', 'it-l10n-backupbuddy' ),
	'css'		=>		'',
	'after'		=>		'',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'archive_name_format',
	'options'	=>		array( 'unchecked' => 'date', 'checked' => 'datetime' ),
	'title'		=>		__( 'Add time in backup file name', 'it-l10n-backupbuddy' ),
	'tip'		=>		__( '[Default: disabled (date only)] - When enabled your backup filename will display the time the backup was created in addition to the default date. This is useful when making multiple backups in a one day period.', 'it-l10n-backupbuddy' ),
	'css'		=>		'',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'lock_archives_directory',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__( 'Lock archive directory (high security)', 'it-l10n-backupbuddy' ),
	'tip'		=>		__( '[Default: disabled] - When enabled all downloads of archives via the web will be prevented under all circumstances via .htaccess file. If your server permits it, they will only be unlocked temporarily on click to download. If your server does not support this unlocking then you will have to access the archives via the server (such as by FTP).', 'it-l10n-backupbuddy' ),
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __('May prevent downloading backups within WordPress on incompatible servers', 'it-l10n-backupbuddy' ),
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'include_importbuddy',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__('Include ImportBuddy in full backup archive', 'it-l10n-backupbuddy' ),
	'tip'		=>		__('[Default: enabled] - When enabled, the importbuddy.php (restoration tool) file will be included within the backup archive ZIP file in the location `/' . str_replace( ABSPATH, '', backupbuddy_core::getTempDirectory() ) . ' xxxxxxxxxx/ importbuddy.php` where the x\'s match the unique random string in the backup ZIP filename.', 'it-l10n-backupbuddy' ),
	'css'		=>		'',
	'after'		=>		' <span style="white-space: nowrap;"><span class="description">' . __( 'Located in backup', 'it-l10n-backupbuddy' ) . ':</span>&nbsp; <span class="code" style="white-space: normal; background: #EAEAEA;"">/' . str_replace( ABSPATH, '', backupbuddy_core::getTempDirectory() ) . 'xxxxxxxxxx/importbuddy.php</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'select',
	'name'		=>		'default_backup_tab',
	'title'		=>		__('Default backup tab', 'it-l10n-backupbuddy' ),
	'options'	=>		array(
								'0'		=>		__( 'Overview', 'it-l10n-backupbuddy' ),
								'1'		=>		__( 'Status Log', 'it-l10n-backupbuddy' ),
							),
	'tip'		=>		sprintf( __('[Default: Overview] - The default tab open during a backup is the overview tab. A more technical view is available in the Status tab.', 'it-l10n-backupbuddy' ) ),
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'disable_localization',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__( 'Disable language localization', 'it-l10n-backupbuddy' ),
	'tip'		=>		__( '[Default: Unchecked] When checked language localization support will be disabled. BackupBuddy will revert to full English language mode. Use this to display logs in English for support.', 'it-l10n-backupbuddy' ) . '</span>',
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __( 'Check to run BackupBuddy in English. This is useful for support.', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
) );




$settings_form->add_setting( array(
	'type'		=>		'title',
	'name'		=>		'title_logging',
	'title'		=>		__( 'Logging', 'it-l10n-backupbuddy' ),
) );



$log_file = backupbuddy_core::getLogDirectory() . 'log-' . pb_backupbuddy::$options['log_serial'] . '.txt';
$settings_form->add_setting( array(
	'type'		=>		'select',
	'name'		=>		'log_level',
	'title'		=>		'<b>' . __('Logging Level', 'it-l10n-backupbuddy' ) . '</b>',
	'options'	=>		array(
								'0'		=>		__( 'None', 'it-l10n-backupbuddy' ),
								'1'		=>		__( 'Errors Only (default)', 'it-l10n-backupbuddy' ),
								'2'		=>		__( 'Errors & Warnings', 'it-l10n-backupbuddy' ),
								'3'		=>		__( 'Everything (troubleshooting mode)', 'it-l10n-backupbuddy' ),
							),
	'tip'		=>		sprintf( __('[Default: Errors Only] - This option controls how much activity is logged for records or troubleshooting. Logs may be viewed from the Logs / Other tab on the Settings page. Additionally when in Everything / Troubleshooting mode error emails will contain encrypted troubleshooting data for support. Log file: %s', 'it-l10n-backupbuddy' ), $log_file ),
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'text',
	'name'		=>		'max_site_log_size',
	'title'		=>		__('Maximum main log file size', 'it-l10n-backupbuddy' ),
	'tip'		=>		__('[Default: 10 MB] - If the log file exceeds this size then it will be cleared to prevent it from using too much space.' ),
	'rules'		=>		'required|int',
	'css'		=>		'width: 50px;',
	'after'		=>		' MB',
) );
$settings_form->add_setting( array(
	'type'		=>		'text',
	'name'		=>		'max_send_stats_days',
	'title'		=>		__('Recent remote send stats max age', 'it-l10n-backupbuddy' ),
	'tip'		=>		sprintf( __('[Default: Errors Only] - This option controls how much activity is logged for records or troubleshooting. Logs may be viewed from the Logs / Other tab on the Settings page. Additionally when in Everything / Troubleshooting mode error emails will contain encrypted troubleshooting data for support. Log file: %s', 'it-l10n-backupbuddy' ), $log_file ),
	'tip'		=>		__('[Default: 7 days] - Number of days to store recently sent file statistics & logs. Valid options are 1 to 90 days.' ),
	'css'		=>		'width: 50px;',
	'rules'		=>		'required|int[1-90]',
	'after'		=>		' days',
) );
$settings_form->add_setting( array(
	'type'		=>		'text',
	'name'		=>		'max_send_stats_count',
	'title'		=>		__('Recent remote send stats max number', 'it-l10n-backupbuddy' ),
	'tip'		=>		sprintf( __('[Default: Errors Only] - This option controls how much activity is logged for records or troubleshooting. Logs may be viewed from the Logs / Other tab on the Settings page. Additionally when in Everything / Troubleshooting mode error emails will contain encrypted troubleshooting data for support. Log file: %s', 'it-l10n-backupbuddy' ), $log_file ),
	'tip'		=>		__('[Default: 7 days] - Maximum number of recently sent file statistics & logs to store. Valid options are 1 to 25 sends.' ),
	'css'		=>		'width: 50px;',
	'rules'		=>		'required|int[1-25]',
	'after'		=>		' sends',
) );






$settings_form->add_setting( array(
	'type'		=>		'title',
	'name'		=>		'title_advanced',
	'title'		=>		__( 'Technical & Server Compatibility', 'it-l10n-backupbuddy' ),
) );






$settings_form->add_setting( array(
	'type'		=>		'select',
	'name'		=>		'backup_mode',
	'title'		=>		'<b>' . __('Default global backup mode', 'it-l10n-backupbuddy' ) . '</b>',
	'options'	=>		array(
								'1'		=>		__( 'Classic (v1.x) - Entire backup in single PHP page load', 'it-l10n-backupbuddy' ),
								'2'		=>		__( 'Modern (v2.x+) - Split across page loads via WP cron', 'it-l10n-backupbuddy' ),
							),
	'tip'		=>		__('[Default: Modern] - If you are encountering difficulty backing up due to WordPress cron, HTTP Loopbacks, or other features specific to version 2.x you can try classic mode which runs like BackupBuddy v1.x did.', 'it-l10n-backupbuddy' ),
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'delete_archives_pre_backup',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__( 'Delete all backup archives prior to backups', 'it-l10n-backupbuddy' ),
	'tip'		=>		__( '[Default: disabled] - When enabled all local backup archives will be deleted prior to each backup. This is useful if in compatibilty mode to prevent backing up existing files.', 'it-l10n-backupbuddy' ),
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __('Use is exclusions are malfunctioning or for special purposes.', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'disable_https_local_ssl_verify',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__( 'Disable local SSL certificate verification', 'it-l10n-backupbuddy' ),
	'tip'		=>		__( '[Default: Disabled] When checked, WordPress will skip local https SSL verification.', 'it-l10n-backupbuddy' ) . '</span>',
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __( 'Workaround if local SSL verification fails (ie. for loopback & local CA cert issues).', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'prevent_flush',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__( 'Prevent Flushing', 'it-l10n-backupbuddy' ),
	'tip'		=>		__( '[Default: not prevented (unchecked)] - Rarely some servers die unexpectedly when flush() or ob_flush() are called multiple times during the same PHP process. Checking this prevents these from ever being called during backups.', 'it-l10n-backupbuddy' ),
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __('Check if directed by support.', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'save_comment_meta',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__( 'Save meta data in comment', 'it-l10n-backupbuddy' ),
	'tip'		=>		__( '[Default: Enabled] When enabled, BackupBuddy will store general backup information in the ZIP comment header such as Site URL, backup type & time, serial, etc. during backup creation.', 'it-l10n-backupbuddy' ) . '</span>',
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __( 'If backups hang when saving meta data disabling skips this process.', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'profiles#0#integrity_check',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__('Perform integrity check on backup files', 'it-l10n-backupbuddy' ),
	'tip'		=>		__('[Default: enabled] - By default each backup file is checked for integrity and completion the first time it is viewed on the Backup page.  On some server configurations this may cause memory problems as the integrity checking process is intensive.  If you are experiencing out of memory errors on the Backup file listing, you can uncheck this to disable this feature.', 'it-l10n-backupbuddy' ),
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __( 'Disable if the backup page will not load or backups hang on integrity check.', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'backup_cron_rescheduling',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__('Reschedule missing crons in manual backups', 'it-l10n-backupbuddy' ),
	'tip'		=>		__('[Default: disabled] - To proceed to subsequent steps during backups BackupBuddy schedules the next step with the WordPress cron system.  If this cron goes missing the backup cannot proceed. This feature instructs BackupBuddy to attempt to re-schedule this cron as it occurs.', 'it-l10n-backupbuddy' ),
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __( 'Check if directed by support.', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'skip_spawn_cron_call',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__('Skip chained spawn of cron', 'it-l10n-backupbuddy' ),
	'tip'		=>		__('[Default: disabled] - When skipping is enabled BackupBuddy will not call spawn_cron() in an attempt to force chaining of cron processes. spawn_cron() cause trouble on some servers.', 'it-l10n-backupbuddy' ),
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __( 'Check if directed by support.', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
) );







$settings_form->add_setting( array(
	'type'		=>		'title',
	'name'		=>		'title_database',
	'title'		=>		__( 'Database', 'it-l10n-backupbuddy' ),
) );






$settings_form->add_setting( array(
	'type'		=>		'select',
	'name'		=>		'database_method_strategy',
	'title'		=>		'<b>' . __('Database method strategy', 'it-l10n-backupbuddy' ) . '</b>',
	'options'	=>		array(
		'php'			=>		__( 'PHP-based: Supports automated chunked resuming - default', 'it-l10n-backupbuddy' ),
		'commandline'	=>		__( 'Commandline: Fast but does not support resuming', 'it-l10n-backupbuddy' ),
		'all'			=>		__( 'All Available: ( PHP [chunking] > Commandline via exec()  )', 'it-l10n-backupbuddy' ),
	),
	'tip'		=>		__('[Default: PHP-based] - Normally use PHP-based which supports chunking (as of BackupBuddy v5) to support larger databases. Commandline-based database dumps use mysqldump which is very fast and efficient but cannot be broken up into smaller steps if it is too large which could result in timeouts on larger servers.', 'it-l10n-backupbuddy' ),
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'profiles#0#skip_database_dump',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__('Skip database dump on backup', 'it-l10n-backupbuddy' ),
	'tip'		=>		__('[Default: disabled] - (WARNING: This prevents BackupBuddy from backing up the database during any kind of backup. This is for troubleshooting / advanced usage only to work around being unable to backup the database.', 'it-l10n-backupbuddy' ),
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __('Completely bypass backing up database for all database types. Use caution.', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
	'orientation' =>	'vertical',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'breakout_tables',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__( 'Break out big table dumps into steps', 'it-l10n-backupbuddy' ),
	'tip'		=>		__( '[Default: enabled] When enabled, BackupBuddy will dump some of the commonly larger tables in separate steps. Note this only applies to command-line based dumps as PHP-based dumps automatically support chunking with resume on table and/or row as needed.', 'it-l10n-backupbuddy' ) . '</span>',
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __( 'Commandline method: Break up dumping of big tables (chunking)', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'force_single_db_file',
	'options'	=>		array( 'unchecked' => '1', 'checked' => '0' ),
	'title'		=>		__( 'Use separate files per table (when possible)', 'it-l10n-backupbuddy' ),
	'tip'		=>		__( '[Default: enabled] When enabled, BackupBuddy will dump individual tables to their own database file (eg wp_options.sql, wp_posts.sql, etc) when possible based on other criteria such as the dump method and whether breaking out big tables is enabled.', 'it-l10n-backupbuddy' ) . '</span>',
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __( 'Uncheck to force dumping all tables into a single db_1.sql file.', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'text',
	'name'		=>		'phpmysqldump_maxrows',
	'title'		=>		__('Compatibility mode max rows per select', 'it-l10n-backupbuddy' ),
	'tip'		=>		__('[Default: *blank*] - When BackupBuddy is using compatibility mode mysql dumping (via PHP), BackupBuddy selects data from the database. Reducing this number has BackupBuddy grab smaller portions from the database at a time. Leave blank to use built in default (around 2000 rows per select).', 'it-l10n-backupbuddy' ),
	'css'		=>		'width: 50px;',
	'after'		=>		' rows. <span class="description"> ' . __( 'Blank for default.', 'it-l10n-backupbuddy' ) . ' (~1000 rows/select)</span>',
	'rules'		=>		'int',
) );
$settings_form->add_setting( array(
	'type'		=>		'text',
	'name'		=>		'max_execution_time',
	'title'		=>		'<b>' . __('Maximum time per chunk', 'it-l10n-backupbuddy' ) . '</b>',
	'tip'		=>		__('[Default: *blank*] - The maximum amount of time BackupBuddy should allow a database import chunk to run. BackupBuddy by default limits each chunk to your Maximum PHP runtime when using the default PHP-based method. If your database dump step is timing out then lowering this value will instruct the script to limit each `chunk` to allow it to finish within this time period. Raising this value above your servers limits will not increase or override server settings.', 'it-l10n-backupbuddy' ),
	'css'		=>		'width: 50px;',
	'after'		=>		' sec. <span class="description"> ' . __( 'Blank for detected default.', 'it-l10n-backupbuddy' ) . ' (' . backupbuddy_core::detectMaxExecutionTime() . ' sec)</span>',
	'rules'		=>		'int',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'ignore_command_length_check',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__('Skip max command line length check ', 'it-l10n-backupbuddy' ),
	'tip'		=>		__('[Default: disabled] - WARNING: BackupBuddy attempts to determine your system\'s maximum command line length to insure that database operation commands do not get inadvertantly cut off. On some systems it is not possible to reliably detect this information which could result in falling back into compatibility mode even though the system is capable of running in normal operational modes. This option instructs BackupBuddy to skip the command line length check.', 'it-l10n-backupbuddy' ),
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __( 'Check if directed by support.', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
) );



$settings_form->add_setting( array(
	'type'		=>		'title',
	'name'		=>		'title_zip',
	'title'		=>		__( 'Zip', 'it-l10n-backupbuddy' ),
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'compression', //'profiles#0#compression',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		'<b>' . __( 'Enable zip compression', 'it-l10n-backupbuddy' ) . '</b>',
	'tip'		=>		__( '[Default: enabled] - ZIP compression decreases file sizes of stored backups. If you are encountering timeouts due to the script running too long, disabling compression may allow the process to complete faster.', 'it-l10n-backupbuddy' ),
	'css'		=>		'',
	'after'		=>		'<span class="description"> ' . __('Unchecking typically DOUBLES the amount of data which may be zipped up before timeouts.', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'select',
	'name'		=>		'zip_method_strategy',
	'title'		=>		'<b>' . __('Zip method strategy', 'it-l10n-backupbuddy' ) . '</b>',
	'options'	=>		array(
								'1'		=>		__( 'Best Available', 'it-l10n-backupbuddy' ),
								'2'		=>		__( 'All Available', 'it-l10n-backupbuddy' ),
								'3'		=>		__( 'Force Compatibility', 'it-l10n-backupbuddy' ),
							),
	'tip'		=>		__('[Default: Best Only] - Normally use Best Available but if the server is unreliable in this mode can try All Available or Force Compatibility', 'it-l10n-backupbuddy' ),
	'after'		=>		'<span class="description"> ' . __('Select Force Compatibility if absolutely necessary.', 'it-l10n-backupbuddy' ) . '</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'alternative_zip_2',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		'<b>' . __( 'Alternative zip system (BETA)', 'it-l10n-backupbuddy' ) . '</b>',
	'tip'		=>		__( '[Default: Disabled] Use if directed by support.', 'it-l10n-backupbuddy' ) . '</span>',
	'css'		=>		'',
	'after'		=>		'<span class="description"> Check if directed by support.</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'disable_zipmethod_caching',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__( 'Disable zip method caching', 'it-l10n-backupbuddy' ),
	'tip'		=>		__( '[Default: Disabled] Use if directed by support. Bypasses caching available zip methods so they are always displayed in logs. When unchecked BackupBuddy will cache command line zip testing for a few minutes so it does not run too often. This means that your backup status log may not always show the test results unless you disable caching.', 'it-l10n-backupbuddy' ) . '</span>',
	'css'		=>		'',
	'after'		=>		'<span class="description"> Check if directed by support to always log zip detection.</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'ignore_zip_warnings',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__( 'Ignore zip archive warnings', 'it-l10n-backupbuddy' ),
	'tip'		=>		__( '[Default: Disabled] When enabled BackupBuddy will ignore non-fatal warnings encountered during the backup process such as inability to read or access a file, symlink problems, etc. These non-fatal warnings will still be logged.', 'it-l10n-backupbuddy' ) . '</span>',
	'css'		=>		'',
	'after'		=>		'<span class="description"> Check to ignore non-fatal errors when zipping files.</span>',
	'rules'		=>		'required',
) );
$settings_form->add_setting( array(
	'type'		=>		'checkbox',
	'name'		=>		'ignore_zip_symlinks',
	'options'	=>		array( 'unchecked' => '0', 'checked' => '1' ),
	'title'		=>		__( 'Ignore/do-not-follow symbolic links', 'it-l10n-backupbuddy' ),
	'tip'		=>		__( '[Default: Enabled] When enabled BackupBuddy will ignore/not-follow symbolic links encountered during the backup process', 'it-l10n-backupbuddy' ) . '</span>',
	'css'		=>		'',
	'after'		=>		'<span class="description"> Symbolic links are followed by default. Unfollowable links may cause failures.</span>',
	'rules'		=>		'required',
) );







$settings_form->process(); // Handles processing the submitted form (if applicable).
$settings_form->display_settings( 'Save Advanced Settings' );

