<?php
/**
 *
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * WARNING:	THERE ARE ABSOLUTELY NO EDITABLE PORTIONS OF THIS SCRIPT.
 * 			ALL OPTIONS ARE CONFIGURABLE VIA THE WEB INTERFACE.
 *			YOU CAN EXTEND THE FUNCTIONALITY BY WRITING A MODULE
 *			SEE /repairbuddy/modules/ FOR EXAMPLES ON FUNCTIONAL MODULES
 *
 * -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 *
 * Script Name: RepairBuddy.php for use with BackupBuddy backups.
 * Plugin URI: http://pluginbuddy.com/backupbuddy/
 * Description: Backup - Restore - Migrate. Backs up files, settings, and content for a complete snapshot of your site. Allows migration to a new host or URL.
 * Version: 0.0.1 - See repairbuddy/history.txt
 * Author: Dustin Bolton and Ronald Huereca
 * Author URI: http://pluginbuddy.com/
 *
 * Usage:
 * 
 * 1. Upload this script to the server you would like to repair/troubleshoot.
 * 2. Upload your backup ZIP file created with BackupBuddy.
 * 3. Navigate to the web address of this script. Ex: http://yoursite.com/repairbuddy.php
 * 4. Follow the on screen instructions.
 * 
 */

//EXTRACT REPAIRBUDDY
// Unpack files into directory.
/**
 *	mkdir_recursive()
 *
 *	Recursively creates the directories needed to generate a full directory path.
 *
 *	$path		string		Full absolute path to generate.
 *	@return		null
 *
 */
function mkdir_recursive( $path ) {
	if ( empty( $path ) ) { // prevent infinite loop on bad path
		return;
	}
	is_dir( dirname( $path ) ) || mkdir_recursive( dirname( $path ) );
	return is_dir( $path ) || mkdir( $path );
}

/**
*	unpack_packbuddy()
*
*	Unpacks required files encoded in importbuddy.php into stand-alone files.
*
*	@return		null
*/
function unpack_repairbuddy( $pb_abspath = '' ) {
	if ( !is_writable( $pb_abspath ) ) {
		echo 'Error #224834. This directory is not write enabled. Please verify write permissions to continue.';
		die();
	} else {
		$unpack_file = '';
		
		$handle = @fopen( $pb_abspath . 'repairbuddy.php', 'r' );
		if ( $handle ) {
			while ( ( $buffer = fgets( $handle ) ) !== false ) {
				if ( substr( $buffer, 0, 11 ) == '###PACKDATA' ) {
					$packdata_commands = explode( ',', trim( $buffer ) );
					array_shift( $packdata_commands );
					
					if ( $packdata_commands[0] == 'BEGIN' ) {
						// Start packed data.
					} elseif ( $packdata_commands[0] == 'FILE_START' ) {
						$unpack_file = $packdata_commands[2];
					} elseif ( $packdata_commands[0] == 'FILE_END' ) {
						$unpack_file = '';
					} elseif ( $packdata_commands[0] == 'END' ) {
						return;
					}
				} else {
					if ( $unpack_file != '' ) {
						if ( !is_dir( dirname( $pb_abspath . $unpack_file ) ) ) {
							mkdir_recursive( dirname( $pb_abspath . $unpack_file ) );
						}
						file_put_contents( $pb_abspath . $unpack_file, trim( base64_decode( $buffer ) ) );
					}
				}
			}
			if ( !feof( $handle ) ) {
				echo "Error: unexpected fgets() fail\n";
			}
			fclose( $handle );
		}
	}
} //end unpack_repairbuddy

$pb_abspath = dirname( __FILE__ ) . '/';
if ( !file_exists( $pb_abspath . 'repairbuddy' ) ) {
	unpack_repairbuddy( $pb_abspath );
	if ( !file_exists( $pb_abspath . 'repairbuddy' ) ) {
		die( 'Unable to unpack RepairBuddy. Error #24349489.' );
	}
}

require_once( 'repairbuddy/_load.php' );

class pluginbuddy_repairbuddy {
	var $_version = '1.0.0';
	var $_bbversion = '#VERSION#';
	var $_selfdestruct = '#SELFDESTRUCT#';
	
	var $debug = false;
	var $_timestamp = 'M j, Y, H:i:s';						// PHP timestamp format.
	var $_bootstrap_wordpress = false;
	
	var $_defaults = array(
		'repair_password'			=>		'#PASSWORD#',	// MD5 hash of the import password. Prevents unauthorized access. Default: #PASSWORD#
		'password'					=>		'',				// MD5 hash of password given.
	);
	var $_modules = array();
	var $_options = array();
	var $_database_connected = false;
	var $_wpconfig_loaded = false;
	
	/**
	 *	pluginbuddy_importbuddy()
	 *
	 *	Default constructor.
	 *
	 */
	function __construct() {
		// SELF DESTRUCT IF APPLICABLE!
		if ( $this->_selfdestruct != ' #SELFDESTRUCT#' ) {
			if ( $this->_selfdestruct > time() ) {
				echo '<html><body><h3>RepairBuddy is self-destructing . . .</h3>This copy of RepairBuddy has been set to self destruct & expire and the expiration time has passed.</body></html>';
				$this->wipe_repairbuddy();
			}
		}
		
		
		// Prevent access to importbuddy.php if it is still in plugin directory.
		if ( file_exists( dirname( __FILE__ ) . '/backupbuddy.php' ) ) {
			echo 'This file can ONLY be accessed on the destination server that you wish to use the script on.<br>';
			echo 'Upload the importer in the root web directory on the destination server and try again.<br><br>';
			echo 'If you need assistance visit <a href="http://pluginbuddy.com">http://pluginbuddy.com</a>';
			die();
		}
		
		
		// Start logging time for steps that report how long they took.
		$this->time_start = microtime( true );
		
		
		
		// Set up PHP error levels.
		if ( ( $this->debug === true ) || ( isset( $this->_options[ 'show_php_warnings' ] ) &&$this->_options['show_php_warnings'] === true ) ) {
			error_reporting( E_ERROR | E_WARNING | E_PARSE | E_NOTICE ); // HIGH
			$this->log( 'PHP error reporting set HIGH.' );
		} else {
			error_reporting( E_ALL ^ E_NOTICE ); // LOW
		}
		
		// Detect max execution time for database steps so they can pause when needed for additional PHP processes.
		$this->detected_max_execution_time = str_ireplace( 's', '', ini_get( 'max_execution_time' ) );
		if ( is_numeric( $this->detected_max_execution_time ) === false ) {
			$detected_max_execution_time = 30;
		}
		
		// Handle authentication (if needed).
		$this->has_access = false; // default
		if ( $this->_defaults['repair_password'] == '#PASSWORD#' ) {
			//$this->has_access = true;
			die( 'Error #454545. A password is required for this script to function.' );
		} else {
			if ( md5( $this->_options['password'] ) == $this->_defaults['repair_password'] ) {
				$this->has_access = true;
			} 
			if ( isset( $_POST['password'] ) || isset( $_GET['v'] ) ) {
				if	( md5( $_POST['password'] ) == $this->_defaults['repair_password'] ) {
					$this->_options['password'] = $_POST['password'];
					$this->has_access = true;
				}
				if ( isset( $_GET['v'] ) &&	( $_GET['v'] == ( 'xv' . md5( $this->_defaults['repair_password'] . 'repairbuddy' . $_GET['page'] ) ) ) ) {
					$this->has_access = true;
				}
			} elseif ( isset( $_POST[ 'hash' ] ) && isset( $_POST[ 'page' ] ) ) {
				if ( $_POST[ 'hash' ] == ( 'xv' . md5( $this->_defaults[ 'repair_password' ] . 'repairbuddy' . $_POST[ 'page' ] ) ) ) {
					$this->has_access = true;
				}
			}
			
		}
		
		//Initialize The database
		if ( $this->_wpconfig_loaded = ( defined( 'PB_WP_CONFIG' ) ) ) {
			$this->_database_connected = defined( 'PB_DB_LOADED' );	
		}

		
		pb_add_action( 'repairbuddy_init', array( &$this, 'init' ) );
		
		
		
		
	} //end constructor
	
	function has_db_access() {
		return $this->_database_connected;
	} //end has_db_access
	
	function has_access() {
		return $this->has_access;
	} //end has_db_access
	
	function ajax_url( ) {
		$path = 'repairbuddy/ajax.php';
		$plugin == __FILE__;
		$plugin_dir = rtrim( dirname( $plugin ), '/' );
		//die( $plugin_dir );
		$plugin_path = rtrim( str_replace( ABSPATH, '', $plugin_dir ), '/' );
		$root_path = 'http://' . $_SERVER[ 'HTTP_HOST' ] . str_replace( $plugin_path, '', $_SERVER[ 'REQUEST_URI' ] );
		
		$filename = basename( $_SERVER[ 'REQUEST_URI' ] );
		$full_url = "http://" . $_SERVER['HTTP_HOST']  .$_SERVER['REQUEST_URI'];
		$full_url = rtrim( str_replace( $filename, '', $full_url ), '/' ) . '/' . $plugin_path;
		
		if ( !empty( $path ) && is_string( $path) ) {
			$full_url .= ltrim( $path, '/' );
		}
			
		?>
		<script type='text/javascript'>
		var pb_ajaxurl = '<?php echo $full_url; ?>';
		</script>
		<?php
	} //end ajax_url
	
	function init() {
		pb_do_action( 'init' );
		// LOAD PAGE TEMPLATE.
		if ( defined( "PB_DOING_AJAX" ) ) return;
		require_once( 'repairbuddy/_template.php' );
	}
	
	//Returns a Module title, false on failure
	function get_module_title( $slug = '' ) {
		$page_slug = isset( $_GET[ 'page' ] ) ? $_GET[ 'page' ] : false;
		if ( !empty( $slug ) ) $page_slug = $slug;
		
		foreach ( $this->_modules as $priority => $modules ) {
			foreach ( $modules as $module ) {
				if ( $module[ 'slug' ] == $page_slug ) {
					return $module[ 'title' ];
				}
			}
		}
		return false;
	} //end get_module_name
	
	
	/**
	 *	register_module()
	 *
	 *	Registers a new module. Typically this is called from the module's init.php within the module directory.
	 *	Modules must be registered here to show on the main page.
	 *	
	 *	@param			$module_slug			string		Module slug. Alphanumeric + underscores + dashes permitted.
	 *	@param			$module_title			string		Informative short title. 1-3 words.
	 *	@param			$module_description		string		Short descriptive sentence explaining the module.
	 *	@param			$module_default_page	string		Base name of the default page to load when clicking the module. pagename.php in the pages directory within the module.
	 *	@param			$bootstrap_wordpress	boolean		True: Load WordPress backend via wp-load.php.
	 *	@param			$is_minimode			string		True: Display the module at the bottom of the page as a small button. False: Large button up top.
	 *	@param			$is_subtle				string		True: Display the button as less prominent than other buttons. Currently only in use for minimode.
	 *	@return			null
	 */
	function register_module( $args = array() ) {
		$defaults = array(
			'slug' => '',
			'title' => '',
			'description' => '',
			'page' => '',
			'bootstrap_wordpress' => false,
			'mini_mode' => '',
			'is_subtle' => '',
			'priority' => 10,
		);
		$defaults = array_merge( $defaults, $args );
		$this->_modules[ intval( $defaults[ 'priority' ] ) ][] = $defaults;
	} //end register_module
	
	
	/**
	 *	alert()
	 *
	 *	Displays a message to the user.
	 *
	 *	$message		string		Message you want to display to the user.
	 *	$error			boolean		OPTIONAL! true indicates this alert is an error and displays as red. Default: false
	 *	$error_code		int			OPTIONAL! Error code number to use in linking in the wiki for easy reference.
	 */
	function alert( $message_title, $message_details = '', $error_code = '' ) {
		?>
		<div class="alert">
			<img src="repairbuddy/images/alert.png" style="float: left;" height="55">
			<div style="margin-left: 65px;">
				<b><?php echo $message_title; ?></b><br><br>
				<?php echo $message_details; ?>
				<?php
				if ( ( $error_code != '' ) && ( $error_code != '9021' ) ) {
					echo '<p><a href="http://ithemes.com/codex/page/BackupBuddy:_Error_Codes#' . $error_code . '" target="_new"><i>BackupBuddy Error Code ' . $error_code . ' - Click for more details.</i></a></p>';
					$this->log( 'Error #' . $error_code . ': ' . $message_title, 'error' );
				}
				?>
			</div>
		</div>
		<?php
	}
	
	function output_status( $message, $is_error = false ) {
		$class = $is_error ? 'error' : 'updated';
		?>
		<div class='<?php echo $class; ?>'><p><strong><?php echo $message; ?></strong></p></div>
		<?php
	} //end status
	
	
	/**
	 *	log()
	 *
	 *	Logs to a text file depending on settings.
	 *	0 = none, 1 = errors only, 2 = errors + warnings, 3 = debugging (all kinds of actions)
	 *
	 *	$text		string		Text to log.
	 *	$log_type	string		Valid options: error, warning, all (default so may be omitted).
	 *
	 */
	function log( $text, $log_type = 'all' ) {
		$write = false;
		
		if ( $this->_options['log_level'] == 0 ) { // No logging.
			return;
		} elseif ( $this->_options['log_level'] == 1 ) { // Errors only.
			if ( $log_type == 'error' ) {
				$write = true;
			}
		} elseif ( $this->_options['log_level'] == 2 ) { // Errors and warnings only.
			if ( ( $log_type == 'error' ) || ( $log_type == 'warning' ) ) {
				$write = true;
			}
		} elseif ( $this->_options['log_level'] == 3 ) { // Log all; Errors, warnings, actions, notes, etc.
			$write = true;
		}
		if ( is_writable( ABSPATH ) ) {
			$fh = fopen( ABSPATH . 'importbuddy.txt', 'a');
			if ( $fh !== false ) {
				fwrite( $fh, '[' . date( $this->_timestamp, time() ) . '-' . $log_type . '] ' . $text . "\n" );
				fclose( $fh );
			} else {
				// Don't use alert here since it could recursively look writing to the log.
				echo 'Warning: Unable to write to log file. Verify write permissions to this directory.' ;
			}
		}
	}
	
	
	/**
	 *	tip()
	 *
	 *	Displays a message to the user when they hover over the question mark. Gracefully falls back to normal tooltip.
	 *	HTML is supposed within tooltips.
	 *
	 *	$message		string		Actual message to show to user.
	 *	$title			string		Title of message to show to user. This is displayed at top of tip in bigger letters. Default is blank. (optional)
	 *	$echo_tip		boolean		Whether to echo the tip (default; true), or return the tip (false). (optional)
	 */
	function tip( $message, $title = '', $echo_tip = true ) {
		$tip = ' <a class="pluginbuddy_tip" title="' . $title . ' - ' . $message . '"><img src="repairbuddy/images/pluginbuddy_tip.png"></a>';
		if ( $echo_tip === true ) {
			echo $tip;
		} else {
			return $tip;
		}
	}
	
	
	function page_link( $module_slug, $page, $force_wordpress_bootstrap = 'false' ) {
		if ( $this->has_access != true ) {
			return '?';
		}
		
		if ( $this->_modules[$module_slug]['bootsrap_wordpress'] == 'true' ) {
			$bootstrap = 'true';
		} else {
			if ( $force_wordpress_bootstrap == true ) {
				$bootstrap = 'true';
			} else {
				$bootstrap = 'false';
			}
		}
		return '?module=' . $module_slug . '&page=' . $page . '&v=xv' . md5( $this->_defaults['repair_password'] . 'repairbuddy' . $page ) . '&bootstrap=' . $bootstrap;
	}
	
	
	
	
	
	
	/**
	 *	status_box()
	 *
	 *	Displays a textarea for placing status text into.
	 *
	 *	@param			$default_text	string		First line of text to display.
	 *	@return							string		HTML for textarea.
	 */
	function status_box( $default_text = '' ) {
		return '<textarea readonly="readonly" style="width: 100%; height: 120px;" id="importbuddy_status">' . $default_text . '</textarea>';
	}		
	
	
	/**
	 *	status()
	 *
	 *	Write a status line into an existing textarea created with the status_box() function.
	 *
	 *	@param			$type		string		message, details, error, or warning. Currently not in use.
	 *	@param			$message	string		Message to append to the status box.
	 *	@return			null
	 */
	function status( $type, $message ) {
		$message = htmlentities( addslashes( $message ) );
		$status = date( $this->_timestamp, time() ) . ': ' . $message;
		
		echo '<script type="text/javascript">jQuery( "#importbuddy_status" ).append( "\n' . $status . '");	textareaelem = document.getElementById( "importbuddy_status" );	textareaelem.scrollTop = textareaelem.scrollHeight;	</script>';
		flush();
		
		if ( $type == 'error' ) {
			$this->log( $message, 'error' );
		} elseif ( $type == 'warning' ) {
			$this->log( $message, 'warning' );
		} else {
			$this->log( '[' . $type . ']' . $message, 'all' );
		}
	}
	
	
	function format_size( $size ) {
		$sizes = array( ' Bytes', ' KB', ' MB', ' GB', ' TB', ' PB', ' EB', ' ZB', ' YB');
		if ( $size == 0 ) {
			return( 'empty' );
		} else {
			return ( round( $size / pow( 1024, ( $i = floor( log( $size, 1024 ) ) ) ), $i > 1 ? 2 : 0) . $sizes[$i] );
		}
	}
	
	
	function wipe_repairbuddy() {		
		$this->remove_file( ABSPATH . 'repairbuddy/', 'RepairBuddy Directory', true );
		$this->remove_file( ABSPATH . 'repairbuddy.txt', 'RepairBuddy Log File', true );
		$this->remove_file( ABSPATH . 'repairbuddy.php', 'RepairBuddy.php main file.', true );
	}
	
	
	function remove_file( $file, $description, $error_on_missing = false ) {
		$this->status( 'message', 'Deleting `' . $description . '`...' );
		
		@chmod( $file, 0755 ); // High permissions to delete.
		
		if ( is_dir( $file ) ) { // directory.
			$this->remove_dir( $file );
			if ( file_exists( $file ) ) {
				$this->status( 'error', 'Unable to delete directory: `' . $description . '`. You should manually delete it.' );
			} else {
				$this->status( 'message', 'Deleted.' );
			}
		} else { // file
			if ( file_exists( $file ) ) {
				if ( @unlink( $file ) != 1 ) {
					$this->status( 'error', 'Unable to delete file: `' . $description . '`. You should manually delete it.' );
				} else {
					$this->status( 'message', 'Deleted.' );
				}
			}
		}
	}
	
	
	/**
	 *	remove_dir()
	 *
	 *	?
	 *
	 *	@return			?
	 */
	function remove_dir( $dir ) {
		if ( !file_exists( $dir ) ) {
			return true;
		}
		if ( !is_dir( $dir ) || is_link( $dir ) ) {
			return unlink($dir);
		}
		foreach ( scandir( $dir ) as $item ) {
			if ( $item == '.' || $item == '..' ) {
				continue;
			}
			if ( !$this->remove_dir( $dir . "/" . $item ) ) {
				chmod( $dir . "/" . $item, 0777 );
				if ( !$this->remove_dir( $dir . "/" . $item ) ) {
					return false;
				}
			}
		}
		return rmdir($dir);
	}
	
	
} // end class.





define( 'pluginbuddy_importbuddy', true ); // Tell Server Info page to not load some sections.
global $pluginbuddy_repairbuddy;
$pluginbuddy_repairbuddy = new pluginbuddy_repairbuddy();
pb_do_action( 'repairbuddy_init' );

function pb_register_module( $args = array() ) {
	global $pluginbuddy_repairbuddy;
	$pluginbuddy_repairbuddy->register_module( $args );
} //end pb_register_module

function pb_has_db_access() {
	global $pluginbuddy_repairbuddy;
	return $pluginbuddy_repairbuddy->has_db_access();
} //end pb_has_database_access

function pb_has_access() {
	global $pluginbuddy_repairbuddy;
	return $pluginbuddy_repairbuddy->has_access();
}

?>
<?php /*
###PACKDATA,BEGIN
###PACKDATA,FILE_START,/repairbuddy/_home.php,repairbuddy/_home.php
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
###PACKDATA,FILE_END,/repairbuddy/_home.php,repairbuddy/_home.php
###PACKDATA,FILE_START,/repairbuddy/_load.php,repairbuddy/_load.php
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
###PACKDATA,FILE_END,/repairbuddy/_load.php,repairbuddy/_load.php
###PACKDATA,FILE_START,/repairbuddy/_modules.php,repairbuddy/_modules.php
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
###PACKDATA,FILE_END,/repairbuddy/_modules.php,repairbuddy/_modules.php
###PACKDATA,FILE_START,/repairbuddy/_template.php,repairbuddy/_template.php
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
###PACKDATA,FILE_END,/repairbuddy/_template.php,repairbuddy/_template.php
###PACKDATA,FILE_START,/repairbuddy/ajax.php,repairbuddy/ajax.php
PD9waHAKLyoKCTEuICBUbyBsb2FkIFdvcmRQcmVzcywgcGFzcyBhIEdFVCBvciBQT1NUIHZhcmlhYmxlIG9mIGxvYWRfd3AKCTIuICBZb3UgbXVzdCBwYXNzIHRoZSBhIFBPU1QgdmFpYWJsZSBvZiBwYXNzd29yZCBvciBhIEdFVCB2YXJpYWJsZSBvZiAidiIgd2l0aCB0aGUgcGFzc2VkIHRva2VuCgkzLiAgWW91IG11c3QgaGF2ZSBhbHJlYWR5IHJlZ2lzdGVyZWQgeW91ciBhY3Rpb24gYW5kIHBhc3MgYSBHRVQgb3IgUE9TVCB2YXJpYWJsZSBvZiBhY3Rpb24KKi8KZGVmaW5lKCdQQl9ET0lOR19BSkFYJywgdHJ1ZSk7CgppZiAoICEgaXNzZXQoICRfUkVRVUVTVFsnYWN0aW9uJ10gKSApCglkaWUoJy0xJyk7CiRwYl9wYXRoID0gZGlybmFtZSggZGlybmFtZSggX19GSUxFX18gKSApOwovL0dldCB0aGUgYWN0aW9uIHZhcmlhYmxlCiRhamF4X2FjdGlvbiA9IGlzc2V0KCAkX0dFVFsgJ2FjdGlvbicgXSApID8gJF9HRVRbICdhY3Rpb24nIF0gOiBmYWxzZTsKaWYgKCAhJGFqYXhfYWN0aW9uICkgewoJJGFqYXhfYWN0aW9uID0gaXNzZXQoICRfUE9TVFsgJ2FjdGlvbicgXSApID8gJF9QT1NUWyAnYWN0aW9uJyBdIDogZmFsc2U7CglpZiAoICEkYWpheF9hY3Rpb24gKSBkaWUoICctMScgKTsKfQoKCnJlcXVpcmVfb25jZSggJHBiX3BhdGggLiAnL3JlcGFpcmJ1ZGR5LnBocCcgKTsKCmlmICggIXBiX2hhc19hY2Nlc3MoKSApIHsKCWRpZSggJ0FjY2VzcyBEZW5pZWQnICk7Cn0KcGJfZG9fYWN0aW9uKCAncGJfYWpheF8nIC4gJGFqYXhfYWN0aW9uICk7CmRpZSggMCApOwo/Pg==
###PACKDATA,FILE_END,/repairbuddy/ajax.php,repairbuddy/ajax.php
###PACKDATA,FILE_START,/repairbuddy/css/style.css,repairbuddy/css/style.css
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
###PACKDATA,FILE_END,/repairbuddy/css/style.css,repairbuddy/css/style.css
###PACKDATA,FILE_START,/repairbuddy/images/alert.png,repairbuddy/images/alert.png
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
###PACKDATA,FILE_END,/repairbuddy/images/alert.png,repairbuddy/images/alert.png
###PACKDATA,FILE_START,/repairbuddy/images/button-grad.png,repairbuddy/images/button-grad.png
iVBORw0KGgoAAAANSUhEUgAAAAUAAAAeCAYAAADkftS9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAACF0RVh0U29mdHdhcmUATWFjcm9tZWRpYSBGaXJld29ya3MgNC4w6iYndQAAABZ0RVh0Q3JlYXRpb24gVGltZQAxMS8xNy8wONpsdXEAAABGSURBVHicY9Ts2fWfAQ2wMPzHEGNg+f//H6Ygwz9sgthU/sdmJlbtlFpEgpOwWoTszv+Dz0lUtOg/ukoSfATT+5+gSkxBAOqCS3dTeDKPAAAAAElFTkSuQmCC
###PACKDATA,FILE_END,/repairbuddy/images/button-grad.png,repairbuddy/images/button-grad.png
###PACKDATA,FILE_START,/repairbuddy/images/gray-grad.png,repairbuddy/images/gray-grad.png
iVBORw0KGgoAAAANSUhEUgAAAAUAAAAfCAIAAACgQJBPAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAAAsSAAALEgHS3X78AAAAIXRFWHRTb2Z0d2FyZQBNYWNyb21lZGlhIEZpcmV3b3JrcyA0LjDqJid1AAAAFnRFWHRDcmVhdGlvbiBUaW1lADEwLzI0LzA4KQ6r+wAAAClJREFUeJxjfPv2LQMSYPn//z8yn4kBFaDzqa0eXZ5U9QMtT6l5tFYPADsXLPcJwrwLAAAAAElFTkSuQmCC
###PACKDATA,FILE_END,/repairbuddy/images/gray-grad.png,repairbuddy/images/gray-grad.png
###PACKDATA,FILE_START,/repairbuddy/images/pluginbuddy.png,repairbuddy/images/pluginbuddy.png
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
###PACKDATA,FILE_END,/repairbuddy/images/pluginbuddy.png,repairbuddy/images/pluginbuddy.png
###PACKDATA,FILE_START,/repairbuddy/images/pluginbuddy_tip.png,repairbuddy/images/pluginbuddy_tip.png
iVBORw0KGgoAAAANSUhEUgAAAA8AAAAPCAYAAAA71pVKAAAB/ElEQVR42n2RPYgaQRiG585rclGLhKQ2gYOUipjiyBGCTQhpNEVsrhAigsWhkEKwSEQQjCBroSBiYQpFEBv/Cn+XCLsElOMCBvUaFYWARoXgKSc3eVlQ9jY/LzwwzHzPzDczJJPJCOTzeVIqlQRqtdpj8BK8Bk/AfrFYJOl0mogjlV8A5ivS6XS+93q9ThMpl8t1yG/+J1tYluXm8/mMSrJcLn/xPN+E/B7KvlR+XqlU+M1mc03/kRsEG5xHIpF30GSCHIvFSCKRCEyn05/bwsFgQLPZLI3H4xQ3EHdwlUqlWJVK9WArP0Q7HBUll8sJTCYTGo1G6Xg83q3V6/ULi8XyFuoBCYVCJ9Vq9ZtYXq1WdDgcChsEg0G6WCx2a61W69JqtX6ArCB+v/+4UChAvhWhXWxM+/0+FYfjuEuTyeSFfJ94PB5FIBBo3CCiGqFVdESlSSaTLZ1Od7aVidPp/Njtdn+Ii/Bt1OVy3RJHo9HMbDbnIerBXWK32wlQu93uBu52JS7GD+zG6/X62ufzcTjVD/EIyLYywQue4qRGu93edSD6upnX6+X1ev1nSM+AnEiyZzQaj/EYjM1mYxmGaYbD4XOHw/HFYDBk1Wr1J9ScgHtgD0gjTB7K5XKVVqs1ajQas1KpfIW5p+ARUEjEPwOZIDJwBxyCg79JvwFn8/sITKnYXQAAAABJRU5ErkJggg==
###PACKDATA,FILE_END,/repairbuddy/images/pluginbuddy_tip.png,repairbuddy/images/pluginbuddy_tip.png
###PACKDATA,FILE_START,/repairbuddy/images/white-grad.png,repairbuddy/images/white-grad.png
iVBORw0KGgoAAAANSUhEUgAAAAUAAAAeCAYAAADkftS9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAACF0RVh0U29mdHdhcmUATWFjcm9tZWRpYSBGaXJld29ya3MgNC4w6iYndQAAABZ0RVh0Q3JlYXRpb24gVGltZQAxMS8xNy8wONpsdXEAAAAlSURBVHicY/z///9/BjTAhC7AwMDAwIJFIXbBoaJ9qLhz+IUSAIMMOibeSzRBAAAAAElFTkSuQmCC
###PACKDATA,FILE_END,/repairbuddy/images/white-grad.png,repairbuddy/images/white-grad.png
###PACKDATA,FILE_START,/repairbuddy/images/working.gif,repairbuddy/images/working.gif
R0lGODlhKwALAPEAAPn5+SiKt5LC2CiKtyH/C05FVFNDQVBFMi4wAwEAAAAh/hpDcmVhdGVkIHdpdGggYWpheGxvYWQuaW5mbwAh+QQJCgAAACwAAAAAKwALAAACMoSOCMuW2diD88UKG95W88uF4DaGWFmhZid93pq+pwxnLUnXh8ou+sSz+T64oCAyTBUAACH5BAkKAAAALAAAAAArAAsAAAI9xI4IyyAPYWOxmoTHrHzzmGHe94xkmJifyqFKQ0pwLLgHa82xrekkDrIBZRQab1jyfY7KTtPimixiUsevAAAh+QQJCgAAACwAAAAAKwALAAACPYSOCMswD2FjqZpqW9xv4g8KE7d54XmMpNSgqLoOpgvC60xjNonnyc7p+VKamKw1zDCMR8rp8pksYlKorgAAIfkECQoAAAAsAAAAACsACwAAAkCEjgjLltnYmJS6Bxt+sfq5ZUyoNJ9HHlEqdCfFrqn7DrE2m7Wdj/2y45FkQ13t5itKdshFExC8YCLOEBX6AhQAADs=
###PACKDATA,FILE_END,/repairbuddy/images/working.gif,repairbuddy/images/working.gif
###PACKDATA,FILE_START,/repairbuddy/js/jquery.js,repairbuddy/js/jquery.js
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
###PACKDATA,FILE_END,/repairbuddy/js/jquery.js,repairbuddy/js/jquery.js
###PACKDATA,FILE_START,/repairbuddy/js/repairbuddy.js,repairbuddy/js/repairbuddy.js
alF1ZXJ5KGRvY3VtZW50KS5yZWFkeShmdW5jdGlvbigpIHsKCWpRdWVyeSh3aW5kb3cpLmxvYWQoZnVuY3Rpb24oKXsKCQlpZiAoIGpRdWVyeSgnI3BiX2ltcG9ydGJ1ZGR5X3dvcmtpbmcnKS5pcygnOnZpc2libGUnKSApIHsKCQkJalF1ZXJ5KCcjcGJfaW1wb3J0YnVkZHlfd29ya2luZycpLnJlcGxhY2VXaXRoKAoJCQkJalF1ZXJ5KCcjcGJfaW1wb3J0YnVkZHlfYmxhbmthbGVydCcpLmh0bWwoKS5yZXBsYWNlKCAnI1RJVExFIycsICdQSFAgVGltZW91dCBvciBGYXRhbCBFcnJvciBPY2N1cnJlZCcgKS5yZXBsYWNlKCAnI01FU1NBR0UjJywgJ1RoZSBwYWdlIGRpZCBub3QgZmluaXNoIGxvYWRpbmcgYXMgZXhwZWN0ZWQuICBUaGUgbW9zdCBjb21tb24gY2F1c2UgZm9yIHRoaXMgaXMgdGhlIFBIUCBwcm9jZXNzIHRha2luZyBtb3JlIHRpbWUgdGhhbiBpdCBoYXMgYmVlbiBhbGxvd2VkIGJ5IHlvdXIgaG9zdCAocGhwLmluaSBzZXR0aW5nIDxpPm1heF9leGVjdXRpb25fdGltZTwvaT4pLiBJZiBhIFBIUCBlcnJvciBpcyBkaXNwbGF5ZWQgYWJvdmUgdGhpcyBjYW4gYWxzbyBjYXVzZSB0aGlzIGVycm9yLicgKQoJCQkpOwoJCX0KCX0pOwp9KTsKCmpRdWVyeShkb2N1bWVudCkucmVhZHkoZnVuY3Rpb24oKSB7CglqUXVlcnkoJy5wbHVnaW5idWRkeV90aXAnKS50b29sdGlwKHsKCQl0cmFjazogdHJ1ZSwKCQlkZWxheTogMCwKCQlzaG93VVJMOiBmYWxzZSwKCQlzaG93Qm9keTogIiAtICIsCgkJZmFkZTogMjUwCgl9KTsKCQoJalF1ZXJ5KCcudG9nZ2xlJykuY2xpY2soZnVuY3Rpb24oZSkgewoJCWpRdWVyeSggJyN0b2dnbGUtJyArIGpRdWVyeSh0aGlzKS5hdHRyKCdpZCcpICkuc2xpZGVUb2dnbGUoKTsKCX0pOwoJCglqUXVlcnkoJy5vcHRpb25fdG9nZ2xlJykuY2hhbmdlKGZ1bmN0aW9uKGUpIHsKCQlpZiAoalF1ZXJ5KHRoaXMpLmF0dHIoJ2NoZWNrZWQnKSkgewoJCQlqUXVlcnkoJy4nICsgalF1ZXJ5KHRoaXMpLmF0dHIoJ2lkJykgKyAnX3RvZ2dsZScgKS5zbGlkZVRvZ2dsZSgpOwoJCX0gZWxzZSB7CgkJCWpRdWVyeSgnLicgKyBqUXVlcnkodGhpcykuYXR0cignaWQnKSArICdfdG9nZ2xlJyApLnNsaWRlVG9nZ2xlKCk7CgkJfQoJfSk7CgkKfSk7
###PACKDATA,FILE_END,/repairbuddy/js/repairbuddy.js,repairbuddy/js/repairbuddy.js
###PACKDATA,FILE_START,/repairbuddy/js/tooltip.js,repairbuddy/js/tooltip.js
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
###PACKDATA,FILE_END,/repairbuddy/js/tooltip.js,repairbuddy/js/tooltip.js
###PACKDATA,FILE_START,/repairbuddy/js/ui.core.js,repairbuddy/js/ui.core.js
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
###PACKDATA,FILE_END,/repairbuddy/js/ui.core.js,repairbuddy/js/ui.core.js
###PACKDATA,FILE_START,/repairbuddy/js/ui.tabs.js,repairbuddy/js/ui.tabs.js
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
###PACKDATA,FILE_END,/repairbuddy/js/ui.tabs.js,repairbuddy/js/ui.tabs.js
###PACKDATA,FILE_START,/repairbuddy/js/ui.widget.js,repairbuddy/js/ui.widget.js
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
###PACKDATA,FILE_END,/repairbuddy/js/ui.widget.js,repairbuddy/js/ui.widget.js
###PACKDATA,FILE_START,/repairbuddy/images/buttons/allcontent-icon.png,repairbuddy/images/buttons/allcontent-icon.png
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
###PACKDATA,FILE_END,/repairbuddy/images/buttons/allcontent-icon.png,repairbuddy/images/buttons/allcontent-icon.png
###PACKDATA,FILE_START,/repairbuddy/images/buttons/dbonly-icon.png,repairbuddy/images/buttons/dbonly-icon.png
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
###PACKDATA,FILE_END,/repairbuddy/images/buttons/dbonly-icon.png,repairbuddy/images/buttons/dbonly-icon.png
###PACKDATA,FILE_START,/repairbuddy/images/buttons/grays2.png,repairbuddy/images/buttons/grays2.png
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
###PACKDATA,FILE_END,/repairbuddy/images/buttons/grays2.png,repairbuddy/images/buttons/grays2.png
###PACKDATA,FILE_START,/repairbuddy/images/buttons/restoremigrate-icon.png,repairbuddy/images/buttons/restoremigrate-icon.png
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
###PACKDATA,FILE_END,/repairbuddy/images/buttons/restoremigrate-icon.png,repairbuddy/images/buttons/restoremigrate-icon.png
###PACKDATA,FILE_START,/repairbuddy/images/sucuri/3.png,repairbuddy/images/sucuri/3.png
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
###PACKDATA,FILE_END,/repairbuddy/images/sucuri/3.png,repairbuddy/images/sucuri/3.png
###PACKDATA,FILE_START,/repairbuddy/lib/dbreplace/dbreplace.php,repairbuddy/lib/dbreplace/dbreplace.php
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
###PACKDATA,FILE_END,/repairbuddy/lib/dbreplace/dbreplace.php,repairbuddy/lib/dbreplace/dbreplace.php
###PACKDATA,FILE_START,/repairbuddy/lib/dbreplace/history.txt,repairbuddy/lib/dbreplace/history.txt
MS4wLjAgLSAyMDExLTA4LTE4IC0gRHVzdGluIEJvbHRvbgoJQ3JlYXRlZCBkYnJlcGxhY2UgY2xhc3Mu
###PACKDATA,FILE_END,/repairbuddy/lib/dbreplace/history.txt,repairbuddy/lib/dbreplace/history.txt
###PACKDATA,FILE_START,/repairbuddy/lib/zipbuddy/history.txt,repairbuddy/lib/zipbuddy/history.txt
Mi4wLjAgLSAyMDExLTEwLTA4IC0gRHVzdGluIEJvbHRvbgoJQWRkZWQgaGlzdG9yeS50eHQuCglBZGRlZCB1bnppcCBmdW5jdGlvbmFsaXR5Lg==
###PACKDATA,FILE_END,/repairbuddy/lib/zipbuddy/history.txt,repairbuddy/lib/zipbuddy/history.txt
###PACKDATA,FILE_START,/repairbuddy/lib/zipbuddy/x-zipbuddy.php,repairbuddy/lib/zipbuddy/x-zipbuddy.php
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
###PACKDATA,FILE_END,/repairbuddy/lib/zipbuddy/x-zipbuddy.php,repairbuddy/lib/zipbuddy/x-zipbuddy.php
###PACKDATA,FILE_START,/repairbuddy/lib/zipbuddy/zbdir.php,repairbuddy/lib/zipbuddy/zbdir.php
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
###PACKDATA,FILE_END,/repairbuddy/lib/zipbuddy/zbdir.php,repairbuddy/lib/zipbuddy/zbdir.php
###PACKDATA,FILE_START,/repairbuddy/lib/zipbuddy/zbzipcore.php,repairbuddy/lib/zipbuddy/zbzipcore.php
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
###PACKDATA,FILE_END,/repairbuddy/lib/zipbuddy/zbzipcore.php,repairbuddy/lib/zipbuddy/zbzipcore.php
###PACKDATA,FILE_START,/repairbuddy/lib/zipbuddy/zbzipexec.php,repairbuddy/lib/zipbuddy/zbzipexec.php
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
###PACKDATA,FILE_END,/repairbuddy/lib/zipbuddy/zbzipexec.php,repairbuddy/lib/zipbuddy/zbzipexec.php
###PACKDATA,FILE_START,/repairbuddy/lib/zipbuddy/zbzippclzip.php,repairbuddy/lib/zipbuddy/zbzippclzip.php
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
###PACKDATA,FILE_END,/repairbuddy/lib/zipbuddy/zbzippclzip.php,repairbuddy/lib/zipbuddy/zbzippclzip.php
###PACKDATA,FILE_START,/repairbuddy/lib/zipbuddy/zbzipproc.php,repairbuddy/lib/zipbuddy/zbzipproc.php
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
###PACKDATA,FILE_END,/repairbuddy/lib/zipbuddy/zbzipproc.php,repairbuddy/lib/zipbuddy/zbzipproc.php
###PACKDATA,FILE_START,/repairbuddy/lib/zipbuddy/zbzipziparchive.php,repairbuddy/lib/zipbuddy/zbzipziparchive.php
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
###PACKDATA,FILE_END,/repairbuddy/lib/zipbuddy/zbzipziparchive.php,repairbuddy/lib/zipbuddy/zbzipziparchive.php
###PACKDATA,FILE_START,/repairbuddy/lib/zipbuddy/zipbuddy.php,repairbuddy/lib/zipbuddy/zipbuddy.php
PD9waHAKLyoqCiAqCXBsdWdpbmJ1ZGR5X3ppcGJ1ZGR5IENsYXNzCiAqCiAqCUhhbmRsZXMgemlwcGluZyBhbmQgdW56aXBwaW5nLCB1c2luZyB0aGUgYmVzdCBtZXRob2RzIGF2YWlsYWJsZSBhbmQgZmFsbGluZyBiYWNrIHRvIHdvcnNlIG1ldGhvZHMKICoJYXMgbmVlZGVkIGZvciBjb21wYXRpYmlsaXR5LiBBbGxvd3MgZm9yIGZvcmNpbmcgY29tcGF0aWJpbGl0eSBtb2Rlcy4KICoJCiAqCVZlcnNpb246IDIuMC4wCiAqCUF1dGhvcjogRHVzdGluIEJvbHRvbgogKglBdXRob3IgVVJJOiBodHRwOi8vZHVzdGluYm9sdG9uLmNvbS8KICoKICoJJHRlbXBfZGlyCQlzdHJpbmcJCVRlbXBvcmFyeSBkaXJlY3RvcnkgYWJzb2x1dGUgcGF0aCBmb3IgdGVtcG9yYXJ5IGZpbGUgc3RvcmFnZS4gTXVzdCBiZSB3cml0YWJsZSEKICoJJHppcF9tZXRob2RzCWFycmF5CQlPcHRpb25hbC4gQXJyYXkgb2YgYXZhaWxhYmxlIHppcCBtZXRob2RzIHRvIHVzZS4gVXNlZnVsIGZvciBub3QgaGF2aW5nIHRvIHJlLXRlc3QgZXZlcnkgdGltZS4KICoJCQkJCQkJCUlmIG9taXR0ZWQgdGhlbiBhIHRlc3Qgd2lsbCBiZSBwZXJmb3JtZWQgdG8gZmluZCB0aGUgbWV0aG9kcyB0aGF0IHdvcmsgb24gdGhpcyBob3N0LgogKgkkbW9kZQkJCXN0cmluZwkJRnV0dXJlIHVzZSB0byBhbGxvdyBmb3Igb3RoZXIgY29tcHJlc3Npb24gbWV0aG9kcyBvdGhlciB0aGFuIHppcC4gQ3VycmVudGx5IG5vdCBpbiB1c2UuCiAqCiAqLwovLyBUcnkgYW5kIGxvYWQgdGhlIGV4cGVyaW1lbnRhbCB2ZXJzaW9uIC0gaWYgc3VjY2Vzc2Z1bCB0aGVuIGNsYXNzIHdpbGwgZXhpc3QgYW5kIHJlbWFpbmluZyBjb2RlIHdpbGwgYmUgaWdub3JlZAppZiAoIGRlZmluZWQoICdVU0VfRVhQRVJJTUVOVEFMX1pJUEJVRERZJyApICYmICggdHJ1ZSA9PT0gVVNFX0VYUEVSSU1FTlRBTF9aSVBCVUREWSApICkgewoJQHJlcXVpcmVfb25jZSggZGlybmFtZSggX19GSUxFX18gKSAuICcveC16aXBidWRkeS5waHAnICk7Cn0KaWYgKCAhY2xhc3NfZXhpc3RzKCAicGx1Z2luYnVkZHlfemlwYnVkZHkiICkgKSB7CgljbGFzcyBwbHVnaW5idWRkeV96aXBidWRkeSB7CgkJCgkJZnVuY3Rpb24gcGx1Z2luYnVkZHlfemlwYnVkZHkoICR0ZW1wX2RpciwgJHppcF9tZXRob2RzID0gJycsICRtb2RlID0gJ3ppcCcgKSB7CgkJCSR0aGlzLT5fc3RhdHVzID0gYXJyYXkoKTsKCQkJJHRoaXMtPl90ZW1wZGlyID0gJHRlbXBfZGlyOwoJCQkkdGhpcy0+X2V4ZWNwYXRoID0gJyc7CgkJCQoJCQlpZiAoICFlbXB0eSggJHppcF9tZXRob2RzICkgKSB7CgkJCQkkdGhpcy0+X3ppcF9tZXRob2RzID0gJHppcF9tZXRob2RzOwoJCQl9IGVsc2UgewoJCQkJJHRoaXMtPl96aXBfbWV0aG9kcyA9ICR0aGlzLT5hdmFpbGFibGVfemlwX21ldGhvZHMoIGZhbHNlLCAkbW9kZSApOwoJCQl9CgkJfQoJCQoJCQoJCS8vIFJldHVybnMgdHJ1ZSBpZiB0aGUgZmlsZSAod2l0aCBwYXRoKSBleGlzdHMgaW4gdGhlIFpJUC4KCQkvLyBJZiBsZWF2ZV9vcGVuIGlzIHRydWUgdGhlbiB0aGUgemlwIG9iamVjdCB3aWxsIGJlIGxlZnQgb3BlbiBmb3IgZmFzdGVyIGNoZWNraW5nIGZvciBzdWJzZXF1ZW50IGZpbGVzIHdpdGhpbiB0aGlzIHppcAoJCWZ1bmN0aW9uIGZpbGVfZXhpc3RzKCAkemlwX2ZpbGUsICRsb2NhdGVfZmlsZSwgJGxlYXZlX29wZW4gPSBmYWxzZSApIHsKCQkJaWYgKCBpbl9hcnJheSggJ3ppcGFyY2hpdmUnLCAkdGhpcy0+X3ppcF9tZXRob2RzICkgKSB7CgkJCQkkdGhpcy0+X3ppcCA9IG5ldyBaaXBBcmNoaXZlOwoJCQkJaWYgKCAkdGhpcy0+X3ppcC0+b3BlbiggJHppcF9maWxlICkgPT09IHRydWUgKSB7CgkJCQkJCWlmICggJHRoaXMtPl96aXAtPmxvY2F0ZU5hbWUoICRsb2NhdGVfZmlsZSApID09PSBmYWxzZSApIHsgLy8gRmlsZSBub3QgZm91bmQgaW4gemlwLgoJCQkJCQkJJHRoaXMtPl96aXAtPmNsb3NlKCk7CgkJCQkJCQkkdGhpcy0+X3N0YXR1c1tdID0gX18oJ0ZpbGUgbm90IGZvdW5kICh6aXBhcmNoaXZlKScsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgLiAnOiAnIC4gJGxvY2F0ZV9maWxlOwoJCQkJCQkJcmV0dXJuIGZhbHNlOwoJCQkJCQl9CgkJCQkJCSR0aGlzLT5femlwLT5jbG9zZSgpOwoJCQkJCXJldHVybiB0cnVlOyAvLyBOZXZlciByYW4gaW50byBhIGZpbGUgbWlzc2luZyBzbyBtdXN0IGhhdmUgZm91bmQgdGhlbSBhbGwuCgkJCQl9IGVsc2UgewoJCQkJCSR0aGlzLT5fc3RhdHVzW10gPSBzcHJpbnRmKCBfXygnWmlwQXJjaGl2ZSBmYWlsZWQgdG8gb3BlbiBmaWxlIHRvIGNoZWNrIGlmIGZpbGUgZXhpc3RzIChsb29raW5nIGZvciAlMSRzIGluICUyJHMpLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JyksICRsb2NhdGVfZmlsZSAsICR6aXBfZmlsZSApOwoJCQkJCQoJCQkJCXJldHVybiBmYWxzZTsKCQkJCX0KCQkJfQoJCQkKCQkJLy8gSWYgd2UgbWFkZSBpdCB0aGlzIGZhciB0aGVuIHppcGFyY2hpdmUgbm90IGF2YWlsYWJsZS9mYWlsZWQuCgkJCWlmICggaW5fYXJyYXkoICdwY2x6aXAnLCAkdGhpcy0+X3ppcF9tZXRob2RzICkgKSB7CgkJCQlyZXF1aXJlX29uY2UoIEFCU1BBVEggLiAnd3AtYWRtaW4vaW5jbHVkZXMvY2xhc3MtcGNsemlwLnBocCcgKTsKCQkJCSR0aGlzLT5femlwID0gbmV3IFBjbFppcCggJHppcF9maWxlICk7CgkJCQlpZiAoICggJGZpbGVfbGlzdCA9ICR0aGlzLT5femlwLT5saXN0Q29udGVudCgpICkgPT0gMCApIHsgLy8gSWYgemVybywgemlwIGlzIGNvcnJ1cHQgb3IgZW1wdHkuCgkJCQkJJHRoaXMtPl9zdGF0dXNbXSA9ICR0aGlzLT5femlwLT5lcnJvckluZm8oIHRydWUgKTsKCQkJCX0gZWxzZSB7CgkJCQkJZm9yZWFjaCggJGZpbGVfbGlzdCBhcyAkZmlsZSApIHsKCQkJCQkJaWYgKCAkZmlsZVsnZmlsZW5hbWUnXSA9PSAkbG9jYXRlX2ZpbGUgKSB7IC8vIEZvdW5kIGZpbGUuCgkJCQkJCQlyZXR1cm4gdHJ1ZTsKCQkJCQkJfQoJCQkJCX0KCQkJCQkkdGhpcy0+X3N0YXR1c1tdID0gX18oJ0ZpbGUgbm90IGZvdW5kIChwY2x6aXApJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknKSAuICc6ICcgLiAkbG9jYXRlX2ZpbGU7CgkJCQkJcmV0dXJuIGZhbHNlOwoJCQkJfQoJCQl9IGVsc2UgewoJCQkJJHRoaXMtPl9zdGF0dXNbXSA9IF9fKCdVbmFibGUgdG8gY2hlY2sgaWYgZmlsZSBleGlzdHM6IE5vIGNvbXBhdGlibGUgemlwIG1ldGhvZCBmb3VuZC4nLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpOwoJCQkJcmV0dXJuIGZhbHNlOwoJCQl9CgkJfQoJCQoJCQoJCS8qKgoJCSAqCWFkZF9kaXJlY3RvcnlfdG9femlwKCkKCQkgKgoJCSAqCUFkZHMgYSBkaXJlY3RvcnkgdG8gYSBuZXcgb3IgZXhpc3RpbmcgKFRPRE86IG5vdCB5ZXQgYXZhaWxhYmxlKSBaSVAgZmlsZS4KCQkgKgoJCSAqCSR6aXBfZmlsZQkJCQkJc3RyaW5nCQkJCUZ1bGwgcGF0aCAmIGZpbGVuYW1lIG9mIFpJUCBmaWxlIHRvIGNyZWF0ZS4KCQkgKgkkYWRkX2RpcmVjdG9yeQkJCQlzdHJpbmcJCQkJRnVsbCBkaXJlY3RvcnkgdG8gYWRkIHRvIHppcCBmaWxlLgoJCSAqCSRjb21wcmVzc2lvbgkJCQlib29sZWFuCQkJCVRydWUgdG8gZW5hYmxlIFpJUCBjb21wcmVzc2lvbiwKCQkgKgkJCQkJCQkJCQkJCQkoaWYgcG9zc2libGUgd2l0aCBhdmFpbGFibGUgemlwIG1ldGhvZHMpCgkJICoJJGV4Y2x1ZGVzCQkJCQlhcnJheSggc3RyaW5nICkJCUFycmF5IG9mIHN0cmluZ3Mgb2YgcGF0aHMvZmlsZXMgdG8gZXhjbHVkZSBmcm9tIHppcHBpbmcsCgkJICoJCQkJCQkJCQkJCQkJKGlmIHBvc3NpYmxlIHdpdGggYXZhaWxhYmxlIHppcCBtZXRob2RzKS4KCQkgKgkkdGVtcG9yYXJ5X3ppcF9kaXJlY3RvcnkJc3RyaW5nCQkJCU9wdGlvbmFsLiBGdWxsIGRpcmVjdG9yeSBwYXRoIHRvIGRpcmVjdG9yeSB0byB0ZW1wb3JhcmlseSBwbGFjZSBaSVAKCQkgKgkJCQkJCQkJCQkJCQlmaWxlIHdoaWxlIGNyZWF0aW5nLiBVc2VzIHNhbWUgZGlyZWN0b3J5IGlmIG9taXR0ZWQuCgkJICoJJGZvcmNlX2NvbXBhdGliaWxpdHlfbW9kZQlib29sZWFuCQkJCVRydWU6IG9ubHkgdXNlIFBDTFppcC4gRmFsc2U6IHRyeSBleGVjIGZpcnN0IGlmIGF2YWlsYWJsZSwKCQkgKgkJCQkJCQkJCQkJCQlhbmQgZmFsbGJhY2sgdG8gbGVzc2VyIG1ldGhvZHMgYXMgcmVxdWlyZWQuCgkJICoKCQkgKglAcmV0dXJuCQkJCQkJCQkJdHJ1ZSBvbiBzdWNjZXNzLCBmYWxzZSBvdGhlcndpc2UKCQkgKgoJCSAqLwoJCWZ1bmN0aW9uIGFkZF9kaXJlY3RvcnlfdG9femlwKCAkemlwX2ZpbGUsICRhZGRfZGlyZWN0b3J5LCAkY29tcHJlc3Npb24sICRleGNsdWRlcyA9IGFycmF5KCksICR0ZW1wb3JhcnlfemlwX2RpcmVjdG9yeSA9ICcnLCAkZm9yY2VfY29tcGF0aWJpbGl0eV9tb2RlID0gZmFsc2UgKSB7CgkJCWlmICggJGZvcmNlX2NvbXBhdGliaWxpdHlfbW9kZSA9PT0gdHJ1ZSApIHsKCQkJCSR6aXBfbWV0aG9kcyA9IGFycmF5KCAncGNsemlwJyApOwoJCQkJJHRoaXMtPnN0YXR1cyggJ21lc3NhZ2UnLCBfXygnRm9yY2VkIGNvbXBhdGliaWxpdHkgbW9kZSAoUENMWmlwKSBiYXNlZCBvbiBzZXR0aW5ncy4gVGhpcyBpcyBzbG93ZXIgYW5kIGxlc3MgcmVsaWFibGUuJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknKSApOwoJCQl9IGVsc2UgewoJCQkJJHppcF9tZXRob2RzID0gJHRoaXMtPl96aXBfbWV0aG9kczsKCQkJCSR0aGlzLT5zdGF0dXMoICdkZXRhaWxzJywgX18oJ1VzaW5nIGFsbCBhdmFpbGFibGUgemlwIG1ldGhvZHMgaW4gcHJlZmVycmVkIG9yZGVyLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgKTsKCQkJfQoJCQkKCQkJJGFwcGVuZCA9IGZhbHNlOyAvLyBQb3NzaWJsZSBmdXR1cmUgb3B0aW9uIHRvIGFsbG93IGFwcGVuZGluZyBpZiBmaWxlIGV4aXN0cy4KCQkJCgkJCWlmICggIWVtcHR5KCAkdGVtcG9yYXJ5X3ppcF9kaXJlY3RvcnkgKSApIHsKCQkJCWlmICggIWZpbGVfZXhpc3RzKCAkdGVtcG9yYXJ5X3ppcF9kaXJlY3RvcnkgKSApIHsgLy8gQ3JlYXRlIHRlbXAgZGlyIGlmIGl0IGRvZXMgbm90IGV4aXN0LgoJCQkJCW1rZGlyKCAkdGVtcG9yYXJ5X3ppcF9kaXJlY3RvcnkgKTsKCQkJCX0KCQkJfQoJCQkKCQkJJHRoaXMtPnN0YXR1cyggJ2RldGFpbHMnLCBfXygnQ3JlYXRpbmcgWklQIGZpbGUnLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpIC4gJyBgJyAuICR6aXBfZmlsZSAuICdgLiAnIC4gX18oJ0FkZGluZyBkaXJlY3RvcnknLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpIC4gJyBgJyAuICRhZGRfZGlyZWN0b3J5IC4gJ2AuICcgLiBfXygnQ29tcHJlc3Npb24nLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpIC4gJzogJyAuICRjb21wcmVzc2lvbiAuICc7ICcgLiBfXygnRXhjbHVkZXMnLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpIC4gJzogJyAuIGltcGxvZGUoICcsJywgJGV4Y2x1ZGVzICkgKTsKCQkJCgkJCWlmICggaW5fYXJyYXkoICdleGVjJywgJHppcF9tZXRob2RzICkgKSB7CgkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsIF9fKCdVc2luZyBleGVjKCkgbWV0aG9kIGZvciBaSVAuJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknKSApOwoJCQkJCgkJCQkkY29tbWFuZCA9ICd6aXAgLXEgLXInOwoJCQkJCgkJCQlpZiAoICRjb21wcmVzc2lvbiAhPT0gdHJ1ZSApIHsKCQkJCQkkY29tbWFuZCAuPSAnIC0wJzsKCQkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsIF9fKCdFeGVjIGNvbXByZXNzaW9uIGRpc2FibGVkIGJhc2VkIG9uIHNldHRpbmdzLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgKTsKCQkJCX0KCQkJCWlmICggZmlsZV9leGlzdHMoICR6aXBfZmlsZSApICkgewoJCQkJCWlmICggJGFwcGVuZCA9PT0gdHJ1ZSApIHsKCQkJCQkJJHRoaXMtPnN0YXR1cyggJ2RldGFpbHMnLCBfXygnWklQIGZpbGUgZXhpc3RzLiBBcHBlbmRpbmcgYmFzZWQgb24gb3B0aW9ucy4nLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpICk7CgkJCQkJCSRjb21tYW5kIC49ICcgLWcnOwoJCQkJCX0gZWxzZSB7CgkJCQkJCSR0aGlzLT5zdGF0dXMoICdkZXRhaWxzJywgX18oJ1pJUCBmaWxlIGV4aXN0cy4gRGVsZXRpbmcgJiB3cml0aW5nIGJhc2VkIG9uIG9wdGlvbnMuJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknKSApOwoJCQkJCQl1bmxpbmsoICR6aXBfZmlsZSApOwoJCQkJCX0KCQkJCX0KCQkJCQoJCQkJLy8kY29tbWFuZCAuPSAiIC1yIjsKCQkJCQoJCQkJLy8gU2V0IHRlbXBvcmFyeSBkaXJlY3RvcnkgdG8gc3RvcmUgWklQIHdoaWxlIGl0J3MgYmVpbmcgZ2VuZXJhdGVkLgoJCQkJaWYgKCAhZW1wdHkoICR0ZW1wb3JhcnlfemlwX2RpcmVjdG9yeSApICkgewoJCQkJCSRjb21tYW5kIC49ICIgLWIgJ3skdGVtcG9yYXJ5X3ppcF9kaXJlY3Rvcnl9JyI7CgkJCQl9CgkJCQkKCQkJCSRjb21tYW5kIC49ICIgJ3skemlwX2ZpbGV9JyAuIC1pICcqJyI7CgkJCQkKCQkJCWlmICggY291bnQoICRleGNsdWRlcyApID4gMCApIHsKCQkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsIF9fKCdDYWxjdWxhdGluZyBkaXJlY3RvcmllcyB0byBleGNsdWRlIGZyb20gYmFja3VwLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgKTsKCQkJCQkkY29tbWFuZCAuPSAnIC14JzsKCQkJCQkKCQkJCQkkZXhjbHVkaW5nX2FkZGl0aW9uYWwgPSBmYWxzZTsKCQkJCQkkZXhjbHVkZV9jb3VudCA9IDA7CgkJCQkJZm9yZWFjaCAoICRleGNsdWRlcyBhcyAkZXhjbHVkZSApIHsKCQkJCQkJLy8kZXhjbHVkZSA9IHByZWdfcmVwbGFjZSggJ3xbL1xcXFxdJHwnLCAnJywgJGV4Y2x1ZGUgKTsKCQkJCQkJJGV4Y2x1ZGUgPSB0cmltKCAkZXhjbHVkZSwgIlxuXHJcMCIgKTsKCQkJCQkJaWYgKCAkZXhjbHVkZSAhPSAnJyApIHsKCQkJCQkJCWlmICggIXN0cnN0ciggJGV4Y2x1ZGUsICdiYWNrdXBidWRkeV9iYWNrdXBzJyApICkgeyAvLyBTZXQgdmFyaWFibGUgdG8gc2hvdyB3ZSBhcmUgZXhjbHVkaW5nIGFkZGl0aW9uYWwgZGlyZWN0b3JpZXMgYmVzaWRlcyBiYWNrdXAgZGlyLgoJCQkJCQkJCSRleGNsdWRpbmdfYWRkaXRpb25hbCA9IHRydWU7CgkJCQkJCQl9CgkJCQkJCQkKCQkJCQkJCS8vJGV4Y2x1ZGUgPSAkZXhjbHVkZSAuICcvJzsKCQkJCQkJCQoJCQkJCQkJaWYgKCBzdWJzdHIoICRleGNsdWRlLCAtMSwgMSkgIT0gJy8nICkgewoJCQkJCQkJCSRleGNsdWRlID0gJGV4Y2x1ZGUgLiAnLyc7CgkJCQkJCQl9CgkJCQkJCQkKCQkJCQkJCSR0aGlzLT5zdGF0dXMoICdkZXRhaWxzJywgX18oJ0V4Y2x1ZGluZycsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgLiAnOiAnIC4gJGV4Y2x1ZGUgKTsKCQkJCQkJCSRjb21tYW5kIC49ICIgJ3skZXhjbHVkZX0qJyI7CgkJCQkJCQkKCQkJCQkJCSRleGNsdWRlX2NvdW50Kys7CgkJCQkJCX0KCQkJCQl9CgkJCQl9CgkJCQkKCQkJCSRjb21tYW5kIC49ICcgIi9pbXBvcnRidWRkeS5waHAiJzsKCQkJCQoJCQkJaWYgKCAkZXhjbHVkaW5nX2FkZGl0aW9uYWwgPT09IHRydWUgKSB7CgkJCQkJJHRoaXMtPnN0YXR1cyggJ21lc3NhZ2UnLCBfXyggJ0V4Y2x1ZGluZyBhcmNoaXZlcyBkaXJlY3RvcnkgYW5kIGFkZGl0aW9uYWwgZGlyZWN0b3JpZXMgZGVmaW5lZCBpbiBzZXR0aW5ncy4nLCAnaXQtbDEwbi1iYWNrdXBidWRkeScgKSAuICcgJyAuICRleGNsdWRlX2NvdW50IC4gJyAnIC4gX18oICd0b3RhbCcsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JyApIC4gJy4nICk7CgkJCQl9IGVsc2UgewoJCQkJCSR0aGlzLT5zdGF0dXMoICdtZXNzYWdlJywgX18oICdPbmx5IGV4Y2x1ZGluZyBhcmNoaXZlcyBkaXJlY3RvcnkgYmFzZWQgb24gc2V0dGluZ3MuJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknICkgLiAnICcgLiAkZXhjbHVkZV9jb3VudCAuICcgJyAuIF9fKCAndG90YWwnLCAnaXQtbDEwbi1iYWNrdXBidWRkeScgKSAuICcuJyApOwoJCQkJfQoJCQkJdW5zZXQoICRleGNsdWRlX2NvdW50ICk7CgkJCQkKCQkJCSR3b3JraW5nX2RpciA9IGdldGN3ZCgpOwoJCQkJY2hkaXIoICRhZGRfZGlyZWN0b3J5ICk7IC8vIENoYW5nZSBkaXJlY3RvcnkgdG8gdGhlIHBhdGggd2UgYXJlIGFkZGluZy4KCQkJCQoJCQkJaWYgKCAkdGhpcy0+X2V4ZWNwYXRoICE9ICcnICkgewoJCQkJCSR0aGlzLT5zdGF0dXMoICdkZXRhaWxzJywgX18oICdVc2luZyBjdXN0b20gZXhlYygpIHBhdGg6ICcsICdMSU9OJyApIC4gJHRoaXMtPl9leGVjcGF0aCApOwoJCQkJfQoJCQkJCgkJCQkvLyBSdW4gWklQIGNvbW1hbmQuCgkJCQlpZiAoIHN0cmlzdHIoIFBIUF9PUywgJ1dJTicgKSAmJiAhc3RyaXN0ciggUEhQX09TLCAnREFSV0lOJyApICkgeyAvLyBSdW5uaW5nIFdpbmRvd3MuIChub3QgZGFyd2luKQoJCQkJCWlmICggZmlsZV9leGlzdHMoIEFCU1BBVEggLiAnemlwLmV4ZScgKSApIHsKCQkJCQkJJHRoaXMtPnN0YXR1cyggJ21lc3NhZ2UnLCBfXygnQXR0ZW1wdGluZyB0byB1c2UgcHJvdmlkZWQgV2luZG93cyB6aXAuZXhlLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgKTsKCQkJCQkJJGNvbW1hbmQgPSBzdHJfcmVwbGFjZSggJ1wnJywgJyInLCAkY29tbWFuZCApOyAvLyBXaW5kb3dzIHdhbnRzIGRvdWJsZSBxdW90ZXMKCQkJCQkJJGNvbW1hbmQgPSBBQlNQQVRIIC4gJGNvbW1hbmQ7CgkJCQkJfQoJCQkJCQoJCQkJCSR0aGlzLT5zdGF0dXMoICdkZXRhaWxzJywgX18oJ0V4ZWMgY29tbWFuZCAoV2luZG93cyknLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpIC4gJzogJyAuICRjb21tYW5kICk7CgkJCQkJQGV4ZWMoICR0aGlzLT5fZXhlY3BhdGggLiAkY29tbWFuZCwgJGV4ZWNfcmV0dXJuX2EsICRleGVjX3JldHVybl9iKTsgLy8gU3VwcHJlc3MgZXJyb3JzIGluIFdpbmRvd3Mgc2luY2UgaXQgZ2l2ZXMgbWFqb3IgZm9ya2luZyB3YXJuaW5ncyBpbiBXaW5kb3dzLgoJCQkJfSBlbHNlIHsgLy8gQWxsb3cgZXhlYyB3YXJuaW5ncyBvbiB3aW5kb3dzCgkJCQkJJHRoaXMtPnN0YXR1cyggJ2RldGFpbHMnLCBfXygnRXhlYyBjb21tYW5kIChMaW51eCknLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpIC4gJzogJyAuICRjb21tYW5kICk7CgkJCQkJZXhlYyggJHRoaXMtPl9leGVjcGF0aCAuICRjb21tYW5kLCAkZXhlY19yZXR1cm5fYSwgJGV4ZWNfcmV0dXJuX2IpOwoJCQkJfQoJCQkJCgkJCQkvLyBWZXJpZnkgemlwIGNvbW1hbmQgd2FzIGNyZWF0ZWQgYW5kIGV4ZWMgcmVwb3J0cyBubyBlcnJvcnMuIElmIGZhaWxzIHRoZW4gZmFsbHMgYmFjayB0byBvdGhlciBtZXRob2RzLgoJCQkJaWYgKCAoICEgZmlsZV9leGlzdHMoICR6aXBfZmlsZSApICkgfHwgKCAkZXhlY19yZXR1cm5fYiA9PSAnLTEnICkgKSB7IC8vIEZpbGUgbm90IG1hZGUgb3IgZXJyb3IgcmV0dXJuZWQuCgkJCQkJaWYgKCAkZXhlY19yZXR1cm5fYiA9PSAnLTEnICkgewoJCQkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsIF9fKCAnRXhlYyBjb21tYW5kIHJldHVybmVkIC0xLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JyApICk7CgkJCQkJfQoJCQkJCWlmICggISBmaWxlX2V4aXN0cyggJHppcF9maWxlICkgKSB7CgkJCQkJCSR0aGlzLT5zdGF0dXMoICdkZXRhaWxzJywgX18oICdFeGVjIGNvbW1hbmQgcmFuIGJ1dCBaSVAgZmlsZSBkaWQgbm90IGV4aXN0LicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JyApICk7CgkJCQkJfQoJCQkJCSR0aGlzLT5zdGF0dXMoICdtZXNzYWdlJywgX18oICdGdWxsIHNwZWVkIG1vZGUgZGlkIG5vdCBjb21wbGV0ZS4gVHJ5aW5nIGNvbXBhdGliaWxpdHkgbW9kZSBuZXh0LicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JyApICk7CgkJCQkJaWYgKCBmaWxlX2V4aXN0cyggJHppcF9maWxlICkgKSB7IC8vIElmIGZpbGUgd2FzIHNvbWVob3cgY3JlYXRlZCwgaXRzIGxpa2VseSBkYW1hZ2VkIHNpbmNlIGFuIGVycm9yIHdhcyB0aHJvd24uIERlbGV0ZSBpdC4KCQkJCQkJJHRoaXMtPnN0YXR1cyggJ2RldGFpbHMnLCBfXyggJ0NsZWFuaW5nIHVwIGRhbWFnZWQgWklQIGZpbGUuIElzc3VlICMzNDg5MzI4OTk4LicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JyApICk7CgkJCQkJCXVubGluayggJHppcF9maWxlICk7CgkJCQkJfQoJCQkJCQoJCQkJCS8vIElmIGV4ZWMgY29tcGxldGVkIGJ1dCBsZWZ0IGJlaGluZCBhIHRlbXBvcmFyeSBmaWxlL2RpcmVjdG9yeSAob2Z0ZW4gaGFwcGVucyBpZiBhIHRoaXJkIHBhcnR5IHByb2Nlc3Mga2lsbGVkIG9mZiBleGVjKSB0aGVuIGNsZWFuIGl0IHVwLgoJCQkJCWlmICggZmlsZV9leGlzdHMoICR0ZW1wb3JhcnlfemlwX2RpcmVjdG9yeSApICkgewoJCQkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsIF9fKCAnQ2xlYW5pbmcgdXAgaW5jb21wbGV0ZSB0ZW1wb3JhcnkgWklQIGZpbGUuIElzc3VlICMzNDM4OTQuJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknICkgKTsKCQkJCQkJJHRoaXMtPmRlbGV0ZV9kaXJlY3RvcnlfcmVjdXJzaXZlKCAkdGVtcG9yYXJ5X3ppcF9kaXJlY3RvcnkgKTsKCQkJCQl9CgkJCQl9IGVsc2UgewoJCQkJCSR0aGlzLT5zdGF0dXMoICdtZXNzYWdlJywgX18oICdGdWxsIHNwZWVkIG1vZGUgY29tcGxldGVkICYgZ2VuZXJhdGVkIFpJUCBmaWxlLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JyApICk7CgkJCQkJcmV0dXJuIHRydWU7CgkJCQl9CgkJCQkKCQkJCWNoZGlyKCAkd29ya2luZ19kaXIgKTsKCQkJCQoJCQkJdW5zZXQoICRjb21tYW5kICk7CgkJCQl1bnNldCggJGV4Y2x1ZGUgKTsKCQkJCXVuc2V0KCAkZXhjbHVkaW5nX2FkZGl0aW9uYWwgKTsKCQkJCQoJCQkJJHRoaXMtPnN0YXR1cyggJ2RldGFpbHMnLCBfXygnRXhlYyBjb21tYW5kIGRpZCBub3Qgc3VjY2VlZC4gRmFsbGluZyBiYWNrLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgKTsKCQkJfQoJCQkKCQkJaWYgKCBpbl9hcnJheSggJ3BjbHppcCcsICR6aXBfbWV0aG9kcyApICkgewoJCQkJJHRoaXMtPnN0YXR1cyggJ21lc3NhZ2UnLCBfXygnVXNpbmcgQ29tcGF0aWJpbGl0eSBNb2RlIGZvciBaSVAuIFRoaXMgaXMgc2xvd2VyIGFuZCBsZXNzIHJlbGlhYmxlLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgKTsKCQkJCSR0aGlzLT5zdGF0dXMoICdtZXNzYWdlJywgX18oJ0lmIHlvdXIgYmFja3VwIHRpbWVzIG91dCBpbiBjb21wYXRpYmlsaXR5IG1vZGUgdHJ5IGRpc2FibGVkIHppcCBjb21wcmVzc2lvbi4nLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpICk7CgkJCQkkdGhpcy0+c3RhdHVzKCAnbWVzc2FnZScsIF9fKCdXQVJOSU5HOiBEaXJlY3RvcnkvZmlsZSBleGNsdXNpb24gdW5hdmFpbGFibGUgaW4gQ29tcGF0aWJpbGl0eSBNb2RlLiBFdmVuIGV4aXN0aW5nIG9sZCBiYWNrdXBzIHdpbGwgYmUgYmFja2VkIHVwLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgKTsKCQkJCQoJCQkJcmVxdWlyZV9vbmNlKCBBQlNQQVRIIC4gJ3dwLWFkbWluL2luY2x1ZGVzL2NsYXNzLXBjbHppcC5waHAnICk7CgkJCQkKCQkJCWlmICggIWVtcHR5KCAkdGVtcG9yYXJ5X3ppcF9kaXJlY3RvcnkgKSApIHsKCQkJCQkkcGNsemlwID0gbmV3IFBjbFppcCggJHRlbXBvcmFyeV96aXBfZGlyZWN0b3J5IC4gYmFzZW5hbWUoICR6aXBfZmlsZSApICk7CgkJCQl9IGVsc2UgewoJCQkJCSRwY2x6aXAgPSBuZXcgUGNsWmlwKCAkemlwX2ZpbGUgKTsKCQkJCX0KCQkJCQoJCQkJaWYgKCAkY29tcHJlc3Npb24gIT09IHRydWUgKSB7CgkJCQkJJHRoaXMtPnN0YXR1cyggJ2RldGFpbHMnLCBfXygnUENMWmlwIGNvbXByZXNzaW9uIGRpc2FibGVkIGJhc2VkIG9uIHNldHRpbmdzLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgKTsKCQkJCQkkYXJndW1lbnRzID0gYXJyYXkoICRhZGRfZGlyZWN0b3J5LCBQQ0xaSVBfT1BUX05PX0NPTVBSRVNTSU9OLCBQQ0xaSVBfT1BUX1JFTU9WRV9QQVRILCAkYWRkX2RpcmVjdG9yeSApOwoJCQkJfSBlbHNlIHsKCQkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsIF9fKCdQQ0xaaXAgY29tcHJlc3Npb24gZW5hYmxlZCBiYXNlZCBvbiBzZXR0aW5ncy4nLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpICk7CgkJCQkJJGFyZ3VtZW50cyA9IGFycmF5KCAkYWRkX2RpcmVjdG9yeSwgUENMWklQX09QVF9SRU1PVkVfUEFUSCwgJGFkZF9kaXJlY3RvcnkgKTsKCQkJCX0KCQkJCQoJCQkJJG1vZGUgPSAnY3JlYXRlJzsKCQkJCWlmICggZmlsZV9leGlzdHMoICR6aXBfZmlsZSApICYmICggJGFwcGVuZCA9PT0gdHJ1ZSApICkgewoJCQkJCSR0aGlzLT5zdGF0dXMoICdkZXRhaWxzJywgX18oJ1pJUCBmaWxlIGV4aXN0cy4gQXBwZW5kaW5nIGJhc2VkIG9uIG9wdGlvbnMuJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknKSApOwoJCQkJCSRtb2RlID0gJ2FwcGVuZCc7CgkJCQl9CgkJCQkKCQkJCWlmICggJG1vZGUgPT0gJ2FwcGVuZCcgKSB7CgkJCQkJJHRoaXMtPnN0YXR1cyggJ2RldGFpbHMnLCBfXygnQXBwZW5kaW5nIHRvIFpJUCBmaWxlIHZpYSBQQ0xaaXAuJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknKSApOwoJCQkJCSRyZXN1bHQgPSBjYWxsX3VzZXJfZnVuY19hcnJheSggYXJyYXkoICYkcGNsemlwLCAnYWRkJyApLCAkYXJndW1lbnRzICk7CgkJCQl9IGVsc2UgeyAvLyBjcmVhdGUKCQkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsIF9fKCAnQ3JlYXRpbmcgWklQIGZpbGUgdmlhIFBDTFppcCcsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgLiAnOicgLiBpbXBsb2RlKCAnOycsICRhcmd1bWVudHMgKSApOwoJCQkJCS8vZXJyb3JfbG9nKCAncGNsemlwIGFyZ3M6ICcgLiBwcmludF9yKCAkYXJndW1lbnRzLCB0cnVlICkgLiAiXG4iICk7CgkJCQkJJHJlc3VsdCA9IGNhbGxfdXNlcl9mdW5jX2FycmF5KCBhcnJheSggJiRwY2x6aXAsICdjcmVhdGUnICksICRhcmd1bWVudHMgKTsKCQkJCX0KCQkJCQoJCQkJaWYgKCAhZW1wdHkoICR0ZW1wb3JhcnlfemlwX2RpcmVjdG9yeSApICkgewoJCQkJCWlmICggZmlsZV9leGlzdHMoICR0ZW1wb3JhcnlfemlwX2RpcmVjdG9yeSAuIGJhc2VuYW1lKCAkemlwX2ZpbGUgKSApICkgewoJCQkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsIF9fKCdSZW5hbWluZyBQQ0xaaXAgRmlsZS4uLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgKTsKCQkJCQkJcmVuYW1lKCAkdGVtcG9yYXJ5X3ppcF9kaXJlY3RvcnkgLiBiYXNlbmFtZSggJHppcF9maWxlICksICR6aXBfZmlsZSApOwoJCQkJCQlpZiAoIGZpbGVfZXhpc3RzKCAkemlwX2ZpbGUgKSApIHsKCQkJCQkJCSR0aGlzLT5zdGF0dXMoICdkZXRhaWxzJywgX18oJ1JlbmFtaW5nIFBDTFppcCBzdWNjZXNzLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgKTsKCQkJCQkJfSBlbHNlIHsKCQkJCQkJCSR0aGlzLT5zdGF0dXMoICdkZXRhaWxzJywgX18oJ1JlbmFtaW5nIFBDTFppcCBmYWlsdXJlLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgKTsKCQkJCQkJfQoJCQkJCX0gZWxzZSB7CgkJCQkJCSR0aGlzLT5zdGF0dXMoICdkZXRhaWxzJywgX18oJ1RlbXBvcmFyeSBQQ0xaaXAgYXJjaGl2ZSBmaWxlIGV4cGVjdGVkIGJ1dCBub3QgZm91bmQuJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknKSApOwoJCQkJCX0KCQkJCX0KCQkJCQoJCQkJLy8gSWYgbm90IGEgcmVzdWx0IG9mIDAgYW5kIHRoZSBmaWxlIGV4aXN0cyB0aGVuIGl0IGxvb2tzIGxpa2UgdGhlIGJhY2t1cCB3YXMgYSBzdWNjZXNzLgoJCQkJaWYgKCAoICRyZXN1bHQgIT0gMCApICYmIGZpbGVfZXhpc3RzKCAkemlwX2ZpbGUgKSApIHsKCQkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsIF9fKCdCYWNrdXAgZmlsZSBjcmVhdGVkIGluIGNvbXBhdGliaWxpdHkgbW9kZSAoUENMWmlwKS4nLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpICk7CgkJCQkJcmV0dXJuIHRydWU7CgkJCQl9IGVsc2UgewoJCQkJCWlmICggJHJlc3VsdCA9PSAwICkgewoJCQkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsIF9fKCdQQ0xaaXAgcmV0dXJuZWQgc3RhdHVzIDAuJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknKSApOwoJCQkJCX0KCQkJCQlpZiAoICFmaWxlX2V4aXN0cyggJHppcF9maWxlICkgKSB7CgkJCQkJCSR0aGlzLT5zdGF0dXMoICdkZXRhaWxzJywgX18oJ1BDTFppcCBhcmNoaXZlIFpJUCBmaWxlIHdhcyBub3QgZm91bmQuJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknKSApOwoJCQkJCX0KCQkJCX0KCQkJCQoJCQkJdW5zZXQoICRyZXN1bHQgKTsKCQkJCXVuc2V0KCAkbW9kZSApOwoJCQkJdW5zZXQoICRhcmd1bWVudHMgKTsKCQkJCXVuc2V0KCAkcGNsemlwICk7CgkJCX0KCQkJCgkJCS8vIElmIHdlIG1hZGUgaXQgdGhpcyBmYXIgdGhlbiBzb21ldGhpbmcgZGlkbnQgcmVzdWx0IGluIGEgc3VjY2Vzcy4KCQkJcmV0dXJuIGZhbHNlOwoJCX0KCQkKCQkKCQkvKioKCQkgKgl1bnppcCgpCgkJICoKCQkgKglFeHRyYWN0cyB0aGUgY29udGVudHMgb2YgYSB6aXAgZmlsZSB0byB0aGUgc3BlY2lmaWVkIGRpcmVjdG9yeSB1c2luZyB0aGUgYmVzdCB1bnppcCBtZXRob2RzIHBvc3NpYmxlLgoJCSAqCgkJICoJJHppcF9maWxlCQkJCQlzdHJpbmcJCUZ1bGwgcGF0aCAmIGZpbGVuYW1lIG9mIFpJUCBmaWxlIHRvIGNyZWF0ZS4KCQkgKgkkZGVzdGluYXRpb25fZGlyZWN0b3J5CQlzdHJpbmcJCUZ1bGwgZGlyZWN0b3J5IHBhdGggdG8gZXh0cmFjdCBpbnRvLgoJCSAqCSRmb3JjZV9jb21wYXRpYmlsaXR5X21vZGUJbWl4ZWQJCWZhbHNlIChkZWZhdWx0KTogdXNlIGJlc3QgbWV0aG9kcyBhdmFpbGFibGUgKHppcCBleGVjIGZpcnN0KSwgZmFsbGluZyBiYWNrIGFzIG5lZWRlZC4KCQkgKgkJCQkJCQkJCQkJemlwYXJjaGl2ZTogZmlyc3QgZmFsbGJhY2sgbWV0aG9kLiAoTWVkaXVtIHBlcmZvcm1hbmNlKQoJCSAqCQkJCQkJCQkJCQlwY2x6aXA6IHNlY29uZCBmYWxsYmFjayBtZXRob2QuIChXb3JzdCBwZXJmb3JtYW5jZTsgYnVnZ3kpCgkJICoKCQkgKglAcmV0dXJuYGAJCQkJCQkJCXRydWUgb24gc3VjY2VzcywgZmFsc2Ugb3RoZXJ3aXNlCgkJICovCgkJZnVuY3Rpb24gdW56aXAoICR6aXBfZmlsZSwgJGRlc3RpbmF0aW9uX2RpcmVjdG9yeSwgJGZvcmNlX2NvbXBhdGliaWxpdHlfbW9kZSA9IGZhbHNlICkgewoJCQlpZiAoICRmb3JjZV9jb21wYXRpYmlsaXR5X21vZGUgPT0gJ3ppcGFyY2hpdmUnICkgewoJCQkJJHppcF9tZXRob2RzID0gYXJyYXkoICd6aXBhcmNoaXZlJyApOwoJCQkJJHRoaXMtPnN0YXR1cyggJ21lc3NhZ2UnLCBfXygnRm9yY2VkIGNvbXBhdGliaWxpdHkgbW9kZSAoWmlwQXJjaGl2ZTsgbWVkaXVtIHNwZWVkKSBiYXNlZCBvbiBzZXR0aW5ncy4gVGhpcyBpcyBzbG93ZXIgYW5kIGxlc3MgcmVsaWFibGUuJywgJ2l0LWwxMG4tYmFja3VwYnVkZHknKSApOwoJCQl9IGVsc2VpZiAoICRmb3JjZV9jb21wYXRpYmlsaXR5X21vZGUgPT0gJ3BjbHppcCcgKSB7CgkJCQkkemlwX21ldGhvZHMgPSBhcnJheSggJ3BjbHppcCcgKTsKCQkJCSR0aGlzLT5zdGF0dXMoICdtZXNzYWdlJywgX18oJ0ZvcmNlZCBjb21wYXRpYmlsaXR5IG1vZGUgKFBDTFppcDsgc2xvdyBzcGVlZCkgYmFzZWQgb24gc2V0dGluZ3MuIFRoaXMgaXMgc2xvd2VyIGFuZCBsZXNzIHJlbGlhYmxlLicsICdpdC1sMTBuLWJhY2t1cGJ1ZGR5JykgKTsKCQkJfSBlbHNlIHsKCQkJCSR6aXBfbWV0aG9kcyA9ICR0aGlzLT5femlwX21ldGhvZHM7CgkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsIF9fKCdVc2luZyBhbGwgYXZhaWxhYmxlIHppcCBtZXRob2RzIGluIHByZWZlcnJlZCBvcmRlci4nLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpICk7CgkJCX0KCQkJCgkJCWlmICggaW5fYXJyYXkoICdleGVjJywgJHppcF9tZXRob2RzICkgKSB7CgkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsICAnU3RhcnRpbmcgaGlnaHNwZWVkIGV4dHJhY3Rpb24gKGV4ZWMpLi4uIFRoaXMgbWF5IHRha2UgYSBtb21lbnQuLi4nICk7CgkJCQkKCQkJCSRjb21tYW5kID0gJ3VuemlwIC1xbyc7IC8vIHEgPSBxdWlldCwgbyA9IG92ZXJ3cml0ZSB3aXRob3V0IHByb21wdC4KCQkJCSRjb21tYW5kIC49ICIgJyR6aXBfZmlsZScgLWQgJyRkZXN0aW5hdGlvbl9kaXJlY3RvcnknIC14ICdpbXBvcnRidWRkeS5waHAnIjsgLy8geCBleGNsdWRlcyBpbXBvcnRidWRkeSBzY3JpcHQgdG8gcHJldmVudCBvdmVyd3JpdGluZyBuZXdlciBpbXBvcnRidWRkeSBvbiBleHRyYWN0IHN0ZXAuCgkJCQoJCQkJLy8gSGFuZGxlIHdpbmRvd3MuCgkJCQlpZiAoIHN0cmlzdHIoIFBIUF9PUywgJ1dJTicgKSAmJiAhc3RyaXN0ciggUEhQX09TLCAnREFSV0lOJyApICkgeyAvLyBSdW5uaW5nIFdpbmRvd3MuIChub3QgZGFyd2luKQoJCQkJCWlmICggZmlsZV9leGlzdHMoIEFCU1BBVEggLiAndW56aXAuZXhlJyApICkgewoJCQkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsICAnQXR0ZW1wdGluZyB0byB1c2UgV2luZG93cyB1bnppcC5leGUuJyApOwoJCQkJCQkkY29tbWFuZCA9IHN0cl9yZXBsYWNlKCAnXCcnLCAnIicsICRjb21tYW5kICk7IC8vIFdpbmRvd3Mgd2FudHMgZG91YmxlIHF1b3RlcwoJCQkJCQkkY29tbWFuZCA9IEFCU1BBVEggLiAkY29tbWFuZDsKCQkJCQl9CgkJCQl9CgkJCQkKCQkJCWlmICggJHRoaXMtPl9leGVjcGF0aCAhPSAnJyApIHsKCQkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsIF9fKCAnVXNpbmcgY3VzdG9tIGV4ZWMoKSBwYXRoOiAnLCAnTElPTicgKSAuICR0aGlzLT5fZXhlY3BhdGggKTsKCQkJCX0KCQkJCQoJCQkJJHRoaXMtPnN0YXR1cyggJ2RldGFpbHMnLCAnUnVubmluZyBaSVAgY29tbWFuZDogJyAuICRjb21tYW5kICk7CgkJCQlleGVjKCAkdGhpcy0+X2V4ZWNwYXRoIC4gJGNvbW1hbmQsICRleGVjX3JldHVybl9hLCAkZXhlY19yZXR1cm5fYiApOwoJCQkJCQkJCQoJCQkJaWYgKCAoICEgZmlsZV9leGlzdHMoICd3cC1jb25maWcucGhwJyApICkgfHwgKCAkZXhlY19yZXR1cm5fYiAhPSAnJyApICkgeyAvLyBGaWxlIG5vdCBtYWRlIG9yIGVycm9yIHJldHVybmVkLgoJCQkJLy9pZiAoICRleGVjX3JldHVybl9iICE9ICcnICkgeyAvLyBGaWxlIG5vdCBtYWRlIG9yIGVycm9yIHJldHVybmVkLgoKCQkJCQkvLyBFUlJPUiBMSVNUOiBodHRwOi8vd3d3Lm1rc3NvZnR3YXJlLmNvbS9kb2NzL21hbjEvdW56aXAuMS5hc3AKCQkJCQlpZiAoICRleGVjX3JldHVybl9iID09ICc1MCcgKSB7CgkJCQkJCSR0aGlzLT5zdGF0dXMoICdlcnJvcicsICAnVGhlIGRpc2sgaXMgKG9yIHdhcykgZnVsbCBkdXJpbmcgZXh0cmFjdGlvbiA8Yj5PUjwvYj4gdGhlIHppcC91bnppcCBjb21tYW5kIGRvZXMgbm90IGhhdmUgd3JpdGUgcGVybWlzc2lvbiB0byB5b3VyIGRpcmVjdG9yeS4gIFRyeSBpbmNyZWFzaW5nIHBlcm1pc3Npb25zIGZvciB0aGUgZGlyZWN0b3J5LicsIHRydWUgKTsKCQkJCQl9CgkJCQkJCgkJCQkJCgkJCQkJaWYgKCAhIGZpbGVfZXhpc3RzKCAnd3AtY29uZmlnLnBocCcgKSApIHsKCQkJCQkJJHRoaXMtPnN0YXR1cyggJ2Vycm9yJywgICd3cC1jb25maWcucGhwIGZpbGUgd2FzIG5vdCBmb3VuZCBhZnRlciBleHRyYWN0aW9uIHVzaW5nIGhpZ2ggc3BlZWQgbW9kZS4nICk7CgkJCQkJfQoJCQkJCQoJCQkJCQoJCQkJCSR0aGlzLT5zdGF0dXMoICdtZXNzYWdlJywgICdGYWxsaW5nIGJhY2sgdG8gbmV4dCBjb21wYXRpbGJpdHkgbW9kZS4nICk7CgkJCQl9IGVsc2UgewoJCQkJCSR0aGlzLT5zdGF0dXMoICdtZXNzYWdlJywgJ0ZpbGUgZXh0cmFjdGlvbiBjb21wbGV0ZS4nICk7CgkJCQkJcmV0dXJuIHRydWU7CgkJCQl9CgkJCX0KCQkJCgkJCWlmICggaW5fYXJyYXkoICd6aXBhcmNoaXZlJywgJHppcF9tZXRob2RzICkgKSB7CgkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsICAnU3RhcnRpbmcgbWVkaXVtIHNwZWVkIGV4dHJhY3Rpb24gKHppcGFyY2hpdmUpLi4uIFRoaXMgbWF5IHRha2UgYSBtb21lbnQuLi4nICk7CgkJCQkKCQkJCSR6aXAgPSBuZXcgWmlwQXJjaGl2ZTsKCQkJCWlmICggJHppcC0+b3BlbiggJHppcF9maWxlICkgPT09IHRydWUgKSB7CgkJCQkJaWYgKCB0cnVlID09PSAkemlwLT5leHRyYWN0VG8oICRkZXN0aW5hdGlvbl9kaXJlY3RvcnkgKSApIHsKCQkJCQkJJHRoaXMtPnN0YXR1cyggJ2RldGFpbHMnLCAgJ1ppcEFyY2hpdmUgZXh0cmFjdGlvbiBzdWNjZXNzLicgKTsKCQkJCQkJcmV0dXJuIHRydWU7CgkJCQkJfSBlbHNlIHsKCQkJCQkJJHRoaXMtPnN0YXR1cyggJ21lc3NhZ2UnLCAgJ0Vycm9yOiBaaXBBcmNoaXZlIHdhcyBhdmFpbGFibGUgYnV0IGZhaWxlZCBleHRyYWN0aW5nIGZpbGVzLiAgRmFsbGluZyBiYWNrIHRvIG5leHQgY29tcGF0aWJpbGl0eSBtb2RlLicgKTsKCQkJCQl9CgkJCQl9IGVsc2UgewoJCQkJCSR0aGlzLT5zdGF0dXMoICdtZXNzYWdlJywgICdFcnJvcjogVW5hYmxlIHRvIG9wZW4gemlwIGZpbGUgdmlhIFppcEFyY2hpdmUuIEZhbGxpbmcgYmFjayB0byBuZXh0IGNvbXBhdGliaWxpdHkgbW9kZS4nICk7CgkJCQl9CgkJCX0KCQkJCgkJCWlmICggaW5fYXJyYXkoICdwY2x6aXAnLCAkemlwX21ldGhvZHMgKSApIHsKCQkJCSR0aGlzLT5zdGF0dXMoICdkZXRhaWxzJywgICdTdGFydGluZyBsb3cgc3BlZWQgZXh0cmFjdGlvbiAocGNsemlwKS4uLiBUaGlzIG1heSB0YWtlIGEgbW9tZW50Li4uJyApOwoJCQkJCgkJCQlpZiAoICFjbGFzc19leGlzdHMoICdQY2xaaXAnICkgKSB7CgkJCQkJJHBjbHppcF9maWxlID0gc3RyX3JlcGxhY2UoICcvemlwYnVkZHknLCAnL3BjbHppcC9wY2x6aXAucGhwJywgZGlybmFtZSggX19GSUxFX18gKSApOwoJCQkJCWlmICggZmlsZV9leGlzdHMoICRwY2x6aXBfZmlsZSApICkgewoJCQkJCQlyZXF1aXJlX29uY2UoICRwY2x6aXBfZmlsZSApOwoJCQkJCX0KCQkJCX0KCQkJCSRhcmNoaXZlID0gbmV3IFBjbFppcCggJHppcF9maWxlICk7CgkJCQkkcmVzdWx0ID0gJGFyY2hpdmUtPmV4dHJhY3QoKTsgLy8gRXh0cmFjdCB0byBjdXJyZW50IGRpcmVjdG9yeS4gRXhwbGljaXR5IHVzaW5nIFBDTFpJUF9PUFRfUEFUSCByZXN1bHRzIGluIGV4dHJhY3Rpb24gdG8gYSBQQ0xaSVBfT1BUX1BBVEggc3ViZm9sZGVyLgoJCQkJCgkJCQlpZiAoIDAgPT0gJHJlc3VsdCApIHsKCQkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsICAnUENMWmlwIEZhaWx1cmU6ICcgLiAkYXJjaGl2ZS0+ZXJyb3JJbmZvKCB0cnVlICkgKTsKCQkJCQkkdGhpcy0+c3RhdHVzKCAnbWVzc2FnZScsICAnTG93IHNwZWVkIChQQ0xaaXApIGV4dHJhY3Rpb24gZmFpbGVkLicsICRhcmNoaXZlLT5lcnJvckluZm8oIHRydWUgKSApOwoJCQkJfSBlbHNlIHsKCQkJCQlyZXR1cm4gdHJ1ZTsKCQkJCX0KCQkJfQoJCQkKCQkJLy8gTm90aGluZyBzdWNjZWVkZWQgaWYgd2UgbWFkZSBpdCB0aGlzIGZhci4uLgoJCQlyZXR1cm4gZmFsc2U7CgkJfQoJCQoJCQoJCS8vIFRlc3QgYXZhaWxhYmlsaXR5IG9mIFppcEFyY2hpdmUgYW5kIHRoYXQgaXQgYWN0dWFsbHkgd29ya3MuCgkJZnVuY3Rpb24gdGVzdF96aXBhcmNoaXZlKCkgewoJCQlpZiAoIGNsYXNzX2V4aXN0cyggJ1ppcEFyY2hpdmUnICkgKSB7CgkJCQkkdGVzdF9maWxlID0gJHRoaXMtPl90ZW1wZGlyIC4gJ3RlbXBfdGVzdF8nIC4gdW5pcWlkKCkgLiAnLnppcCc7CgkJCQkKCQkJCSR6aXAgPSBuZXcgWmlwQXJjaGl2ZTsKCQkJCWlmICggJHppcC0+b3BlbiggJHRlc3RfZmlsZSwgWklQQVJDSElWRTo6Q1JFQVRFIHwgWklQQVJDSElWRTo6T1ZFUldSSVRFICkgPT09IHRydWUgKSB7CgkJCQkJJHppcC0+YWRkRmlsZSggX19GSUxFX18sICd0aGlzX2lzX2FfdGVzdC50eHQnKTsKCQkJCQkkemlwLT5jbG9zZSgpOwoJCQkJCWlmICggZmlsZV9leGlzdHMoICR0ZXN0X2ZpbGUgKSApIHsKCQkJCQkJdW5saW5rKCAkdGVzdF9maWxlICk7CgkJCQkJCSR0aGlzLT5fc3RhdHVzW10gPSBfXygnWmlwQXJjaGl2ZSB0ZXN0IFBBU1NFRC4nLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpOwoJCQkJCQlyZXR1cm4gdHJ1ZTsKCQkJCQl9IGVsc2UgewoJCQkJCQkkdGhpcy0+X3N0YXR1c1tdID0gX18oJ1ppcEFyY2hpdmUgdGVzdCBGQUlMRUQ6IFppcCBmaWxlIG5vdCBmb3VuZC4nLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpOwoJCQkJCQlyZXR1cm4gZmFsc2U7CgkJCQkJfQoJCQkJfSBlbHNlIHsKCQkJCQkkdGhpcy0+X3N0YXR1c1tdID0gX18oJ1ppcEFyY2hpdmUgdGVzdCBGQUlMRUQ6IFVuYWJsZSB0byBjcmVhdGUvb3BlbiB6aXAgZmlsZS4nLCAnaXQtbDEwbi1iYWNrdXBidWRkeScpOwoJCQkJCXJldHVybiBmYWxzZTsKCQkJCX0KCQkJfQoJCX0KCQkKCQkKCQkvLyBUZXN0IGF2YWlsYWJpbGl0eSBvZiB6aXAgbWV0aG9kcyB0byBkZXRlcm1pbmUgd2hpY2ggZXhpc3QgYW5kIGFjdHVhbGx5IHdvcmsuCgkJLy8gJG1vZGUJc3RyaW5nCQlWYWxpZCBvcHRpb25zOiB6aXAsIHVuemlwCgkJLy8JCQkJCQkJdG9kbzogYWN0dWFsbHkgdGVzdCB1bnppcHBpbmcgaW4gdW56aXAgbW9kZSBub3QganVzdCB6aXBwaW5nIGFuZCBhc3N1bWluZyB0aGUgb3RoZXIgd2lsbCB3b3JrCgkJZnVuY3Rpb24gYXZhaWxhYmxlX3ppcF9tZXRob2RzKCAkcmV0dXJuX2Jlc3QgPSB0cnVlLCAkbW9kZSA9ICd6aXAnICkgewoJCQkkcmV0dXJuID0gYXJyYXkoKTsKCQkJJHRlc3RfZmlsZSA9ICR0aGlzLT5fdGVtcGRpciAuICd0ZW1wXycgLiB1bmlxaWQoKSAuICcuemlwJzsKCQkJCgkJCS8vIFRlc3QgY29tbWFuZC1saW5lIFpJUC4KCQkJaWYgKCBmdW5jdGlvbl9leGlzdHMoICdleGVjJyApICkgewoJCQkJJGNvbW1hbmQgPSAnemlwJzsKCQkJCQoJCQkJLy8gSGFuZGxlIHdpbmRvd3MuCgkJCQlpZiAoIHN0cmlzdHIoIFBIUF9PUywgJ1dJTicgKSAmJiAhc3RyaXN0ciggUEhQX09TLCAnREFSV0lOJyApICkgeyAvLyBSdW5uaW5nIFdpbmRvd3MuIChub3QgZGFyd2luKQoJCQkJCWlmICggZmlsZV9leGlzdHMoIEFCU1BBVEggLiAnemlwLmV4ZScgKSApIHsKCQkJCQkJJGNvbW1hbmQgPSBBQlNQQVRIIC4gJGNvbW1hbmQ7CgkJCQkJfQoJCQkJCS8vIElmIHVuemlwIG1vZGUgYW5kIHVuemlwLmV4ZSBpcyBmb3VuZCB0aGVuIGFzc3VtZSB3ZSBoYXZlIHRoYXQgb3B0aW9uIGZvciB1bnppcHBpbmcgc2luY2Ugd2UgYXJlbnQgYWN0dWFsbHkgdGVzdGluZyB1bnppcC4KCQkJCQlpZiAoICggJG1vZGUgPT0gJ3VuemlwJyApICYmIGZpbGVfZXhpc3RzKCBBQlNQQVRIIC4gJy91bnppcC5leGUnICkgKSB7CgkJCQkJCWFycmF5X3B1c2goICRyZXR1cm4sICdleGVjJyApOwoJCQkJCX0KCQkJCX0KCQkJCQoJCQkJLy8gUG9zc2libGUgbG9jYXRpb25zIHRvIGZpbmQgdGhlIFpJUCBleGVjdXRhYmxlLiBTdGFydCB3aXRoIGEgYmxhbmsgc3RyaW5nIHRvIGF0dGVtcHQgdG8gcnVuIGluIGN1cnJlbnQgZGlyZWN0b3J5LgoJCQkJJGV4ZWNfcGF0aHMgPSBhcnJheSggJycsICcvdXNyL2Jpbi8nLCAnL3Vzci9sb2NhbC9iaW4vJyApOyAvLyBJbmNsdWRlIHByZWNlZWRpbmcgJiB0cmFpbGluZyBzbGFzaC4KCQkJCQoJCQkJJGV4ZWNfY29tcGxldGlvbiA9IGZhbHNlOyAvLyBkZWZhdWx0IHN0YXRlLgoJCQkJd2hpbGUoICRleGVjX2NvbXBsZXRpb24gPT09IGZhbHNlICkgeyAvLyBDaGVjayBhbGwgcG9zc2libGUgemlwIHBhdGggbG9jYXRpb25zIHN0YXJ0aW5nIHdpdGggY3VycmVudCBkaXIuIFVzdWFsbHkgdGhlIHBhdGggaXMgc2V0IHRvIG1ha2UgdGhpcyB3b3JrIHdpdGhvdXQgaHVudGluZy4KCQkJCQlpZiAoIGVtcHR5KCAkZXhlY19wYXRocyApICkgewoJCQkJCQkkZXhlY19jb21wbGV0aW9uID0gdHJ1ZTsKCQkJCQkJJHRoaXMtPnN0YXR1cyggJ2Vycm9yJywgX18oICdFeGhhdXN0ZWQgYWxsIGtub3duIGV4ZWMoKSBwYXRoIHBvc3NpYmlsaXRpZXMgd2l0aCBubyBzdWNjZXNzLicsICdMSU9OJyApICk7CgkJCQkJCWJyZWFrOwoJCQkJCX0KCQkJCQkkcGF0aCA9IGFycmF5X3NoaWZ0KCAkZXhlY19wYXRocyApOwoJCQkJCSR0aGlzLT5zdGF0dXMoICdkZXRhaWxzJywgX18oICdUcnlpbmcgZXhlYygpIFpJUCBwYXRoOicsICdMSU9OJyApIC4gJyBgJyAuICRwYXRoIC4gJ2AuJyApOwoJCQkJCQoJCQkJCUBleGVjKCAkcGF0aCAuICRjb21tYW5kIC4gJyAiJyAuICR0ZXN0X2ZpbGUgLiAnIiAiJyAuIF9fRklMRV9fIC4gJyInLCAkZXhlY19yZXR1cm5fYSwgJGV4ZWNfcmV0dXJuX2IgKTsKCQkJCQkKCQkJCQlpZiAoICggIWZpbGVfZXhpc3RzKCAkdGVzdF9maWxlICkgKSB8fCAoICRleGVjX3JldHVybl9iID09ICctMScgKSApIHsgLy8gRmlsZSBub3QgbWFkZSBvciBlcnJvciByZXR1cm5lZC4KCQkJCQkJJGV4ZWNfY29tcGxldGlvbiA9IGZhbHNlOwoJCQkJCQkKCQkJCQkJaWYgKCAkZXhlY19yZXR1cm5fYiA9PSAnLTEnICkgewoJCQkJCQkJJHRoaXMtPnN0YXR1cyggJ2RldGFpbHMnLCBfXyggJ0V4ZWMgY29tbWFuZCByZXR1cm5lZCAtMS4nLCAnTElPTicgKSApOwoJCQkJCQl9CgkJCQkJCWlmICggIWZpbGVfZXhpc3RzKCAkdGVzdF9maWxlICkgKSB7CgkJCQkJCQkkdGhpcy0+c3RhdHVzKCAnZGV0YWlscycsIF9fKCAnRXhlYyBjb21tYW5kIHJhbiBidXQgWklQIGZpbGUgZGlkIG5vdCBleGlzdC4nLCAnTElPTicgKSApOwoJCQkJCQl9CgkJCQkJCWlmICggZmlsZV9leGlzdHMoICR0ZXN0X2ZpbGUgKSApIHsgLy8gSWYgZmlsZSB3YXMgc29tZWhvdyBjcmVhdGVkLCBkbyBjbGVhbnVwIG9uIGl0LgoJCQkJCQkJJHRoaXMtPnN0YXR1cyggJ2RldGFpbHMnLCBfXyggJ0NsZWFuaW5nIHVwIGRhbWFnZWQgWklQIGZpbGUuIElzc3VlICMzNDg5MzI4OTk4LicsICdMSU9OJyApICk7CgkJCQkJCQl1bmxpbmsoICR0ZXN0X2ZpbGUgKTsKCQkJCQkJfQoJCQkJCX0gZWxzZSB7IC8vIFN1Y2Nlc3MuCgkJCQkJCSRleGVjX2NvbXBsZXRpb24gPSB0cnVlOwoJCQkJCQkKCQkJCQkJaWYgKCAhdW5saW5rKCAkdGVzdF9maWxlICkgKSB7CgkJCQkJCQllY2hvIHNwcmludGYoIF9fKCAnRXJyb3IgIzU2NDYzNC4gVW5hYmxlIHRvIGRlbGV0ZSB0ZXN0IGZpbGUgKCVzKSEnLCAnTElPTicgKSwgJHRlc3RfZmlsZSApOwoJCQkJCQl9CgkJCQkJCWFycmF5X3B1c2goICRyZXR1cm4sICdleGVjJyApOwoJCQkJCQkkdGhpcy0+X2V4ZWNwYXRoID0gJHBhdGg7CgkJCQkJCQoJCQkJCQlicmVhazsKCQkJCQl9CgkJCQl9IC8vIGVuZCB3aGlsZQoJCQl9CgkJCQoJCQkvLyBUZXN0IFppcEFyY2hpdmUKCQkJaWYgKCBjbGFzc19leGlzdHMoICdaaXBBcmNoaXZlJyApICkgewoJCQkJaWYgKCAkdGhpcy0+dGVzdF96aXBhcmNoaXZlKCkgPT09IHRydWUgKSB7CgkJCQkJYXJyYXlfcHVzaCggJHJldHVybiwgJ3ppcGFyY2hpdmUnICk7CgkJCQl9CgkJCX0KCQkJCgkJCS8vIFRlc3QgUENMWmlwCgkJCWFycmF5X3B1c2goICRyZXR1cm4sICdwY2x6aXAnICk7CgkJCQoJCQlyZXR1cm4gJHJldHVybjsKCQl9CgkJCgkJCgkJLy8gUmVjdXJzaXZlbHkgZGVsZXRlIGEgZGlyZWN0b3J5IGFuZCBhbGwgY29udGVudCB3aXRoaW4uCgkJZnVuY3Rpb24gZGVsZXRlX2RpcmVjdG9yeV9yZWN1cnNpdmUoICRkaXJlY3RvcnkgKSB7CgkJCSRkaXJlY3RvcnkgPSBwcmVnX3JlcGxhY2UoICd8Wy9cXFxcXSskfCcsICcnLCAkZGlyZWN0b3J5ICk7CgkJCQoJCQkkZmlsZXMgPSBnbG9iKCAkZGlyZWN0b3J5IC4gJy8qJywgR0xPQl9NQVJLICk7CgkJCWlmICggaXNfYXJyYXkoICRmaWxlcyApICYmICFlbXB0eSggJGZpbGVzICkgKSB7CgkJCQlmb3JlYWNoKCAkZmlsZXMgYXMgJGZpbGUgKSB7CgkJCQkJaWYoICcvJyA9PT0gc3Vic3RyKCAkZmlsZSwgLTEgKSApCgkJCQkJCSR0aGlzLT5ybWRpcl9yZWN1cnNpdmUoICRmaWxlICk7CgkJCQkJZWxzZQoJCQkJCQl1bmxpbmsoICRmaWxlICk7CgkJCQl9CgkJCX0KCQkJCgkJCWlmICggaXNfZGlyKCAkZGlyZWN0b3J5ICkgKSBybWRpciggJGRpcmVjdG9yeSApOwoJCQkKCQkJaWYgKCBpc19kaXIoICRkaXJlY3RvcnkgKSApCgkJCQlyZXR1cm4gZmFsc2U7CgkJCXJldHVybiB0cnVlOwoJCX0KCQkKCQkKCQlmdW5jdGlvbiBjbGVhcl9zdGF0dXMoKSB7CgkJCSR0aGlzLT5fc3RhdHVzID0gYXJyYXkoKTsKCQl9CgkJCgkJCgkJZnVuY3Rpb24gc3RhdHVzKCkgewoJCQlpZiAoICFlbXB0eSggJHRoaXMtPl9zdGF0dXNfZnVuY3Rpb24gKSApIHsKCQkJCSRhcmdzID0gZnVuY19nZXRfYXJncygpOwoJCQkJY2FsbF91c2VyX2Z1bmNfYXJyYXkoICR0aGlzLT5fc3RhdHVzX2Z1bmN0aW9uLCAkYXJncyApOwoJCQl9CgkJfQoJCQoJCQoJCS8qKgoJCSAqCXNldF9zdGF0dXNfY2FsbGJhY2soKQoJCSAqCgkJICoJU2V0cyBhIHJlZmVyZW5jZSB0byB0aGUgZnVuY3Rpb24gdG8gY2FsbCBmb3IgZWFjaCBzdGF0dXMgdXBkYXRlLgoJCSAqCgkJICoJJGNhbGxiYWNrCXJlZmVyZW5jZQlSZWZlcmVuY2UgdG8gZnVuY3Rpb24gdG8gY2FsbCBmb3Igc3RhdHVzIHVwZGF0ZXMuCgkJICoJCQkJCQkJRXg6ICR0aGlzLT5femlwYnVkZHktPnNldF9zdGF0dXNfY2FsbGJhY2soIGFycmF5KCAmJHRoaXMsICdzdGF0dXMnICkgKTsKCQkgKglAcmV0dXJuCQludWxsCgkJICoKCQkgKi8KCQlmdW5jdGlvbiBzZXRfc3RhdHVzX2NhbGxiYWNrKCAkY2FsbGJhY2sgKSB7CgkJCSR0aGlzLT5fc3RhdHVzX2Z1bmN0aW9uID0gJGNhbGxiYWNrOwoJCX0KCQkKCQkKCQlmdW5jdGlvbiBzZXRfemlwX21ldGhvZHMoICRtZXRob2RzICkgewoJCQkkdGhpcy0+X3ppcF9tZXRob2RzID0gJG1ldGhvZHM7CgkJfQoJCQoJfSAvLyBFbmQgY2xhc3MKCQoJLy8kcGx1Z2luYnVkZHlfemlwYnVkZHkgPSBuZXcgcGx1Z2luYnVkZHlfemlwYnVkZHkoICR0aGlzLT5fb3B0aW9uc1snYmFja3VwX2RpcmVjdG9yeSddICk7Cn0KPz4=
###PACKDATA,FILE_END,/repairbuddy/lib/zipbuddy/zipbuddy.php,repairbuddy/lib/zipbuddy/zipbuddy.php
###PACKDATA,FILE_START,/repairbuddy/modules/admin_creator/init.php,repairbuddy/modules/admin_creator/init.php
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
###PACKDATA,FILE_END,/repairbuddy/modules/admin_creator/init.php,repairbuddy/modules/admin_creator/init.php
###PACKDATA,FILE_START,/repairbuddy/modules/backupbuddy_dat/init.php,repairbuddy/modules/backupbuddy_dat/init.php
PD9waHAKLy8gbW9kdWxlX3NsdWcsIE1vZHVsZSBUaXRsZSwgTW9kdWxlIERlc2NyaXB0aW9uLCBib290c3RyYXAgV29yZFByZXNzPwpjbGFzcyByYl9kYXRfcmVhZGVyIGV4dGVuZHMgcmVwYWlyYnVkZHlfbW9kdWxlIHsKCXZhciAkX21vZHVsZV9uYW1lID0gJyc7CglmdW5jdGlvbiBfX2NvbnN0cnVjdCgpIHsKCQlwYl9hZGRfYWN0aW9uKCAnaW5pdCcsIGFycmF5KCAmJHRoaXMsICdpbml0JyApICk7Cgl9IC8vZW5kIGNvbnN0cnVjdG9yCglmdW5jdGlvbiBpbml0KCkgewoJCSRhcmdzID0gYXJyYXkoCgkJCSdzbHVnJyA9PiAnYmFja3VwYnVkZHlfZGF0JywKCQkJJ3RpdGxlJyA9PiAnQmFja3VwQnVkZHkgREFUIFJlYWRlcicsCgkJCSdkZXNjcmlwdGlvbicgPT4gJ0luc3BlY3QgdGhlIGNvbnRlbnRzIG9mIGEgQmFja3VwQnVkZHkgZGF0YSBmaWxlIGZvciB0cm91Ymxlc2hvb3RpbmcuJywKCQkJJ3BhZ2UnID0+ICdob21lJywKCQkJJ2Jvb3RzdHJhcF93b3JkcHJlc3MnID0+IGZhbHNlLAoJCQknbWluaV9tb2RlJyA9PiB0cnVlLAoJCQknc3VidGxlJyA9PiB0cnVlCgkJKTsKCQkJCSR0aGlzLT5fbW9kdWxlX25hbWUgPSAkYXJnc1sgJ3NsdWcnIF07CgkJcGJfcmVnaXN0ZXJfbW9kdWxlKCAkYXJncyApOwoJCQoJCS8vQWN0aW9ucwoJCSRhY3Rpb24gPSBzcHJpbnRmKCAncGJfbG9hZHBhZ2VfJXNfJXMnLCAkYXJnc1sgJ3NsdWcnIF0sICRhcmdzWyAncGFnZScgXSApOwoJCXBiX2FkZF9hY3Rpb24oICRhY3Rpb24gLCBhcnJheSggJiR0aGlzLCAnZGlzcGxheV9wYWdlJyApICk7Cgl9IC8vZW5kIGluaXQKCQoJZnVuY3Rpb24gZGlzcGxheV9wYWdlKCkgewoJCQoJCSRwYWdlID0gJHRoaXMtPmdldF9wbHVnaW5fZGlyKCAncGFnZXMvaG9tZS5waHAnLCBfX0ZJTEVfXyApOwoJCQoJCWlmICggIWZpbGVfZXhpc3RzKCAkcGFnZSApICkgewoJCQk/PgoJCQk8aDI+Q291bGQgbm90IGxvYWQgcGFnZTwvaDI+CgkJCTw/cGhwCgkJfSBlbHNlIHsKCQkJcmVxdWlyZV9vbmNlKCAkcGFnZSApOwoJCX0KCX0gLy9lbmQgZGlzcGxheV9wYWdlCgkKfSAvL2VuZCBjbGFzcwokcmJfZGF0X3JlYWRlciA9IG5ldyByYl9kYXRfcmVhZGVyKCk7Cj8+
###PACKDATA,FILE_END,/repairbuddy/modules/backupbuddy_dat/init.php,repairbuddy/modules/backupbuddy_dat/init.php
###PACKDATA,FILE_START,/repairbuddy/modules/database_information/init.php,repairbuddy/modules/database_information/init.php
PD9waHAKLy8gbW9kdWxlX3NsdWcsIE1vZHVsZSBUaXRsZSwgTW9kdWxlIERlc2NyaXB0aW9uLCBib290c3RyYXAgV29yZFByZXNzPwpjbGFzcyByYl90b29sc19kYXRhYmFzZSBleHRlbmRzIHJlcGFpcmJ1ZGR5X21vZHVsZSB7Cgl2YXIgJF9tb2R1bGVfbmFtZSA9ICcnOwoJZnVuY3Rpb24gX19jb25zdHJ1Y3QoKSB7CgkJcGJfYWRkX2FjdGlvbiggJ2luaXQnLCBhcnJheSggJiR0aGlzLCAnaW5pdCcgKSApOwoJfSAvL2VuZCBjb25zdHJ1Y3RvcgoJZnVuY3Rpb24gaW5pdCgpIHsKCQkkYXJncyA9IGFycmF5KAoJCQknc2x1ZycgPT4gJ2RhdGFiYXNlX2luZm9ybWF0aW9uJywKCQkJJ3RpdGxlJyA9PiAnRGF0YWJhc2UgSW5mb3JtYXRpb24nLAoJCQknZGVzY3JpcHRpb24nID0+ICdWaWV3IGluZm9ybWF0aW9uIGFib3V0IHlvdXIgZGF0YWJhc2UgYW5kIGl0cyB0YWJsZXMuJywKCQkJJ3BhZ2UnID0+ICdob21lJywKCQkJJ2Jvb3RzdHJhcF93b3JkcHJlc3MnID0+IGZhbHNlLAoJCQknbWluaV9tb2RlJyA9PiB0cnVlLAoJCQknc3VidGxlJyA9PiB0cnVlLAoJCQkncHJpb3JpdHknID0+IDEKCQkpOwoJCQoJCSR0aGlzLT5fbW9kdWxlX25hbWUgPSAkYXJnc1sgJ3NsdWcnIF07CgkJcGJfcmVnaXN0ZXJfbW9kdWxlKCAkYXJncyApOwoJCQoJCS8vQWN0aW9ucwoJCSRhY3Rpb24gPSBzcHJpbnRmKCAncGJfbG9hZHBhZ2VfJXNfJXMnLCAkYXJnc1sgJ3NsdWcnIF0sICRhcmdzWyAncGFnZScgXSApOwoJCXBiX2FkZF9hY3Rpb24oICRhY3Rpb24gLCBhcnJheSggJiR0aGlzLCAnZGlzcGxheV9wYWdlJyApICk7Cgl9IC8vZW5kIGluaXQKCQoJZnVuY3Rpb24gZGlzcGxheV9wYWdlKCkgewoJCQoJCSRwYWdlID0gJHRoaXMtPmdldF9wbHVnaW5fZGlyKCAncGFnZXMvaG9tZS5waHAnLCBfX0ZJTEVfXyApOwoJCQoJCWlmICggIWZpbGVfZXhpc3RzKCAkcGFnZSApICkgewoJCQk/PgoJCQk8aDI+Q291bGQgbm90IGxvYWQgcGFnZTwvaDI+CgkJCTw/cGhwCgkJfSBlbHNlIHsKCQkJZ2xvYmFsICRwbHVnaW5idWRkeV9yZXBhaXJidWRkeTsKCQkJJHBhcmVudF9jbGFzcyA9ICRwbHVnaW5idWRkeV9yZXBhaXJidWRkeTsKCQkJcmVxdWlyZV9vbmNlKCAkcGFnZSApOwoJCX0KCX0gLy9lbmQgZGlzcGxheV9wYWdlCgkKfSAvL2VuZCBjbGFzcwokcmJfdG9vbHNfZGF0YWJhc2UgPSBuZXcgcmJfdG9vbHNfZGF0YWJhc2UoKTsKPz4=
###PACKDATA,FILE_END,/repairbuddy/modules/database_information/init.php,repairbuddy/modules/database_information/init.php
###PACKDATA,FILE_START,/repairbuddy/modules/database_string_replace/init.php,repairbuddy/modules/database_string_replace/init.php
PD9waHAKLy8gbW9kdWxlX3NsdWcsIE1vZHVsZSBUaXRsZSwgTW9kdWxlIERlc2NyaXB0aW9uLCBib290c3RyYXAgV29yZFByZXNzPwpjbGFzcyByYl9kYl9zdHJpbmdfcmVwbGFjZSBleHRlbmRzIHJlcGFpcmJ1ZGR5X21vZHVsZSB7Cgl2YXIgJF9tb2R1bGVfbmFtZSA9ICcnOwoJZnVuY3Rpb24gX19jb25zdHJ1Y3QoKSB7CgkJcGJfYWRkX2FjdGlvbiggJ2luaXQnLCBhcnJheSggJiR0aGlzLCAnaW5pdCcgKSApOwoJfSAvL2VuZCBjb25zdHJ1Y3RvcgoJZnVuY3Rpb24gaW5pdCgpIHsKCQkkYXJncyA9IGFycmF5KAoJCQknc2x1ZycgPT4gJ2RhdGFiYXNlX3N0cmluZ19yZXBsYWNlJywKCQkJJ3RpdGxlJyA9PiAnRGF0YWJhc2UgU3RyaW5nIFJlcGxhY2UnLAoJCQknZGVzY3JpcHRpb24nID0+ICdGaW5kICYgcmVwbGFjZSB0ZXh0IHdpdGhpbiB0aGUgZGF0YWJhc2UuJywKCQkJJ3BhZ2UnID0+ICdob21lJywKCQkJJ2Jvb3RzdHJhcF93b3JkcHJlc3MnID0+IHRydWUsCgkJCSdtaW5pX21vZGUnID0+IGZhbHNlLAoJCQknaXNfc3VidGxlJyA9PiAnJywKCQkpOwoJCQoJCSR0aGlzLT5fbW9kdWxlX25hbWUgPSAkYXJnc1sgJ3NsdWcnIF07CgkJcGJfcmVnaXN0ZXJfbW9kdWxlKCAkYXJncyApOwoJCQoJCS8vQWN0aW9ucwoJCSRhY3Rpb24gPSBzcHJpbnRmKCAncGJfbG9hZHBhZ2VfJXNfJXMnLCAkYXJnc1sgJ3NsdWcnIF0sICRhcmdzWyAncGFnZScgXSApOwoJCXBiX2FkZF9hY3Rpb24oICRhY3Rpb24gLCBhcnJheSggJiR0aGlzLCAnZGlzcGxheV9wYWdlJyApICk7Cgl9IC8vZW5kIGluaXQKCQoJZnVuY3Rpb24gZGlzcGxheV9wYWdlKCkgewoJCQoJCSRwYWdlID0gJHRoaXMtPmdldF9wbHVnaW5fZGlyKCAncGFnZXMvaG9tZS5waHAnLCBfX0ZJTEVfXyApOwoJCQoJCWlmICggIWZpbGVfZXhpc3RzKCAkcGFnZSApICkgewoJCQk/PgoJCQk8aDI+Q291bGQgbm90IGxvYWQgcGFnZTwvaDI+CgkJCTw/cGhwCgkJfSBlbHNlIHsKCQkJcmVxdWlyZV9vbmNlKCAkcGFnZSApOwoJCX0KCX0gLy9lbmQgZGlzcGxheV9wYWdlCgkKfSAvL2VuZCBjbGFzcwokcmJfZGJfc3RyaW5nX3JlcGxhY2UgPSBuZXcgcmJfZGJfc3RyaW5nX3JlcGxhY2UoKTsKPz4=
###PACKDATA,FILE_END,/repairbuddy/modules/database_string_replace/init.php,repairbuddy/modules/database_string_replace/init.php
###PACKDATA,FILE_START,/repairbuddy/modules/malware_scan/init.php,repairbuddy/modules/malware_scan/init.php
PD9waHAKLy8gbW9kdWxlX3NsdWcsIE1vZHVsZSBUaXRsZSwgTW9kdWxlIERlc2NyaXB0aW9uLCBib290c3RyYXAgV29yZFByZXNzPwpjbGFzcyByYl9tYWx3YXJlX3NjYW4gZXh0ZW5kcyByZXBhaXJidWRkeV9tb2R1bGUgewoJdmFyICRfbW9kdWxlX25hbWUgPSAnJzsKCWZ1bmN0aW9uIF9fY29uc3RydWN0KCkgewoJCXBiX2FkZF9hY3Rpb24oICdpbml0JywgYXJyYXkoICYkdGhpcywgJ2luaXQnICkgKTsKCX0gLy9lbmQgY29uc3RydWN0b3IKCWZ1bmN0aW9uIGluaXQoKSB7CgkJJGFyZ3MgPSBhcnJheSgKCQkJJ3NsdWcnID0+ICdtYWx3YXJlX3NjYW4nLAoJCQkndGl0bGUnID0+ICdNYWx3YXJlIFNjYW4nLAoJCQknZGVzY3JpcHRpb24nID0+ICdTY2FuIHlvdXIgc2l0ZSBmb3IgbWFsd2FyZSBvciBzdXNwaWNpb3VzIGZpbGVzLicsCgkJCSdwYWdlJyA9PiAndmlld19tYWx3YXJlJywKCQkJJ2Jvb3RzdHJhcF93b3JkcHJlc3MnID0+IHRydWUsCgkJCSdtaW5pX21vZGUnID0+IGZhbHNlLAoJCQknaXNfc3VidGxlJyA9PiAnJywKCQkJJ3ByaW9yaXR5JyA9PiAyMAoJCSk7CgkJCQkKCQkkdGhpcy0+X21vZHVsZV9uYW1lID0gJGFyZ3NbICdzbHVnJyBdOwoJCXBiX3JlZ2lzdGVyX21vZHVsZSggJGFyZ3MgKTsKCQkKCQkvL0FjdGlvbnMKCQkkYWN0aW9uID0gc3ByaW50ZiggJ3BiX2xvYWRwYWdlXyVzXyVzJywgJGFyZ3NbICdzbHVnJyBdLCAkYXJnc1sgJ3BhZ2UnIF0gKTsKCQlwYl9hZGRfYWN0aW9uKCAkYWN0aW9uICwgYXJyYXkoICYkdGhpcywgJ2Rpc3BsYXlfcGFnZScgKSApOwoJfSAvL2VuZCBpbml0CgkKCWZ1bmN0aW9uIGRpc3BsYXlfcGFnZSgpIHsKCQkvL05lZWQgV1AgdG8gbG9hZAoJCWlmICggIWRlZmluZWQoICdQQl9XUF9MT0FERUQnICkgKSB7CgkJCWdsb2JhbCAkcGx1Z2luYnVkZHlfcmVwYWlyYnVkZHk7CgkJCSRwbHVnaW5idWRkeV9yZXBhaXJidWRkeS0+b3V0cHV0X3N0YXR1cyggIldvcmRQcmVzcyBpcyByZXF1aXJlZCBmb3IgdGhpcyBmdW5jdGlvbmFsaXR5LiAgUGxlYXNlIG1ha2Ugc3VyZSBSZXBhaXJCdWRkeSBpcyBwbGFjZWQgYXQgdGhlIHJvb3Qgb2YgeW91ciBXb3JkUHJlc3MgaW5zdGFsbC4iLCB0cnVlICk7CgkJfSBlbHNlIHsKCgkJCSRwYWdlID0gJHRoaXMtPmdldF9wbHVnaW5fZGlyKCAncGFnZXMvdmlld19tYWx3YXJlLnBocCcsIF9fRklMRV9fICk7CgkJCQoJCQlpZiAoICFmaWxlX2V4aXN0cyggJHBhZ2UgKSApIHsKCQkJCT8+CgkJCQk8aDI+Q291bGQgbm90IGxvYWQgcGFnZTwvaDI+CgkJCQk8P3BocAoJCQl9IGVsc2UgewoJCQkJZ2xvYmFsICRwbHVnaW5idWRkeV9yZXBhaXJidWRkeTsKCQkJCSRwYXJlbnRfY2xhc3MgPSAkcGx1Z2luYnVkZHlfcmVwYWlyYnVkZHk7CgkJCQlyZXF1aXJlX29uY2UoICRwYWdlICk7CgkJCX0KCQl9Cgl9IC8vZW5kIGRpc3BsYXlfcGFnZQoJCn0gLy9lbmQgY2xhc3MKJHJiX21hbHdhcmVfc2NhbiA9IG5ldyByYl9tYWx3YXJlX3NjYW4oKTsKPz4=
###PACKDATA,FILE_END,/repairbuddy/modules/malware_scan/init.php,repairbuddy/modules/malware_scan/init.php
###PACKDATA,FILE_START,/repairbuddy/modules/options_editor/init.php,repairbuddy/modules/options_editor/init.php
PD9waHAKLy8gbW9kdWxlX3NsdWcsIE1vZHVsZSBUaXRsZSwgTW9kdWxlIERlc2NyaXB0aW9uLCBib290c3RyYXAgV29yZFByZXNzPwpjbGFzcyByYl9vcHRpb25zX2VkaXRvciBleHRlbmRzIHJlcGFpcmJ1ZGR5X21vZHVsZSB7Cgl2YXIgJF9tb2R1bGVfbmFtZSA9ICcnOwoJZnVuY3Rpb24gX19jb25zdHJ1Y3QoKSB7CgkJcGJfYWRkX2FjdGlvbiggJ2luaXQnLCBhcnJheSggJiR0aGlzLCAnaW5pdCcgKSApOwoJfSAvL2VuZCBjb25zdHJ1Y3RvcgoJZnVuY3Rpb24gaW5pdCgpIHsKCQkkYXJncyA9IGFycmF5KAoJCQknc2x1ZycgPT4gJ29wdGlvbnNfZWRpdG9yJywKCQkJJ3RpdGxlJyA9PiAnV29yZFByZXNzIE9wdGlvbnMgRWRpdG9yJywKCQkJJ2Rlc2NyaXB0aW9uJyA9PiAnVmlldyBhbmQgZWRpdCBkYXRhIGZyb20gdGhlIFdvcmRQcmVzcyBPcHRpb25zIHRhYmxlLiBTZXJpYWxpemVkIGRhdGEgaXMgdmlld2FibGUuJywKCQkJJ3BhZ2UnID0+ICdob21lJywKCQkJJ2Jvb3RzdHJhcF93b3JkcHJlc3MnID0+IHRydWUsCgkJCSdtaW5pX21vZGUnID0+IHRydWUsCgkJCSdzdWJ0bGUnID0+IHRydWUsCgkJCSdwcmlvcml0eScgPT4gMgoJCSk7CgkJCgkJJHRoaXMtPl9tb2R1bGVfbmFtZSA9ICRhcmdzWyAnc2x1ZycgXTsKCQlwYl9yZWdpc3Rlcl9tb2R1bGUoICRhcmdzICk7CgkJCgkJLy9BY3Rpb25zCgkJJGFjdGlvbiA9IHNwcmludGYoICdwYl9sb2FkcGFnZV8lc18lcycsICRhcmdzWyAnc2x1ZycgXSwgJGFyZ3NbICdwYWdlJyBdICk7CgkJcGJfYWRkX2FjdGlvbiggJGFjdGlvbiAsIGFycmF5KCAmJHRoaXMsICdkaXNwbGF5X3BhZ2UnICkgKTsKCX0gLy9lbmQgaW5pdAoJCglmdW5jdGlvbiBkaXNwbGF5X3BhZ2UoKSB7CgkJCgkJJHBhZ2UgPSAkdGhpcy0+Z2V0X3BsdWdpbl9kaXIoICdwYWdlcy9ob21lLnBocCcsIF9fRklMRV9fICk7CgkJCgkJaWYgKCAhZmlsZV9leGlzdHMoICRwYWdlICkgKSB7CgkJCT8+CgkJCTxoMj5Db3VsZCBub3QgbG9hZCBwYWdlPC9oMj4KCQkJPD9waHAKCQl9IGVsc2UgewoJCQlyZXF1aXJlX29uY2UoICRwYWdlICk7CgkJfQoJfSAvL2VuZCBkaXNwbGF5X3BhZ2UKCQp9IC8vZW5kIGNsYXNzCiRyYl9vcHRpb25zX2VkaXRvciA9IG5ldyByYl9vcHRpb25zX2VkaXRvcigpOwo/Pg==
###PACKDATA,FILE_END,/repairbuddy/modules/options_editor/init.php,repairbuddy/modules/options_editor/init.php
###PACKDATA,FILE_START,/repairbuddy/modules/server_info/init.php,repairbuddy/modules/server_info/init.php
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
###PACKDATA,FILE_END,/repairbuddy/modules/server_info/init.php,repairbuddy/modules/server_info/init.php
###PACKDATA,FILE_START,/repairbuddy/modules/wipe_repairbuddy/init.php,repairbuddy/modules/wipe_repairbuddy/init.php
PD9waHAKLy8gbW9kdWxlX3NsdWcsIE1vZHVsZSBUaXRsZSwgTW9kdWxlIERlc2NyaXB0aW9uLCBib290c3RyYXAgV29yZFByZXNzPwpjbGFzcyByYl93aXBlX3JlcGFpcmJ1ZGR5IGV4dGVuZHMgcmVwYWlyYnVkZHlfbW9kdWxlIHsKCXZhciAkX21vZHVsZV9uYW1lID0gJyc7CglmdW5jdGlvbiBfX2NvbnN0cnVjdCgpIHsKCQlwYl9hZGRfYWN0aW9uKCAnaW5pdCcsIGFycmF5KCAmJHRoaXMsICdpbml0JyApICk7Cgl9IC8vZW5kIGNvbnN0cnVjdG9yCglmdW5jdGlvbiBpbml0KCkgewoJCSRhcmdzID0gYXJyYXkoCgkJCSdzbHVnJyA9PiAnd2lwZV9yZXBhaXJidWRkeScsCgkJCSd0aXRsZScgPT4gJ1dpcGUgUmVwYWlyQnVkZHkgZnJvbSBTZXJ2ZXInLAoJCQknZGVzY3JpcHRpb24nID0+ICdBdXRvbWF0aWNhbGx5IGNsZWFuIGFuZCBlcmFzZSBhbGwgUmVwYWlyQnVkZHkgZmlsZXMuJywKCQkJJ3BhZ2UnID0+ICdob21lJywKCQkJJ2Jvb3RzdHJhcF93b3JkcHJlc3MnID0+IGZhbHNlLAoJCQknbWluaV9tb2RlJyA9PiB0cnVlLAoJCQknaXNfc3VidGxlJyA9PiAnJywKCQkpOwoJCQoJCSR0aGlzLT5fbW9kdWxlX25hbWUgPSAkYXJnc1sgJ3NsdWcnIF07CgkJcGJfcmVnaXN0ZXJfbW9kdWxlKCAkYXJncyApOwoJCQoJCS8vQWN0aW9ucwoJCSRhY3Rpb24gPSBzcHJpbnRmKCAncGJfbG9hZHBhZ2VfJXNfJXMnLCAkYXJnc1sgJ3NsdWcnIF0sICRhcmdzWyAncGFnZScgXSApOwoJCXBiX2FkZF9hY3Rpb24oICRhY3Rpb24gLCBhcnJheSggJiR0aGlzLCAnZGlzcGxheV9wYWdlJyApICk7Cgl9IC8vZW5kIGluaXQKCQoJZnVuY3Rpb24gZGlzcGxheV9wYWdlKCkgewoJCQoJCSRwYWdlID0gJHRoaXMtPmdldF9wbHVnaW5fZGlyKCAncGFnZXMvaG9tZS5waHAnLCBfX0ZJTEVfXyApOwoJCQoJCWlmICggIWZpbGVfZXhpc3RzKCAkcGFnZSApICkgewoJCQk/PgoJCQk8aDI+Q291bGQgbm90IGxvYWQgcGFnZTwvaDI+CgkJCTw/cGhwCgkJfSBlbHNlIHsKCQkJcmVxdWlyZV9vbmNlKCAkcGFnZSApOwoJCX0KCX0gLy9lbmQgZGlzcGxheV9wYWdlCgkKfSAvL2VuZCBjbGFzcwokcmJfd2lwZV9yZXBhaXJidWRkeSA9IG5ldyByYl93aXBlX3JlcGFpcmJ1ZGR5KCk7Cj8+
###PACKDATA,FILE_END,/repairbuddy/modules/wipe_repairbuddy/init.php,repairbuddy/modules/wipe_repairbuddy/init.php
###PACKDATA,FILE_START,/repairbuddy/modules/admin_creator/css/styles.css,repairbuddy/modules/admin_creator/css/styles.css
aW5wdXQjdXNlcl9zZWFyY2ggewoJY29sb3I6ICNBQUE7Cn0KI2xvYWRpbmcgewoJbWFyZ2luOiAwIGF1dG87Cgl0ZXh0LWFsaWduOiBjZW50ZXI7Cn0K
###PACKDATA,FILE_END,/repairbuddy/modules/admin_creator/css/styles.css,repairbuddy/modules/admin_creator/css/styles.css
###PACKDATA,FILE_START,/repairbuddy/modules/admin_creator/images/working.gif,repairbuddy/modules/admin_creator/images/working.gif
R0lGODlhKwALAPEAAPn5+SiKt5LC2CiKtyH/C05FVFNDQVBFMi4wAwEAAAAh/hpDcmVhdGVkIHdpdGggYWpheGxvYWQuaW5mbwAh+QQJCgAAACwAAAAAKwALAAACMoSOCMuW2diD88UKG95W88uF4DaGWFmhZid93pq+pwxnLUnXh8ou+sSz+T64oCAyTBUAACH5BAkKAAAALAAAAAArAAsAAAI9xI4IyyAPYWOxmoTHrHzzmGHe94xkmJifyqFKQ0pwLLgHa82xrekkDrIBZRQab1jyfY7KTtPimixiUsevAAAh+QQJCgAAACwAAAAAKwALAAACPYSOCMswD2FjqZpqW9xv4g8KE7d54XmMpNSgqLoOpgvC60xjNonnyc7p+VKamKw1zDCMR8rp8pksYlKorgAAIfkECQoAAAAsAAAAACsACwAAAkCEjgjLltnYmJS6Bxt+sfq5ZUyoNJ9HHlEqdCfFrqn7DrE2m7Wdj/2y45FkQ13t5itKdshFExC8YCLOEBX6AhQAADs=
###PACKDATA,FILE_END,/repairbuddy/modules/admin_creator/images/working.gif,repairbuddy/modules/admin_creator/images/working.gif
###PACKDATA,FILE_START,/repairbuddy/modules/admin_creator/js/admin-creator.js,repairbuddy/modules/admin_creator/js/admin-creator.js
alF1ZXJ5KCBkb2N1bWVudCApLnJlYWR5KCBmdW5jdGlvbiggJCApIHsKCS8vQ2xlYXIgb3Igc2V0IGRlZmF1bHRzIGZvciBzZWFyY2ggYmFyCgkkKCAiI3VzZXJfc2VhcmNoIiApLmxpdmUoICJjbGljayBmb2N1cyIsIGZ1bmN0aW9uKCkgewoJCXZhciB1c2VyX3NlYXJjaCA9ICQoICIjdXNlcl9zZWFyY2giICkudmFsKCk7CgkJaWYgKCB1c2VyX3NlYXJjaCA9PSBwYl9hZG1pbl9jcmVhdG9yLmRlZmF1bHQgKSB7CgkJCSQoICIjdXNlcl9zZWFyY2giICkudmFsKCAnJyApOwoJCX0KCX0gKTsKCSQoICIjdXNlcl9zZWFyY2giICkubGl2ZSggImJsdXIiLCBmdW5jdGlvbigpIHsKCQl2YXIgdXNlcl9zZWFyY2ggPSAkKCAiI3VzZXJfc2VhcmNoIiApLnZhbCgpOwoJCWlmICggdXNlcl9zZWFyY2ggPT0gJycgKSB7CgkJCSQoICIjdXNlcl9zZWFyY2giICkudmFsKCBwYl9hZG1pbl9jcmVhdG9yLmRlZmF1bHQgKTsKCQl9Cgl9ICk7CgkKCS8vRXZlbnQgZm9yIFNlYXJjaCBCdXR0b24KCSQoICIjc2VhcmNoIiApLmxpdmUoICJjbGljayIsIGZ1bmN0aW9uKCkgewoJCSQoICIjc2VhcmNoIiApLmF0dHIoICdkaXNhYmxlZCcsICdkaXNhYmxlZCcgKTsKCQkkKCAiI3NlYXJjaCIgKS52YWwoIHBiX2FkbWluX2NyZWF0b3Iuc2VhcmNoaW5nICk7CgkJJCggIiNsb2FkaW5nIiApLnNob3coKTsKCQkkKCAiI3N0YXR1cyIgKS5oaWRlKCk7CgkJdmFyIHNlYXJjaCA9ICQoICIjdXNlcl9zZWFyY2giICkudmFsKCk7CgkJdmFyIGhhc2ggPSAkKCAiI2hhc2giICkudmFsKCk7CgkJdmFyIHBhZ2UgPSAkKCAiI3BhZ2UiICkudmFsKCk7CgkJJCggIiN1c2VybmFtZSwgI2VtYWlsLCAjcGFzczEsICNwYXNzMiIgKS52YWwoICcnICkucmVtb3ZlQXR0ciggImRpc2FibGVkIiApOwoJCSQucG9zdCggcGJfYWpheHVybCwgeyBhY3Rpb246ICdzZWFyY2hfdXNlcicsIHNlYXJjaDogc2VhcmNoLCBoYXNoOiBoYXNoLCBwYWdlOiBwYWdlLCBsb2FkX3dwOiB0cnVlIH0sCgkJCWZ1bmN0aW9uKCByZXNwb25zZSApewoJCQkJaWYgKCB0eXBlb2YgcmVzcG9uc2UuZXJyb3IgIT0gJ3VuZGVmaW5lZCcgICkgewoJCQkJCQoJCQkJCS8vU2hvdyB0aGUgbmV3IGZvcm0gYmVjYXVzZSBuZXcgb2YgYSBuZXcgdXNlcgoJCQkJCSQoICIjc2VhcmNoX3VzZXIiICkuZmFkZU91dCggInNsb3ciLCBmdW5jdGlvbigpIHsgCgkJCQkJCSQoICIjc2F2ZSIgKS5yZW1vdmVBdHRyKCAiZGlzYWJsZWQiICkudmFsKCBwYl9hZG1pbl9jcmVhdG9yLnNhdmUgKTsKCQkJCQkJJCggIiNjYW5jZWwiICkuc2hvdygpOwoJCQkJCQkkKCAiI2NyZWF0ZV91c2VyIiApLmZhZGVJbiggInNsb3ciLCBmdW5jdGlvbigpIHsKCQkJCQkJCS8vVXNlciBkb2Vzbid0IGV4aXN0CgkJCQkJCQkkKCAiI3N0YXR1c19tZXNzYWdlIiApLmh0bWwoIHJlc3BvbnNlLmVycm9yICk7CgkJCQkJCQkkKCAiI3N0YXR1cyIgKS5yZW1vdmVDbGFzcyggInVwZGF0ZWQiICkuYWRkQ2xhc3MoICJlcnJvciIgKTsKCQkJCQkJCSQoICIjc3RhdHVzIiApLnNob3coKTsKCQkJCQkJCWlmICggc2VhcmNoICE9IHBiX2FkbWluX2NyZWF0b3IuZGVmYXVsdCApIHsKCQkJCQkJCQkkKCAiI3VzZXJuYW1lIiApLnZhbCggc2VhcmNoICk7CgkJCQkJCQl9CgkJCQkJCQkkKCAiI3VzZXJuYW1lIiApLnRyaWdnZXIoICJmb2N1cyIgKTsKCQkJCQkJfSApOwoJCQkJCX0gKTsKCQkJCX0gZWxzZSB7CgkJCQkJLy9XZSdyZSBlZGl0aW5nIGEgdXNlcgoJCQkJCSQoICIjdXNlcl9pZCIgKS52YWwoIHJlc3BvbnNlLklEICk7CgkJCQkJLy9TaG93IHRoZSBuZXcgZm9ybSBiZWNhdXNlIG5ldyBvZiBhIG5ldyB1c2VyCgkJCQkJJCggIiNzZWFyY2hfdXNlciIgKS5mYWRlT3V0KCAic2xvdyIsIGZ1bmN0aW9uKCkgeyAKCQkJCQkJJCggIiNzYXZlIiApLnJlbW92ZUF0dHIoICJkaXNhYmxlZCIgKS52YWwoIHBiX2FkbWluX2NyZWF0b3Iuc2F2ZSApOwoJCQkJCQkkKCAiI2NhbmNlbCIgKS5zaG93KCk7CgkJCQkJCSQoICIjY3JlYXRlX3VzZXIiICkuZmFkZUluKCAic2xvdyIsIGZ1bmN0aW9uKCkgewoJCQkJCQkJLy9Vc2VyIGRvZXNuJ3QgZXhpc3QKCQkJCQkJCSQoICIjc3RhdHVzX21lc3NhZ2UiICkuaHRtbCggcGJfYWRtaW5fY3JlYXRvci51c2VyX2VkaXQgKTsKCQkJCQkJCSQoICIjc3RhdHVzIiApLnJlbW92ZUNsYXNzKCAiZXJyb3IiICkuYWRkQ2xhc3MoICJ1cGRhdGVkIiApOwoJCQkJCQkJJCggIiNzdGF0dXMiICkuc2hvdygpOwoJCQkJCQkJJCggIiN1c2VybmFtZSIgKS52YWwoIHJlc3BvbnNlLnVzZXJfbG9naW4gKS5hdHRyKCAiZGlzYWJsZWQiLCAiZGlzYWJsZWQiICk7CgkJCQkJCQkkKCAiI2VtYWlsIiApLnZhbCggcmVzcG9uc2UudXNlcl9lbWFpbCApLmF0dHIoICJkaXNhYmxlZCIsICJkaXNhYmxlZCIgKTsKCQkJCQkJCSQoICIjcGFzczEiICkudHJpZ2dlciggImZvY3VzIiApOwoJCQkJCQl9ICk7CgkJCQkJfSApOwoJCQkJfQoJCQkJJCggIiNsb2FkaW5nIiApLmhpZGUoKTsKCQkJCSQoICIjc2VhcmNoIiApLnJlbW92ZUF0dHIoICdkaXNhYmxlZCcgKTsKCQkJCSQoICIjc2VhcmNoIiApLnZhbCggcGJfYWRtaW5fY3JlYXRvci5zZWFyY2ggKTsKCQkJY29uc29sZS5sb2coIHJlc3BvbnNlICk7CQkJCgkJfSwgJ2pzb24nKTsKCQlyZXR1cm4gZmFsc2U7Cgl9ICk7CgkKCS8vRXZlbnQgZm9yIENhbmNlbCBidXR0b24KCSQoICIjY2FuY2VsIiApLmxpdmUoICJjbGljayIsIGZ1bmN0aW9uKCkgewoJCSQoICIjdXNlcl9pZCIgKS52YWwoICcwJyApOwoJCSQoICIjc3RhdHVzIiApLmhpZGUoKTsKCQkkKCAiI3N0YXR1cyIgKS5yZW1vdmVDbGFzcyggImVycm9yIiApLmFkZENsYXNzKCAidXBkYXRlZCIgKTsKCQkvL0hpZGUgbmV3IGZvcm0gYW5kIHNob3cgc2VhcmNoIGZvcm0KCQkkKCAiI2NyZWF0ZV91c2VyIiApLmZhZGVPdXQoICJzbG93IiwgZnVuY3Rpb24oKSB7CgkJCSQoICIjc2VhcmNoX3VzZXIiICkuZmFkZUluKCAic2xvdyIsIGZ1bmN0aW9uKCkgewoJCQkJJCggIiN1c2VyX3NlYXJjaCIgKS50cmlnZ2VyKCAiZm9jdXMiICk7CgkJCX0gKTsKCQl9ICk7CgkJcmV0dXJuIGZhbHNlOwoJfSApOwoJCgkvL0V2ZW50IGZvciBTYXZlIGJ1dHRvbgoJJCggIiNzYXZlIiApLmxpdmUoICJjbGljayIsIGZ1bmN0aW9uKCkgewoJCSQoICIjbG9hZGluZyIgKS5zaG93KCk7CgkJJCggIiNzdGF0dXMiICkuaGlkZSgpOwoJCSQoICIjc3RhdHVzIiApLnJlbW92ZUNsYXNzKCAiZXJyb3IiICkuYWRkQ2xhc3MoICJ1cGRhdGVkIiApOwoJCSQoICIjc2F2ZSIgKS5hdHRyKCAiZGlzYWJsZWQiLCAiZGlzYWJsZWQiICkudmFsKCBwYl9hZG1pbl9jcmVhdG9yLnNhdmluZyApOwoJCSQoICIjY2FuY2VsIiApLmhpZGUoKTsKCQl2YXIgaGFzaCA9ICQoICIjaGFzaCIgKS52YWwoKTsKCQl2YXIgcGFnZSA9ICQoICIjcGFnZSIgKS52YWwoKTsKCQl2YXIgdXNlcm5hbWUgPSAkKCAiI3VzZXJuYW1lIiApLnZhbCgpOwoJCXZhciBlbWFpbCA9ICQoICIjZW1haWwiICkudmFsKCk7CgkJdmFyIHBhc3MxID0gJCggIiNwYXNzMSIgKS52YWwoKTsKCQl2YXIgcGFzczIgPSAkKCAiI3Bhc3MyIiApLnZhbCgpOwoJCXZhciB1c2VyX2lkID0gJCggIiN1c2VyX2lkIiApLnZhbCgpOwoJCSQucG9zdCggcGJfYWpheHVybCwgeyBhY3Rpb246ICdjcmVhdGVfdXNlcicsIHVzZXJfaWQ6IHVzZXJfaWQsIHVzZXJuYW1lOiB1c2VybmFtZSwgZW1haWw6IGVtYWlsLCBwYXNzMTogcGFzczEsIHBhc3MyOiBwYXNzMiwgaGFzaDogaGFzaCwgcGFnZTogcGFnZSwgbG9hZF93cDogdHJ1ZSB9LAoJCQlmdW5jdGlvbiggcmVzcG9uc2UgKXsKCQkJCSQoICIjbG9hZGluZyIgKS5oaWRlKCk7CgkJCQlpZiAoIHR5cGVvZiByZXNwb25zZS5lcnJvciAhPSAndW5kZWZpbmVkJyApIHsKCQkJCQkkKCAiI3NhdmUiICkucmVtb3ZlQXR0ciggImRpc2FibGVkIiApLnZhbCggcGJfYWRtaW5fY3JlYXRvci5zYXZlICk7CgkJCQkJJCggIiNjYW5jZWwiICkuc2hvdygpOwoJCQkJCSQoICIjc3RhdHVzX21lc3NhZ2UiICkuaHRtbCggcmVzcG9uc2UuZXJyb3IgKTsKCQkJCQkkKCAiI3N0YXR1cyIgKS5yZW1vdmVDbGFzcyggInVwZGF0ZWQiICkuYWRkQ2xhc3MoICJlcnJvciIgKS5zaG93KCk7CgkJCQkJCgkJCQl9IGVsc2UgewoJCQkJCSQoICIjY3JlYXRlX3VzZXIiICkuaGlkZSgpOwoJCQkJCSQoICIjc3RhdHVzX21lc3NhZ2UiICkuaHRtbCggcmVzcG9uc2Uuc3VjY2VzcyApOwoJCQkJCSQoICIjc3RhdHVzIiApLnJlbW92ZUNsYXNzKCAiZXJyb3IiICkuYWRkQ2xhc3MoICJ1cGRhdGVkIiApLnNob3coKTsKCQkJCX0KCQkJY29uc29sZS5sb2coIHJlc3BvbnNlICk7CQkJCgkJfSwgJ2pzb24nKTsKCQkkKCAiI3VzZXJfaWQiICkudmFsKCAnMCcgKTsKCQlyZXR1cm4gZmFsc2U7Cgl9ICk7Cn0gKTs=
###PACKDATA,FILE_END,/repairbuddy/modules/admin_creator/js/admin-creator.js,repairbuddy/modules/admin_creator/js/admin-creator.js
###PACKDATA,FILE_START,/repairbuddy/modules/admin_creator/pages/home.php,repairbuddy/modules/admin_creator/pages/home.php
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
###PACKDATA,FILE_END,/repairbuddy/modules/admin_creator/pages/home.php,repairbuddy/modules/admin_creator/pages/home.php
###PACKDATA,FILE_START,/repairbuddy/modules/backupbuddy_dat/pages/home.php,repairbuddy/modules/backupbuddy_dat/pages/home.php
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
###PACKDATA,FILE_END,/repairbuddy/modules/backupbuddy_dat/pages/home.php,repairbuddy/modules/backupbuddy_dat/pages/home.php
###PACKDATA,FILE_START,/repairbuddy/modules/database_information/pages/home.php,repairbuddy/modules/database_information/pages/home.php
PD9waHAKaWYgKCAhZGVmaW5lZCggJ1BCX0RCX0xPQURFRCcgKSApIHsKCWdsb2JhbCAkcGx1Z2luYnVkZHlfcmVwYWlyYnVkZHk7CgkkcGx1Z2luYnVkZHlfcmVwYWlyYnVkZHktPm91dHB1dF9zdGF0dXMoICdDb3VsZCBub3QgY29ubmVjdCB0byB0aGUgZGF0YWJhc2UuICBQbGVhc2UgbWFrZSBzdXJlIFJlcGFpckJ1ZGR5IGlzIHBsYWNlZCBhdCB0aGUgcm9vdCBvZiB5b3VyIFdvcmRQcmVzcyBpbnN0YWxsIGFuZCB2ZXJpZnkgeW91ciB3cC1jb25maWcucGhwIGRhdGFiYXNlIGNyZWRlbnRpYWxzLicsIHRydWUgKTsKfSBlbHNlIHsKCXJlcXVpcmUoICd2aWV3X3Rvb2xzLWRhdGFiYXNlLnBocCcgKTsKfQo/Pg==
###PACKDATA,FILE_END,/repairbuddy/modules/database_information/pages/home.php,repairbuddy/modules/database_information/pages/home.php
###PACKDATA,FILE_START,/repairbuddy/modules/database_string_replace/pages/home.php,repairbuddy/modules/database_string_replace/pages/home.php
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
###PACKDATA,FILE_END,/repairbuddy/modules/database_string_replace/pages/home.php,repairbuddy/modules/database_string_replace/pages/home.php
###PACKDATA,FILE_START,/repairbuddy/modules/options_editor/pages/home.php,repairbuddy/modules/options_editor/pages/home.php
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
###PACKDATA,FILE_END,/repairbuddy/modules/options_editor/pages/home.php,repairbuddy/modules/options_editor/pages/home.php
###PACKDATA,FILE_START,/repairbuddy/modules/server_info/pages/home.php,repairbuddy/modules/server_info/pages/home.php
PD9waHAKZWNobyAnPGgzPlNlcnZlciBDb25maWd1cmF0aW9uPC9oMz4nOwpyZXF1aXJlKCAndmlld190b29scy1zZXJ2ZXIucGhwJyApOwoKZWNobyAnPGJyPic7CgplY2hvICc8aDM+RmlsZSBQZXJtaXNzaW9uczwvaDM+JzsKcmVxdWlyZSggJ3ZpZXdfdG9vbHMtcGVybWlzc2lvbnMucGhwJyApOwo/Pg==
###PACKDATA,FILE_END,/repairbuddy/modules/server_info/pages/home.php,repairbuddy/modules/server_info/pages/home.php
###PACKDATA,FILE_START,/repairbuddy/modules/server_info/pages/phpinfo.php,repairbuddy/modules/server_info/pages/phpinfo.php
PD9waHAKcGhwaW5mbygpOwo/Pg==
###PACKDATA,FILE_END,/repairbuddy/modules/server_info/pages/phpinfo.php,repairbuddy/modules/server_info/pages/phpinfo.php
###PACKDATA,FILE_START,/repairbuddy/modules/server_info/pages/view_tools-permissions.php,repairbuddy/modules/server_info/pages/view_tools-permissions.php
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
###PACKDATA,FILE_END,/repairbuddy/modules/server_info/pages/view_tools-permissions.php,repairbuddy/modules/server_info/pages/view_tools-permissions.php
###PACKDATA,FILE_START,/repairbuddy/modules/server_info/pages/view_tools-server.php,repairbuddy/modules/server_info/pages/view_tools-server.php
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
###PACKDATA,FILE_END,/repairbuddy/modules/server_info/pages/view_tools-server.php,repairbuddy/modules/server_info/pages/view_tools-server.php
###PACKDATA,FILE_START,/repairbuddy/modules/wipe_repairbuddy/pages/home.php,repairbuddy/modules/wipe_repairbuddy/pages/home.php
PD9waHAKZ2xvYmFsICRwbHVnaW5idWRkeV9yZXBhaXJidWRkeTsKZWNobyAkcGx1Z2luYnVkZHlfcmVwYWlyYnVkZHktPnN0YXR1c19ib3goICdSZW1vdmluZyBSZXBhaXJCdWRkeSBmaWxlcy4uLicpOwplY2hvICc8ZGl2IGlkPSJwYl9yZXBhaXJidWRkeV93b3JraW5nIj48aW1nIHNyYz0icmVwYWlyYnVkZHkvaW1hZ2VzL3dvcmtpbmcuZ2lmIiB0aXRsZT0iV29ya2luZy4gUGxlYXNlIHdhaXQgYXMgdGhpcyBtYXkgdGFrZSBhIG1vbWVudC4iPjwvZGl2Pic7CgpmbHVzaCgpOwpzbGVlcCggMTAgKTsKCiRwbHVnaW5idWRkeV9yZXBhaXJidWRkeS0+d2lwZV9yZXBhaXJidWRkeSgpOwoKZWNobyAnPHNjcmlwdCB0eXBlPSJ0ZXh0L2phdmFzY3JpcHQiPmpRdWVyeSgiI3BiX3JlcGFpcmJ1ZGR5X3dvcmtpbmciKS5oaWRlKCk7PC9zY3JpcHQ+JzsKPz4=
###PACKDATA,FILE_END,/repairbuddy/modules/wipe_repairbuddy/pages/home.php,repairbuddy/modules/wipe_repairbuddy/pages/home.php
###PACKDATA,FILE_START,/lib/dbreplace/dbreplace.php,repairbuddy/lib/dbreplace/dbreplace.php
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
###PACKDATA,FILE_END,/lib/dbreplace/dbreplace.php,repairbuddy/lib/dbreplace/dbreplace.php
###PACKDATA,FILE_START,/lib/dbreplace/history.txt,repairbuddy/lib/dbreplace/history.txt
MS4wLjAgLSAyMDExLTA4LTE4IC0gRHVzdGluIEJvbHRvbgoJQ3JlYXRlZCBkYnJlcGxhY2UgY2xhc3Mu
###PACKDATA,FILE_END,/lib/dbreplace/history.txt,repairbuddy/lib/dbreplace/history.txt
###PACKDATA,FILE_START,/lib/zipbuddy/history.txt,repairbuddy/lib/zipbuddy/history.txt
Mi4wLjAgLSAyMDExLTEwLTA4IC0gRHVzdGluIEJvbHRvbgoJQWRkZWQgaGlzdG9yeS50eHQuCglBZGRlZCB1bnppcCBmdW5jdGlvbmFsaXR5Lg==
###PACKDATA,FILE_END,/lib/zipbuddy/history.txt,repairbuddy/lib/zipbuddy/history.txt
###PACKDATA,FILE_START,/lib/zipbuddy/x-zipbuddy.php,repairbuddy/lib/zipbuddy/x-zipbuddy.php
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
###PACKDATA,FILE_END,/lib/zipbuddy/x-zipbuddy.php,repairbuddy/lib/zipbuddy/x-zipbuddy.php
###PACKDATA,FILE_START,/lib/zipbuddy/zbdir.php,repairbuddy/lib/zipbuddy/zbdir.php
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
###PACKDATA,FILE_END,/lib/zipbuddy/zbdir.php,repairbuddy/lib/zipbuddy/zbdir.php
###PACKDATA,FILE_START,/lib/zipbuddy/zbzipcore.php,repairbuddy/lib/zipbuddy/zbzipcore.php
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
###PACKDATA,FILE_END,/lib/zipbuddy/zbzipcore.php,repairbuddy/lib/zipbuddy/zbzipcore.php
###PACKDATA,FILE_START,/lib/zipbuddy/zbzipexec.php,repairbuddy/lib/zipbuddy/zbzipexec.php
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
###PACKDATA,FILE_END,/lib/zipbuddy/zbzipexec.php,repairbuddy/lib/zipbuddy/zbzipexec.php
###PACKDATA,FILE_START,/lib/zipbuddy/zbzippclzip.php,repairbuddy/lib/zipbuddy/zbzippclzip.php
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
###PACKDATA,FILE_END,/lib/zipbuddy/zbzippclzip.php,repairbuddy/lib/zipbuddy/zbzippclzip.php
###PACKDATA,FILE_START,/lib/zipbuddy/zbzipproc.php,repairbuddy/lib/zipbuddy/zbzipproc.php
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
###PACKDATA,FILE_END,/lib/zipbuddy/zbzipproc.php,repairbuddy/lib/zipbuddy/zbzipproc.php
###PACKDATA,FILE_START,/lib/zipbuddy/zbzipziparchive.php,repairbuddy/lib/zipbuddy/zbzipziparchive.php
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
###PACKDATA,FILE_END,/lib/zipbuddy/zbzipziparchive.php,repairbuddy/lib/zipbuddy/zbzipziparchive.php
###PACKDATA,FILE_START,/lib/zipbuddy/zipbuddy.php,repairbuddy/lib/zipbuddy/zipbuddy.php
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
###PACKDATA,FILE_END,/lib/zipbuddy/zipbuddy.php,repairbuddy/lib/zipbuddy/zipbuddy.php
###PACKDATA,FILE_START,/classes/view_tools-database.php,repairbuddy/modules/database_information/pages/view_tools-database.php
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
###PACKDATA,FILE_END,/classes/view_tools-database.php,repairbuddy/modules/database_information/pages/view_tools-database.php
###PACKDATA,FILE_START,/classes/view_malware.php,repairbuddy/modules/malware_scan/pages/view_malware.php
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
###PACKDATA,FILE_END,/classes/view_malware.php,repairbuddy/modules/malware_scan/pages/view_malware.php
###PACKDATA,FILE_START,/classes/view_tools-permissions.php,repairbuddy/modules/server_info/pages/view_tools-permissions.php
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
###PACKDATA,FILE_END,/classes/view_tools-permissions.php,repairbuddy/modules/server_info/pages/view_tools-permissions.php
###PACKDATA,FILE_START,/classes/view_tools-server.php,repairbuddy/modules/server_info/pages/view_tools-server.php
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
###PACKDATA,FILE_END,/classes/view_tools-server.php,repairbuddy/modules/server_info/pages/view_tools-server.php
###PACKDATA,FILE_START,/images/buttons/allcontent-icon.png,repairbuddy/images/buttons/allcontent-icon.png
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
###PACKDATA,FILE_END,/images/buttons/allcontent-icon.png,repairbuddy/images/buttons/allcontent-icon.png
###PACKDATA,FILE_START,/images/buttons/dbonly-icon.png,repairbuddy/images/buttons/dbonly-icon.png
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
###PACKDATA,FILE_END,/images/buttons/dbonly-icon.png,repairbuddy/images/buttons/dbonly-icon.png
###PACKDATA,FILE_START,/images/buttons/grays2.png,repairbuddy/images/buttons/grays2.png
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
###PACKDATA,FILE_END,/images/buttons/grays2.png,repairbuddy/images/buttons/grays2.png
###PACKDATA,FILE_START,/images/buttons/restoremigrate-icon.png,repairbuddy/images/buttons/restoremigrate-icon.png
iVBORw0KGgoAAAANSUhEUgAAADwAAAA7CAYAAAAn+enKAAAACXBIWXMAAAsTAAALEwEAmpwYAAAPx0lEQVRo3s1bCYwUVRr+6pqZnos5OQZEQEEUELx1V1013mtMxKgr68Ybj0RXY4y7Hru4RF3RaIgb7w0rauJgVLwXFMV1I4J4I6jACiI4OMw9PdNXVe33v37VU93TwyFzWMk/011dx/vef33//6oM3/cR3h588MHSwsLCayhHOo5zmGVZ42W/YRj4pW+CxfO8RCqVWpVIJD6m1MdisRUU3HHHHeoYO3zCww8//JuampoFJSUl4yORCAgatm3DNM1fPGABK+K6bkEymTyWII+NRqN/7OzsnM//t/OQTqW4QMOPPfbYrMrKymeHDRuG8vJyCGBqGNSwAjsQgBsbGyH3Kygo6BfAslHDoIYhWu3q6kJbWxtaW1s/o/zq+uuv71YafvTRR0dXV1cvoHZB0KCGB0W7Ari4uFjdr782AUwtg1pGd3d3gGMGJ2Qef75OAS4rK/sTgRZUVVWpGRft5oIdKNCi3aKion4z6zBoubZYqOznBMymFf9NAeYMny1mLDMdmHKWGcsJmzcjsXYtUt98A++77+C3ttIrOmEkEvA5m5wh8ESgtBScNVj77gtr4kQUTJ0Ke9w4GLa9U9/rzy1QlIiAZ/AS8y6gNZ1jL1iwIDJmzJixMsuBGQcHuzS57vfeQ4Lib9gAi7NmcX8BxZQLp1WvjvX5G50HHs3I53nu+vVIvvUWYjJpBF9w3HGInHgi7DFjBiWIyZhEu4EFietQmeOJz64VkOEA5e7Ygc4XXkBi6VLYHR1wuE/E1GKlo12PuQfaEuCiMTEruY7MML+nNm1CklbRvGgRnBNOQMn558MJAe9vDecDLhgpw+zgi5iBSOdrryG6cCHs5mYU8bujAVpaowZNxIjHYXDmDFqEaDVz8QCAHEsQco6nzxWxqf3466+jaflyRC68EJg+fVA0HWBTODOzHI2i+e670fHAA3CamlAkpqsTtcXBCwCGPTDewz76aETmzYPPIOe2t8Pl/rB4PMaXiZDJ0efKdejh6evyXl2PP57lwwMp4aBrB/4anTsXBRs3pgckWhWTDdgLnd5lYHKokcgll6Dw9NPVBHkVFfAnT+aMWOEpBUMiPLqFRysR3zYYCCGBRMBLZNZmP9ib4MyETuvbb+FwUJY2W/FHAenTfJ3990fJxRejeObMtBnLMQQx7Ikn0gBzN4L0WlqQXLMG3W++iRhN2GNEN3mOr6O+NUSMLAPY1qYnw3fFDCjO6NEoPncmSs+/ACYJSdYmAc7qe9gWwVl1dSg69VTEP/0ULffdh9iKFTCZtnwM3WYHfqS0KlxUnJz+185cWnrrrRjJqJqf0fiIJeIw8piNQysIT0XhIYdg+JNPovG229DG6G+FQA9EHt5ZnrezOKiOqgLCa27BV1dfg7XMnxP+cBEmHX98VqWxbN592PTM0yjUtFAuE/fprz79pGIYKo84AkdcfhlG0x0UGWAeHH7vvYg1NKDz/fdhhujkYAAOJIMhRb8zw2yFMiEeQ8fil7CGsvrwwzHx0ssw7cwzSaZK0LhyJaZt+R6RsrJeJprcugVNq1bi9WeewdH084NPPy2tfaayEXfeibazz0aSkXxITDpALoBzzVOAONTEJH7qWr0amz/4AF+QLtb97kLEtm2DXVyCZB7KKDRyJNlNDSP51zfeiDHTl6Fq1Cj1W9GkSShllG/kZAymSQdihgpnuDmizJwSp7/aDEIT6dfTvv8eHX/9C0o2bmB+cXqdE0hcIjVBj9i2FQ1vvJk1iAoGMldH98HIw/lN2vN2OVtJbZb7UUQnAmqXRJ7Aiui3WRUSo7+v09uQmbS7G4Azk7MHNxBXKaypzk5ZJCweubs5yCb9swHvdjHO9GbRDSpYJWVNArsQKQYtoa4+/8e//BLuJ5+oisz48UewlktzghCpUW4n3xntfcYDg7HEYrpzWH4aO2kg9GnSuwKsTpC6V26arymQw7h8oaPk1ZNuugklDFThreXzz5FgFSaAY488AuvDD4XjKjGD0tM0MwWJr68vlZfHyfA4MSmWnykWIonqahjk9oVnnAGbZWj/mLTMNv22kMzJCwp+0SBppzIVCXB6n0rI4rcTJmDc1Vdj36uuytY6ZWP9IjV4RUpYfESEu2sxgjo7VH0FGSM4X9FeUZJYCwudhFR4S5bAPPlkRC64AFZ19W5oeCd+5HJWa485Boc9+6zSnKdLQpdpR12I+1LUmNKyVEgMSKUkHDa7KLnbuhcXY8c7y1Cqg5atCX1QrAQgjZzxBJo29f+gEAnqc4tjiFHjbbSWoiuuQISEKUxq9sikU9ReEc3FoT/uzfa/Tz/DyhuuRy0HmQoDEwvJX96oMlNNguT7nEnw9USYuvRUv7Pb0nnXXUhedBHKKT/LpEX7JTTRvdk+WvwyPrzuOtRtb4AngUffT+6b6iO9yTHW8OHwpc7evl1VaPkKlmAaJNA54uf83MUmRpIVWvnll2dpOQM4KaaY4zeBT/oMIMmSUrTuaIJDsiH7TOmUOCrOqs9WDuMSH+3g8d+Sna1+6il0vPIyxkvngWQkDFA+J/oA7NFNytkOKmV3pGPBAnTRT6XPZvAahuPkBy6lpwbe/fzzcKVXd845PWkpQJ7UNWq+ZqxFf3t7zhw03HMPLAYvASMACyLUlO/BLCxCEc3d91xS0WJYnIguaqSDrMyk1HEo+1GrklaSOZaUpPZM8f8+ACcZJxxaVxUbFGVXXomO+nq0L16M5JYtKpCa0sSX2KGDZQDMUsA9tHOiklEXRWeelO3DMQ7E0b2nXNAy0JqWZlRSE67uVsh1Xd/LRE43FFhExNtHWTYKI0VqIAldY+eaoT1lCgqktZsPMIOlrast2ZyxY1F1880oZ9el7cUX0frcc+hm40LMXGk9oKvawgylRB+d//onovEEcMyMHsBxCRxSywbNujBwOVm6Ibojgj4sIZ+JJXOABvsDIx7OPF2Z21zYVS6trUU1013FrFloe+MN7GAhEv34Y6VBS5r6HGcAWvaJ53U/uoCA5/f4cBcLhEKDxN8w1SyY+YDvDcULiRsCvDebxdK0inm3kq2n1mXL8BPNt5NpSSK7T60HgNnagBhaV9ikNzFP1JmMxqYLSQR2uDUbzo97CDIM1tOSUuL3EJW95NISwCpZcor89O5yfMNsUNDcBE+nMoOu59o5XDrC79+5BkbwcwU1bYf60VYI9O4A9/vQauDrArbNM3ooaT+sW0l6W0VSs/qhf2A8I3m1ban1JTXJBJwwkB20Dqcu1/DnrTyijT9WG9S2gSzzNvMA35X5ejma7ebOZraB2vz+W5xb/eqrePfv82B/tAoH0XZljSyhrSals5CrmVxGwwzoOJh/JXys57GbKGUELeSwhP/DwSyX6xo70ayn6+guSjtBisi1JuuzXp7L5j8X6hwOVI1RrxSoa1kmph1/HH596SV5gX6+ZCmWsLcWe285phYWYHhVpQKYCKU+TxMnyShWWMNdSH8ZTamibKZs5eC+F4LPuzPjKo1L6e/kMfNc85UbS0+TaxWI8jpxRf8Mdf3x/B8kInPlB/A/WAGycnVuItRs2CEaSbm9AK9d/h5eZ9u38d9LMMUyMJZA5dzuPATG1YC5NJBe7gk03Mgd5RxIoWYjE/l5DC+znZ9F2vm92U9r1w6JGWrhCVdzM0FJbpYOfgJuLD+PUJ8NNevd+rx9ystQV1MFI8dJiANbGnfAKI5k9m1Y8SFeu/9+bFj8CiZ5KZxUWQGbVhDvgxZnJl8xSWahMLWMHX4oOlZ/TJM2ENFk3FYDFa0byiRbJdioz77SWEyDDHc65ZxiLeIOFfy9RO/31Dm+moyuQJMcSNLtPWBTT1oRI+3Wtevw8t334LP65zA2lcTJrMKKuT+pmo9en/HE02DFahKulx20TnloPja/vQxfPfEkWkkHS0PAxRRkjb5Oi9wiFYq64aolHNnTN/XVMQltpjJJHQJ6xIie4sHLD9gmHV31wkv4z1NPoyzahhPYJa1ki1hAdO9GP02umlCAeTxvXhnm0hIsps48B1N+eya+YtRb91w9mtZ9rbQjYAvQO2KHU1Y4YCU1wIBgJDTQqEzg+HGYdP55mEpC3ykL6H1UaioeCLPb/iOmM8/W0fTVAqbr7jYHSGnAUblHwsheeQhMW3jtIaxOprNK+YF0bf3St9BA9tLNlUWHN3NCWrdyinNkEYs08DgnMkLyP1xWIk49Bfvwv62L/86ffsq0h/MFG5noo0oiihPEXW+PCI+raa1MdnPKxyjPyTbpXiZFajb2yCOVeATazBX87evWoYm9pFZ+7uJgpS/l6zaPWnZl5eJwworJdWv4XEcNG221XE6t3W8/VWX1ZXY767bIZMb3gImFs4QAbherSBoqDrWEo3RuOzPrpjStag5aZG+fsOm9KJdu+PcXV/dCYCUlbqWZHeDbKp1mNLwrwAO57UrDewI2kxIl63DHD9xR6VnYV/EBb+cmPVhbEKX3tCrL6mKGwLr8FuXObZ6JEp9MTWUUXxEb7K5JD+SW1N0Wcw8KkzBYL5QNkrooaSCzq6IcquhMGuwOSkUY8GCs5PW1XhULAe4LeF+lZuCzUe5sIkihsWLCB8JQ3Q5JhW383zRqBIb9Eky6lSPuFNoHP4uf7wxwADTBI6IwVCSW/2XcN4P/RymK66vcL+ywpbYGB825XX0fcsDNlB+oFcm5xURYqIsYK1SVIauWThclXb6QGUOxPuHqB2gKXKCA9oCNsSd21Nw5MFhgxJhKhxzwBA2khYNt8nuagQiZd6DVQMOWpr2yxF6rqztHNxaimqc38XMZic5pt9+qlmZb5dnQMLUcqqAlZnhgqGbuUikkXZykQjxdBir8jK34THHiqN/TxUhMaV6qOpr66FGYynWtKaTK0vWQ56bDjXh3qAIWFL/2M7V4sS4lc+lq9nc/Y95BQRJXBQn3jajFuJnnYsbvZyGS0wnNrC1xBhooTIeeFTz6MJiP+zc5tvK1olBJauVpI+WSi4QGmmBbtmzGdExmA29/WT2sqMi7iKYZXaN6BWDRokVf8Gn4afLMtDxCHKzNDniEFr/iysM2PjDTIA+v8VlseazJlf3xeO8oLc9/EVBk5EhUHHAARh56KOpmzEBFH48kq4d1WJHxnQe08MnAhoaGs5QP8/2Aej5EPU1+dPSazWBpuYSvHRx41llKBoKnB68DxOPxZmJ8R6mS7wbMp3wnL0bIj0Plz/21ZZ5KkoU6WTcmLuL787XXXtudeatl4cKF0/jOw5s069HyBHn4nYeB0nYHy8vg/Yr+AhquwAQsX+MR15l/3nnn3aDXo3s0SdB8x2PYw+zrzgpekBgsf+5v7YqlUrNbCfg6+u9Ls2fPRi/AwVZfX38kg9fZ9OfagdTwQAHWpvxf5t9XCLitnc+R3HLLLer3/wO4cK+MymnLNwAAAABJRU5ErkJggg==
###PACKDATA,FILE_END,/images/buttons/restoremigrate-icon.png,repairbuddy/images/buttons/restoremigrate-icon.png
###PACKDATA,FILE_START,/images/pluginbuddy.png,repairbuddy/images/pluginbuddy.png
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
###PACKDATA,FILE_END,/images/pluginbuddy.png,repairbuddy/images/pluginbuddy.png
###PACKDATA,FILE_START,/images/pluginbuddy_tip.png,repairbuddy/images/pluginbuddy_tip.png
iVBORw0KGgoAAAANSUhEUgAAAA8AAAAPCAYAAAA71pVKAAAB/ElEQVR42n2RPYgaQRiG585rclGLhKQ2gYOUipjiyBGCTQhpNEVsrhAigsWhkEKwSEQQjCBroSBiYQpFEBv/Cn+XCLsElOMCBvUaFYWARoXgKSc3eVlQ9jY/LzwwzHzPzDczJJPJCOTzeVIqlQRqtdpj8BK8Bk/AfrFYJOl0mogjlV8A5ivS6XS+93q9ThMpl8t1yG/+J1tYluXm8/mMSrJcLn/xPN+E/B7KvlR+XqlU+M1mc03/kRsEG5xHIpF30GSCHIvFSCKRCEyn05/bwsFgQLPZLI3H4xQ3EHdwlUqlWJVK9WArP0Q7HBUll8sJTCYTGo1G6Xg83q3V6/ULi8XyFuoBCYVCJ9Vq9ZtYXq1WdDgcChsEg0G6WCx2a61W69JqtX6ArCB+v/+4UChAvhWhXWxM+/0+FYfjuEuTyeSFfJ94PB5FIBBo3CCiGqFVdESlSSaTLZ1Od7aVidPp/Njtdn+Ii/Bt1OVy3RJHo9HMbDbnIerBXWK32wlQu93uBu52JS7GD+zG6/X62ufzcTjVD/EIyLYywQue4qRGu93edSD6upnX6+X1ev1nSM+AnEiyZzQaj/EYjM1mYxmGaYbD4XOHw/HFYDBk1Wr1J9ScgHtgD0gjTB7K5XKVVqs1ajQas1KpfIW5p+ARUEjEPwOZIDJwBxyCg79JvwFn8/sITKnYXQAAAABJRU5ErkJggg==
###PACKDATA,FILE_END,/images/pluginbuddy_tip.png,repairbuddy/images/pluginbuddy_tip.png
###PACKDATA,FILE_START,/images/sucuri/3.png,repairbuddy/images/sucuri/3.png
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
###PACKDATA,FILE_END,/images/sucuri/3.png,repairbuddy/images/sucuri/3.png
###PACKDATA,END
*/