<?php
/**
 * The template for displaying the footer.
 *
 * Closes the <div> for #content, #content-main and #container, <body> and <html> tags.
 *
 * @package Graphene
 * @since Graphene 1.0
 */
global $graphene_settings;
?>  

<?php if ( ! graphene_has_custom_layout() ) : ?>
        <?php do_action( 'graphene_bottom_content' ); ?>
        </div><!-- #content-main -->
        
        <?php
            if ( ! $graphene_settings['mobile_left_column_first'] ) {
                /* Sidebar2 on the left side? */
                if ( in_array( graphene_column_mode(), array( 'three_col_right', 'three_col_center', 'two_col_right' ) ) ) get_sidebar( 'two' );
                
                /* Sidebar1 on the left side? */            
                if ( in_array( graphene_column_mode(), array( 'three_col_right' ) ) ) get_sidebar();
            }
            
            /* Sidebar 2 on the right side? */
            if ( graphene_column_mode() == 'three_col_left' ) get_sidebar( 'two' );
            
            /* Sidebar 1 on the right side? */
            if ( in_array( graphene_column_mode(), array( 'two_col_left', 'three_col_left', 'three_col_center' ) ) ) get_sidebar();
        ?>
        
        <?php do_action( 'graphene_after_content' ); ?>

    <?php graphene_container_wrapper( 'end' ); ?>
</div><!-- #content -->
<?php endif; ?>

<?php do_action( 'graphene_before_footer_widget_area' ); ?>

<?php /* Get the footer widget area */ ?>
<?php get_template_part( 'sidebar', 'footer' ); ?>

<?php do_action( 'graphene_before_footer' ); ?>

<div id="footer" class="row">
    <?php graphene_container_wrapper( 'start' ); ?>

        <?php 
            if ( ( stripos( $graphene_settings['social_media_location'], 'footer' ) !== false && $graphene_settings['social_profiles'] ) || has_nav_menu( 'footer-menu' ) ) :
        ?>
            
           
        </div>

        <?php do_action('graphene_footer'); ?>
        
    <?php graphene_container_wrapper( 'end' ); ?>
</div><!-- #footer -->

<?php do_action('graphene_after_footer'); ?>

</div><!-- #container -->

<?php wp_footer(); ?>
</body>
</html>