<?php
/**
 * Template part for displaying post previews.
 *
 * @package ComRepair
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'post-preview post-preview--horizontal' ); ?>>

	<?php if ( has_post_thumbnail() ) : ?>
		<a href="<?php the_permalink(); ?>">
			<div class="post-preview-image">
				<?php the_post_thumbnail( 'comrepair_preview_image' ); ?>
			</div>
		</a>
	<?php endif; ?>

	<div class="post-preview-copy-wrap">

		<?php if ( is_sticky() && is_home() ) : ?>
			<div class="post-preview-sticky-icon">
				<span class="typcn typcn-pin-outline"></span>
			</div>
		<?php endif; ?>

		<?php
		if ( 'post' === get_post_type() ) {
			comrepair_post_date( 'post-preview-date' );
		}
		?>

		<a href="<?php the_permalink(); ?>" rel="bookmark">
			<h2 class="post-preview-title"><?php the_title(); ?></h2>
			<div class="post-preview-text"><?php the_excerpt(); ?></div>
		</a>

		<footer class="post-preview-meta-wrap">

			<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
				<span class="post-preview-author">
					<?php
					/* translators: %s is an author name */
					printf( wp_kses_post( __( '<span class="screen-reader-text">An article by </span>%s', 'comrepair' ) ), esc_html( get_the_author() ) );
					?>
				</span>
			</a>

			<?php if ( $comments_number = get_comments_number() ) : ?>
				<a href="<?php comments_link(); ?>">
					<span class="post-preview-comments">
						<?php
						/* translators: %d is the number of comments */
						printf( wp_kses_post( __( '%d<span class="screen-reader-text"> comments</span>', 'comrepair' ) ), esc_html( $comments_number ) );
						?>
					</span>
				</a>
			<?php endif; ?>

			<?php
			/* translators: used between list items, there is a space after the comma */
			if ( $categories = get_the_category_list( __( ', ', 'comrepair' ) ) ) :
			?>
				<span class="post-preview-categories">
					<?php
					/* translators: %s is the list of categories */
					echo wp_kses_post( sprintf( __( '<span class="screen-reader-text">Posted in </span>%s', 'comrepair' ), $categories ) );
					?>
				</span>
			<?php endif; ?>

		</footer><!-- .post-preview-meta-wrap -->

	</div><!-- .post-preview-copy-wrap -->

</article><!-- .post-preview -->
