<?php
/**
 * Template part for displaying blog post content.
 *
 * @package ComRepair
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'entry' ); ?>>

	<header class="entry-header">

		<?php comrepair_post_date( 'entry-date' ); ?>

		<div class="entry-category">
			<?php
			/* translators: used between list items, there is a space after the comma */
			if ( $categories = get_the_category_list( __( ', ', 'comrepair' ) ) ) {
				/* translators: %s is the list of categories */
				echo wp_kses_post( sprintf( __( 'Category: %s', 'comrepair' ), $categories ) );
			}
			?>
		</div><!-- .entry-category -->

		<div class="entry-author">
			<?php
			/* translators: %s is the author name */
			echo wp_kses_post( sprintf( __( 'Posted by %s', 'comrepair' ), get_the_author_posts_link() ) );
			?>
		</div><!-- .entry-author -->

		<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>

	</header><!-- .entry-header -->

	<?php if ( has_post_thumbnail() ) : ?>
		<div class="entry-featured-image">
			<?php the_post_thumbnail( 'comrepair_featured_image' ); ?>
		</div><!-- .entry-featured-image -->
	<?php endif; ?>

	<div class="entry-content">
		<?php
		the_content();
		wp_link_pages( array(
			'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'comrepair' ),
			'after'       => '</div>',
			'link_before' => '<span class="page-number">',
			'link_after'  => '</span>',
		) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">

		<?php
		/* translators: used between list items, there is a space after the comma */
		if ( $tags = get_the_tag_list( '', __( ', ', 'comrepair' ) ) ) :
		?>
			<div class="entry-tags">
				<?php
				/* translators: %s is the list of tags */
				echo wp_kses_post( sprintf( __( 'Tags: %s', 'comrepair' ), $tags ) );
				?>
			</div><!-- .entry-tags -->
		<?php endif; ?>

		<div class="entry-share">
			<?php
			esc_html_e( 'Share this post: ', 'comrepair' );
			comrepair_post_share_links();
			?>
		</div><!-- .entry-share -->

	</footer><!-- .entry-footer -->

</article><!-- .entry -->
