<?php
/**
 * WPBakery Visual Composer plugin integration.
 *
 * @package ComRepair
 */

/**
 * Customize VC settings
 */
function comrepair_vc_before_init() {
	vc_set_as_theme();
	vc_set_default_editor_post_types( array( 'page', 'service' ) );
	add_action( 'wp_enqueue_scripts', 'comrepair_vc_deregister_scripts' );
}
add_action( 'vc_before_init', 'comrepair_vc_before_init' );

/**
 * De-register some of the default VC scripts and styles, because they are
 * already included with our theme.
 */
function comrepair_vc_deregister_scripts() {
	wp_deregister_style( 'vc_typicons' );
	wp_deregister_style( 'comrepair_vc_themify_icons' );
}

/**
 * Add additional styles for VC Backend Editor.
 */
function comrepair_add_vc_backend_editor_style() {
	wp_enqueue_style( 'comrepair-vc-editor-style', get_template_directory_uri() . '/assets/css/editor-style.css', array(), COMREPAIR_THEME_VERSION );
}
add_action( 'vc_backend_editor_enqueue_js_css', 'comrepair_add_vc_backend_editor_style' );
