( function( $ ) {
	'use strict';

	var isRtl = $( 'body' ).hasClass( 'rtl' );

	$( '.menu-toggle' ).click( function() {
		var $primaryNav = $( '.mobile-navigation' );

		if ( $primaryNav.hasClass( 'is-shown' ) ) {
			$primaryNav.stop( true, true ).slideUp( 200, function() {
				$primaryNav.removeClass( 'is-shown' ).css( 'display', '' );
			} );
		} else {
			$primaryNav.stop( true, true ).slideDown( 200, function() {
				$primaryNav.addClass( 'is-shown' ).css( 'display', '' );
			} );
		}
	} );

	// Add has-focus class to menu items parents
	$( '.primary-navigation, .secondary-navigation, .site-header-cart' ).on( 'focus.comrepair blur.comrepair', 'a', function() {
		$( this ).parents().toggleClass( 'has-focus' );
	} );

	// object-fit fallback for MS browsers. For more info see:
	//   https://medium.com/@primozcigler/neat-trick-for-css-object-fit-fallback-on-edge-and-other-browsers-afbc53bbb2c3
	if ( ! Modernizr.objectfit ) {
		$( '.js-post-image-container' ).each( function( index, element ) {
			var $element = $( element );
			var imgUrl   = $element.find( 'img' ).prop( 'src' );
			if ( imgUrl ) {
				$element.css( 'background-image', 'url(' + imgUrl + ')' ).addClass( 'compat-object-fit' );
			}
		} );
	}

	// Smooth scroll to top
	$( 'a[href="#top"]' ).on( 'click.comrepair', function() {
		$( 'html, body' ).animate( { scrollTop: 0 }, 1000 );
		return false;
	} );

	function clampValue( from, to, value ) {
		return Math.max( from, Math.min( to, value ) );
	}

	// Carousel setup
	if ( $( '.js-bt-carousel' ).length ) {
		function owlMakeItemHeightsEqual( carousel ) {
			var $carousel = $( carousel );
			var maxHeight = 0;

			$carousel.find( '.owl-item:not(.cloned)' ).height( 'auto' ).each( function() {
				maxHeight = Math.max( maxHeight, $( this ).height() );
			} );
			$carousel.find( '.owl-item' ).height( maxHeight );
		}

		$( '.js-bt-carousel' ).each( function( index, element ) {
			var $element        = $( element );
			var items           = $element.data( 'items' ) !== undefined ? $element.data( 'items' ) : 1;
			var autoplayTimeout = $element.data( 'autoplay-timeout' );
			var config          = {
				items: 1,
				center: false,
				margin: 30,
				rtl: isRtl,
				loop: true,
				nav: false,
				dots: true,
				autoplay: autoplayTimeout !== undefined,
				autoplayTimeout: autoplayTimeout,
				autoplayHoverPause: true,
				autoplaySpeed: 500,
				responsive: {
					768: {
						items: clampValue( 1, 2, items - 1 ),
					},
					970: {
						items: clampValue( 1, 3, items ),
					},
					1200: {
						items: clampValue( 1, 4, items ),
					},
				},
			};

			if ( $element.data( 'equal-heights' ) !== undefined ) {
				config.onInitialized = function( event ) {
					owlMakeItemHeightsEqual( event.target );
					setTimeout( function() {
						owlMakeItemHeightsEqual( event.target );
					}, 100 );
				};
				config.onResized = function( event ) {
					owlMakeItemHeightsEqual( event.target );
				};
				$element.imagesLoaded().progress( function( instance, image ) {
					owlMakeItemHeightsEqual( instance.elements[0] );
				} );
			}

			$element.owlCarousel( config );
		} );
	}

	// Grid setup
	if ( $( '.js-bt-grid' ).length ) {
		function delayAndThrottle( update, delayAmount ) {
			var timeoutID;
			function callUpdate() {
				timeoutID = 0;
				update();
			}
			return function delayed() {
				if ( timeoutID ) {
					clearTimeout( timeoutID );
				}
				timeoutID = setTimeout( callUpdate, delayAmount );
			};
		};

		$( '.js-bt-grid' ).each( function( index, element ) {
			var $element      = $( element );
			var $filters      = $element.find( '.bt-grid-filters-wrap' );
			var $activeFilter = $filters.find( '.is-active' );
			var container     = $element.find( '.bt-grid-items-wrap' )[0];
			var shuffle       = new window.shuffle( container, {
				itemSelector: '.bt-grid-item',
				throttle: function( resize, wait ) {
					return function() {};
				},
			} );
			var updateFunc;
			var throttledUpdateFunc;

			// Handle filtering.
			$filters.on( 'click.comrepair', '.bt-grid-filter', function( event ) {
				var $target = $( event.target );

				event.target.blur();
				if ( ! $target.hasClass( 'is-active' ) ) {
					$target.addClass( 'is-active' );
					$activeFilter.removeClass( 'is-active' );
					$activeFilter = $target;
					shuffle.filter( $target.data( 'group' ) );
				}
			} );

			if ( $element.data( 'layout-method' ) === 'masonry' ) {
				updateFunc = function() {
					shuffle.update();
				};
			} else {
				updateFunc = function() {
					var $items = $element.find( '.bt-grid-item' );
					var maxHeight = 0;

					// Make all items equal height.
					$items.height( 'auto' ).each( function() {
						maxHeight = Math.max( maxHeight, $( this ).height() );
					} );
					$items.height( maxHeight );
					shuffle.update();
				};
			}

			imagesLoaded( container ).on( 'progress', updateFunc );

			throttledUpdateFunc = delayAndThrottle( updateFunc, 100 );
			throttledUpdateFunc();
			$( window ).resize( throttledUpdateFunc );
		} );
	}

	// Statistics box counter animation
	if ( $( '.js-statistics-box' ).length ) {
		// Setup number items animation
		$( '.js-statistics-box' ).each( function() {
			$( this ).find( '.js-statistics-box-number' ).each( function( index, element ) {
				var $element   = $( element );
				var duration   = 0.5 + Math.random();
				var number     = Number( $element.text() );
				var numberAnim = new CountUp( this, 0, number < 3000 ? number : number * 0.98, 0, duration );

				$element.text( '0' );
				$element.data( 'number', number );
				$element.data( 'number-animation', numberAnim );
				$element.addClass( 'js-animate-number' );
			} );
		} );

		// Trigger the animations when statistics box enters the viewport
		$( '.js-statistics-box' ).waypoint( {
			offset: '95%',
			handler: function() {
				$( this.element ).find( '.js-animate-number' ).each( function( index, element ) {
					var $element   = $( element );
					var number     = $element.data( 'number' );
					var numberAnim = $element.data( 'number-animation' );

					$element.removeClass( 'js-animate-number' );
					$element.removeData( [ 'number', 'number-animation' ] );

					if ( numberAnim ) {
						numberAnim.start( function() {
							numberAnim.callback = null;
							numberAnim.update( number );
						} );
					}
				} );
			},
		} );
	}

} ( jQuery ) );
