/**
 * File customize-preview.js.
 *
 * Instantly live-update customizer settings in the preview for improved user experience.
 */

( function( $ ) {
	'use strict';

	// Site Branding Text visibility customization
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( 'body' ).addClass( 'hide-site-branding-text' );
			} else {
				$( 'body' ).removeClass( 'hide-site-branding-text' );
			}
		} );
	} );

	// Breadcrumbs customization
	wp.customize( 'show_breadcrumbs', function( value ) {
		if ( 'hide' === value.get() ) {
			$( '.breadcrumbs' ).css( 'display', 'none' );
		}
		value.bind( function( to ) {
			if ( 'hide' === to ) {
				$( '.breadcrumbs' ).css( 'display', 'none' );
			} else {
				$( '.breadcrumbs' ).css( 'display', '' );
			}
		} );
	} );

	// Header background color customization
	wp.customize( 'header_bg_color', function( value ) {
		value.bind( function( to ) {
			$( '.page-title-wrap' ).css( 'background-color', to );
		} );
	} );

	// Footer background color customization
	wp.customize( 'footer_bg_color', function( value ) {
		value.bind( function( to ) {
			$( '.footer-top-wrap' ).css( 'background-color', to );
		} );
	} );

	// Footer bottom background color customization
	wp.customize( 'footer_bottom_bg_color', function( value ) {
		value.bind( function( to ) {
			$( '.footer-bottom-wrap' ).css( 'background-color', to );
		} );
	} );

	// Header Info Blocks customization
	function bindHeaderInfoBlockIconClass( id ) {
		wp.customize( 'header_info_block_icon_class_' + id, function( value ) {
			value.bind( function( to ) {
				$( '.js-header-info-block-' + id + ' .header-info-block-icon' ).html( '<span class="' + to + '"></span>' );
			} );
		} );
	}

	function bindHeaderInfoBlockIconStyle( id ) {
		wp.customize( 'header_info_block_icon_style_' + id, function( value ) {
			value.bind( function( to, from ) {
				$( '.js-header-info-block-' + id + ' .header-info-block-icon' )
					.removeClass( 'header-info-block-icon--' + from )
					.addClass( 'header-info-block-icon--' + to );
			} );
		} );
	}

	// eslint-disable-next-line vars-on-top
	for ( var i = 1; i <= 3; ++i ) {
		bindHeaderInfoBlockIconClass( i );
		bindHeaderInfoBlockIconStyle( i );
	}

	// Custom colors customization
	$.each( [ 'primary_color', 'primary_color_light', 'secondary_color' ], function( index, settingId ) {
		wp.customize( settingId, function( setting ) {
			setting.bind( function( to ) {
				// Update custom color CSS.
				var style = $( '#comrepair-custom-' + settingId ),
					currentColor = style.data( 'currentColor' ),
					css = style.html();
				css = css.split( ' ' + currentColor ).join( ' ' + to );
				style.html( css ).data( 'current-color', to );
			} );
		} );
	} );

} ( jQuery ) );
