<?php
/**
 * Extensions for WPBakery Visual Composer plugin
 *
 * @package ComRepair_Plugin
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

define( 'COMREPAIR_VC_ADDON_PATH', COMREPAIR_PLUGIN_DIR_PATH . 'visual-composer/' );
define( 'COMREPAIR_VC_SHORTCODES_PATH', COMREPAIR_PLUGIN_DIR_PATH . 'visual-composer/shortcodes/' );

/**
 * Register custom VC shortcodes
 */
function comrepair_vc_map_shortcodes() {
	vc_lean_map( 'comrepair_cta',                   null, COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_cta/config.php' );
	vc_lean_map( 'comrepair_feature_box',           null, COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_feature_box/config.php' );
	vc_lean_map( 'comrepair_logo_box',              null, COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_logo_box/config.php' );
	vc_lean_map( 'comrepair_posts_feed',            null, COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_posts_feed/config.php' );
	vc_lean_map( 'comrepair_section_heading',       null, COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_section_heading/config.php' );
	vc_lean_map( 'comrepair_services_carousel',     null, COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_services_carousel/config.php' );
	vc_lean_map( 'comrepair_services_grid',         null, COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_services_grid/config.php' );
	vc_lean_map( 'comrepair_statistics_box',        null, COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_statistics_box/config.php' );
	vc_lean_map( 'comrepair_testimonials_carousel', null, COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_testimonials_carousel/config.php' );
	vc_lean_map( 'comrepair_text_image',            null, COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_text_image/config.php' );
}

if ( function_exists( 'vc_lean_map' ) ) {
	// If we can perform the mapping on this stage, then do it.
	comrepair_vc_map_shortcodes();
} else {
	// Otherwise hook to VC initializiation.
	add_action( 'vc_after_init', 'comrepair_vc_map_shortcodes' );
}

/**
 * Register image sizes that are used in our custom shortcodes
 */
function comrepair_vc_register_image_sizes() {
	add_image_size( 'comrepair_vc_avatar', 84, 84, true );
	add_image_size( 'comrepair_vc_logo', 120, 120 );
	add_image_size( 'comrepair_vc_logo_wide', 180, 120 );
	add_image_size( 'comrepair_vc_w3', 360 );
	add_image_size( 'comrepair_vc_w4', 470 );
	add_image_size( 'comrepair_vc_w6', 750 );
	add_image_size( 'comrepair_vc_w6_thin', 750, 300, true );
	add_image_size( 'comrepair_vc_w12', 1520 );
}
add_action( 'init', 'comrepair_vc_register_image_sizes' );

/**
 * Register Themify icons CSS
 */
function comrepair_vc_register_themify_icons_style() {
	wp_register_style( 'comrepair_vc_themify_icons', COMREPAIR_PLUGIN_DIR_URL . 'assets/css/themify-icons.min.css', false, '1.0.1' );
}
add_action( 'wp_enqueue_scripts', 'comrepair_vc_register_themify_icons_style' );
add_action( 'admin_enqueue_scripts', 'comrepair_vc_register_themify_icons_style' );

/**
 * Enqueue Themify icons CSS if necessary
 */
function comrepair_vc_enqueue_themify_icons_style( $font ) {
	if ( 'themify' === $font ) {
		wp_enqueue_style( 'comrepair_vc_themify_icons' );
	}
}
add_action( 'vc_enqueue_font_icon_element', 'comrepair_vc_enqueue_themify_icons_style' );

/**
 * Always enqueue Themify icons CSS when inside VC editor mode
 */
function comrepair_vc_editor_enqueue_themify_icons_style() {
	wp_enqueue_style( 'comrepair_vc_themify_icons' );
}
add_action( 'vc_backend_editor_enqueue_js_css', 'comrepair_vc_editor_enqueue_themify_icons_style' );
add_action( 'vc_frontend_editor_enqueue_js_css', 'comrepair_vc_editor_enqueue_themify_icons_style' );

/**
 * Add Themify icons list to VC icon picker
 */
function comrepair_vc_iconpicker_type_themify( $icons ) {
	$themify = require COMREPAIR_VC_ADDON_PATH . 'vc-themify-icons-config.php';
	return array_merge( $icons, $themify );
}
add_filter( 'vc_iconpicker-type-themify', 'comrepair_vc_iconpicker_type_themify' );

/**
 * VC Helper functions
 */
require COMREPAIR_VC_ADDON_PATH . 'vc-functions.php';
