<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_ComRepair_Services_Carousel' ) ) {
	class WPBakeryShortCode_ComRepair_Services_Carousel extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'comrepair_services_carousel',
	'html_template' => COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_services_carousel/template.php',
	'name'          => __( 'Services Carousel', 'comrepair-plugin' ),
	'category'      => __( 'ComRepair WP Theme', 'comrepair-plugin' ),

	'params'        => array(
		array(
			'type'       => 'dropdown',
			'param_name' => 'style',
			'heading'    => __( 'Style', 'comrepair-plugin' ),
			'value'      => array(
				__( 'Style 1', 'comrepair-plugin' ) => 'style-1',
				__( 'Style 2', 'comrepair-plugin' ) => 'style-2',
			),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'service_tag',
			'heading'    => __( 'Show services with tag', 'comrepair-plugin' ),
			'value'      => comrepair_vc_get_taxonomy_terms( 'service_tag', array( 'All' => '' ) ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'posts_per_page',
			'value'       => 6,
			'heading'     => __( 'Number of items to show', 'comrepair-plugin' ),
			'description' => __( 'To show all items enter: All', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'autoplay_timeout',
			'heading'    => __( 'Autoplay timeout', 'comrepair-plugin' ),
			'value'      => array(
				__( 'Disabled', 'comrepair-plugin' )   => 0,
				__( '5 seconds', 'comrepair-plugin' )  => 5000,
				__( '6 seconds', 'comrepair-plugin' )  => 6000,
				__( '7 seconds', 'comrepair-plugin' )  => 7000,
				__( '8 seconds', 'comrepair-plugin' )  => 8000,
				__( '9 seconds', 'comrepair-plugin' )  => 9000,
				__( '10 seconds', 'comrepair-plugin' ) => 10000,
			),
		),
		array(
			'type'       => 'dropdown',
			'param_name' => 'item_heading_tag',
			'heading'    => __( 'Item Heading Tag', 'comrepair-plugin' ),
			'std'        => 'h4',
			'value'      => array(
				__( 'h1', 'comrepair-plugin' ) => 'h1',
				__( 'h2', 'comrepair-plugin' ) => 'h2',
				__( 'h3', 'comrepair-plugin' ) => 'h3',
				__( 'h4', 'comrepair-plugin' ) => 'h4',
				__( 'h5', 'comrepair-plugin' ) => 'h5',
				__( 'h6', 'comrepair-plugin' ) => 'h6',
			),
		),
		array(
			'type'        => 'checkbox',
			'param_name'  => 'permalinks_enabled',
			'heading'     => __( 'Enable permalinks', 'comrepair-plugin' ),
			'description' => __( 'Whether clicking on an item should open service detail page', 'comrepair-plugin' ),
			'std'         => 'true',
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'more_link_text',
			'heading'    => __( 'Read more link text', 'comrepair-plugin' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'comrepair-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'comrepair-plugin' ),
			'group'      => __( 'Design Options', 'comrepair-plugin' ),
		),
	),
);
