<?php
/**
 * Custom post types configuration
 *
 * @package ComRepair_Plugin
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Register the custom post types to be used in our theme
 */
function comrepair_cpt_register_post_types() {
	// Add Excerpt support for Pages
	add_post_type_support( 'page', 'excerpt' );
	// Service
	$service_labels = array(
		'name'               => __( 'Services', 'comrepair-plugin' ),
		'singular_name'      => __( 'Service', 'comrepair-plugin' ),
		'add_new'            => __( 'Add New', 'comrepair-plugin' ),
		'add_new_item'       => __( 'Add New Service', 'comrepair-plugin' ),
		'edit_item'          => __( 'Edit Service', 'comrepair-plugin' ),
		'new_item'           => __( 'New Service', 'comrepair-plugin' ),
		'all_items'          => __( 'All Services', 'comrepair-plugin' ),
		'view_item'          => __( 'View Service', 'comrepair-plugin' ),
		'search_items'       => __( 'Search Services', 'comrepair-plugin' ),
		'not_found'          => __( 'No Service found', 'comrepair-plugin' ),
		'not_found_in_trash' => __( 'No Service found in Trash', 'comrepair-plugin' ),
		'menu_name'          => __( 'Services', 'comrepair-plugin' ),
		'parent_item'        => __( 'Parent Service', 'comrepair-plugin' ),
		'parent_item_colon'  => __( 'Parent Service:', 'comrepair-plugin' ),
	);
	$service_args = array(
		'labels'        => $service_labels,
		'public'        => true,
		'show_ui'       => true,
		'menu_icon'     => 'dashicons-clipboard',
		'menu_position' => 6,
		'hierarchical'  => true,
		'has_archive'   => false,
		'map_meta_cap'  => true,
		'supports'      => array( 'title', 'editor', 'excerpt', 'thumbnail', 'page-attributes' ),
	);
	register_post_type( 'service', $service_args );
	// Service Category taxonomy
	$service_category_labels = array(
		'name'                  => __( 'Service Categories', 'comrepair-plugin' ),
		'singular_name'         => __( 'Service Category', 'comrepair-plugin' ),
		'menu_name'             => __( 'Service Categories', 'comrepair-plugin' ),
		'search_items'          => __( 'Search Service Categories', 'comrepair-plugin' ),
		'all_items'             => __( 'All Service Categories', 'comrepair-plugin' ),
		'edit_item'             => __( 'Edit Service Category', 'comrepair-plugin' ),
		'update_item'           => __( 'Update Service Category', 'comrepair-plugin' ),
		'add_new_item'          => __( 'Add new Service Category', 'comrepair-plugin' ),
		'new_item_name'         => __( 'New Service Category', 'comrepair-plugin' ),
		'choose_from_most_used' => __( 'Choose from the most used categories', 'comrepair-plugin' ),
	);
	$service_category_args = array(
		'labels'            => $service_category_labels,
		'show_ui'           => true,
		'show_tagcloud'     => false,
		'show_admin_column' => true,
	);
	register_taxonomy( 'service_category', 'service', $service_category_args );
	// Service Tag taxonomy
	$service_tag_labels = array(
		'name'          => __( 'Service Tags', 'comrepair-plugin' ),
		'singular_name' => __( 'Service Tag', 'comrepair-plugin' ),
		'menu_name'     => __( 'Service Tags', 'comrepair-plugin' ),
		'search_items'  => __( 'Search Service Tags', 'comrepair-plugin' ),
		'all_items'     => __( 'All Service Tags', 'comrepair-plugin' ),
		'edit_item'     => __( 'Edit Service Tag', 'comrepair-plugin' ),
		'update_item'   => __( 'Update Service Tag', 'comrepair-plugin' ),
		'add_new_item'  => __( 'Add new Service Tag', 'comrepair-plugin' ),
		'new_item_name' => __( 'New Service Tag', 'comrepair-plugin' ),
	);
	$service_tag_args = array(
		'labels'            => $service_tag_labels,
		'show_ui'           => true,
		'show_tagcloud'     => false,
		'show_admin_column' => true,
	);
	register_taxonomy( 'service_tag', 'service', $service_tag_args );

	// Testimonial
	$testimonial_labels = array(
		'name'               => __( 'Testimonials', 'comrepair-plugin' ),
		'singular_name'      => __( 'Testimonial', 'comrepair-plugin' ),
		'add_new'            => __( 'Add New', 'comrepair-plugin' ),
		'add_new_item'       => __( 'Add New Testimonial', 'comrepair-plugin' ),
		'edit_item'          => __( 'Edit Testimonial', 'comrepair-plugin' ),
		'new_item'           => __( 'New Testimonial', 'comrepair-plugin' ),
		'all_items'          => __( 'All Testimonials', 'comrepair-plugin' ),
		'view_item'          => __( 'View Testimonial', 'comrepair-plugin' ),
		'search_items'       => __( 'Search Testimonials', 'comrepair-plugin' ),
		'not_found'          => __( 'No Testimonial found', 'comrepair-plugin' ),
		'not_found_in_trash' => __( 'No Testimonial found in Trash', 'comrepair-plugin' ),
		'menu_name'          => __( 'Testimonials', 'comrepair-plugin' ),
		'parent_item'        => __( 'Parent Testimonial', 'comrepair-plugin' ),
		'parent_item_colon'  => __( 'Parent Testimonial:', 'comrepair-plugin' ),
	);
	$testimonial_args = array(
		'labels'              => $testimonial_labels,
		'public'              => true,
		'show_ui'             => true,
		'menu_icon'           => 'dashicons-format-quote',
		'menu_position'       => 6,
		'has_archive'         => false,
		'map_meta_cap'        => true,
		'supports'            => array( 'title', 'editor', 'thumbnail', 'page-attributes' ),
		'exclude_from_search' => true,
	);
	register_post_type( 'testimonial', $testimonial_args );
	// Testimonial Category taxonomy
	$testimonial_category_labels = array(
		'name'          => __( 'Testimonial Categories', 'comrepair-plugin' ),
		'singular_name' => __( 'Testimonial Category', 'comrepair-plugin' ),
		'menu_name'     => __( 'Testimonial Categories', 'comrepair-plugin' ),
		'search_items'  => __( 'Testimonial Search categories', 'comrepair-plugin' ),
		'all_items'     => __( 'All Testimonial Categories', 'comrepair-plugin' ),
		'edit_item'     => __( 'Edit Testimonial Category', 'comrepair-plugin' ),
		'update_item'   => __( 'Update Testimonial Category', 'comrepair-plugin' ),
		'add_new_item'  => __( 'Add new Testimonial Category', 'comrepair-plugin' ),
		'new_item_name' => __( 'New Testimonial Category', 'comrepair-plugin' ),
	);
	$testimonial_category_args = array(
		'labels'            => $testimonial_category_labels,
		'show_ui'           => true,
		'show_tagcloud'     => false,
		'show_admin_column' => true,
	);
	register_taxonomy( 'testimonial_category', 'testimonial', $testimonial_category_args );
}
add_action( 'init', 'comrepair_cpt_register_post_types' );

/**
 * Integrate with Carbon Fields plugin to add some useful custom fields meta boxes
 * for our custom post types.
 */
function comrepair_cpt_register_carbon_fields() {
	require_once COMREPAIR_PLUGIN_DIR_PATH . 'carbon-fields/carbon-fields-config.php';
}
add_action( 'carbon_register_fields', 'comrepair_cpt_register_carbon_fields' );

/**
 * Add the Featured Image column to the list of posts in the Dashboard
 */
function comrepair_cpt_manage_posts_columns( $columns, $post_type ) {
	if ( 'product' === $post_type ) {
		return $columns;
	}
	$columns['featured-image'] = __( 'Featured Image', 'comrepair-plugin' );
	return $columns;
}
add_filter( 'manage_posts_columns', 'comrepair_cpt_manage_posts_columns', 10, 2 );

/**
 * Handle the rendering of the Featured Image column
 */
function comrepair_cpt_manage_posts_custom_column( $column, $post_id ) {
	if ( 'featured-image' === $column ) {
		echo get_the_post_thumbnail( $post_id, array( 100, 100 ) );
	}
}
add_action( 'manage_pages_custom_column', 'comrepair_cpt_manage_posts_custom_column', 10, 2 );
add_action( 'manage_posts_custom_column', 'comrepair_cpt_manage_posts_custom_column', 10, 2 );
