<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $posts_per_page
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$class = 'testimonials-carousel bt-carousel js-bt-carousel owl-carousel';
$class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$query = new WP_Query( array(
	'post_type'      => 'testimonial',
	'posts_per_page' => 'All' === $posts_per_page ? -1 : (int) $posts_per_page,
) );

?>

<?php if ( ! $query->have_posts() ) : ?>

	<div class="text-center">
		<h2><?php esc_html_e( 'No items', 'comrepair-plugin' ); ?></h2>
		<p><?php esc_html_e( 'Please add some Testimonials items to show.', 'comrepair-plugin' ); ?></p>
	</div>

<?php else : ?>

	<div class="<?php echo esc_attr( $class ); ?>" data-items="2" data-equal-heights>

		<?php while ( $query->have_posts() ) : $query->the_post(); ?>

			<blockquote class="testimonial-item">

				<div class="testimonial-item-copy-wrap">
					<?php the_content(); ?>
				</div><!-- .testimonial-item-copy-wrap -->

				<footer>

					<div class="testimonial-item-image-wrap">
						<?php the_post_thumbnail( 'comrepair_vc_avatar', array( 'class' => 'testimonial-item-image' ) ); ?>
					</div><!-- .testimonial-item-image-wrap -->

					<span class="testimonial-item-author-name"><?php the_title(); ?></span>

					<?php if ( $job_title = get_post_meta( get_the_ID(), '_comrepair_job_title', true ) ) : ?>
						<span class="testimonial-item-author-title"><?php echo esc_html( $job_title ); ?></span>
					<?php endif; ?>

				</footer>

			</blockquote><!-- .testimonial-item -->

		<?php endwhile; ?>

		<?php wp_reset_postdata(); ?>

	</div><!-- .bt-carousel -->

<?php endif; ?>
