<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $content
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$class = 'statistics-box js-statistics-box';
$class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

// Add <span></span> tag around first numbers in <li> elements.
$content = preg_replace( '/<li>\s*(\d+)/', '<li><span class="js-statistics-box-number">$1</span>', $content );
?>

<div class="<?php echo esc_attr( $class ); ?>">
	<?php echo wpb_js_remove_wpautop( $content, true ); // wpcs: xss ok ?>
</div><!-- .statistics-box -->
