<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

if ( ! class_exists( 'WPBakeryShortCode_ComRepair_Section_Heading' ) ) {
	class WPBakeryShortCode_ComRepair_Section_Heading extends WPBakeryShortCode {
	}
}

return array(
	'base'          => 'comrepair_section_heading',
	'html_template' => COMREPAIR_VC_SHORTCODES_PATH . 'comrepair_section_heading/template.php',
	'name'          => __( 'Section Heading', 'comrepair-plugin' ),
	'category'      => __( 'ComRepair WP Theme', 'comrepair-plugin' ),

	'params'        => array(
		array(
			'type'       => 'dropdown',
			'param_name' => 'decoration',
			'heading'    => __( 'Decoration', 'comrepair-plugin' ),
			'value'      => array(
				__( 'No decoration', 'comrepair-plugin' ) => 'no',
				__( 'Style 1', 'comrepair-plugin' )       => 'decor-1',
				__( 'Style 2', 'comrepair-plugin' )       => 'decor-2',
			),
		),
		array(
			'type'       => 'textarea_html',
			'param_name' => 'content',
			'holder'     => 'div',
			'heading'    => __( 'Text', 'comrepair-plugin' ),
		),
		array(
			'type'        => 'textfield',
			'param_name'  => 'el_class',
			'heading'     => __( 'Extra class name', 'comrepair-plugin' ),
			'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'comrepair-plugin' ),
		),
		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'heading'    => __( 'CSS box', 'comrepair-plugin' ),
			'group'      => __( 'Design Options', 'comrepair-plugin' ),
		),
	),
);
