<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $css
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$class = 'three-posts-feed';
$class .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$query = new WP_Query( array(
	'post_type'           => 'post',
	'posts_per_page'      => 3,
	'ignore_sticky_posts' => true,
) );

?>

<?php if ( ! $query->have_posts() ) : ?>

	<div class="text-center">
		<h2><?php esc_html_e( 'No items', 'comrepair-plugin' ); ?></h2>
		<p><?php esc_html_e( 'Please add some Posts to show.', 'comrepair-plugin' ); ?></p>
	</div>

<?php else : ?>

	<div class="<?php echo esc_attr( $class ); ?>">
		<?php
		$item_index = 0;
		while ( $query->have_posts() ) : $query->the_post();
			$item_index++;
		?>

			<div class="three-posts-feed-column">

				<article id="post-<?php the_ID(); ?>" <?php post_class( 'post-preview post-preview--vertical' ); ?>>

					<a href="<?php the_permalink(); ?>" rel="bookmark">
						<div class="post-preview-image">
							<?php the_post_thumbnail( ( 1 === $item_index ? 'comrepair_vc_w6_thin' : 'comrepair_vc_w3' ) ); ?>
						</div>
					</a>

					<div class="post-preview-copy-wrap">

						<?php if ( 'post' === get_post_type() ) : ?>
							<a href="<?php the_permalink(); ?>" rel="bookmark">
								<div class="post-preview-date post-date post-date--circle">
									<time datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>">
										<span class="post-date-day"><?php echo esc_html( get_the_time( 'd' ) ); ?></span> <span class="post-date-month"><?php echo esc_html( get_the_time( 'M' ) ); ?></span>
									</time>
								</div>
							</a>
						<?php endif; ?>

						<a href="<?php the_permalink(); ?>" rel="bookmark">
							<h2 class="post-preview-title title"><?php the_title(); ?></h2>
							<div class="post-preview-text"><?php the_excerpt(); ?></div>
						</a>

						<footer class="post-preview-meta-wrap">

							<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
								<span class="post-preview-author">
									<?php
									/* translators: %s is an author name */
									printf( wp_kses_post( __( '<span class="screen-reader-text">An article by </span>%s', 'comrepair-plugin' ) ), esc_html( get_the_author() ) );
									?>
								</span>
							</a>

							<?php if ( $comments_number = get_comments_number() ) : ?>
								<a href="<?php comments_link(); ?>">
									<span class="post-preview-comments">
										<?php
										/* translators: %d is the number of comments */
										printf( wp_kses_post( __( '%d<span class="screen-reader-text"> comments</span>', 'comrepair-plugin' ) ), esc_html( $comments_number ) );
										?>
									</span>
								</a>
							<?php endif; ?>

							<?php
							/* translators: used between list items, there is a space after the comma */
							if ( $categories = get_the_category_list( __( ', ', 'comrepair-plugin' ) ) ) :
							?>
								<span class="post-preview-categories">
									<?php
									/* translators: %s is the list of categories */
									echo wp_kses_post( sprintf( __( '<span class="screen-reader-text">Posted in </span>%s', 'comrepair-plugin' ), $categories ) );
									?>
								</span>
							<?php endif; ?>

						</footer><!-- .post-preview-meta-wrap -->

					</div><!-- .post-preview-copy-wrap -->

				</article><!-- .post-preview -->

			</div><!-- .three-posts-feed-column -->

		<?php endwhile; ?>
	</div><!-- .three-posts-feed -->

	<?php wp_reset_postdata(); ?>

<?php endif; ?>
