<?php
/**
 * Add custom fields meta boxes using the Carbon Fields API
 *
 * @package ComRepair_Plugin
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

use Carbon_Fields\Container;
use Carbon_Fields\Field;

// Service custom fields
Container::make( 'post_meta', __( 'Service Details', 'comrepair-plugin' ) )
	->show_on_post_type( 'service' )
	->set_priority( 'default' )
	->add_fields( array(
		Field::make( 'text', 'comrepair_service_icon', __( 'Service Icon', 'comrepair-plugin' ) ),
	) );

// Testimonial custom fields
Container::make( 'post_meta', __( 'Testimonial Details', 'comrepair-plugin' ) )
	->show_on_post_type( 'testimonial' )
	->set_priority( 'default' )
	->add_fields( array(
		Field::make( 'text', 'comrepair_job_title', __( 'Job Title', 'comrepair-plugin' ) ),
	) );
