<?php
/**
 * Add custom fields meta boxes using the Carbon Fields API.
 *
 * @package ComRepair
 */

use Carbon_Fields\Container;
use Carbon_Fields\Field;

Container::make( 'post_meta', esc_html__( 'Page Settings', 'comrepair' ) )
	->show_on_post_type( array( 'post', 'page', 'service' ) )
	->set_priority( 'default' )
	->add_fields( array(
		Field::make( 'select', 'comrepair_show_page_header', esc_html__( 'Show Page Header?', 'comrepair' ) )
			->add_options( array(
				''     => esc_html__( 'Default', 'comrepair' ),
				'show' => esc_html__( 'Show', 'comrepair' ),
				'hide' => esc_html__( 'Hide', 'comrepair' ),
			) ),
		Field::make( 'select', 'comrepair_show_breadcrumbs', esc_html__( 'Show Breadcrumbs?', 'comrepair' ) )
			->add_options( array(
				''     => esc_html__( 'Default', 'comrepair' ),
				'show' => esc_html__( 'Show', 'comrepair' ),
				'hide' => esc_html__( 'Hide', 'comrepair' ),
			) )
			->set_conditional_logic( array(
				array(
					'field'   => 'comrepair_show_page_header',
					'value'   => 'hide',
					'compare' => '!=',
				),
			) ),
	) );
