<?php
/**
 * Breadcrumb NavXT plugin itegration.
 *
 * @package ComRepair
 */

/**
 * Customize default settings of the Breadcrumb NavXT plugin.
 */
function comrepair_bcn_settings_init( $opt ) {
	if ( ! $opt ) {
		$opt = array();
	}
	$opt['bmainsite_display'] = false;
	$opt['bblog_display'] = true;
	$opt['hseparator'] = ' / ';
	$opt['Spost_post_taxonomy_type'] = 'BCN_POST_PARENT';
	return $opt;
}
add_filter( 'bcn_settings_init', 'comrepair_bcn_settings_init' );

/**
 * Remove the title of the current post/page item from the breadcrumb trail to avoid duplication,
 * since the breadcrumbs are displayed right next to the page title.
 */
function comrepair_bcn_remove_post_title( $trail ) {
	// Remove the current item from the trail
	if ( ! is_404() && ! empty( $trail->breadcrumbs ) && in_array( 'current-item', $trail->breadcrumbs[0]->get_types(), true ) ) {
		unset( $trail->breadcrumbs[0] );
		$trail->breadcrumbs = array_values( $trail->breadcrumbs );
	}
}
add_action( 'bcn_after_fill', 'comrepair_bcn_remove_post_title' );
