<?php
/**
 * Theme default values.
 *
 * @package ComRepair
 */

/**
 * A global array with theme default values.
 */
global $comrepair_defaults;

if ( ! isset( $comrepair_defaults ) ) {
	$comrepair_defaults = array(
		'show_page_header'       => 'show',
		'show_breadcrumbs'       => 'show',
		'primary_color'          => '#850345',
		'primary_color_light'    => '#b7045f',
		'secondary_color'        => '#22264b',
		'header_bg_color'        => 'rgba(34,38,75,0.92)',
		'footer_bg_color'        => 'rgba(17,17,17,1)',
		'footer_bottom_bg_color' => 'rgba(17,17,17,1)',
		/* translators: 1: is a link to the author portfolio page, 2: is the author name */
		'footer_tagline'         => sprintf( __( '&copy; 2017 ComRepair WordPress Theme by <a href="%1$s">%2$s</a>', 'comrepair' ), 'https://themeforest.net/user/brotherstheme', 'BrothersTheme' ),
	);
}

/**
 * Retrieve theme default value from the global array.
 */
function comrepair_get_default( $key ) {
	global $comrepair_defaults;
	return $comrepair_defaults[ $key ];
}
